/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.ExtColumn;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ExtensionPanel
extends DefaultTraversablePanel {
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private Component _comp;

    public ExtensionPanel() {
        this.init();
    }

    public ExtensionPanel(List<ExtColumn> list) {
        this.init();
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    public void setColumns(List<ExtColumn> list) {
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    private Map<String, List<String>> modelToMap(DefaultTableModel defaultTableModel) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            String string2 = (String)defaultTableModel.getValueAt(i, 1);
            if (string == null) continue;
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(string2);
        }
        return hashMap;
    }

    private DefaultTableModel mapToModel(Map<String, List<String>> map) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(Messages.getString("ExtensionPanel.0"));
        defaultTableModel.addColumn(Messages.getString("ExtensionPanel.1"));
        for (String string : map.keySet()) {
            for (String string2 : map.get(string)) {
                defaultTableModel.addRow(new Object[]{string, string2});
            }
        }
        return defaultTableModel;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        DefaultTableModel defaultTableModel = this.mapToModel(dBConfig.getExtensions());
        if (defaultTableModel.getColumnName(0).equals(Messages.getString("ExtensionPanel.2"))) {
            this._model = defaultTableModel;
            this._table.setModel(this._model);
            this._table.updateUI();
            int n = 0;
            TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new TypeCellEditor());
            n = 1;
            tableColumn = this._table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new URLCellEditor());
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            if (this._table.getCellEditor() != null) {
                this._table.getCellEditor().stopCellEditing();
            }
            DBConfig dBConfig = DBConfig.getInstance(traversableContext);
            dBConfig.putExtensions(this.modelToMap(this._model));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init() {
        this.setHelpID("f1_userdefinedextensions_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PreferencesArb.getString("EXT_WARN"));
        this.add(jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._table = new JTable(this._model);
        this._model.addColumn(Messages.getString("ExtensionPanel.4"));
        this._model.addColumn(Messages.getString("ExtensionPanel.5"));
        jScrollPane.setViewportView(this._table);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)Messages.getString("ExtensionPanel.6"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionPanel.this.addRow(null, null);
            }
        });
        this.add(jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton2, (String)Messages.getString("ExtensionPanel.7"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExtensionPanel.this._table.getSelectedRow();
                int n2 = ExtensionPanel.this._table.getSelectedColumn();
                while (n > -1) {
                    ExtensionPanel.this._table.getCellEditor(n, n2).stopCellEditing();
                    ExtensionPanel.this._model.removeRow(n);
                    n = ExtensionPanel.this._table.getSelectedRow();
                }
            }
        });
        this.add(jButton2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        int n = 0;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new TypeCellEditor());
        n = 1;
        tableColumn = this._table.getColumnModel().getColumn(n);
        this._comp = this;
        tableColumn.setCellEditor(new URLCellEditor());
    }

    public void addRow(String string, String string2) {
        this._model.addRow(new Object[]{string2, string});
        this._model.fireTableDataChanged();
    }

    public List<ExtColumn> getColumns() {
        ExtColumn extColumn = null;
        ArrayList<ExtColumn> arrayList = new ArrayList<ExtColumn>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            extColumn = new ExtColumn((String)this._table.getModel().getValueAt(i, 0), (String)this._table.getModel().getValueAt(i, 1));
            arrayList.add(extColumn);
        }
        return arrayList;
    }

    public class URLCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component;

        public URLCellEditor() {
            this.component = new FilePanel(ExtensionPanel.this._comp);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((FilePanel)this.component).setFileName((String)object);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((FilePanel)this.component).getFileName();
        }
    }

    public class TypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"REPORT", "ACTION", "EDITOR", "NAVIGATOR"}));

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((JComboBox)this.component).getModel().setSelectedItem(object);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JComboBox)this.component).getModel().getSelectedItem();
        }
    }
}

