/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config.homesupport;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.homesupport.OracleHomeSettings;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.startup.OracleHomeType;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.DialogTraversable;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;

final class ConfigureClientPanel
extends DialogTraversable {
    static final String HOME_KEY = "Dialog.Home";
    private static final String TEST_CLIENT_CMD = "AdvancedInfo.TestClient";
    private JPanel m_content;
    private JComboBox m_cmbType = new JComboBox(new NonNullableComboBoxModel((Object[])OracleHomeType.values()));
    private URLTextField m_fldDir = new URLTextField();
    private JButton m_btnBrowse = new JButton();
    private JButton m_btnTest = new JButton();
    private DialogCallbacks m_dc;

    public ConfigureClientPanel() {
        this.m_btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OracleHomeSettings.OracleHome oracleHome = ConfigureClientPanel.this.getHome();
                    OracleHomeType oracleHomeType = oracleHome.getType();
                    String string = Ide.getProductHomeDirectory();
                    File file = new File(string);
                    File file2 = new File(new File(file, "lib"), "oracle.sqldeveloper.homesupport.jar");
                    String string2 = System.getProperty("java.home");
                    File file3 = new File(string2);
                    File file4 = new File(file3, "bin");
                    File file5 = new File(file4, "java");
                    String[] stringArray = new String[]{file5.getAbsolutePath(), "-classpath", file2.getAbsolutePath(), oracleHomeType.getTesterClass(), URLFileSystem.getPath((URL)oracleHome.getLocation())};
                    SimpleProcess simpleProcess = new SimpleProcess(stringArray);
                    simpleProcess.setWorkingDirectory(new File(Ide.getBinDirectory()));
                    simpleProcess.setLabel(PreferencesArb.getString("LOG_PAGE_CLIENT_TEST"));
                    simpleProcess.setLogCommandString(false);
                    simpleProcess.setLogStartDirectory(false);
                    simpleProcess.setAddToProcessesFolder(false);
                    simpleProcess.exec();
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog(ConfigureClientPanel.this.getComponent());
                }
            }
        });
        this.m_btnTest.setActionCommand(TEST_CLIENT_CMD);
        ResourceUtils.resButton((AbstractButton)this.m_btnTest, (String)PreferencesArb.getString("BUTTON_TEST"));
    }

    JButton getTestButton() {
        return this.m_btnTest;
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        OracleHomeSettings.OracleHome oracleHome = this.getHome();
        traversableContext.put(HOME_KEY, (Object)oracleHome);
    }

    private OracleHomeSettings.OracleHome getHome() throws TraversalException {
        OracleHomeType oracleHomeType = (OracleHomeType)this.m_cmbType.getSelectedItem();
        if (oracleHomeType == null) {
            throw new TraversalException(PreferencesArb.getString("MESSAGE_MISSING_CLIENT_TYPE"));
        }
        URL uRL = this.m_fldDir.getURL();
        if (uRL == null) {
            throw new TraversalException(PreferencesArb.getString("MESSAGE_MISSING_CLIENT_LOC"));
        }
        if (!URLFileSystem.exists((URL)uRL)) {
            throw new TraversalException(PreferencesArb.format("MESSAGE_CLIENT_LOC_NOT_EXISTS", URLFileSystem.getPlatformPathName((URL)uRL)));
        }
        if (!URLFileSystem.isDirectory((URL)uRL)) {
            throw new TraversalException(PreferencesArb.format("MESSAGE_CLIENT_LOC_NOT_DIRECTORY", URLFileSystem.getPlatformPathName((URL)uRL)));
        }
        OracleHomeSettings.OracleHome oracleHome = new OracleHomeSettings.OracleHome(uRL, oracleHomeType);
        return oracleHome;
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        this.m_dc = traversableContext.getDialogCallbacks();
        OracleHomeSettings.OracleHome oracleHome = (OracleHomeSettings.OracleHome)traversableContext.get(HOME_KEY);
        if (oracleHome != null) {
            this.m_cmbType.setSelectedItem(oracleHome.getType());
            this.m_fldDir.setURL(oracleHome.getLocation());
        }
        this.checkOKState();
    }

    public String getHelpID() {
        return "f1_oracleclientconfig_html";
    }

    @Override
    protected Component createComponent() {
        this.m_content = LayoutControl.GBC.createPanel();
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ConfigureClientPanel.this.checkOKState();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ConfigureClientPanel.this.checkOKState();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ConfigureClientPanel.this.checkOKState();
            }
        };
        this.m_fldDir.setDirectoryOnly(true);
        this.m_fldDir.setChooserInit(new URLChooserInit(){

            public void initURLChooser(URLChooser uRLChooser) {
                uRLChooser.setShowJarsAsDirs(false);
            }
        });
        this.m_fldDir.getDocument().addDocumentListener(documentListener);
        this.m_fldDir.setColumns(30);
        this.m_btnBrowse.addActionListener((ActionListener)this.m_fldDir);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_cmbType, (String)PreferencesArb.getString("LABEL_CLIENT_TYPE"));
        this.m_content.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.m_content.add((Component)this.m_cmbType, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_fldDir, (String)PreferencesArb.getString("LABEL_LOCATION"));
        this.m_content.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.m_content.add((Component)this.m_fldDir, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        ResourceUtils.resButton((AbstractButton)this.m_btnBrowse, (String)ImpExpResources.getString("BROWSE_BUTTON"));
        this.m_content.add((Component)this.m_btnBrowse, LayoutControl.GBC.gbc(2, 1, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        return this.m_content;
    }

    @Override
    public Component getInitialFocusComponent() {
        return this.m_fldDir;
    }

    private void checkOKState() {
        URL uRL;
        boolean bl = false;
        if (this.m_cmbType.getSelectedItem() != null && (uRL = this.m_fldDir.getURL()) != null && ModelUtil.areEqual((Object)uRL.getProtocol(), (Object)"file") && URLFileSystem.exists((URL)uRL)) {
            bl = true;
        }
        this.m_dc.enableOKButton(bl);
    }
}

