/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.ImpExpPanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.Source;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.checktree.CheckboxTree;
import oracle.javatools.ui.checktree.TriStateNode;
import oracle.jdeveloper.db.ConnectionException;

class ConnectionListPanel
extends ImpExpPanel
implements PropertyChangeListener {
    TraversableContext m_traversableContext;
    boolean exportConnectionList = false;
    private JTree m_tree;
    private Source m_source;
    private Destination m_dest;

    ConnectionListPanel() {
    }

    @Override
    protected JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        this.m_tree = new CheckboxTree(){

            public String getToolTipText(MouseEvent mouseEvent) {
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                String string = "";
                if (treePath != null) {
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof ConnectionNode) {
                        ConnectionNode connectionNode = (ConnectionNode)((Object)object);
                        string = connectionNode.getToolTipText();
                    } else if (object instanceof StoreNode) {
                        StoreNode storeNode = (StoreNode)((Object)object);
                        string = storeNode.getToolTipText();
                    }
                }
                return string;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        JScrollPane jScrollPane = new JScrollPane(this.m_tree);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_tree.setRootVisible(true);
        this.m_tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                if (((JTree)treeExpansionEvent.getSource()).getModel().getRoot() == treeExpansionEvent.getPath().getLastPathComponent()) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            }
        });
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.m_tree.setSelectionModel(defaultTreeSelectionModel);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_tree, (String)ImpExpResources.getString("CONNECTIONS_LABEL"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        JComponent jComponent = this.createBottomPanel();
        if (jComponent != null) {
            jPanel.add((Component)jComponent, LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X));
        }
        return jPanel;
    }

    protected JComponent createBottomPanel() {
        return null;
    }

    protected void setFinishPermitted(boolean bl) {
        this.m_callbacks.wizardEnableButtons(null, null, Boolean.valueOf(bl));
    }

    @Override
    protected final void init(TraversableContext traversableContext) {
        this.m_traversableContext = traversableContext;
        this.setNextPermitted(false);
        this.setFinishPermitted(false);
        this.m_source = (Source)traversableContext.get("ImportExport.SOURCE");
        this.m_dest = (Destination)traversableContext.get("ImportExport.DESTINATION");
        StoreNode storeNode = new StoreNode(this.m_source);
        try {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : this.m_source.listAllConnections()) {
                treeSet.add(string);
            }
            for (String string : treeSet) {
                ConnectionNode connectionNode = new ConnectionNode(string);
                connectionNode.setConnectionProperties(this.m_source.getConnectionProperties(string));
                connectionNode.addPropertyChangeListener(this);
                storeNode.add((MutableTreeNode)((Object)connectionNode));
                if (this.m_dest.isConnectionAddedForCopy(string)) {
                    connectionNode.setNodeState(TriStateNode.NodeState.YES);
                    continue;
                }
                connectionNode.setNodeState(TriStateNode.NodeState.NO);
            }
        }
        catch (ConnectionException connectionException) {
            MessageDialog.error((Component)this.m_tree, (Object)ImpExpResources.format("FILE_READ_ERROR", this.m_source.getLabel()), (String)ImpExpResources.getString("FILE_READ_ERROR_TITLE"), null);
            storeNode.removeAllChildren();
        }
        this.m_tree.setModel(new DefaultTreeModel((TreeNode)((Object)storeNode)));
        this.m_tree.setSelectionPath(new TreePath((Object)storeNode));
        this.initImpl(this.m_source, this.m_dest);
    }

    protected void initImpl(Source source, Destination destination) {
    }

    @Override
    protected final void commit(TraversableContext traversableContext) throws TraversalException {
        this.m_dest.clearConnectionCopyList();
        TriStateNode triStateNode = (TriStateNode)this.m_tree.getModel().getRoot();
        Enumeration enumeration = triStateNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            ConnectionNode connectionNode;
            TriStateNode.NodeState nodeState;
            Object e = enumeration.nextElement();
            if (!(e instanceof ConnectionNode) || (nodeState = (connectionNode = (ConnectionNode)((Object)e)).getNodeState()) != TriStateNode.NodeState.YES) continue;
            String string = connectionNode.getConnectionName();
            this.m_dest.addConnectionForCopy(string, connectionNode.getConnectionProperties());
        }
        this.commitImpl(this.m_source, this.m_dest);
        traversableContext.put("ImportExport.SOURCE", (Object)this.m_source);
        traversableContext.put("ImportExport.DESTINATION", (Object)this.m_dest);
    }

    protected void commitImpl(Source source, Destination destination) throws TraversalException {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ConnectionNode && string == "PROP_STATE_CHANGE") {
            this.checkNextState();
        }
    }

    private void checkNextState() {
        TriStateNode.NodeState nodeState = ((TriStateNode)this.m_tree.getModel().getRoot()).getNodeState();
        boolean bl = nodeState != TriStateNode.NodeState.NO;
        this.setNextPermitted(bl);
        this.setFinishPermitted(bl && !this.isExportConnectionList());
    }

    public boolean isExportConnectionList() {
        return this.exportConnectionList;
    }

    private static class ConnectionNode
    extends TriStateNode {
        private static final long serialVersionUID = 1L;
        private String m_name;
        private Icon m_icon;
        private Properties m_props;
        private String m_label;
        private String m_tooltip;

        ConnectionNode(String string) {
            super((Object)string);
            this.m_name = string;
        }

        public String getConnectionName() {
            return this.m_name;
        }

        public String getToolTipText() {
            if (this.m_tooltip == null) {
                this.m_tooltip = this.m_props == null ? this.m_name : ImpExpResources.format("CONNECTION_TOOLTIP_FORMAT", this.m_name, DatabaseConnection.formatDetailsForTooltip(this.m_props));
            }
            return this.m_tooltip;
        }

        public String getLabel() {
            if (this.m_label == null) {
                this.m_label = this.m_props == null ? this.m_name : ImpExpResources.format("CONNECTION_NAME_FORMAT", this.m_name, DatabaseConnection.formatDetailsForTooltip(this.m_props));
            }
            return this.m_label;
        }

        public Icon getIcon() {
            if (this.m_icon == null) {
                this.m_icon = DatabaseConnection.loadIcon(this.m_name);
            }
            return this.m_icon;
        }

        protected void setConnectionProperties(Properties properties) {
            this.m_props = properties;
            this.m_label = null;
        }

        protected Properties getConnectionProperties() {
            return this.m_props;
        }
    }

    private static class StoreNode
    extends TriStateNode {
        private static final long serialVersionUID = 1L;

        StoreNode(Source source) {
            super((Object)source);
        }

        public Icon getIcon() {
            return ((Source)this.getUserObject()).getIcon();
        }

        public String getLabel() {
            return ((Source)this.getUserObject()).getLabel();
        }

        public String getToolTipText() {
            return "";
        }
    }
}

