/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.connections.impexp.DestinationBase;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpFile;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

class ExportDestination
extends DestinationBase
implements ImpExpFile {
    private URL m_url;
    private ImpExpEngine.PasswordMode m_mode;
    private String m_key;

    ExportDestination() {
    }

    @Override
    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    @Override
    public URL getURL() {
        return this.m_url;
    }

    @Override
    public ImpExpEngine.PasswordMode getMode() {
        return this.m_mode;
    }

    @Override
    public void setMode(ImpExpEngine.PasswordMode passwordMode) {
        this.m_mode = passwordMode;
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    @Override
    public void setKey(String string) {
        this.m_key = string;
    }

    @Override
    public boolean connectionExistsInDestination(String string) {
        return false;
    }

    @Override
    public void commitChanges() throws TraversalException {
        String string;
        String string2 = string = this.m_mode == ImpExpEngine.PasswordMode.KEY ? this.m_key : null;
        if (URLFileSystem.exists((URL)this.m_url)) {
            try {
                URLFileSystem.deleteEx((URL)this.m_url);
            }
            catch (IOException iOException) {
                throw new TraversalException(iOException.getLocalizedMessage());
            }
        }
        try {
            DatabaseConnections databaseConnections = DatabaseConnections.getPrivateInstance((URL)this.m_url, (String)string);
            for (Map.Entry entry : this.m_conns.entrySet()) {
                String string3 = (String)entry.getKey();
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)((Map)entry.getValue()));
                if (this.m_mode == ImpExpEngine.PasswordMode.STRIP) {
                    properties.setProperty("SavePassword", Boolean.FALSE.toString());
                }
                databaseConnections.addConnection(string3, properties);
            }
            databaseConnections.saveConnections();
        }
        catch (ConnectionException connectionException) {
            throw new TraversalException(connectionException.getLocalizedMessage());
        }
    }

    public String toString() {
        return ImpExpResources.get("TITLE_EXPORT_DIALOG");
    }
}

