/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.impexp.ImpExpPanel;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

abstract class FilenamePanel
extends ImpExpPanel {
    static final URLFilter PROPS_FILTER = new WildcardURLFilter(ConnectionArb.getString((String)"IMPEXP_PROPS_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString((String)"IMPEXP_PROPS_FILTER_NAME"));
    static final URLFilter XML_FILTER = new WildcardURLFilter(ConnectionArb.getString((String)"IMPEXP_XML_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString((String)"IMPEXP_XML_FILTER_NAME"));
    private JMultiLineLabel m_descArea = new JMultiLineLabel();
    private URLTextField m_filename = new URLTextField();
    private JButton m_browseBtn = new JButton();

    @Override
    public Object getExitTransition() {
        return super.getExitTransition();
    }

    @Override
    public String getHelpID() {
        return null;
    }

    protected void customizeContentPanel(URLTextField uRLTextField, JMultiLineLabel jMultiLineLabel) {
    }

    @Override
    protected final JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)this.m_descArea, LayoutControl.GBC.gbc(0, 0, 3, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.X));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_filename, (String)ImpExpResources.getString("FILENAME_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.m_browseBtn, (String)ImpExpResources.getString("BROWSE_BUTTON"));
        this.m_browseBtn.addActionListener((ActionListener)this.m_filename);
        this.m_filename.setDirectoryOnly(false);
        this.m_filename.clearChooseableURLFilters();
        this.m_filename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FilenamePanel.this.updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FilenamePanel.this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FilenamePanel.this.updateButtons();
            }
        });
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        jPanel.add((Component)this.m_filename, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.XY, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        jPanel.add((Component)this.m_browseBtn, LayoutControl.GBC.gbc(2, 1, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y, LayoutControl.GBC.Anchor.FIRST_LINE_START));
        this.customizeContentPanel(this.m_filename, this.m_descArea);
        return jPanel;
    }

    protected void setURL(URL uRL) {
        this.m_filename.setURL(uRL);
        this.updateButtons();
    }

    protected URL getURL() {
        return this.m_filename.getURL();
    }

    private void updateButtons() {
        URL uRL = this.m_filename.getURL();
        this.setNextPermitted(uRL != null);
    }

    @Override
    protected final void init(TraversableContext traversableContext) {
        URL uRL = this.getURLFromNamespace(traversableContext);
        this.setURL(uRL);
    }

    @Override
    protected final void commit(TraversableContext traversableContext) throws TraversalException {
        URL uRL = this.getURL();
        if (traversableContext.getDirection() != 2) {
            this.validateURL(uRL);
        }
        this.setURLInNamespace(uRL, traversableContext);
    }

    protected abstract void setURLInNamespace(URL var1, TraversableContext var2) throws TraversalException;

    protected abstract URL getURLFromNamespace(TraversableContext var1);

    abstract boolean isURLAccepted(URL var1);

    protected void validateURL(URL uRL) throws TraversalException {
        if (URLFileSystem.isDirectoryPath((URL)uRL)) {
            throw new TraversalException(ConnectionArb.format((String)"IMPEXP_NEED_FILE_ERROR", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
        if (!this.isURLAccepted(uRL)) {
            throw new TraversalException(ConnectionArb.format((String)"IMPEXP_BAD_FILE_ERROR", (Object[])new Object[]{URLFileSystem.getPlatformPathName((URL)uRL)}), ConnectionArb.getString((String)"IMPEXP_BAD_FILE_TITLE"));
        }
    }
}

