/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.raptor.connections.impexp.Destination;
import oracle.dbtools.raptor.connections.impexp.DestinationBase;
import oracle.dbtools.raptor.connections.impexp.ExportDestination;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.ImpExpResources;
import oracle.dbtools.raptor.connections.impexp.ImportDestination;
import oracle.dbtools.raptor.connections.impexp.ImportSource;
import oracle.dbtools.raptor.controls.WizardTraversable;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class FinishPanel
extends WizardTraversable {
    JTree summaryTree = new JTree();

    @Override
    protected JPanel createContentPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.summaryTree);
        jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.CENTER_FULL, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        this.summaryTree.setShowsRootHandles(false);
        this.summaryTree.setCellRenderer(new NodeRenderer());
        return jPanel;
    }

    @Override
    public void onEntry(TraversableContext traversableContext) {
        Object object = traversableContext.get("ImportExport.SOURCE");
        Object object2 = traversableContext.get("ImportExport.DESTINATION");
        this.summaryTree.setModel(new FinishTreeModel(object, object2));
    }

    private static String getDuplicatModeString(Destination.DuplicateMode duplicateMode) {
        switch (duplicateMode) {
            case REPLACE: {
                return ImpExpResources.get("LABEL_DUPLICATION_MODE_REPLACE");
            }
            case RENAME: {
                return ImpExpResources.get("LABEL_DUPLICATION_MODE_RENAME");
            }
        }
        return "";
    }

    private static String getImportPWModeString(ImpExpEngine.PasswordMode passwordMode) {
        switch (passwordMode) {
            case STRIP: {
                return ImpExpResources.get("LABEL_PASSWORDS_STRIP");
            }
            case KEY: {
                return ImpExpResources.get("LABEL_PASSWORDS_IMPORT_KEY");
            }
            case LEGACY: {
                return ImpExpResources.get("LABEL_PASSWORDS_LEGACY");
            }
        }
        return "";
    }

    private static String getExportPWModeString(ImpExpEngine.PasswordMode passwordMode) {
        switch (passwordMode) {
            case STRIP: {
                return ImpExpResources.get("LABEL_PASSWORDS_STRIP");
            }
            case KEY: {
                return ImpExpResources.get("LABEL_PASSWORDS_EXPORT_KEY");
            }
            case LEGACY: {
                return ImpExpResources.get("LABEL_PASSWORDS_LEGACY");
            }
        }
        return "";
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (object2 != null && !(object2 instanceof String)) {
                object2 = object2.toString();
            }
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                if (jLabel.getText().equals(ImpExpResources.get("TITLE_EXPORT_DIALOG"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else if (jLabel.getText().equals(ImpExpResources.get("TITLE_IMPORT_DIALOG"))) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"application.png"));
                } else if (jLabel.getText().equals(ImpExpResources.get("LABEL_CONNECTIONS"))) {
                    jLabel.setIcon(DatabaseConnectionStores.getInstance().getIcon("IdeConnections"));
                } else if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.toString().equals(ImpExpResources.get("LABEL_CONNECTIONS"))) {
                    jLabel.setIcon(DatabaseConnection.loadIcon(jLabel.getText()));
                } else {
                    jLabel.setIcon(null);
                }
                return jLabel;
            }
            jLabel.setIcon(null);
            return jLabel;
        }
    }

    private class FinishTreeModel
    extends DefaultTreeModel {
        DefaultMutableTreeNode root;

        /*
         * WARNING - void declaration
         */
        public FinishTreeModel(Object object, Object object2) {
            super(new DefaultMutableTreeNode(object2.toString()));
            this.root = (DefaultMutableTreeNode)this.getRoot();
            if (object2 instanceof DestinationBase) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object3;
                Object object4;
                DestinationBase destinationBase = (DestinationBase)object2;
                Set<String> set = destinationBase.getConnectionsForCopy();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ImpExpResources.get("LABEL_CONNECTIONS"));
                for (String object52 : set) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(object52));
                }
                this.root.add(defaultMutableTreeNode2);
                if (object2 instanceof ExportDestination) {
                    void var8_13;
                    object4 = (ExportDestination)object2;
                    String string = ((ExportDestination)object4).getURL().getPath();
                    if (PlatformUtils.isWindows()) {
                        void var8_11;
                        if (string.startsWith("/") && string.charAt(2) == ':') {
                            String string2 = string.substring(1);
                        }
                        String string3 = var8_11.replaceAll("/", "\\\\");
                    }
                    object3 = new DefaultMutableTreeNode(ImpExpResources.format("LABEL_DESTINATION", var8_13));
                    ((DefaultMutableTreeNode)object3).setAllowsChildren(false);
                    this.root.add((MutableTreeNode)object3);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(ImpExpResources.format("LABEL_PASSWORDS", FinishPanel.getExportPWModeString(((ExportDestination)object4).getMode())));
                    this.root.add(defaultMutableTreeNode);
                }
                if (object2 instanceof ImportDestination) {
                    DefaultMutableTreeNode defaultMutableTreeNode3;
                    object4 = (ImportDestination)object2;
                    ImportSource importSource = (ImportSource)object;
                    object3 = importSource.getURL().getPath();
                    if (PlatformUtils.isWindows()) {
                        if (((String)object3).startsWith("/") && ((String)object3).charAt(2) == ':') {
                            object3 = ((String)object3).substring(1);
                        }
                        object3 = ((String)object3).replaceAll("/", "\\\\");
                    }
                    defaultMutableTreeNode = new DefaultMutableTreeNode(ImpExpResources.format("LABEL_SOURCE", object3));
                    defaultMutableTreeNode.setAllowsChildren(false);
                    this.root.add(defaultMutableTreeNode);
                    if (importSource.getMode() == ImpExpEngine.PasswordMode.LEGACY) {
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImpExpResources.get("LABEL_LEGACY_FILE_FORMAT"));
                        this.root.add(defaultMutableTreeNode3);
                    } else {
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImpExpResources.format("LABEL_PASSWORDS", FinishPanel.getImportPWModeString(importSource.getMode())));
                        this.root.add(defaultMutableTreeNode3);
                    }
                    defaultMutableTreeNode3 = new DefaultMutableTreeNode(ImpExpResources.format("LABEL_DUPLICATION_MODE", FinishPanel.getDuplicatModeString(((DestinationBase)object4).getDuplicateMode())));
                    this.root.add(defaultMutableTreeNode3);
                }
            }
        }
    }
}

