/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.conntypes;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.utils.DatabaseJDBCRegistry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.util.ModelUtil;

public class RaptorClassLoader
extends URLClassLoader {
    private static RaptorClassLoader s_instance;
    private URLPath m_path = new URLPath();
    private URLPath m_nativePath = new URLPath();

    public static void registerClassPath(String string, URLPath uRLPath, URLPath uRLPath2) {
    }

    public static synchronized ClassLoader findClassLoader(String string) {
        ClassLoader classLoader = DatabaseJDBCRegistry.getInstance().getClassLoader(string);
        if (classLoader != null) {
            return classLoader;
        }
        DBConfig dBConfig = DBConfig.getInstance();
        URLPath uRLPath = dBConfig.getThirdPartyPath();
        if (s_instance == null || s_instance.getURLPath() != null && !s_instance.getURLPath().equals((Object)uRLPath)) {
            s_instance = new RaptorClassLoader(uRLPath);
        }
        return s_instance;
    }

    private RaptorClassLoader(URLPath uRLPath) {
        super(RaptorClassLoader.convertPath(uRLPath.asList()), RaptorClassLoader.class.getClassLoader());
        uRLPath.copyTo((Object)this.m_path);
    }

    private RaptorClassLoader(URLPath uRLPath, URLPath uRLPath2) {
        this(uRLPath);
        if (uRLPath2 != null) {
            uRLPath2.copyTo((Object)this.m_nativePath);
        }
    }

    private RaptorClassLoader(ClassLoader classLoader) {
        this(new URLPath(), classLoader);
    }

    private RaptorClassLoader(URLPath uRLPath, ClassLoader classLoader) {
        super(RaptorClassLoader.convertPath(uRLPath.asList()), classLoader);
        uRLPath.copyTo((Object)this.m_path);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    @Override
    public URL findResource(String string) {
        return super.findResource(string);
    }

    @Override
    protected String findLibrary(String string) {
        String string2 = System.mapLibraryName(string);
        URL uRL = this.m_nativePath.toBoundURL(string2);
        if (uRL != null) {
            String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
            File file = new File(string3);
            return file.getAbsolutePath();
        }
        return null;
    }

    URLPath getURLPath() {
        return this.m_path;
    }

    private static URL[] convertPath(List<URL> list) {
        int n = list.size();
        URL[] uRLArray = new URL[n];
        int n2 = 0;
        for (URL uRL : list) {
            if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
                uRL = JarUtil.getJarFileURL((URL)uRL);
            }
            uRLArray[n2++] = uRL;
        }
        return uRLArray;
    }
}

