/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.Bug4199622Fix;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionNameCellRenderer;
import oracle.dbtools.raptor.controls.IDBConnectionComboBoxListener;
import oracle.dbtools.raptor.editors.EditorUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class DBConnectionComboBox
implements ItemListener {
    private JComboBox m_dbConns;
    protected Connections m_conns;
    private DefaultComboBoxModel m_model;
    private String[] m_subTypes;
    private IDBConnectionComboBoxListener iDBCCBL;
    private ConnectionOpener task;
    private ConnectionTaskListener taskListener = new ConnectionTaskListener();
    private ITaskViewer taskViewer = null;
    private ConnectionListener m_connListener = new ConnectionListener(){

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
            String string;
            String string2 = connectionEvent.getOldName();
            if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName()))) {
                this.processConnectionRename(string2, string);
            }
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = connectionEvent.getConnectionName();
            this.processConnectionRename(string, string2);
        }

        private void processConnectionRename(String string, String string2) {
            String string3 = DBConnectionComboBox.this.getCurrentConnectionName();
            DBConnectionComboBox.this.addConnection(string2);
            if (ModelUtil.areEqual((Object)string, (Object)string3)) {
                DBConnectionComboBox.this.setCurrentConnection(string2);
            }
            DBConnectionComboBox.this.removeConnection(string);
        }

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DBConnectionComboBox.this.addConnection(string);
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DBConnectionComboBox.this.removeConnection(string);
        }
    };

    public DBConnectionComboBox(String[] stringArray) {
        this.m_subTypes = stringArray;
        this.init();
    }

    public DBConnectionComboBox() {
        this.init();
    }

    public DBConnectionComboBox(Container container) {
        this.init();
        this.add(container);
    }

    public DBConnectionComboBox(Container container, String[] stringArray) {
        this.m_subTypes = stringArray;
        this.init();
        this.add(container);
    }

    public void init() {
        this.m_conns = Connections.getInstance();
        this.m_model = new DefaultComboBoxModel();
        this.m_dbConns = new JComboBox(this.m_model);
        this.m_dbConns.setToolTipText(ControlsArb.getString("DB_CONNECTIONS_TIP"));
        this.m_dbConns.setRenderer(new DBConnectionNameCellRenderer());
        this.m_dbConns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Color color = null;
                    Object object = itemEvent.getItem();
                    if (object != null) {
                        color = this.getColor(object.toString());
                    }
                    if (color != null) {
                        DBConnectionComboBox.this.m_dbConns.setForeground(color);
                    } else {
                        DBConnectionComboBox.this.m_dbConns.setForeground(UIManager.getColor("ComboBox.foreground"));
                    }
                }
            }

            private Color getColor(String string) {
                return string != null ? DBConnectionComboBox.this.m_conns.getConnectionColor(string) : null;
            }
        });
        this.m_conns.addConnectionListener(this.m_connListener);
        Object var1_1 = null;
        this.populate();
        this.m_dbConns.addActionListener(Bug4199622Fix.INSTANCE);
        this.m_dbConns.addPopupMenuListener(Bug4199622Fix.INSTANCE);
    }

    public void dispose() {
        this.m_conns.removeConnectionListener(this.m_connListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_dbConns.addActionListener(actionListener);
    }

    public void setCurrentConnection(String string) {
        if (string != null) {
            this.m_model.setSelectedItem(string);
        } else {
            this.m_dbConns.setSelectedIndex(-1);
        }
        if (string != null && Connections.isUnsharedWorksheetConnection(string)) {
            this.m_dbConns.setEnabled(false);
        } else {
            this.m_dbConns.setEnabled(true);
        }
    }

    public JComboBox getJComboBox() {
        return this.m_dbConns;
    }

    public void add(Container container) {
        container.add(this.m_dbConns);
    }

    public AccessibleContext getAccessibleContext() {
        return this.m_dbConns.getAccessibleContext();
    }

    public String getCurrentConnectionName() {
        String string = null;
        try {
            string = this.m_dbConns.getItemCount() > 0 ? (String)this.m_dbConns.getSelectedItem() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void resize() {
        this.m_dbConns.setSize(this.m_dbConns.getPreferredSize());
        this.m_dbConns.setMaximumSize(this.m_dbConns.getPreferredSize());
    }

    protected void populate() {
        String[] stringArray = this.m_subTypes != null ? this.m_conns.getConnNames(this.m_subTypes) : this.m_conns.getConnNames();
        for (String string : stringArray) {
            this.addConnection(string);
        }
    }

    public String[] getConnNames() {
        return this.m_conns.getConnNames();
    }

    public void addConnection(String string) {
        this.addConnection(string, false);
    }

    public void addConnection(String string, boolean bl) {
        if (!bl && Connections.isUnsharedWorksheetConnection(string)) {
            return;
        }
        String string2 = this.getCurrentConnectionName();
        boolean bl2 = false;
        for (int i = 0; i < this.m_dbConns.getItemCount(); ++i) {
            if (!this.m_dbConns.getItemAt(i).equals(string)) continue;
            bl2 = true;
        }
        if (!bl2) {
            if (this.m_dbConns.getItemCount() == 0) {
                this.m_dbConns.insertItemAt(string, 0);
            } else {
                this.m_dbConns.addItem(string);
            }
            this.resize();
        }
        if (string2 == null) {
            this.m_dbConns.setSelectedIndex(-1);
        }
    }

    public void makeNewConnection() {
        String string = null;
        string = ConnectionSelectorUI.getConnection(ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), string, true);
        this.setCurrentConnection(string);
    }

    public void removeConnection(String string) {
        this.m_model.removeElement(string);
        this.resize();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.iDBCCBL != null) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    Editor editor;
                    String string = (String)itemEvent.getItem();
                    IRaptorTaskRunMode iRaptorTaskRunMode = null;
                    iRaptorTaskRunMode = this.taskViewer == null ? IRaptorTaskRunMode.MODAL : IRaptorTaskRunMode.TASKVIEWER;
                    this.task = new ConnectionOpener(iRaptorTaskRunMode);
                    this.task.getDescriptor().addListener((IRaptorTaskListener)this.taskListener);
                    if (this.taskViewer == null) {
                        RaptorTaskManager.getInstance().addTask((RaptorTask)this.task);
                    } else {
                        editor = new ArrayList();
                        editor.add(this.taskViewer);
                        RaptorTaskManager.getInstance().addTask((RaptorTask)this.task, (List)editor);
                    }
                    editor = EditorManager.getEditorManager().getCurrentEditor();
                    if (editor == null) break;
                    EditorUtils.setDBViewColor((View)editor);
                }
            }
        }
    }

    public void addConnectionOpenListener(IDBConnectionComboBoxListener iDBConnectionComboBoxListener, ITaskViewer iTaskViewer) {
        this.iDBCCBL = iDBConnectionComboBoxListener;
        this.taskViewer = iTaskViewer;
        if (iDBConnectionComboBoxListener != null) {
            this.m_dbConns.addItemListener(this);
        }
    }

    public void removeConnectionOpenListener() {
        if (this.iDBCCBL != null) {
            this.m_dbConns.removeItemListener(this);
        }
    }

    private class ConnectionTaskListener
    extends RaptorTaskAdapter {
        private ConnectionTaskListener() {
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            if (DBConnectionComboBox.this.iDBCCBL != null && DBConnectionComboBox.this.task != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        DBConnectionComboBox.this.iDBCCBL.connectionOpening();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
            if (DBConnectionComboBox.this.iDBCCBL != null && DBConnectionComboBox.this.task != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Connection connection = null;
                        try {
                            connection = (Connection)DBConnectionComboBox.this.task.getResult();
                            DBConnectionComboBox.this.iDBCCBL.connectionOpened(connection);
                        }
                        catch (Exception exception) {
                            raptorTaskEvent.setThrowable((Throwable)exception);
                            DBConnectionComboBox.this.iDBCCBL.connectionFailed(raptorTaskEvent);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            if (DBConnectionComboBox.this.iDBCCBL != null && DBConnectionComboBox.this.task != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        DBConnectionComboBox.this.iDBCCBL.connectionFailed(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
            if (DBConnectionComboBox.this.iDBCCBL != null && DBConnectionComboBox.this.task != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        DBConnectionComboBox.this.iDBCCBL.connectionCanceled(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private class ConnectionOpener
    extends RaptorTask<Connection> {
        public ConnectionOpener(IRaptorTaskRunMode iRaptorTaskRunMode) {
            super("Connection Opener", true, iRaptorTaskRunMode);
            this.setCancellable(true);
            this.setPausable(false);
        }

        protected Connection doWork() throws TaskException {
            try {
                return DBConnectionComboBox.this.m_conns.getConnection(DBConnectionComboBox.this.getCurrentConnectionName());
            }
            catch (DBException dBException) {
                throw new TaskException((Throwable)dBException);
            }
        }
    }
}

