/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.OracleColumnDnDHandler;
import oracle.dbtools.raptor.controls.OraclePackageMemberDnDHandler;
import oracle.dbtools.raptor.controls.OracleStoredProgramDnDHandler;
import oracle.dbtools.raptor.controls.OracleTableDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public final class RaptorCodeEditorDnDProviderRegistry {
    private static Map<String, StringTemplateGroup> s_groups = new HashMap<String, StringTemplateGroup>();
    private static final String DEFAULT_TEMPLATE = "dnd";
    private static final String DEFAULT_TEMPLATE_DIR = "oracle/dbtools/raptor/controls/templates";
    private static Map<String, Map<String, RaptorCodeEditorDnDHandler>> s_handlers = new HashMap<String, Map<String, RaptorCodeEditorDnDHandler>>();

    public static final synchronized void addDnDProvider(String string, String string2, RaptorCodeEditorDnDHandler raptorCodeEditorDnDHandler) {
        if (!RaptorCodeEditorDnDProviderRegistry.hasLength(string) || !RaptorCodeEditorDnDProviderRegistry.hasLength(string2) || raptorCodeEditorDnDHandler == null) {
            return;
        }
        if (s_handlers.get(string) == null) {
            s_handlers.put(string, new HashMap());
        }
        if (s_handlers.get(string).get(string2) == null) {
            s_handlers.get(string).put(string2, raptorCodeEditorDnDHandler);
        }
    }

    public static final RaptorCodeEditorDnDHandler getDnDProvider(String string, String string2) {
        RaptorCodeEditorDnDHandler raptorCodeEditorDnDHandler = null;
        if (s_handlers != null && string != null && string2 != null && s_handlers.get(string) != null && (raptorCodeEditorDnDHandler = (RaptorCodeEditorDnDHandler)((HashMap)s_handlers.get(string)).get(string2)) == null) {
            raptorCodeEditorDnDHandler = (RaptorCodeEditorDnDHandler)((HashMap)s_handlers.get(string)).get("DEFAULT");
        }
        return raptorCodeEditorDnDHandler;
    }

    public static final void registerTemplateGroup(String string, String string2, String string3) {
        RaptorCodeEditorDnDProviderRegistry.registerTemplateGroup(string, string2, string3, RaptorCodeEditorDnDProviderRegistry.class.getClassLoader());
    }

    public static final void registerTemplateGroup(String string, String string2, String string3, ClassLoader classLoader) {
        if (RaptorCodeEditorDnDProviderRegistry.hasLength(string) && RaptorCodeEditorDnDProviderRegistry.hasLength(string2) && RaptorCodeEditorDnDProviderRegistry.hasLength(string3)) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader(string2, classLoader);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup((String)string3);
            s_groups.put(string, stringTemplateGroup);
        }
    }

    public static final StringTemplate getTemplate(String string, String string2) {
        StringTemplateGroup stringTemplateGroup = null;
        StringTemplate stringTemplate = null;
        if (RaptorCodeEditorDnDProviderRegistry.hasLength(string) && RaptorCodeEditorDnDProviderRegistry.hasLength(string2) && (stringTemplateGroup = s_groups.get(string)) != null) {
            stringTemplate = stringTemplateGroup.getInstanceOf(string2);
        }
        return stringTemplate;
    }

    public static boolean isQualifyObjectName(String string, String string2) {
        DatabaseMetaData databaseMetaData = null;
        String string3 = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            if (connection == null) {
                return false;
            }
            databaseMetaData = connection.getMetaData();
            string3 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(RaptorCodeEditorDnDProviderRegistry.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string2 == null || !string2.equals(string3);
    }

    private static boolean hasLength(String string) {
        return string != null && string.trim().length() > 0;
    }

    static {
        HashMap<String, RaptorCodeEditorDnDHandler> hashMap = new HashMap<String, RaptorCodeEditorDnDHandler>();
        hashMap.put("DEFAULT", new DefaultRaptorCodeEditorDnDHandler());
        hashMap.put("TABLE", new OracleTableDnDHandler());
        hashMap.put("VIEW", new OracleTableDnDHandler());
        hashMap.put("COLUMN", new OracleColumnDnDHandler());
        hashMap.put("VIEW_COLUMN", new OracleColumnDnDHandler());
        hashMap.put("FUNCTION", new OracleStoredProgramDnDHandler());
        hashMap.put("PROCEDURE", new OracleStoredProgramDnDHandler());
        hashMap.put("MEMBER", new OraclePackageMemberDnDHandler());
        s_handlers.put("Oracle", hashMap);
        RaptorCodeEditorDnDProviderRegistry.registerTemplateGroup("Oracle", DEFAULT_TEMPLATE_DIR, DEFAULT_TEMPLATE);
    }
}

