/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class RaptorTableEditorTextField
extends JTextField {
    private JTable table;

    public RaptorTableEditorTextField(JTable jTable) {
        this.table = jTable;
        this.addMouseListener(new DrillDownListener());
        Document document = this.getDocument();
        if (document != null) {
            document.putProperty("filterNewlines", Boolean.FALSE);
        }
        if (this.isEditable()) {
            this.setCaret(new DefaultCaret());
        }
    }

    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    @Override
    public void setText(String string) {
        super.setText(string != null ? string.toString() : "");
    }

    private final class DrillDownListener
    extends MouseAdapter {
        private DrillDownListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                MouseListener[] mouseListenerArray = RaptorTableEditorTextField.this.table.getMouseListeners();
                for (MouseListener mouseListener : RaptorTableEditorTextField.this.table.getMouseListeners()) {
                    Point point = mouseEvent.getPoint();
                    mouseListener.mouseClicked(mouseEvent);
                }
            }
        }
    }
}

