/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;
import oracle.sql.Datum;

public abstract class DisplayAdapter
implements IDisplay {
    private static MetaClass<AbstractMenuAction> s_drillClass;
    protected Query _query;
    protected String _connName;
    protected JScrollPane _sp;
    private Map<String, Object> _bindMap;
    protected boolean _dirty = false;
    private Map<String, String> _extVales;
    private ArrayList<ISelectionChangeListener> _listeners = null;
    private String _type;
    private String _id;
    private IErrorHandler errorHandler;
    protected IRaptorTaskListener _taskListener;
    private DisplayModel _displayModel;
    private Toolbar _toolbar;
    protected View _view;
    private long lastScrollTimestamp;
    private int scrollPageSz;
    private final PropertyChangeSupport _listenerList = new PropertyChangeSupport(this);

    public static void setDrillActionClass(MetaClass<AbstractMenuAction> metaClass) {
        s_drillClass = metaClass;
    }

    protected static MetaClass<AbstractMenuAction> getDrillActionClass() {
        return s_drillClass;
    }

    @Override
    public void setId(String string) {
        this._id = string;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addSelectionChangeListener(ISelectionChangeListener iSelectionChangeListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(iSelectionChangeListener);
    }

    public void fireSelectionChanged() {
        if (this._listeners != null) {
            for (ISelectionChangeListener iSelectionChangeListener : this._listeners) {
                iSelectionChangeListener.parentSelectionChanged();
            }
        }
    }

    @Override
    public Map<String, String> getExtValues() {
        return this._extVales;
    }

    @Override
    public void setExtValues(Map<String, String> map) {
        this._extVales = map;
    }

    @Override
    public JScrollPane getScrollableUI() {
        if (this._sp == null) {
            JComponent jComponent = this.getUI();
            this._sp = new JScrollPane(jComponent);
        }
        return this._sp;
    }

    protected boolean hasScrollableUI() {
        return this._sp != null;
    }

    @Override
    public void replaceBindMap(Map<String, Object> map) {
        this._bindMap = map;
        this._dirty = true;
    }

    @Override
    public void appendBindMap(Map<String, Object> map) {
        if (map != null) {
            if (this._bindMap == null) {
                this._bindMap = new HashMap<String, Object>();
            }
            for (String string : map.keySet()) {
                if (this._bindMap != null && ModelUtil.areEqual((Object)this._bindMap.get(string), (Object)map.get(string))) continue;
                this._dirty = true;
                this._bindMap.putAll(map);
            }
        }
    }

    @Override
    public Map<String, Object> getBindMap() {
        HashMap hashMap = this._query.getBindValues();
        if (this._bindMap != null) {
            hashMap.putAll(this._bindMap);
        }
        return hashMap;
    }

    public Map<String, Bind> getFullValueBindMap() {
        Map<String, Object> map = this.getBindMap();
        HashMap<String, Bind> hashMap = new HashMap<String, Bind>();
        Set<String> set = map.keySet();
        for (String string : set) {
            Object object = map.get(string);
            String string2 = null;
            String string3 = null;
            if (object instanceof Datum) {
                string2 = this.getStringFromOracleDatum((Datum)object);
                string3 = this.getTypeFromOracleDatum((Datum)object);
            } else if (object instanceof BigDecimal) {
                string2 = Double.toString(((BigDecimal)object).doubleValue());
                string3 = "CHAR";
            } else {
                if (object != null && object != DBUtil.NULL_VALUE) {
                    string2 = object.toString();
                }
                string3 = "CHAR";
            }
            Bind bind = new Bind(string, string3, null, string2, null);
            hashMap.put(string, bind);
        }
        return hashMap;
    }

    private String getStringFromOracleDatum(Datum datum) {
        String string = null;
        try {
            string = datum.stringValue();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    private String getTypeFromOracleDatum(Datum datum) {
        String string = null;
        string = datum.getClass().toString();
        string = string.substring(string.lastIndexOf(".") + 1).toUpperCase();
        return string;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    @Override
    public void populateToolBar(Toolbar toolbar) {
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public void setConn(Connection connection) {
        boolean bl = false;
        try {
            if (this._connName != null && Connections.getInstance().getConnection(this._connName, false) == null) {
                bl = true;
            }
        }
        catch (DBException dBException) {
            bl = true;
        }
        if (bl || !ModelUtil.areEqual((Object)this.getConnection(), (Object)connection)) {
            this._connName = Connections.getInstance().getConnectionName(connection);
            this._dirty = true;
        }
    }

    @Override
    public void setConnName(String string) {
        if (!ModelUtil.areEqual((Object)this._connName, (Object)string)) {
            this._connName = string;
            this._dirty = true;
        }
    }

    public String getConnName() {
        return this._connName;
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            if (this._connName != null) {
                connection = Connections.getInstance().getConnection(this._connName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    @Override
    public Map<String, Object> getBinds(Point point) {
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public void close() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
            this._toolbar.removeAll();
        }
        if (this._sp != null && this._sp.getParent() != null) {
            this._sp.getParent().remove(this._sp);
        }
        this._view = null;
    }

    @Override
    public void setType(String string) {
        this._type = string;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public BasicEditorPane getCodeEditor() {
        return null;
    }

    @Override
    public void addTaskListener(IRaptorTaskListener iRaptorTaskListener) {
        this._taskListener = iRaptorTaskListener;
    }

    @Override
    public void removeTaskListener(IRaptorTaskListener iRaptorTaskListener) {
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public void setDisplayModel(DisplayModel displayModel) {
        this._displayModel = displayModel;
    }

    @Override
    public DisplayModel getDisplayModel() {
        return this._displayModel;
    }

    @Override
    public void setToolbar(Toolbar toolbar) {
        this._toolbar = toolbar;
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public void setView(View view) {
        this._view = view;
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Component getScrollableLeftMargin() {
        return null;
    }

    @Override
    public Component getScrollableTopMargin() {
        return null;
    }

    public void setErrorHandler(IErrorHandler iErrorHandler) {
        this.errorHandler = iErrorHandler;
    }

    public void handleException(Throwable throwable) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(IErrorHandler.Category.SQL, throwable);
        } else {
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    protected void addMouseMoveListener(Component component) {
        component.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWhen() > DisplayAdapter.this.lastScrollTimestamp) {
                    DisplayAdapter.this.scroll(mouseWheelEvent.getUnitsToScroll());
                    DisplayAdapter.this.lastScrollTimestamp = mouseWheelEvent.getWhen();
                }
            }
        });
    }

    protected void addPageListener(Component component) {
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getWhen() > DisplayAdapter.this.lastScrollTimestamp) {
                    switch (keyEvent.getKeyCode()) {
                        case 33: {
                            DisplayAdapter.this.scroll(-DisplayAdapter.this.scrollPageSz);
                            break;
                        }
                        case 34: {
                            DisplayAdapter.this.scroll(DisplayAdapter.this.scrollPageSz);
                            break;
                        }
                    }
                    DisplayAdapter.this.lastScrollTimestamp = keyEvent.getWhen();
                }
            }
        });
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.addPageListener(container.getComponent(i));
            }
        }
    }

    private void scroll(int n) {
        JScrollBar jScrollBar = this._sp.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getValue() + n);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChangeEvent(String string, Object object, Object object2) {
        this._listenerList.firePropertyChange(string, object, object2);
    }

    @Override
    public ContextMenu getContextMenu() {
        return null;
    }

    @Override
    public boolean isUseEditorScrollPane() {
        return true;
    }

    @Override
    public boolean isUseScrollableUI() {
        return true;
    }
}

