/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.IdeUtil;

public class DisplayHtml {
    private String _reportName;
    private List<DisplayModel> _models;
    private String _connectionName;
    private Connection _connection;
    private Map<String, Object> _binds;
    private File _baseDir;
    private String _fileName;
    private String _ideEncoding;
    private String _resourcePrefix;
    private File _resourceDir;
    private Writer _writer;
    private String _headerId;
    private Map<Class, Integer> generatorIds = new HashMap<Class, Integer>();

    public DisplayHtml(File file, String string, DisplayModel displayModel) {
        this(file, string, displayModel, null, null);
    }

    public DisplayHtml(File file, String string, DisplayModel displayModel, Map<String, Object> map) {
        this(file, string, displayModel, map, null);
    }

    public DisplayHtml(File file, String string, DisplayModel displayModel, Map<String, Object> map, String string2) {
        this(file, string, null, displayModel.getName(), Collections.singletonList(displayModel), map, string2);
    }

    public DisplayHtml(File file, String string, Connection connection, String string2, List<DisplayModel> list, Map<String, Object> hashMap, String string3) {
        this._baseDir = file.getParentFile();
        String string4 = file.getName();
        int n = string4.lastIndexOf(".");
        this._fileName = n > 0 ? string4.substring(0, n) : string4;
        this._reportName = string2;
        this._models = list;
        this._connectionName = string;
        this._connection = connection;
        this._binds = hashMap != null ? hashMap : new HashMap();
        this._headerId = string3;
        try {
            this._resourcePrefix = URLEncoder.encode(this._fileName, "UTF-8") + "/";
        }
        catch (IOException iOException) {
            this._resourcePrefix = this._fileName + "/";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IErrorHandler iErrorHandler) {
        this._ideEncoding = IdeUtil.getIdeEncoding();
        if (this._ideEncoding == null) {
            this._ideEncoding = "UTF-8";
        }
        try {
            this._writer = this.getFileWriter(new File(this._baseDir, this._fileName + ".html"));
        }
        catch (Exception exception) {
            iErrorHandler.handleError(IErrorHandler.Category.FILE, exception);
        }
        if (!iErrorHandler.hasErrors() && this._connection == null) {
            try {
                this._connection = Connections.getInstance().getConnection(this._connectionName, true);
                if (this._connection == null) {
                    iErrorHandler.handleError(IErrorHandler.Category.CONNECTION, new Exception(ControlsArb.getString("DATABASE_CONNECTION_ERROR")));
                }
            }
            catch (Exception exception) {
                iErrorHandler.handleError(IErrorHandler.Category.CONNECTION, exception);
            }
        }
        if (!iErrorHandler.hasErrors()) {
            try {
                try {
                    this._resourceDir = new File(this._baseDir, this._fileName);
                    this.initResources(iErrorHandler);
                    if (!iErrorHandler.hasErrors()) {
                        this.generateHtml(iErrorHandler);
                    }
                    if (!iErrorHandler.hasErrors()) {
                        this._writer.flush();
                    }
                }
                finally {
                    this._writer.close();
                }
            }
            catch (Exception exception) {
                iErrorHandler.handleError(IErrorHandler.Category.FILE, exception);
            }
        }
    }

    public URI uri() {
        File file = new File(this._baseDir, this._fileName + ".html");
        return file.toURI();
    }

    private void generateHtml(final IErrorHandler iErrorHandler) {
        try {
            final StringBuffer stringBuffer = new StringBuffer();
            IErrorHandler iErrorHandler2 = new IErrorHandler(){

                @Override
                public void handleError(IErrorHandler.Category category, Throwable throwable) {
                    stringBuffer.append("<pre>ERROR! ");
                    stringBuffer.append(throwable.getLocalizedMessage());
                    stringBuffer.append("</pre>");
                    iErrorHandler.handleError(category, throwable);
                }

                @Override
                public boolean hasErrors() {
                    return iErrorHandler.hasErrors();
                }
            };
            this._writer.write("<html>\n");
            this._writer.write("<head>\n");
            this._writer.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=" + this._ideEncoding + "\" />\n");
            this._writer.write("<script src=\"" + this._resourcePrefix + "report.js\" type=\"text/javascript\"></script>\n");
            this._writer.write("<link href=\"" + this._resourcePrefix + "report.css\" type=\"text/css\" rel=\"stylesheet\">\n");
            this._writer.write("</head>\n");
            this._writer.write("<body>\n");
            this.generateBannerHtml(iErrorHandler2);
            this._writer.write("<div id=\"masterreports\">\n");
            int n = 0;
            for (DisplayModel displayModel : this._models) {
                this.generateModelHtml(n++, displayModel, iErrorHandler2);
            }
            this._writer.write("</div>\n");
            if (iErrorHandler2.hasErrors()) {
                this._writer.write(stringBuffer.toString());
            }
            this._writer.write("</body>\n");
            this._writer.write("</html>\n");
        }
        catch (IOException iOException) {
            iErrorHandler.handleError(IErrorHandler.Category.FILE, iOException);
        }
    }

    private void generateBannerHtml(IErrorHandler iErrorHandler) {
        try {
            this._writer.write("<div class=\"banner\">\n");
            this._writer.write("<table width=\"98%\"><tr>\n");
            this._writer.write("<td><h2 class=\"banner\">" + this._reportName + "</h2></td>\n");
            if (this._headerId != null) {
                this._writer.write("<td align=\"RIGHT\"><small class=\"banner\">" + this._headerId + "</small></td>\n");
            }
            this._writer.write("</tr></table>");
            this._writer.write("</div>\n");
            if (this._models.size() > 1) {
                this._writer.write("<div id=\"maintabs\">\n");
                int n = 0;
                for (DisplayModel displayModel : this._models) {
                    String string = n == 0 ? "currentmaintab" : "maintab";
                    this._writer.write("<div class=\"" + string + "\" onclick=\"onSelectMainTab(this, " + n + ")\">\n");
                    this._writer.write("<div>\n");
                    this._writer.write("<p>" + displayModel.getName() + "</p>\n");
                    this._writer.write("</div>\n");
                    this._writer.write("</div>\n");
                    ++n;
                }
                this._writer.write("</div>\n");
            }
            this._writer.write("<br/>\n");
        }
        catch (IOException iOException) {
            iErrorHandler.handleError(IErrorHandler.Category.FILE, iOException);
        }
    }

    private void generateModelHtml(int n, DisplayModel displayModel, IErrorHandler iErrorHandler) {
        try {
            List<DisplayModel> list;
            this._writer.write("<div id=\"Master." + n + "\">\n");
            String string = n == 0 ? "currentmasterreport" : "masterreport";
            this._writer.write("<div class=\"" + string + "\">\n");
            List<Map<String, Object>> list2 = this.generateStyleSpecificHtml(false, displayModel, this._binds, iErrorHandler);
            if (list2 != null && (list = displayModel.getChildren()) != null && list.size() > 0) {
                this._writer.write("<br/>\n");
                this._writer.write("<hr/>\n");
                this._writer.write("<br/>");
                this._writer.write("<div id=\"ChildTabs." + n + "\">\n");
                int n2 = 0;
                for (DisplayModel object : list) {
                    String string2 = n2 == 0 ? "currentchildtab" : "childtab";
                    this._writer.write("<div class=\"" + string2 + "\" onclick=\"onSelectChildTab(this, " + n2 + ")\">\n");
                    this._writer.write("<div>\n");
                    this._writer.write("<p>" + object.getName() + "</p>\n");
                    this._writer.write("</div>\n");
                    this._writer.write("</div>\n");
                    ++n2;
                }
                this._writer.write("</div>\n");
                this._writer.write("<br/>\n");
                this._writer.write("<div id=\"ChildReports." + n + "\">\n");
                int n3 = 0;
                for (Map<String, Object> map : list2) {
                    n2 = 0;
                    for (DisplayModel displayModel2 : list) {
                        String string3 = n3 == 0 && n2 == 0 ? "currentchildreport" : "childreport";
                        this._writer.write("<div id=\"Child." + n2 + "." + n3 + "." + n + "\">\n");
                        this._writer.write("<div class=\"" + string3 + "\">");
                        if (this.generateStyleSpecificHtml(true, displayModel2, map, iErrorHandler) == null) break;
                        this._writer.write("</div>\n");
                        this._writer.write("</div>\n");
                        ++n2;
                    }
                    ++n3;
                }
                this._writer.write("</div>\n");
            }
            this._writer.write("</div>\n");
            this._writer.write("</div>\n");
        }
        catch (IOException iOException) {
            iErrorHandler.handleError(IErrorHandler.Category.FILE, iOException);
        }
    }

    private List<Map<String, Object>> generateStyleSpecificHtml(final boolean bl, final DisplayModel displayModel, final Map<String, Object> map, final IErrorHandler iErrorHandler) {
        ArrayList arrayList = null;
        try {
            IHtmlGenerator iHtmlGenerator = DisplayRegistry.getHtmlGenerator(displayModel.getStyle());
            final Integer n = this.fabricateGeneratorId(iHtmlGenerator, iErrorHandler);
            if (n != null) {
                final ArrayList arrayList2 = new ArrayList();
                iHtmlGenerator.generateHtml(new HtmlGenerationContext(){

                    @Override
                    public int id() {
                        return n;
                    }

                    @Override
                    public DisplayModel model() {
                        return displayModel;
                    }

                    @Override
                    public boolean isChildReport() {
                        return bl;
                    }

                    @Override
                    public Map<String, Object> binds() {
                        return map;
                    }

                    @Override
                    public String connectionName() {
                        return DisplayHtml.this._connectionName;
                    }

                    @Override
                    public Connection connection() {
                        return DisplayHtml.this._connection;
                    }

                    @Override
                    public String resourcePath(String string) {
                        return DisplayHtml.this._resourcePrefix + string;
                    }

                    @Override
                    public void addChildBinding(Map<String, Object> map2) {
                        arrayList2.add(map2);
                    }

                    @Override
                    public Writer writer() {
                        return DisplayHtml.this._writer;
                    }

                    @Override
                    public void addResource(String string, InputStream inputStream) throws IOException {
                        DisplayHtml.this.copyResource(inputStream, new File(DisplayHtml.this._resourceDir, string), false);
                    }

                    @Override
                    public IErrorHandler errorHandler() {
                        return iErrorHandler;
                    }
                });
                if (!iErrorHandler.hasErrors()) {
                    arrayList = arrayList2;
                }
            }
        }
        catch (Exception exception) {
            iErrorHandler.handleError(IErrorHandler.Category.OTHER, exception);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResources(IErrorHandler iErrorHandler) {
        String[] stringArray = new String[]{"report.js", "report.css", "headerBg.jpg", "topDimTabBg.gif", "topDimTabL.gif", "topDimTabR.gif", "topTabBg.gif", "topTabL.gif", "topTabR.gif"};
        this._resourceDir.mkdir();
        try {
            for (String string : stringArray) {
                InputStream inputStream = this.getClass().getResourceAsStream("generationresources/" + string);
                try {
                    this.copyResource(inputStream, new File(this._resourceDir, string), false);
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            iErrorHandler.handleError(IErrorHandler.Category.FILE, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(InputStream inputStream, File file, boolean bl) throws IOException {
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[4096];
            int n = bufferedInputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private Integer fabricateGeneratorId(IHtmlGenerator iHtmlGenerator, final IErrorHandler iErrorHandler) {
        Class<?> clazz = iHtmlGenerator.getClass();
        Integer n = this.generatorIds.get(clazz);
        if (n == null) {
            iHtmlGenerator.generateStaticResources(new ResourceGenerationContext(){

                @Override
                public void appendJavaScript(InputStream inputStream) throws IOException {
                    DisplayHtml.this.copyResource(inputStream, new File(DisplayHtml.this._resourceDir, "report.js"), true);
                }

                @Override
                public void appendStyleSheet(InputStream inputStream) throws IOException {
                    DisplayHtml.this.copyResource(inputStream, new File(DisplayHtml.this._resourceDir, "report.css"), true);
                }

                @Override
                public void addResource(String string, InputStream inputStream) throws IOException {
                    DisplayHtml.this.copyResource(inputStream, new File(DisplayHtml.this._resourceDir, string), false);
                }

                @Override
                public IErrorHandler errorHandler() {
                    return iErrorHandler;
                }
            });
            if (!iErrorHandler.hasErrors()) {
                n = 0;
            }
        } else {
            n = n + 1;
        }
        this.generatorIds.put(clazz, n);
        return n;
    }

    private Writer getFileWriter(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, this._ideEncoding);
        return outputStreamWriter;
    }
}

