/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;

public class DisplayPLSQL
extends DisplayAdapter {
    private JEditorPane htmlPane;

    public void init() {
        if (this.htmlPane == null) {
            this.htmlPane = new JEditorPane();
            this.htmlPane.setContentType("text/html");
            this.htmlPane.setEditable(false);
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this.htmlPane;
    }

    @Override
    public void close() {
        JEditorPane jEditorPane = this.htmlPane;
        this.htmlPane = null;
        if (jEditorPane != null && jEditorPane.getParent() != null) {
            jEditorPane.getParent().remove(jEditorPane);
        }
        super.close();
    }

    @Override
    public void refresh(boolean bl) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("ResultSetTableModel.8"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){
            private PreparedStatement refreshPstmt;
            private boolean refreshCancelled;
            {
                this.refreshCancelled = false;
            }

            public boolean cancel() {
                if (this.refreshPstmt != null) {
                    try {
                        this.refreshPstmt.cancel();
                        this.refreshCancelled = true;
                    }
                    catch (SQLException sQLException) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                        return false;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                Connection connection;
                DisplayPLSQL.this.init();
                Connection connection2 = connection = DisplayPLSQL.this.getConnection();
                synchronized (connection2) {
                    block24: {
                        try {
                            Connections.getInstance().lock(connection);
                            DisplayPLSQL.this.htmlPane.setText("");
                            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                            dBUtil.setRaiseError(false);
                            String string = DisplayPLSQL.this.getQuery().getSql();
                            if (string != null) {
                                string = string.replaceAll("\r", " ");
                            }
                            this.refreshPstmt = dBUtil.prepareExecute(string, DisplayPLSQL.this.getBindMap());
                            if (this.refreshPstmt == null) break block24;
                            Statement statement = DisplayPLSQL.this.getConnection().createStatement();
                            try {
                                statement.execute("begin dbms_output.enable; end;");
                            }
                            finally {
                                statement.close();
                            }
                            this.refreshPstmt.execute();
                            final String string2 = dBUtil.getDBMSOUTPUT();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DisplayPLSQL.this.htmlPane.setText(string2);
                                }
                            });
                        }
                        catch (SQLException sQLException) {
                            if (!this.refreshCancelled && sQLException.getErrorCode() != 17104) {
                                DisplayPLSQL.this.handleException(sQLException);
                            }
                        }
                        catch (Exception exception) {
                            DisplayPLSQL.this.handleException(exception);
                        }
                        finally {
                            try {
                                if (this.refreshPstmt != null) {
                                    this.refreshPstmt.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)sQLException);
                            }
                            Connections.getInstance().unlock(connection);
                        }
                    }
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void addActions(List<ObjectAction> list) {
    }

    @Override
    public void clear() {
        this.htmlPane.setText("");
    }
}

