/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.controls.JMenuSorter;

public class DisplayResultTable
extends DisplayAdapter
implements ISelectionChangeListener {
    private Logger logger = Logger.getLogger(DisplayResultTable.class.getName());
    protected ResultSetTable _grid;
    private Map<String, Object> _binds;
    private DisplayRTContextMenuListener _menu;
    protected boolean _closing = false;
    private List<ObjectAction> _actions;
    public static final int _delay = 1000;
    private RefreshChecker _refreshChecker;
    private IRaptorTaskListener notifyEditorHeadersChanged = new RaptorTaskAdapter(){

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new EditorHeadersChange());
        }
    };

    public void initTable() {
        if (this._grid == null) {
            this._grid = new ResultSetTable();
            this._refreshChecker = new RefreshChecker(1000);
            this._grid.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!DisplayResultTable.this._closing && !listSelectionEvent.getValueIsAdjusting()) {
                        int n = DisplayResultTable.this._grid.getSelectedRow();
                        if (!DisplayResultTable.this._refreshChecker.isRunning()) {
                            DisplayResultTable.this._refreshChecker.setLastSelectedRow(n);
                            DisplayResultTable.this._refreshChecker.start();
                        } else {
                            DisplayResultTable.this._refreshChecker.setLastSelectedRow(n);
                            DisplayResultTable.this._refreshChecker.restart();
                        }
                    }
                }
            });
            this._menu = new DisplayRTContextMenuListener(this);
            this._grid.addLocalContextMenuListener(this._menu);
        }
        this._grid.setMinimumSize(new Dimension(200, 200));
    }

    @Override
    public void setToolbar(Toolbar toolbar) {
        super.setToolbar(toolbar);
        this.initTable();
        this.getGrid().setToolbar(toolbar);
    }

    @Override
    public JComponent getUI() {
        this.logger.finer("DisplayResultTable.getUI()");
        this.initTable();
        return this._grid;
    }

    @Override
    public void close() {
        this.logger.finer("DisplayResultTable.close()");
        this._binds = null;
        this._closing = true;
        if (this._grid != null) {
            this._grid.closeModel();
        }
        if (this._menu != null) {
            RaptorGridTable.removeGridContextMenu((GridContextMenuItem)this._menu);
        }
        if (this._refreshChecker != null) {
            this._refreshChecker.stop();
        }
        if (this._grid != null && this._grid.getParent() != null) {
            this._grid.getParent().remove((Component)((Object)this._grid));
        }
        this._grid = null;
        super.close();
    }

    @Override
    public void refresh(boolean bl) {
        this.logger.finer("DisplayResultTable.refresh(" + bl + ")");
        String string = this.getQuery().getSql();
        if (string == null) {
            return;
        }
        if (this._grid == null) {
            this.initTable();
        }
        this._grid.clearSelection();
        Map<String, Object> map = this.getBindMap();
        Iterator<String> iterator = map.keySet().iterator();
        String string2 = null;
        while (iterator.hasNext()) {
            string2 = iterator.next();
            this.logger.finer(string2 + "=" + map.get(string2));
        }
        if (!bl || this.isDirty() || this._grid.getGridModel() == null) {
            if (string.indexOf(":") == -1 || string.indexOf(":") > 0) {
                this.updateQuery(string, map);
                try {
                    ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
                    if (this._taskListener != null) {
                        arrayList.add(this._taskListener);
                    }
                    arrayList.add(this.notifyEditorHeadersChanged);
                    this.openGrid(arrayList);
                }
                catch (ExecutionException executionException) {
                    this.logger.severe(executionException.getLocalizedMessage());
                    return;
                }
                this.logger.finer(Messages.getString("DisplayResultTable.9") + string);
                this.setDirty(false);
            }
        } else if (bl) {
            try {
                this._grid.refresh();
                this.setDirty(false);
            }
            catch (ExecutionException executionException) {
                this.logger.severe(executionException.getLocalizedMessage());
                return;
            }
        }
    }

    @Override
    protected void addMouseMoveListener(Component component) {
    }

    protected void openGrid(List<IRaptorTaskListener> list) throws ExecutionException {
        this._grid.open(new RaptorGridTaskWrapper(Messages.getString("DisplayResultsLabel"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, list, null, null));
    }

    protected void updateQuery(String string, Map<String, Object> map) {
        String string2 = this.getExtValues().get("TYPE");
        if (string2 != null && string2.equalsIgnoreCase("vertical")) {
            this._grid.setVerticalDisplay(true);
        }
        if (this.getExtValues().containsKey("SCRIPTTABLE")) {
            if (!string.startsWith("/*SQLDEV:SCRIPTTABLE*/")) {
                string = "/*SQLDEV:SCRIPTTABLE*/" + string;
            }
            this.getQuery().setSql(string);
        }
        this._grid.setQuery(this.getConnName(), QueryUtils.expandQuery((String)string, map), null, map);
        this._grid.getGridModel().setQueryObject(this.getQuery());
    }

    public Map<String, Object> getBinds() {
        this.logger.finer("DisplayResultTable.getBinds()");
        return this._binds;
    }

    @Override
    public Map<String, Object> getBinds(Point point) {
        if (point != null) {
            this.logger.finer("DisplayResultTable.getBinds(" + point.getX() + "," + point.getY() + ")");
        }
        if (this._binds == null) {
            this._binds = new HashMap<String, Object>();
        } else {
            this._binds.clear();
        }
        int n = this._grid.getSelectedRow();
        if (n == -1 && point != null) {
            n = this._grid.rowAtPoint(point);
        }
        if (n > -1) {
            int n2 = this._grid.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                String string = this._grid.getColumnName(i);
                Object object = this._grid.getValueAt(n, i);
                this._binds.put(string, object);
            }
        }
        return this._binds;
    }

    @Override
    public void parentSelectionChanged() {
    }

    @Override
    public void addActions(List<ObjectAction> list) {
        this._actions = list;
    }

    @Override
    public void clear() {
        if (this._grid != null && this._grid.getModel() != null && this._grid.getModel() instanceof IResultSetTableModel) {
            this._grid.clearSelection();
            ((IResultSetTableModel)((Object)this._grid.getModel())).closeModel();
        }
    }

    public ResultSetTable getGrid() {
        return this._grid;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public Component getScrollableLeftMargin() {
        return null == this._grid ? null : this._grid.getRowHeader();
    }

    @Override
    public Component getScrollableTopMargin() {
        return null == this._grid ? null : this._grid.getTableHeader();
    }

    @Override
    public JScrollPane getScrollableUI() {
        JScrollPane jScrollPane = super.getScrollableUI();
        jScrollPane.setRowHeaderView(this.getScrollableLeftMargin());
        jScrollPane.setColumnHeaderView(this.getScrollableTopMargin());
        return jScrollPane;
    }

    @Override
    public ContextMenu getContextMenu() {
        return null == this._grid ? null : this._grid.getContextMenu();
    }

    @Override
    public void setView(View view) {
        super.setView(view);
        this._grid.setView(this.getView());
    }

    private class RefreshChecker
    extends Timer {
        int lastSelectedRow;
        ActionListener listener;

        public RefreshChecker(int n) {
            super(n, null);
            this.lastSelectedRow = -1;
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (DisplayResultTable.this._grid != null && (n = DisplayResultTable.this._grid.getSelectedRow()) == RefreshChecker.this.lastSelectedRow && n < DisplayResultTable.this._grid.getLoadedRowCount()) {
                        RefreshChecker.this.lastSelectedRow = n;
                        DisplayResultTable.this.fireSelectionChanged();
                    }
                }
            };
            this.addActionListener(this.listener);
            this.setRepeats(false);
        }

        void setLastSelectedRow(int n) {
            this.lastSelectedRow = n;
        }
    }

    public class DisplayRTContextMenuListener
    extends GridContextMenuItem {
        JMenu reports;
        JMenu auto;
        private DisplayResultTable _display;
        boolean showA;
        private HashMap<String, myMenu> menus = new HashMap();

        DisplayRTContextMenuListener(DisplayResultTable displayResultTable2) {
            this._display = displayResultTable2;
        }

        public boolean canShow(ContextMenu contextMenu) {
            boolean bl = false;
            this.reports = contextMenu.createMenu(Messages.getString("DisplayResultTable.14"), (float)StringUtils.getMnemonicKeyCode((String)Messages.getString("DisplayResultTable.15")));
            JMenuSorter.registerJMenu((JMenu)this.reports);
            this.showA = false;
            if (this._table != null && this._table == this._display.getGrid()) {
                Object object;
                contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
                contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                if (DisplayResultTable.this._actions != null) {
                    object = DisplayResultTable.this._actions.iterator();
                    while (object.hasNext()) {
                        ObjectAction objectAction = (ObjectAction)object.next();
                        JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                        objectAction.putProperty("CONTEXT", contextMenu.getContext());
                        objectAction.putProperty("DISPLAY", (Object)this);
                        objectAction.putProperty("ACTION_TYPE", "REPORT");
                        if (objectAction.getMetaClass() == DisplayAdapter.getDrillActionClass()) {
                            this.reports.add(jMenuItem);
                            this.showA = true;
                            continue;
                        }
                        contextMenu.add((Component)jMenuItem);
                    }
                }
                if ((object = System.getProperty("sqldev.autoreport")) != null && ((String)object).equals("TRUE")) {
                    this.getDrillableReports(contextMenu);
                    bl = true;
                } else if (this.showA) {
                    contextMenu.add((Component)this.reports);
                    bl = true;
                }
            }
            return bl;
        }

        private JMenu processPath(String string) {
            String[] stringArray = string.split("/");
            String string2 = "";
            myMenu myMenu2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = string2;
                myMenu2 = this.menus.get(string2 = string2 + "/" + stringArray[i]);
                if (myMenu2 != null) continue;
                myMenu2 = new myMenu(i, new JMenu(stringArray[i]));
                if (i > 0) {
                    this.menus.get(string3).getMenu().add(myMenu2.getMenu());
                }
                this.menus.put(string2, myMenu2);
            }
            return myMenu2.getMenu();
        }

        private void addRootMenus(JMenu jMenu) {
            for (String string : this.menus.keySet()) {
                if (this.menus.get(string).getDepth() != 0) continue;
                jMenu.add(this.menus.get(string).getMenu());
            }
        }

        public void getDrillableReports(ContextMenu contextMenu) {
            this.menus = new HashMap();
            ArrayList<String> arrayList = DisplayModelCache.getIds();
            Map<String, Object> map = DisplayResultTable.this.getBinds();
            this.auto = contextMenu.createMenu(Messages.getString("DisplayResultTable.8"), (float)StringUtils.getMnemonicKeyCode((String)Messages.getString("DisplayResultTable.7")));
            boolean bl = false;
            for (String string : arrayList) {
                DisplayModel displayModel = DisplayModelCache.getDisplayModel(string);
                Query query = displayModel.getQueries() == null ? null : QueryUtils.getQuery(displayModel.getQueries(), (Connection)DisplayResultTable.this.getConnection());
                if (query == null) continue;
                List list = query.getBinds();
                boolean bl2 = query.getBinds().size() > 0;
                for (Bind bind : list) {
                    if (map.containsKey(bind.getName())) continue;
                    bl2 = false;
                }
                if (!bl2) continue;
                ObjectAction objectAction = new ObjectAction();
                objectAction.setMetaClass(DisplayAdapter.getDrillActionClass());
                objectAction.setTitle(displayModel.getName());
                objectAction.setClassArgs(displayModel.getID());
                int n = displayModel.getPath().lastIndexOf(displayModel.getName().trim()) - 1;
                if (n <= 0) continue;
                String string2 = displayModel.getPath().substring(0, n);
                JMenu jMenu = this.processPath(string2);
                if (!JMenuSorter.isSorted((JMenu)jMenu)) {
                    JMenuSorter.registerJMenu((JMenu)jMenu);
                }
                JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
                objectAction.putProperty("CONTEXT", contextMenu.getContext());
                objectAction.putProperty("ACTION_TYPE", "REPORT");
                jMenu.add(jMenuItem);
                bl = true;
            }
            if (bl) {
                this.addRootMenus(this.auto);
                this.reports.add(this.auto);
            }
            if (this.showA || bl) {
                contextMenu.add((Component)this.reports);
            }
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return true;
        }

        public String getID() {
            if (this._display == null) {
                return null;
            }
            return this._display.getId();
        }

        public DisplayModel getDisplayModel() {
            if (this._display == null) {
                return null;
            }
            return this._display.getDisplayModel();
        }

        private class myMenu {
            int _depth;
            JMenu _menu;

            public myMenu(int n, JMenu jMenu) {
                this._menu = jMenu;
                this._depth = n;
            }

            public JMenu getMenu() {
                return this._menu;
            }

            public int getDepth() {
                return this._depth;
            }
        }
    }

    private class EditorHeadersChange
    implements Runnable {
        private EditorHeadersChange() {
        }

        @Override
        public void run() {
            JTable jTable = DisplayResultTable.this._grid.getRowHeader();
            jTable.setModel((TableModel)DisplayResultTable.this._grid.getGridModel().getRowHeaderModel());
            jTable.setSize(jTable.getPreferredSize());
            if (DisplayResultTable.this.hasScrollableUI()) {
                JScrollPane jScrollPane = DisplayResultTable.this.getScrollableUI();
                jScrollPane.setRowHeaderView(jTable);
                jScrollPane.setColumnHeaderView(DisplayResultTable.this._grid.getTableHeader());
            } else {
                DisplayResultTable.this.firePropertyChangeEvent("scrollable_left_margin", null, jTable);
                DisplayResultTable.this.firePropertyChangeEvent("scrollable_top_margin", null, DisplayResultTable.this._grid.getTableHeader());
            }
        }
    }
}

