/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.newscriptrunner.OutputRedirector;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class DisplayScript
extends DisplayAdapter {
    private BasicEditorPane _codeArea;

    public void init() {
        if (this._codeArea == null) {
            this._codeArea = EditorFactory.createIdeEditorPane();
            this._codeArea.setText("");
            this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            this._codeArea.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this._codeArea.setText("");
            this._codeArea.setEditable(false);
            LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            this._codeArea.installPlugin((EditorPlugin)lineGutterPlugin);
            JScrollPane jScrollPane = this.getScrollableUI();
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._codeArea;
    }

    @Override
    public void close() {
        BasicEditorPane basicEditorPane = this._codeArea;
        this._codeArea = null;
        if (basicEditorPane != null && basicEditorPane.getParent() != null) {
            basicEditorPane.getParent().remove((Component)basicEditorPane);
        }
        super.close();
    }

    @Override
    public void refresh(boolean bl) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("ResultSetTableModel.8"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                DisplayScript.this.init();
                Connection connection = DisplayScript.this.getConnection();
                synchronized (connection) {
                    try {
                        DisplayScript.this._codeArea.getDocument().remove(0, DisplayScript.this._codeArea.getDocument().getLength());
                        ScriptExecutor scriptExecutor = new ScriptExecutor(DisplayScript.this.getQuery().getSql(), DisplayScript.this.getConnection());
                        DisplayScript.this._codeArea.setEditable(true);
                        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                        scriptRunnerContext.putProperty("BINDMAP", DisplayScript.this.getFullValueBindMap());
                        scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                        PipedInputStream pipedInputStream = new PipedInputStream();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                        scriptExecutor.setOut(bufferedOutputStream);
                        scriptExecutor.getScriptRunnerContext().setBaseConnection(DisplayScript.this.getConnection());
                        scriptExecutor.getScriptRunnerContext().setCurrentConnection(DisplayScript.this.getConnection());
                        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, DisplayScript.this._codeArea.getDocument(), DisplayScript.this._codeArea);
                        outputRedirector.setName(Messages.getString("DisplayScript.3"));
                        outputRedirector.start();
                        scriptExecutor.start();
                        DisplayScript.this._codeArea.setEditable(false);
                        String string = DisplayScript.this._codeArea.getText();
                    }
                    catch (Exception exception) {
                        DisplayScript.this.handleException(exception);
                    }
                }
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void addActions(final List<ObjectAction> list) {
        UIUtils.MousePopupTriggerListener mousePopupTriggerListener = new UIUtils.MousePopupTriggerListener(){

            protected void doPopup(MouseEvent mouseEvent) {
                ContextMenu contextMenu = new ContextMenu();
                for (ObjectAction objectAction : list) {
                    contextMenu.add((Component)objectAction.getMenuItem());
                }
                Context context = new Context();
                context.setEvent((EventObject)mouseEvent);
                contextMenu.show(context);
            }
        };
        this.init();
        this._codeArea.addMouseListener((MouseListener)mousePopupTriggerListener);
    }

    @Override
    public void clear() {
        this._codeArea.setText("");
    }

    @Override
    public boolean isUseEditorScrollPane() {
        return false;
    }

    @Override
    public BasicEditorPane getCodeEditor() {
        return this._codeArea;
    }
}

