/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.display.CancellableQuery;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.PopupManager;
import oracle.dss.gauge.Gauge;
import oracle.dss.gauge.GaugeModelAdapter;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.MessageDialog;

public class DisplaySimpleGuage
extends DisplayAdapter {
    MouseListener mListen = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ContextMenu contextMenu = new ContextMenu();
            String string = "RSETTABLE";
            Context context = new Context();
            int n = mouseEvent.getModifiers();
            if ((n & 8) != 0 || (n & 4) != 0) {
                context.setProperty(string, mouseEvent.getSource());
                context.setEvent((EventObject)mouseEvent);
                contextMenu.show(context);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private Gauge _gauge;
    private Boolean _show;
    private DisplaySimpleGuage _instance;
    private boolean refreshInTask = true;
    GaugeModelAdapter _gm = null;
    private List<ObjectAction> _actions;

    public Boolean getBoolean(String string) {
        try {
            String string2 = this.getExtValues().get(string);
            if (string2.equals("true")) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void init() {
        if (this._gauge == null) {
            if (this._instance == null) {
                this._instance = this;
            }
            this._gauge = new Gauge();
            String string = this.getExtValues().get("TYPE");
            if (string.equals("DIAL")) {
                this._gauge.setGaugeType(0);
            } else if (string.equals("STATUSMETER")) {
                this._gauge.setGaugeType(1);
            } else {
                this._gauge.setGaugeType(9);
            }
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            this._gauge.setLocale(locale);
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._gauge;
    }

    @Override
    public void close() {
        Gauge gauge = this._gauge;
        this._gauge = null;
        if (gauge != null && gauge.getParent() != null) {
            gauge.getParent().remove((Component)gauge);
        }
        super.close();
    }

    public Gauge getGauge() {
        return this._gauge;
    }

    public void disableRefreshInTask() {
        this.refreshInTask = false;
    }

    @Override
    public void refresh(boolean bl) {
        this.refresh(this.getConnection());
    }

    public void refresh(Connection connection) {
        CancellableQuery cancellableQuery = new CancellableQuery(this.refreshInTask){

            @Override
            protected void initialize(Connection connection) throws SQLException {
            }

            @Override
            protected PreparedStatement prepareStatement(Connection connection) throws SQLException {
                return DisplaySimpleGuage.this.prepareRefreshStatement(connection);
            }

            @Override
            protected void loadData(ResultSet resultSet) throws SQLException {
                GridData gridData = new GridData();
                DisplaySimpleGuage.this.populateGridData(resultSet, gridData, this);
                DisplaySimpleGuage.this.displayData(gridData);
            }

            @Override
            protected void clearData() {
                DisplaySimpleGuage.this.displayData(null);
            }

            @Override
            protected void handleException(Exception exception) {
                DisplaySimpleGuage.this.handleException(exception);
            }
        };
        cancellableQuery.process(connection);
    }

    private PreparedStatement prepareRefreshStatement(Connection connection) throws SQLException {
        return DBUtil.getInstance((Connection)connection).prepareExecute(this.getQuery().getSql().replaceAll("\n", " "), this.getBindMap());
    }

    private void populateGridData(ResultSet resultSet, GridData gridData, CancellableQuery cancellableQuery) throws SQLException {
        int n;
        String string = resultSet.getMetaData().getColumnName(1);
        int n2 = resultSet.getMetaData().getColumnCount();
        if (n2 > 5) {
            n2 = 5;
        }
        Object[] objectArray = null;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        final int n3 = DBConfig.getInstance().getInt("REPORTMAXCHARTROWS");
        int n4 = 0;
        while (cancellableQuery.continueLoading() && n4++ < n3 && resultSet.next()) {
            objectArray = new Object[n2];
            for (n = 0; n < n2; ++n) {
                try {
                    objectArray[n] = resultSet.getBigDecimal(n + 1);
                    continue;
                }
                catch (SQLException sQLException) {
                    objectArray[n] = 0.0;
                }
            }
            arrayList.add(objectArray);
        }
        if (n4 >= n3) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)ControlsArb.format("REPORT_TOO_MANY_ROWS", n3), (String)ControlsArb.getString("REPORT_TOO_MANY_ROWS_TITLE"), null);
                }
            });
        }
        n = arrayList.size();
        gridData.rowLab = new Object[n];
        gridData.data = new Object[5][n];
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = (Object[])arrayList.get(i);
            gridData.rowLab[i] = string + Integer.toString(i);
            if (this.getBoolean("QUERY").booleanValue()) {
                for (int j = 0; j < n2; ++j) {
                    gridData.data[j][i] = objectArray2[j];
                }
                continue;
            }
            gridData.data[0][i] = objectArray2[0];
            gridData.data[1][i] = Integer.valueOf(this.getExtValues().get("MIN"));
            gridData.data[2][i] = Integer.valueOf(this.getExtValues().get("MAX"));
            gridData.data[3][i] = Integer.valueOf(this.getExtValues().get("LOW"));
            gridData.data[4][i] = Integer.valueOf(this.getExtValues().get("HIGH"));
        }
        gridData.colLab = new Object[]{"value", "min", "max", "low", "high"};
        gridData.spec = new Object[]{"DST_METRIC", "DST_MINIMUM", "DST_MAXIMUM", "DST_THRESHOLD", "DST_THRESHOLD"};
    }

    private void displayData(final GridData gridData) {
        if (this.refreshInTask) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisplaySimpleGuage.this.doDisplayData(gridData);
                }
            });
        } else {
            this.doDisplayData(gridData);
        }
    }

    private void doDisplayData(GridData gridData) {
        this._gauge.setVisible(false);
        this._show = gridData != null ? Boolean.valueOf(this._gauge.setGridData(gridData.spec, gridData.colLab, gridData.rowLab, gridData.data)) : Boolean.valueOf(this._gauge.setGridData(new Object[0], new Object[0], new Object[0], new Object[0][0]));
        if (this._show.booleanValue()) {
            this._gauge.setThresholdDialStyle(1);
            this._gauge.setVisible(true);
            this._gauge.getIndicator().setBarFillColor(Color.BLACK);
            this._gauge.setPopupManager((PopupManager)new GaugePopupManager(this));
        } else {
            this._gauge.setVisible(false);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void addActions(List<ObjectAction> list) {
        this._actions = list;
    }

    @Override
    public void clear() {
        this._gauge.setVisible(false);
    }

    private class GaugePopupManager
    implements PopupManager {
        JPopupMenu reports;
        private DisplaySimpleGuage _display;

        GaugePopupManager(DisplaySimpleGuage displaySimpleGuage2) {
            this._display = displaySimpleGuage2;
        }

        public JPopupMenu getPopupMenu(Dataview dataview, ComponentHandle componentHandle) {
            this.reports = new JPopupMenu(Messages.getString("DisplaySimpleGuage.16"));
            if (DisplaySimpleGuage.this._actions != null) {
                for (ObjectAction objectAction : DisplaySimpleGuage.this._actions) {
                    JMenuItem jMenuItem = objectAction.getMenuItem(new ContextMenu());
                    objectAction.putProperty("ACTION_TYPE", "REPORT");
                    Context context = EditorManager.getEditorManager().getCurrentEditor().getContext();
                    context.setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                    context.setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                    objectAction.putProperty("CONTEXT", context);
                    this.reports.add(jMenuItem);
                }
            }
            return this.reports;
        }

        public void dataSourceChanged() {
        }
    }

    private static class GridData {
        Object[] spec;
        Object[] colLab;
        Object[] rowLab;
        Object[][] data;

        private GridData() {
        }
    }
}

