/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;

public class CodeHtmlGenerator
implements IHtmlGenerator {
    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        block14: {
            String string;
            Writer writer = htmlGenerationContext.writer();
            DisplayModel displayModel = htmlGenerationContext.model();
            Connection connection = htmlGenerationContext.connection();
            ReentrantLock reentrantLock = Connections.getInstance().getLock(connection);
            Map<String, Object> map = htmlGenerationContext.binds();
            String string2 = null;
            Query query = displayModel.getQuery();
            if (query != null && (string = query.getSql()) != null) {
                string2 = QueryUtils.expandQuery((String)string, map);
            }
            if (string2 != null) {
                string = null;
                reentrantLock.lock();
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    try {
                        string = dBUtil.executeQuery(string2, map);
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException != null) {
                            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.SQL, sQLException);
                            break block14;
                        }
                        if (string == null) break block14;
                        try {
                            ResultSet resultSet = string.getResultSet();
                            if (resultSet != null) {
                                writer.write("<pre>\n");
                                while (resultSet.next()) {
                                    writer.write(this.escape(resultSet.getString(1)));
                                }
                                writer.write("</pre>\n");
                            }
                        }
                        finally {
                            if (string != null) {
                                string.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.SQL, exception);
                    }
                }
                finally {
                    reentrantLock.unlock();
                }
            }
        }
    }

    private String escape(String string) {
        if (string != null) {
            return string.replaceAll("<", "&lt;");
        }
        return string;
    }
}

