/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.sql.Datum;

public class ScriptHtmlGenerator
implements IHtmlGenerator {
    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
    }

    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        String string;
        Writer writer = htmlGenerationContext.writer();
        DisplayModel displayModel = htmlGenerationContext.model();
        Connection connection = htmlGenerationContext.connection();
        Map<String, Object> map = htmlGenerationContext.binds();
        String string2 = null;
        Query query = displayModel.getQuery();
        if (query != null && (string = query.getSql()) != null) {
            string2 = QueryUtils.expandQuery((String)string, map);
        }
        try {
            writer.write("<pre>");
            if (string2 != null) {
                string = new ScriptExecutor(string2, connection);
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptRunnerContext.putProperty("BINDMAP", this.getFullValueBindMap(map));
                string.setScriptRunnerContext(scriptRunnerContext);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                string.setOut(bufferedOutputStream);
                string.getScriptRunnerContext().setBaseConnection(connection);
                string.getScriptRunnerContext().setCurrentConnection(connection);
                string.start();
                int n = pipedInputStream.read();
                try {
                    while (n >= 0) {
                        writer.write(n);
                        n = pipedInputStream.read();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            writer.write("</pre>\n");
        }
        catch (Exception exception) {
            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.OTHER, exception);
        }
    }

    private Map<String, Bind> getFullValueBindMap(Map<String, Object> map) {
        HashMap<String, Bind> hashMap = new HashMap<String, Bind>();
        Set<String> set = map.keySet();
        for (String string : set) {
            Object object = map.get(string);
            String string2 = null;
            String string3 = null;
            if (object instanceof Datum) {
                string2 = this.getStringFromOracleDatum((Datum)object);
                string3 = this.getTypeFromOracleDatum((Datum)object);
            } else if (object instanceof BigDecimal) {
                string2 = Double.toString(((BigDecimal)object).doubleValue());
                string3 = "CHAR";
            } else {
                if (object != null) {
                    string2 = object.toString();
                }
                string3 = "CHAR";
            }
            Bind bind = new Bind(string, string3, null, string2, null);
            hashMap.put(string, bind);
        }
        return hashMap;
    }

    private String getStringFromOracleDatum(Datum datum) {
        String string = null;
        try {
            string = datum.stringValue();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(QueryUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    private String getTypeFromOracleDatum(Datum datum) {
        String string = null;
        string = datum.getClass().toString();
        string = string.substring(string.lastIndexOf(".") + 1).toUpperCase();
        return string;
    }
}

