/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.cellrenderers.CellRenderingFactory;
import oracle.dbtools.raptor.controls.cellrenderers.ICellDisplayValue;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraMessageFormat;
import oracle.dbtools.raptor.query.Column;

public class DefaultResultSetTableCellRenderer
implements TableCellRenderer {
    protected final JLabelTableCellRenderer textRenderer;

    public DefaultResultSetTableCellRenderer() {
        this(new JLabelTableCellRenderer());
    }

    protected DefaultResultSetTableCellRenderer(JLabelTableCellRenderer jLabelTableCellRenderer) {
        this.textRenderer = jLabelTableCellRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Object object2;
        String string;
        ResultSetTableModel resultSetTableModel;
        block19: {
            ResultSetTable resultSetTable = jTable instanceof ResultSetTable ? (ResultSetTable)((Object)jTable) : null;
            resultSetTableModel = resultSetTable != null ? resultSetTable.getGridModel() : null;
            Column column = null;
            string = null;
            if (resultSetTableModel != null && (column = resultSetTableModel.getQueryColumn(n, n2)) != null && column.getCellRenderer() != null) {
                try {
                    Object obj;
                    object2 = column.getClassLoader();
                    Object obj2 = obj = object2 == null ? Class.forName(column.getCellRenderer()).newInstance() : Class.forName(column.getCellRenderer(), true, (ClassLoader)object2).newInstance();
                    if (obj instanceof ICellDisplayValue) {
                        string = ((ICellDisplayValue)obj).getText(jTable, object, bl, bl2, n, n2);
                    }
                    if (!(obj instanceof TableCellRenderer)) {
                        RuntimeException runtimeException = new RuntimeException("Must implement a TableCellRenderer or an ICellDisplayValue");
                        Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "getTableCellRendererComponent", runtimeException);
                        throw runtimeException;
                    }
                }
                catch (InstantiationException instantiationException) {
                    Logger.getLogger(this.getClass().getName()).severe(instantiationException.getLocalizedMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).severe(illegalAccessException.getLocalizedMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).severe(classNotFoundException.getLocalizedMessage());
                }
            }
            try {
                if (string != null || object == null) break block19;
                if (resultSetTableModel != null && column != null && column.getFormat() != null && !column.getFormat().equals("")) {
                    try {
                        string = OraMessageFormat.format((String)column.getFormat(), (DefaultNLSProvider)NLSProvider.getProvider((String)resultSetTableModel.getConnectionName()), (Object[])new Object[]{object});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = CellRenderingFactory.getText(jTable, object, bl, bl2, n, n2);
                }
                if (string == null && resultSetTableModel != null) {
                    string = resultSetTableModel.getDisplayValueAt(jTable.convertRowIndexToModel(n), jTable.convertColumnIndexToModel(n2), jTable.getColumn(jTable.getColumnName(n2)).getWidth());
                }
            }
            catch (Throwable throwable) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
            }
        }
        if (string == null) {
            string = object == null ? DefaultResultSetTableCellRenderer.getNullDisplayText() : object.toString();
        }
        object2 = (JLabel)this.textRenderer.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        if (resultSetTableModel != null) {
            String string2;
            int n3 = resultSetTableModel.getColumnSqlType(jTable.convertColumnIndexToModel(n2));
            if (((JLabel)object2).getText().length() == 0 && (string2 = DefaultResultSetTableCellRenderer.getEmptyDisplayText(n3)).length() > 0) {
                ((JLabel)object2).setText(string2);
            }
            this.applyTextAlignment((JLabel)object2, n3);
        } else {
            this.applyDefaultTextAlignment((JLabel)object2);
        }
        Color color2 = color = bl ? UIManager.getColor("textHighlight") : this.getTextBackgroundColor(object);
        if (color != null) {
            ((JComponent)object2).setBackground(color);
        }
        return object2;
    }

    public Color getTextBackgroundColor(Object object) {
        Color color = null;
        if (object == null) {
            color = DefaultResultSetTableCellRenderer.getNullColor();
        }
        if (color == null) {
            color = UIManager.getColor("text");
        }
        return color;
    }

    public void applyTextAlignment(JLabel jLabel, int n) {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                jLabel.setHorizontalAlignment(4);
                jLabel.setAlignmentX(1.0f);
                break;
            }
            case -102: 
            case -101: 
            case -1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: {
                jLabel.setHorizontalAlignment(2);
                jLabel.setAlignmentX(0.0f);
                break;
            }
            default: {
                this.applyDefaultTextAlignment(jLabel);
            }
        }
    }

    public void applyDefaultTextAlignment(JLabel jLabel) {
        jLabel.setHorizontalAlignment(2);
        jLabel.setAlignmentX(0.0f);
    }

    public static Color getColor(String string) {
        Color color = null;
        if (string != null) {
            if (string.equals("BLUE")) {
                color = Color.BLUE;
            } else if (string.equals("GRAY")) {
                color = Color.GRAY;
            } else if (string.equals("LIGHT_GRAY")) {
                color = Color.LIGHT_GRAY;
            } else if (string.equals("BLACK")) {
                color = Color.BLACK;
            } else if (string.equals("RED")) {
                color = Color.RED;
            } else if (string.equals("PINK")) {
                color = Color.PINK;
            } else if (string.equals("ORANGE")) {
                color = Color.ORANGE;
            } else if (string.equals("YELLOW")) {
                color = Color.YELLOW;
            } else if (string.equals("GREEN")) {
                color = Color.GREEN;
            }
        }
        return color;
    }

    public static Color getNullColor() {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("NULLCOLOR");
        if (string == null) {
            string = "NONE";
            dBConfig.putString("NULLCOLOR", string);
        }
        return DefaultResultSetTableCellRenderer.getColor(string);
    }

    public static String getNullDisplayText() {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("NULLDISPLAY");
        if (string == null) {
            string = "";
            dBConfig.putString("NULLDISPLAY", string);
        }
        return string;
    }

    public static String getEmptyDisplayText(int n) {
        switch (n) {
            case -14: 
            case -13: 
            case -10: 
            case -8: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2011: {
                return "";
            }
        }
        return DefaultResultSetTableCellRenderer.getNullDisplayText();
    }

    protected static class JLabelTableCellRenderer
    extends DefaultTableCellRenderer {
        protected JLabelTableCellRenderer() {
        }
    }
}

