/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;
import oracle.javatools.util.ModelUtil;

public class RSTMSql {
    private static final Logger LOGGER = Logger.getLogger(RSTMSql.class.getName());
    protected String _originalSql;
    protected List<RaptorGridFilter> _filters;
    protected String _modifiedSql = null;
    protected String _whereClauseFilter = null;
    protected String _tableName = null;

    public RSTMSql(String string) {
        this._originalSql = string;
        this._filters = new ArrayList<RaptorGridFilter>();
    }

    public String getModifiedSql(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (this._whereClauseFilter != null && this._whereClauseFilter.length() > 0) {
            stringBuilder.insert(0, "select  /*+ NO_PARALLEL */ * from (\n");
            stringBuilder.append("\n ) ");
            stringBuilder.append(" WHERE " + this._whereClauseFilter);
        }
        for (int i = 0; i < this._filters.size(); ++i) {
            RaptorGridFilter raptorGridFilter = this._filters.get(i);
            if (!raptorGridFilter.isEnabled()) continue;
            stringBuilder.insert(0, "select  /*+ NO_PARALLEL */ * from (\n");
            stringBuilder.append("\n ) ");
            if (ModelUtil.hasLength((String)this._tableName)) {
                stringBuilder.append(this._tableName);
            }
            stringBuilder.append(" WHERE " + raptorGridFilter.getFilterClause());
        }
        this._modifiedSql = RSTMSql.sanitizeSql(stringBuilder.toString());
        LOGGER.info("Modified SQL: " + this._modifiedSql);
        return this._modifiedSql;
    }

    public String getModifiedSql() {
        if (this._modifiedSql == null) {
            return this.getModifiedSql(this._originalSql);
        }
        return this._modifiedSql;
    }

    public void addFilter(RaptorGridFilter raptorGridFilter) {
        int n = raptorGridFilter.getColumnModelIndex();
        this.removeFilter(n);
        this._filters.add(raptorGridFilter);
        this._modifiedSql = null;
    }

    public void removeFilter(RaptorGridFilter raptorGridFilter) {
        this._filters.remove(raptorGridFilter);
        this._modifiedSql = null;
    }

    public static String sanitizeSql(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    public RaptorGridFilter getFilter(int n) {
        for (RaptorGridFilter raptorGridFilter : this._filters) {
            if (raptorGridFilter.getColumnModelIndex() != n) continue;
            return raptorGridFilter;
        }
        return null;
    }

    public void removeFilter(int n) {
        for (RaptorGridFilter raptorGridFilter : this._filters) {
            if (raptorGridFilter.getColumnModelIndex() != n) continue;
            this._filters.remove(raptorGridFilter);
            this._modifiedSql = null;
            break;
        }
    }

    public void enableFilter(int n, boolean bl) {
        RaptorGridFilter raptorGridFilter = this.getFilter(n);
        if (raptorGridFilter != null) {
            raptorGridFilter.setEnabled(bl);
            this._modifiedSql = null;
        }
    }

    public List<RaptorGridFilter> getAllFilters() {
        return Collections.unmodifiableList(this._filters);
    }

    public void removeAllFilters() {
        this._filters.clear();
        this._modifiedSql = null;
    }

    public String getWhereClauseFilter() {
        return this._whereClauseFilter;
    }

    public void setWhereClauseFilter(String string) {
        this._whereClauseFilter = string;
        this._modifiedSql = null;
    }

    public void setTableName(String string) {
        this._tableName = string;
        this._modifiedSql = null;
    }
}

