/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.dialogs.actions.TableExportAction;
import oracle.dbtools.raptor.export.Messages;
import oracle.dbtools.raptor.export.pdf.PDFReportUtils;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;

public class ExportGrid
extends GridContextMenuItem {
    private TableExportAction _action = new TableExportAction();
    private static ExportGrid _instance = null;

    private ExportGrid() {
    }

    public static ExportGrid getInstance() {
        if (_instance == null) {
            _instance = new ExportGrid();
        }
        return _instance;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        if (this._table == null || !(this._table instanceof ResultSetTable)) {
            return false;
        }
        return !TableExportAction.isExportInProgress();
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        String string = null;
        boolean bl = true;
        ExtractListModel extractListModel = null;
        Node node = contextMenu.getContext().getNode();
        if (node instanceof IViewerNode) {
            node = ((IViewerNode)node).getBaseNode();
        }
        if (contextMenu.getContext().getEvent() != null && contextMenu.getContext().getEvent().getSource() instanceof EditableResultSetTable) {
            EditableResultSetTable editableResultSetTable = (EditableResultSetTable)((Object)contextMenu.getContext().getEvent().getSource());
            if (editableResultSetTable == null || editableResultSetTable.getView() == null) {
                return;
            }
            Context context = editableResultSetTable.getView().getContext();
            node = context.getNode();
            if (node instanceof IViewerNode) {
                node = ((IViewerNode)node).getBaseNode();
            }
            if (node instanceof DatabaseNode) {
                extractListModel = new ExtractListModel(new DBObject((Element)node));
                bl = extractListModel.isPreSelectedDataExtractable();
            }
            extractListModel.getFirstDataObject().setTable((JTable)((Object)editableResultSetTable));
        } else if (contextMenu.getContext().getEvent() != null && contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
            Connection connection = null;
            ResultSetTable resultSetTable = (ResultSetTable)((Object)contextMenu.getContext().getEvent().getSource());
            string = resultSetTable.getGridModel().getConnectionName();
            try {
                connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (connection == null) {
                bl = false;
            } else {
                extractListModel = new ExtractListModel((JTable)((Object)resultSetTable), string);
                PDFFormatOptions pDFFormatOptions = PDFReportUtils.getPDFOptions(resultSetTable);
                if (pDFFormatOptions != null) {
                    extractListModel.setProperty("REPORT_OPTIONS", pDFFormatOptions);
                }
            }
        } else if (node instanceof DatabaseNode) {
            extractListModel = new ExtractListModel(new DBObject((Element)node));
            bl = extractListModel.isPreSelectedDataExtractable();
        } else {
            bl = false;
        }
        if (bl) {
            this._action.setListModel(extractListModel);
            contextMenu.add((Component)this.getMenuItem(bl));
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this._table != null && this._table instanceof ResultSetTable) {
            String string = ((ResultSetTable)this._table).getGridModel().getConnectionName();
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string, false);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (connection == null) {
                ideAction.setEnabled(false);
            } else {
                ideAction.setEnabled(true);
            }
            return true;
        }
        return true;
    }

    public JMenuItem getMenuItem(boolean bl) {
        String string = Messages.getString("ExportContextMenuListener.1");
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportGrid.this._action.setArgs(actionEvent.getActionCommand());
                if (ExportGrid.this._action.getListModel() != null) {
                    if (ExportGrid.this._action.getListModel().isTypeQuery()) {
                        ExportGrid.this._action.launchForGrid();
                    } else if (ExportGrid.this._action.getListModel().isPreSelectedDataExtractable()) {
                        ExportGrid.this._action.launchForObjectGrid();
                    }
                }
            }
        });
        return jMenuItem;
    }
}

