/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.query;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.KeywordFormat;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataFilterItem;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.metadata.JdbcMetadataProvider;
import com.adbs.querybuilder.AddObjectDialogOptions;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceObject;
import com.adbs.querybuilder.DataSourceQuery;
import com.adbs.querybuilder.DataSourceType;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.FieldListOptions;
import com.adbs.querybuilder.FieldListSortType;
import com.adbs.querybuilder.GetDiagramObjectWidthEvent;
import com.adbs.querybuilder.GetDiagramObjectWidthEventListener;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.querybuilder.ValidatePopupMenuEvent;
import com.adbs.querybuilder.ValidatePopupMenuEventListener;
import com.adbs.syntax.AccessSyntaxProvider;
import com.adbs.syntax.AutoSyntaxProvider;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2SyntaxProvider;
import com.adbs.syntax.MSSQLCESyntaxProvider;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.syntax.MySQLSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManagerImpl;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileRepository;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DatabaseElementTransferable;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.query.Localizer;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.TextLockableUI;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Displayable;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class QueryBuilderEditPanel
implements Dirtyable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(QueryBuilderEditPanel.class.getName());
    private static boolean JIT_METADATA_LOADING = true;
    private static boolean DEBUG = Boolean.getBoolean("sqldev.debug");
    private static final String LOADING_MSG = ControlsArb.getString("QueryBuilderEditorPanel_LoadingMsg");
    private static final String JIT_LOADING_MSG = ControlsArb.getString("QueryBuilderEditorPanel_JITLoadingMsg");
    private static final String GENERIC_EXCEPTION_MSG = ControlsArb.getString("QueryBuilderEditorPanel_GenericExceptionMsg");
    private static final String NOT_VALID_SELECT_MSG_KEY = "QueryBuilderEditorPanel_NotValidSelectMsg";
    private static final String UNSUPPORTED_SYNTAX_MSG_KEY = "QueryBuilderEditorPanel_UnsupportedSyntaxMsg";
    private static final String CONN_NOT_SUPPORTED_MSG = ControlsArb.getString("QueryBuilderEditorPanel_NotSupportedMsg");
    private static final String CONN_NULL_MSG = ControlsArb.getString("QueryBuilderEditorPanel_NullConnectionMsg");
    private static final String MESSAGE_DIALOG_TITLE = ControlsArb.getString("QueryBuilderEditorPanel_MessageDialogTitle");
    private static final String SORT_FIELDS_MENU_TEXT = ControlsArb.getString("QueryBuilderEditorPanel_SortFieldsMenuText");
    private static final String CREATE_ORACLE_JOINS_MENU_TEXT = ControlsArb.getString("QueryBuilderEditorPanel_CreatOracleJoinsMenuText");
    private static Cursor BUSY_CURSOR = null;
    private ConnectionListener _connListener = new ConnectionListener(){

        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            this.processConnectionClosed(connectionEvent.getConnectionName());
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
            String string;
            String string2 = connectionEvent.getOldName();
            if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName()))) {
                this.processConnectionRename(string2, string);
            }
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = connectionEvent.getConnectionName();
            this.processConnectionRename(string, string2);
        }

        private void processConnectionRename(String string, String string2) {
            String string3 = QueryBuilderEditPanel.this.getConnectionName();
            if (ModelUtil.areEqual((Object)string, (Object)string3)) {
                QueryBuilderEditPanel.this._connName = string2;
            }
        }

        private void processConnectionClosed(String string) {
            String string2 = QueryBuilderEditPanel.this.getConnectionName();
            if (ModelUtil.areEqual((Object)string, (Object)string2)) {
                QueryBuilderEditPanel.this.setConnection(null);
            }
        }

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
            this.processConnectionClosed(connectionEvent.getConnectionName());
        }
    };
    private JXLayer<JComponent> _jxLayer;
    private GetDiagramObjectWidthEventListener _objectWidthListener = new GetDiagramObjectWidthEventListener(){

        public void getDiagramObjectWidthEventOccurred(GetDiagramObjectWidthEvent getDiagramObjectWidthEvent) {
            try {
                QueryBuilder queryBuilder = QueryBuilderEditPanel.this.getQueryBuilder();
                List list = QueryBuilderEditPanel.this.getDataSources();
                ArrayList<NameInfo> arrayList = new ArrayList<NameInfo>();
                for (DataSource object : list) {
                    if (object instanceof DataSourceQuery || null != object.getMetadataObject() || object instanceof DataSourceObject && DataSourceType.Other == ((DataSourceObject)object).getDatasourceType()) continue;
                    NameInfo nameInfo = new NameInfo(queryBuilder, object);
                    MetadataObject metadataObject = nameInfo.getMetadataObject();
                    if (null == metadataObject) {
                        arrayList.add(nameInfo);
                        continue;
                    }
                    object.getDatasourceAST().setMetadataObject(metadataObject);
                    object.refreshMetadata();
                }
                QueryBuilderEditPanel.loadMetadataByNameInfo(queryBuilder, arrayList);
                for (NameInfo nameInfo : arrayList) {
                    nameInfo.refreshDataSourceMetadata();
                }
            }
            catch (Exception exception) {
                QueryBuilderEditPanel.log(exception);
            }
        }
    };
    private ValidatePopupMenuEventListener _popupListener = new ValidatePopupMenuEventListener(){
        private String PROPERTIES_KEY = "strEdit";
        private String ADD_OBJECT_KEY = "strAddObject";
        private boolean setCreateOracleJoinsLocked;

        private int findMenuItemIndex(JPopupMenu jPopupMenu, String string) {
            int n = -1;
            int n2 = -1;
            String string2 = Helpers.localizer.getString(string, string);
            for (Component component : jPopupMenu.getComponents()) {
                ++n2;
                if (!(component instanceof JMenuItem) || !string2.equals(((JMenuItem)component).getText())) continue;
                n = n2;
                break;
            }
            return n;
        }

        private JMenuItem findMenuItem(JPopupMenu jPopupMenu, String string) {
            JMenuItem jMenuItem = null;
            int n = this.findMenuItemIndex(jPopupMenu, string);
            if (n != -1) {
                jMenuItem = (JMenuItem)jPopupMenu.getComponent(n);
            }
            return jMenuItem;
        }

        private void setCreateOracleJoins(boolean bl) {
            BaseSyntaxProvider baseSyntaxProvider = QueryBuilderEditPanel.this.getQueryBuilder().getSyntaxProvider();
            if (baseSyntaxProvider instanceof OracleSyntaxProvider) {
                OracleSyntaxProvider oracleSyntaxProvider = (OracleSyntaxProvider)baseSyntaxProvider;
                oracleSyntaxProvider.setCreateWhereJoinsByDefault(bl);
            }
        }

        private boolean isCreateOracleJoins() {
            UnionSubQuery unionSubQuery;
            boolean bl = false;
            this.setCreateOracleJoinsLocked = false;
            QueryBuilder queryBuilder = QueryBuilderEditPanel.this.getQueryBuilder();
            BaseSyntaxProvider baseSyntaxProvider = queryBuilder.getUnionSubQueryList().iterator();
            while (baseSyntaxProvider.hasNext()) {
                unionSubQuery = (UnionSubQuery)baseSyntaxProvider.next();
                if (unionSubQuery.haveAnsiJoins()) {
                    bl = false;
                    this.setCreateOracleJoinsLocked = true;
                    break;
                }
                if (!unionSubQuery.haveWhereJoins()) continue;
                bl = true;
                this.setCreateOracleJoinsLocked = true;
                break;
            }
            if (!this.setCreateOracleJoinsLocked && (baseSyntaxProvider = queryBuilder.getSyntaxProvider()) instanceof OracleSyntaxProvider) {
                unionSubQuery = (OracleSyntaxProvider)baseSyntaxProvider;
                bl = unionSubQuery.isCreateWhereJoinsByDefault();
            }
            this.setCreateOracleJoins(bl);
            return bl;
        }

        public void validatePopupMenuEventOccurred(ValidatePopupMenuEvent validatePopupMenuEvent) {
            JMenuItem jMenuItem;
            Component component = validatePopupMenuEvent.component;
            JPopupMenu jPopupMenu = validatePopupMenuEvent.menu;
            final QueryBuilder queryBuilder = QueryBuilderEditPanel.this.getQueryBuilder();
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(CREATE_ORACLE_JOINS_MENU_TEXT, this.isCreateOracleJoins());
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.setCreateOracleJoins(jCheckBoxMenuItem.isSelected());
                }
            });
            jCheckBoxMenuItem.setEnabled(!this.setCreateOracleJoinsLocked);
            int n = this.findMenuItemIndex(jPopupMenu, this.PROPERTIES_KEY);
            if (n != -1) {
                jPopupMenu.add((Component)jCheckBoxMenuItem, n);
            } else {
                jPopupMenu.add(jCheckBoxMenuItem);
            }
            final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(SORT_FIELDS_MENU_TEXT, queryBuilder.getFieldListOptions().getSortType() == FieldListSortType.Name);
            jCheckBoxMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FieldListOptions fieldListOptions = queryBuilder.getFieldListOptions();
                    fieldListOptions.beginUpdate();
                    if (jCheckBoxMenuItem2.isSelected()) {
                        fieldListOptions.setSortType(FieldListSortType.Name);
                    } else {
                        fieldListOptions.setSortType(FieldListSortType.None);
                    }
                    fieldListOptions.endUpdate();
                    QueryBuilderEditPanel.this.refreshDataSourcesMetadata();
                }
            });
            n = this.findMenuItemIndex(jPopupMenu, this.PROPERTIES_KEY);
            if (n != -1) {
                jPopupMenu.add((Component)jCheckBoxMenuItem2, n);
            } else {
                jPopupMenu.add(jCheckBoxMenuItem2);
            }
            if (DEBUG) {
                jPopupMenu.add(new AbstractAction("(DEBUG)Edit Metadata..."){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        QueryBuilder.editMetadataContainer((Window)Ide.getMainWindow(), (MetadataContainer)QueryBuilderEditPanel.this.getQueryBuilder().getMetadataContainer(), (boolean)false, null);
                    }
                });
            }
            if (JIT_METADATA_LOADING && component instanceof DiagramPane && (jMenuItem = this.findMenuItem(jPopupMenu, this.ADD_OBJECT_KEY)) != null) {
                if (DEBUG) {
                    jMenuItem.setText("(DEBUG)" + jMenuItem.getText());
                } else {
                    jPopupMenu.remove(jMenuItem);
                }
            }
            if (component instanceof DiagramPane) {
                // empty if block
            }
        }
    };
    private ComponentAdapter _cListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (QueryBuilderEditPanel.this.textChanged || !QueryBuilderEditPanel.this.componentShown) {
                QueryBuilderEditPanel.this.componentShown = true;
                QueryBuilderEditPanel.this.setSQL(QueryBuilderEditPanel.this.getText());
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            QueryBuilderEditPanel.this.textChanged = false;
        }
    };
    private boolean componentShown;
    private boolean textChanged;
    private DocumentListener _textListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            QueryBuilderEditPanel.this.textChanged = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            QueryBuilderEditPanel.this.textChanged = true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    private PlainTextSQLBuilder _plainTextSQLBuilder = new PlainTextSQLBuilder();
    private SQLUpdatedEventListener _sqlListener = new SQLUpdatedEventListener(){

        public void sqlUpdatedEventOccurred(SQLUpdatedEvent sQLUpdatedEvent) {
            QueryBuilder queryBuilder = QueryBuilderEditPanel.this.getQueryBuilder();
            if (queryBuilder.isVisible()) {
                try {
                    final String string = Helpers.isQueryEmpty((SQLSelectStatement)queryBuilder.getResultQueryAST()) ? "" : QueryBuilderEditPanel.this.getSQL();
                    if (string != null) {
                        final CodingStyleSQLOptions codingStyleSQLOptions = QueryBuilderEditPanel.this.getSQLFormatter();
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                QueryBuilderEditPanel.this.checkQuery();
                                String string2 = codingStyleSQLOptions.format(string);
                                if (null == string2 || string2.trim().isEmpty()) {
                                    string2 = string;
                                }
                                QueryBuilderEditPanel.this.setText(string2);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (QueryBuilderException queryBuilderException) {
                    QueryBuilderEditPanel.log(queryBuilderException);
                }
            }
        }
    };
    private String _connName;
    private static final String QB_SETSQL = "QB-setSQL ";
    private boolean _isRefreshing;
    private boolean _isMetadataLoaded;
    private static final String DASHES40 = "\n----------------------------------------\n";
    private JTextComponent _textComponent;
    private boolean _dirty;
    private static Map<Class<? extends BaseSyntaxProvider>, Integer> codingStyleMap = new HashMap<Class<? extends BaseSyntaxProvider>, Integer>();
    private static final String QB_LOADMETADATABYNAMEINFO = "QB-loadMetadataByNameInfo %d ms";

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void info(String string) {
        LOGGER.log(Level.INFO, string);
    }

    public QueryBuilderEditPanel(JTextComponent jTextComponent) {
        assert (jTextComponent != null);
        this.setTextComponent(jTextComponent);
    }

    public JXLayer<JComponent> getGUI() {
        if (null == this._jxLayer) {
            this.init();
        }
        return this._jxLayer;
    }

    public void setConnection(String string) {
        if (string == null || !string.equals(this._connName)) {
            this._connName = string;
            this.markDirty(true);
            if (this.isMetadataLoaded() || this.isLocked()) {
                this.refreshMetadata();
            }
        }
    }

    public void dispose() {
        QueryBuilder queryBuilder = this.getQueryBuilder();
        Connections.getInstance().removeConnectionListener(this._connListener);
        this._connListener = null;
        this.getGUI().removeComponentListener((ComponentListener)this._cListener);
        this._cListener = null;
        queryBuilder.addGetDiagramObjectWidthEventListener(this._objectWidthListener);
        this._objectWidthListener = null;
        queryBuilder.removeValidatePopupMenuEventListener(this._popupListener);
        this._popupListener = null;
        this._plainTextSQLBuilder.removeSQLUpdatedEventListener(this._sqlListener);
        this._plainTextSQLBuilder = null;
        this._sqlListener = null;
        queryBuilder.clear();
        this.getGUI().setView(null);
        this.getGUI().setUI(null);
        this._jxLayer = null;
        this._textComponent.getDocument().removeDocumentListener(this._textListener);
        this._textComponent = null;
        this._textListener = null;
        this.setMetadataLoaded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this._jxLayer = new JXLayer();
        this.getGUI().setView((Component)new QueryBuilder());
        this.getGUI().setUI((LayerUI)new TextLockableUI());
        BUSY_CURSOR = this.getTextLockableUI().getLockedCursor();
        QueryBuilder queryBuilder = this.getQueryBuilder();
        try {
            queryBuilder.beginUpdate();
            QueryBuilderDropTargetListener queryBuilderDropTargetListener = new QueryBuilderDropTargetListener(queryBuilder);
            queryBuilder.setDropTarget(new DropTarget((Component)this.getGUI(), queryBuilderDropTargetListener));
            queryBuilder.setCustomDiagramPaneDropTarget(new DropTarget((Component)this.getGUI(), queryBuilderDropTargetListener));
            QueryStructureTreeOptions queryStructureTreeOptions = queryBuilder.getQueryStructureTreeOptions();
            queryStructureTreeOptions.beginUpdate();
            queryStructureTreeOptions.setTreeVisible(false);
            queryStructureTreeOptions.setFieldIcon(OracleIcons.getIcon((String)"field.png"));
            queryStructureTreeOptions.setFieldsIcon(OracleIcons.getIcon((String)"folder.png"));
            queryStructureTreeOptions.setFromIcon(RaptorImage.getIcon((String)"table_folder.png"));
            queryStructureTreeOptions.setFromObjIcon(OracleIcons.getIcon((String)"table.png"));
            queryStructureTreeOptions.setQueriesIcon(OracleIcons.getIcon((String)"schema_folder.png"));
            queryStructureTreeOptions.endUpdate();
            MetadataTreeOptions metadataTreeOptions = queryBuilder.getMetadataTreeOptions();
            metadataTreeOptions.beginUpdate();
            metadataTreeOptions.setTreeVisible(false);
            metadataTreeOptions.setShowSystemProcedures(true);
            metadataTreeOptions.setShowSystemSynonyms(true);
            metadataTreeOptions.setShowSystemTables(true);
            metadataTreeOptions.setShowSystemViews(true);
            metadataTreeOptions.endUpdate();
            AddObjectDialogOptions addObjectDialogOptions = queryBuilder.getAddObjectDialogOptions();
            addObjectDialogOptions.beginUpdate();
            addObjectDialogOptions.setTablesIcon(OracleIcons.getIcon((String)"table.png"));
            addObjectDialogOptions.setViewsIcon(OracleIcons.getIcon((String)"view.png"));
            addObjectDialogOptions.setProceduresIcon(RaptorImage.getIcon((String)"procedure.png"));
            addObjectDialogOptions.setSynonymsIcon(RaptorImage.getIcon((String)"synonym.png"));
            addObjectDialogOptions.endUpdate();
            CriteriaListOptions criteriaListOptions = queryBuilder.getCriteriaListOptions();
            criteriaListOptions.beginUpdate();
            criteriaListOptions.setInitialOrColumnsCount(1);
            criteriaListOptions.setExpressionColumnWidth(200);
            criteriaListOptions.setShowNullOrderingInSortTypeColumn(true);
            criteriaListOptions.endUpdate();
        }
        catch (Exception exception) {
            QueryBuilderEditPanel.log(exception);
        }
        finally {
            queryBuilder.endUpdate();
        }
        if (this._plainTextSQLBuilder != null) {
            this._plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
            this._plainTextSQLBuilder.setQueryBuilder(queryBuilder);
        }
        queryBuilder.addValidatePopupMenuEventListener(this._popupListener);
        queryBuilder.addGetDiagramObjectWidthEventListener(this._objectWidthListener);
        this.getGUI().addComponentListener((ComponentListener)this._cListener);
        Connections.getInstance().addConnectionListener(this._connListener);
        Localizer.init(this.getGUI().getLocale());
    }

    private String getConnectionName() {
        return this._connName;
    }

    private QueryBuilder getQueryBuilder() {
        return (QueryBuilder)this.getGUI().getView();
    }

    private void enableSQLUpdatedEventListener(boolean bl) {
        if (bl) {
            this._plainTextSQLBuilder.addSQLUpdatedEventListener(this._sqlListener);
        } else {
            this._plainTextSQLBuilder.removeSQLUpdatedEventListener(this._sqlListener);
        }
    }

    public void setSQL(final String string) {
        if (this.refreshMetadata()) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long l = System.currentTimeMillis();
                    WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                    waitCursor.show(1000);
                    try {
                        QueryBuilderEditPanel.this.enableSQLUpdatedEventListener(false);
                        QueryBuilderEditPanel.this.getQueryBuilder().setSQL(string);
                        QueryBuilderEditPanel.this.enableSQLUpdatedEventListener(true);
                        QueryBuilderEditPanel.this.setLocked(false, false, "");
                    }
                    catch (Exception exception) {
                        QueryBuilderEditPanel.log(exception);
                        QueryBuilderEditPanel.this.setParseError(exception, string);
                    }
                    finally {
                        waitCursor.hide();
                        long l2 = System.currentTimeMillis() - l;
                        QueryBuilderEditPanel.info(QueryBuilderEditPanel.QB_SETSQL + l2 + " ms ");
                    }
                }
            };
            this.maybeInvokeLater(runnable);
        }
    }

    private String getSQL() {
        return this.getQueryBuilder().getSQL();
    }

    private boolean isRefreshing() {
        return this._isRefreshing;
    }

    private void setIsRefreshing(boolean bl) {
        this._isRefreshing = bl;
    }

    private boolean isMetadataLoaded() {
        return this._isMetadataLoaded;
    }

    private void setMetadataLoaded(boolean bl) {
        this._isMetadataLoaded = bl;
    }

    private boolean refreshMetadata() {
        String string = JIT_METADATA_LOADING ? JIT_LOADING_MSG : LOADING_MSG;
        String string2 = this.getConnectionName();
        if (null == string2) {
            this.markDirty(false);
            this.setIsRefreshing(false);
            this.setLocked(false, false, string);
            return true;
        }
        if (this.isUnsupportedConnection()) {
            this.setLocked(true, false, CONN_NOT_SUPPORTED_MSG);
            return false;
        }
        if (this.isDirty()) {
            if (this.isRefreshing()) {
                return false;
            }
            this.setIsRefreshing(true);
            this.setLocked(true, true, string);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueryBuilderEditPanel queryBuilderEditPanel = QueryBuilderEditPanel.this;
                    QueryBuilder queryBuilder = queryBuilderEditPanel.getQueryBuilder();
                    try {
                        queryBuilderEditPanel.enableSQLUpdatedEventListener(false);
                        queryBuilder.clear();
                        AutoSyntaxProvider autoSyntaxProvider = new AutoSyntaxProvider();
                        queryBuilder.setSyntaxProvider((BaseSyntaxProvider)autoSyntaxProvider);
                        Connection connection = Connections.getInstance().getConnection(QueryBuilderEditPanel.this.getConnectionName());
                        JdbcMetadataProvider jdbcMetadataProvider = new JdbcMetadataProvider();
                        jdbcMetadataProvider.setConnection(connection);
                        queryBuilder.setMetadataProvider((BaseMetadataProvider)jdbcMetadataProvider);
                        autoSyntaxProvider.detectSyntaxProvider(queryBuilder.getSQLContext());
                        queryBuilder.setSyntaxProvider(autoSyntaxProvider.getDetectedSyntaxProvider());
                        queryBuilder.getSyntaxProvider().doDetectServerVersion((BaseMetadataProvider)jdbcMetadataProvider);
                        RaptorTaskManager.getInstance().addTask((RaptorTask)new QBDirectLoader(queryBuilderEditPanel));
                    }
                    catch (Exception exception) {
                        QueryBuilderEditPanel.log(exception);
                    }
                    finally {
                        queryBuilderEditPanel.enableSQLUpdatedEventListener(true);
                    }
                }
            };
            this.maybeInvokeLater(runnable);
            return false;
        }
        return true;
    }

    private boolean isUnsupportedConnection() {
        return Connections.getInstance().isTimesTen(this.getConnectionName()) || !Connections.getInstance().isOracle(this.getConnectionName());
    }

    private TextLockableUI getTextLockableUI() {
        return (TextLockableUI)this.getGUI().getUI();
    }

    private void setLocked(boolean bl, boolean bl2, String string) {
        this.setLocked(bl, bl2, string, null);
    }

    private void setLocked(final boolean bl, final boolean bl2, final String string, final Font font) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                QueryBuilderEditPanel.this.setLockedImpl(bl, bl2, string, font);
            }
        };
        this.maybeInvokeLater(runnable);
    }

    private void maybeInvokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void setLockedImpl(boolean bl, boolean bl2, String string, Font font) {
        TextLockableUI textLockableUI = this.getTextLockableUI();
        if (font != null) {
            textLockableUI.setFont(font);
        } else {
            textLockableUI.setFont(TextLockableUI.REGULAR_FONT);
        }
        if (bl2) {
            textLockableUI.setLockedCursor(BUSY_CURSOR);
        } else {
            textLockableUI.setLockedCursor(Ide.getMainWindow().getCursor());
        }
        textLockableUI.setTextVisible(bl);
        if (bl == textLockableUI.isLocked()) {
            textLockableUI.setLocked(!bl);
        }
        textLockableUI.setLocked(bl);
        textLockableUI.setText(string);
    }

    private boolean isLocked() {
        return this.getTextLockableUI().isLocked();
    }

    private void setParseError(Exception exception, String string) {
        String string2 = exception.getLocalizedMessage();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            if (throwable instanceof ParsingException) {
                bl = true;
                break;
            }
            if (throwable.getCause() == throwable) break;
        }
        if (!bl) {
            string2 = GENERIC_EXCEPTION_MSG;
        } else {
            stringBuilder.append(DASHES40).append(string).append(DASHES40);
        }
        SyntaxError syntaxError = null;
        String string3 = null;
        if (this.getQueryBuilder().getSyntaxProvider() instanceof OracleSyntaxProvider) {
            syntaxError = SyntaxError.checkSQLQuerySyntax((String)string);
            if (null == syntaxError) {
                string3 = ControlsArb.format(UNSUPPORTED_SYNTAX_MSG_KEY, string2);
            } else {
                string3 = ControlsArb.format(NOT_VALID_SELECT_MSG_KEY, syntaxError.getDetailedMessage());
                stringBuilder.setLength(0);
            }
        } else {
            string3 = ControlsArb.format(NOT_VALID_SELECT_MSG_KEY, string2);
        }
        this.showMessageDialog((Component)this.getGUI(), string3, stringBuilder.toString(), true);
    }

    private void showMessageDialog(final Component component, final String string, final String string2, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JTextArea jTextArea = new JTextArea();
                Font font = Font.decode("Monospaced");
                Font font2 = font.deriveFont(jTextArea.getFont().getSize());
                jTextArea.setFont(font2);
                jTextArea.setText(string + string2);
                jTextArea.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)jScrollPane, "Center");
                JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, (Component)jPanel, null, (String)MESSAGE_DIALOG_TITLE, (int)16);
                jEWTDialog.setMinimumSize(new Dimension(300, 120));
                WizardLauncher.runDialog((JDialog)jEWTDialog);
                if (bl) {
                    QueryBuilderEditPanel.this.getQueryBuilder().setSQL("");
                    QueryBuilderEditPanel.this.setLocked(true, false, string, font2);
                    QueryBuilderEditPanel.this.getGUI().setVisible(false);
                    QueryBuilderEditPanel.this.getGUI().setVisible(true);
                }
            }
        };
        this.maybeInvokeLater(runnable);
    }

    private void setTextComponent(JTextComponent jTextComponent) {
        this._textComponent = jTextComponent;
        this._textComponent.getDocument().addDocumentListener(this._textListener);
    }

    private void setText(String string) {
        if (this._textComponent != null) {
            this._textComponent.setText(string);
        }
    }

    private String getText() {
        if (this._textComponent != null) {
            return this._textComponent.getText();
        }
        return null;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markDirty(boolean bl) {
        this._dirty = bl;
    }

    private void checkQuery() {
    }

    private CodingStyleSQLOptions getSQLFormatter() {
        Integer n;
        CodingStyleSQLOptions codingStyleSQLOptions = null;
        if (CodingStyleManager.getCodingStyleManager() == null) {
            CodingStyleManager.setCodingStyleManager(new CodingStyleManagerImpl());
        }
        if ((n = codingStyleMap.get(this.getQueryBuilder().getSyntaxProvider().getClass())) != null) {
            NameAndDatabase nameAndDatabase = new NameAndDatabase("SQL", n);
            codingStyleSQLOptions = ProfileRepository.getProfileRepository().getProfile(nameAndDatabase);
        } else {
            codingStyleSQLOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions();
        }
        return codingStyleSQLOptions;
    }

    private void getDataSourcesInDatasourceGroup(DatasourceGroup datasourceGroup, List<DataSource> list) {
        if (datasourceGroup == null) {
            return;
        }
        for (int i = 0; i < datasourceGroup.getCount(); ++i) {
            if (datasourceGroup.get(i) instanceof DataSource) {
                list.add((DataSource)datasourceGroup.get(i));
                continue;
            }
            if (!(datasourceGroup.get(i) instanceof DatasourceGroup)) continue;
            this.getDataSourcesInDatasourceGroup((DatasourceGroup)datasourceGroup.get(i), list);
        }
    }

    private void getDataSourcesInUnionGroup(UnionGroup unionGroup, List<DataSource> list) {
        for (int i = 0; i < unionGroup.getCount(); ++i) {
            if (unionGroup.get(i) instanceof UnionGroup) {
                this.getDataSourcesInUnionGroup((UnionGroup)unionGroup.get(i), list);
                continue;
            }
            if (!(unionGroup.get(i) instanceof UnionSubQuery)) continue;
            this.getDataSourcesInDatasourceGroup(((UnionSubQuery)unionGroup.get(i)).getFromClause(), list);
        }
    }

    private void getDataSources(SubQuery subQuery, List<DataSource> list) {
        this.getDataSourcesInUnionGroup((UnionGroup)subQuery, list);
        for (int i = 0; i < subQuery.getSubQueryCount(); ++i) {
            this.getDataSources(subQuery.getSubQueries().get(i), list);
        }
    }

    private List<DataSource> getDataSources() {
        ArrayList<DataSource> arrayList = new ArrayList<DataSource>();
        QueryBuilder queryBuilder = this.getQueryBuilder();
        this.getDataSources((SubQuery)queryBuilder.getQuery(), arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDataSourcesMetadata() throws QueryBuilderException {
        QueryBuilder queryBuilder = this.getQueryBuilder();
        queryBuilder.beginUpdate();
        try {
            for (DataSource dataSource : this.getDataSources()) {
                dataSource.refreshMetadata();
            }
        }
        finally {
            queryBuilder.endUpdate();
        }
    }

    private static void loadMetadataByNameInfo(QueryBuilder queryBuilder, List<NameInfo> list) {
        MetadataObject metadataObject;
        assert (queryBuilder != null);
        if (list.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        HashMap<SQLQualifiedName, MetadataFilter> hashMap = new HashMap<SQLQualifiedName, MetadataFilter>(list.size());
        for (NameInfo nameInfo : list) {
            metadataObject = nameInfo.getMetadataObject();
            if (null != metadataObject) continue;
            SQLQualifiedName sQLQualifiedName = nameInfo.getQualifiedDbName();
            MetadataFilter metadataFilter = (MetadataFilter)hashMap.get(sQLQualifiedName);
            if (null == metadataFilter) {
                metadataFilter = new MetadataFilter();
                hashMap.put(sQLQualifiedName, metadataFilter);
            }
            nameInfo.addFilterItem(metadataFilter);
        }
        for (NameInfo nameInfo : hashMap.keySet()) {
            metadataObject = (MetadataFilter)hashMap.get(nameInfo);
            queryBuilder.getMetadataContainer().loadMetadataByFilter((MetadataFilter)metadataObject, (SQLQualifiedName)nameInfo);
        }
        long l2 = System.currentTimeMillis() - l;
        QueryBuilderEditPanel.info(String.format(QB_LOADMETADATABYNAMEINFO, l2));
    }

    static {
        codingStyleMap.put(AccessSyntaxProvider.class, 4);
        codingStyleMap.put(DB2SyntaxProvider.class, 2);
        codingStyleMap.put(MSSQLCESyntaxProvider.class, 5);
        codingStyleMap.put(MSSQLSyntaxProvider.class, 5);
        codingStyleMap.put(MySQLSyntaxProvider.class, 6);
        codingStyleMap.put(SybaseSyntaxProvider.class, 3);
    }

    static class QBDirectLoader
    extends DeferUIOperationTask {
        private QueryBuilderEditPanel qbpanel;

        public QBDirectLoader(QueryBuilderEditPanel queryBuilderEditPanel) {
            super("QBDirectLoader(QB-init)-" + queryBuilderEditPanel.getConnectionName());
            this.qbpanel = queryBuilderEditPanel;
        }

        @Override
        protected Object doWork() throws TaskException {
            long l = System.currentTimeMillis();
            if (Connections.getInstance().lock(this.getConnectionName())) {
                this.directLoad();
                Connections.getInstance().unlock(this.getConnectionName());
                long l2 = System.currentTimeMillis() - l;
                QueryBuilderEditPanel.info(this.toString() + " " + l2 + " ms ");
                return null;
            }
            throw new TaskException((Throwable)new Exception());
        }

        @Override
        protected void invokeLater() {
            this.qbpanel.markDirty(false);
            this.qbpanel.setIsRefreshing(false);
            this.qbpanel.setMetadataLoaded(true);
            this.qbpanel.setSQL(this.qbpanel.getText());
            this.qbpanel = null;
        }

        @Override
        public String getConnectionName() {
            return this.qbpanel.getConnectionName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void directLoad() {
            block10: {
                try {
                    QueryBuilder queryBuilder = this.qbpanel.getQueryBuilder();
                    this.qbpanel.enableSQLUpdatedEventListener(false);
                    if (JIT_METADATA_LOADING) break block10;
                    try {
                        System.gc();
                        queryBuilder.refreshMetadata();
                    }
                    catch (Exception exception) {
                        QueryBuilderEditPanel.log(exception);
                    }
                    finally {
                        System.gc();
                    }
                }
                catch (Exception exception) {
                    QueryBuilderEditPanel.log(exception);
                }
                finally {
                    this.qbpanel.enableSQLUpdatedEventListener(true);
                }
            }
        }
    }

    private static class NameInfo {
        private String name;
        private String schema = "";
        private String database = "";
        private AstTokenIdentifier atiName;
        private AstTokenIdentifier atiSchema;
        private SQLQualifiedName sqnDatabase;
        private QueryBuilder qb;
        private DataSource dataSource;

        public NameInfo(QueryBuilder queryBuilder, ObjectNode objectNode) {
            String string;
            assert (queryBuilder != null);
            assert (objectNode != null);
            this.qb = queryBuilder;
            objectNode.ensureOpen();
            String string2 = (String)objectNode.getProperty("CATALOG");
            this.database = string2 != null ? string2 : this.database;
            String string3 = objectNode.getSchemaName();
            AstTokenIdentifier astTokenIdentifier = this.qb.getSyntaxProvider().getEmptySchemaName(this.qb.getSQLContext());
            String string4 = string = null == astTokenIdentifier ? "" : astTokenIdentifier.getToken();
            if (string.equals(string3)) {
                string3 = "";
            }
            this.schema = string3 != null ? string3 : this.schema;
            this.name = objectNode.getObjectName();
            this.database = this.quoteIdentifierFromTree(this.database);
            this.schema = this.quoteIdentifierFromTree(this.schema);
            this.name = this.quoteIdentifierFromTree(this.name);
        }

        public NameInfo(QueryBuilder queryBuilder, DataSource dataSource) {
            int n;
            assert (queryBuilder != null);
            assert (dataSource != null);
            this.qb = queryBuilder;
            this.dataSource = dataSource;
            BaseSyntaxProvider baseSyntaxProvider = this.qb.getSyntaxProvider();
            if (baseSyntaxProvider instanceof AutoSyntaxProvider) {
                baseSyntaxProvider = ((AutoSyntaxProvider)baseSyntaxProvider).getDetectedSyntaxProvider();
            }
            String string = this.dataSource.getResultSQL();
            String string2 = this.dataSource.getAlias();
            if (!Str.IsNullOrEmpty((String)string2)) {
                int n2 = string.length();
                n = string2.length();
                int n3 = n2 - n - 1;
                string = string.substring(0, n3);
            }
            String[] stringArray = string.split("\\.");
            if (baseSyntaxProvider.isIdentifiersCaseSensitive()) {
                n = 0;
                String string3 = baseSyntaxProvider.getQuoteBegin();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (string4.startsWith(string3)) {
                        n = 1;
                    }
                    if (n == 0) {
                        string4 = baseSyntaxProvider.isNonQuotedIdentifiersToUpperCase() ? string4.toUpperCase() : string4.toLowerCase();
                    }
                    stringArray[i] = string4;
                }
            }
            n = 0;
            this.database = stringArray.length > 2 ? stringArray[n++] : this.database;
            this.schema = stringArray.length > 1 ? stringArray[n++] : this.schema;
            this.name = stringArray.length > 0 ? stringArray[n++] : this.name;
        }

        public void refreshDataSourceMetadata() {
            MetadataObject metadataObject = this.getMetadataObject();
            if (this.dataSource != null && metadataObject != null) {
                this.dataSource.getDatasourceAST().setMetadataObject(metadataObject);
                this.dataSource.refreshMetadata();
            }
        }

        private String quoteIdentifierFromTree(String string) {
            if (null == string) {
                return null;
            }
            BaseSyntaxProvider baseSyntaxProvider = this.qb.getSyntaxProvider();
            String string2 = baseSyntaxProvider.getQuoteBegin();
            String string3 = baseSyntaxProvider.getQuoteEnd();
            String string4 = string.trim();
            if (string4.startsWith(string2)) {
                return string4;
            }
            boolean bl = string4.matches(".*\\p{javaWhitespace}.*");
            if (!bl) {
                boolean bl2 = bl = string4.matches(".*\\p{javaLowerCase}.*") && string4.matches(".*\\p{javaUpperCase}.*");
            }
            if (!bl && baseSyntaxProvider.isIdentifiersCaseSensitive()) {
                bl = baseSyntaxProvider.isNonQuotedIdentifiersToUpperCase() ? string4.matches(".*\\p{javaLowerCase}.*") : string4.matches(".*\\p{javaUpperCase}.*");
            }
            return bl ? string2 + string4 + string3 : string4;
        }

        public MetadataObject getMetadataObject() {
            this.initAti();
            MetadataContainer metadataContainer = this.qb.getMetadataContainer();
            MetadataObject metadataObject = metadataContainer.findObjectByName(this.atiName, this.atiSchema, this.sqnDatabase);
            if (null == metadataObject) {
                AstTokenIdentifier astTokenIdentifier;
                AstTokenIdentifier astTokenIdentifier2;
                Object object;
                BaseSyntaxProvider baseSyntaxProvider = this.qb.getSyntaxProvider();
                BaseSQLContext baseSQLContext = this.qb.getSQLContext();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.sqnDatabase);
                if (baseSyntaxProvider.isSupportDatabases() && (object = baseSyntaxProvider.getDefaultDatabaseName(baseSQLContext)) != null && !object.equals(this.sqnDatabase)) {
                    arrayList.add(object);
                }
                object = new ArrayList();
                ((ArrayList)object).add(this.atiSchema);
                if (baseSyntaxProvider.isSupportSchemas()) {
                    SQLIdentifiersCollection sQLIdentifiersCollection = new SQLIdentifiersCollection(baseSQLContext);
                    baseSyntaxProvider.getDefaultSchemaNames(baseSQLContext, sQLIdentifiersCollection);
                    int n = sQLIdentifiersCollection.getCount();
                    for (int i = 0; i < n; ++i) {
                        astTokenIdentifier2 = sQLIdentifiersCollection.get(i);
                        if (((ArrayList)object).contains(astTokenIdentifier2)) continue;
                        ((ArrayList)object).add(astTokenIdentifier2);
                    }
                    astTokenIdentifier = baseSyntaxProvider.getEmptySchemaName(baseSQLContext);
                    if (null != astTokenIdentifier && !((ArrayList)object).contains(astTokenIdentifier)) {
                        ((ArrayList)object).add(astTokenIdentifier);
                    }
                }
                block1: for (SQLQualifiedName sQLQualifiedName : arrayList) {
                    astTokenIdentifier = ((ArrayList)object).iterator();
                    while (astTokenIdentifier.hasNext()) {
                        astTokenIdentifier2 = (AstTokenIdentifier)astTokenIdentifier.next();
                        metadataObject = metadataContainer.findObjectByName(this.atiName, astTokenIdentifier2, sQLQualifiedName);
                        if (metadataObject == null) continue;
                        break block1;
                    }
                }
            }
            return metadataObject;
        }

        private void initAti() {
            if (null == this.atiName) {
                try {
                    BaseSQLContext baseSQLContext = this.qb.getSQLContext();
                    this.atiName = baseSQLContext.parseIdentifierQuoteIfNeed(this.name);
                    this.atiSchema = baseSQLContext.parseIdentifierQuoteIfNeed(this.schema);
                    this.sqnDatabase = Str.IsNullOrEmpty((String)this.database) ? new SQLQualifiedName(baseSQLContext) : baseSQLContext.parseQualifiedNameQuoteIfNeed(this.database);
                }
                catch (ParsingException parsingException) {
                    QueryBuilderEditPanel.log(parsingException);
                }
            }
        }

        public void addFilterItem(MetadataFilter metadataFilter) {
            this.initAti();
            boolean bl = this.qb.getSyntaxProvider().isIdentifiersCaseSensitive();
            MetadataFilterItem metadataFilterItem = metadataFilter.add();
            metadataFilterItem.setObjectMask(this.atiName.getToken());
            metadataFilterItem.setObjectMaskCaseSensitive(bl);
            metadataFilterItem.setSchemaMask(Str.IsNullOrEmpty((String)this.atiSchema.getToken()) ? null : this.atiSchema.getToken());
            metadataFilterItem.setSchemaMaskCaseSensitive(bl);
        }

        public SQLQualifiedName getQualifiedDbName() {
            this.initAti();
            return this.sqnDatabase;
        }

        public void addObjectToDiagram() {
            MetadataObject metadataObject = this.getMetadataObject();
            String string = "";
            String string2 = null;
            if (metadataObject != null) {
                string2 = metadataObject.getFullNameStr();
                string = metadataObject.getAltName();
            } else {
                string2 = this.database.isEmpty() ? (this.schema.isEmpty() ? this.name : this.schema + '.' + this.name) : this.database + '.' + this.schema + '.' + this.name;
            }
            this.qb.getActiveSubquery().getActiveUnionSubquery().addObjectWithFKAt(string2, new Point(0, 0), string);
        }
    }

    public static class QueryBuilderDropTargetListener
    extends DropTargetAdapter {
        private static DataFlavor[] _supportedFlavors = new DataFlavor[]{TransferablesList.TRANSFERABLE_LIST_FLAVOR, TransferableTreeNode.TREE_NODE_FLAVOR, DatabaseElementTransferable.FLAVOR};
        private static List<String> _supportedTypes = new ArrayList<String>();
        static final String TABLE = "TABLE";
        static final String VIEW = "VIEW";
        static final String MATERIALIZED_VIEW = "MATERIALIZED VIEW";
        static final String PROCEDURE = "PROCEDURE";
        static final String SYNONYM = "SYNONYM";
        static final String PUBLIC_SYNONYM = "PUBLIC_SYNONYM";
        static final String SYSTEM_TABLE = "SYSTEM TABLE";
        static final String ALIASES = "ALIASES";
        private QueryBuilder qb;
        private static final String QB_HANDLEDROP = "QB-handleDrop ";

        public QueryBuilderDropTargetListener(QueryBuilder queryBuilder) {
            assert (queryBuilder != null);
            this.qb = queryBuilder;
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            try {
                boolean bl = false;
                for (DataFlavor dataFlavor : _supportedFlavors) {
                    if (!transferable.isDataFlavorSupported(dataFlavor)) continue;
                    bl = this.isTypeSupported(this.getUserObjects(transferable));
                    break;
                }
                if (bl) {
                    dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }
            catch (Exception exception) {
                QueryBuilderEditPanel.log(exception);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                this.handleNodeDrop(this.getUserObjects(transferable));
            }
            catch (Exception exception) {
                QueryBuilderEditPanel.log(exception);
            }
        }

        private boolean isTypeSupported(List<Displayable> list) {
            boolean bl = false;
            for (Displayable displayable : list) {
                if (!(displayable instanceof ObjectNode)) continue;
                ObjectNode objectNode = (ObjectNode)displayable;
                objectNode.ensureOpen();
                String string = objectNode.getObjectType();
                if (_supportedTypes.contains(string)) {
                    bl = true;
                    continue;
                }
                bl = false;
                break;
            }
            return bl;
        }

        private void handleNodeDrop(final List<Displayable> list) {
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker(QB_HANDLEDROP){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object construct() {
                    WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                    waitCursor.show(1000);
                    long l = System.currentTimeMillis();
                    try {
                        final ArrayList<NameInfo> arrayList = new ArrayList<NameInfo>();
                        for (Displayable displayable : list) {
                            if (!(displayable instanceof ObjectNode)) continue;
                            arrayList.add(new NameInfo(QueryBuilderDropTargetListener.this.qb, (ObjectNode)displayable));
                        }
                        QueryBuilderEditPanel.loadMetadataByNameInfo(QueryBuilderDropTargetListener.this.qb, arrayList);
                        UIUtils.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (NameInfo nameInfo : arrayList) {
                                        nameInfo.addObjectToDiagram();
                                    }
                                }
                                catch (Exception exception) {
                                    QueryBuilderEditPanel.log(exception);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        QueryBuilderEditPanel.log(exception);
                    }
                    finally {
                        waitCursor.hide();
                        long l2 = System.currentTimeMillis() - l;
                        QueryBuilderEditPanel.info(QueryBuilderDropTargetListener.QB_HANDLEDROP + l2 + " ms ");
                    }
                    return null;
                }
            };
            namedSwingWorker.start();
        }

        private List<Displayable> getUserObjects(Transferable transferable) {
            ArrayList<Displayable> arrayList;
            block17: {
                arrayList = new ArrayList<Displayable>();
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    Object object = null;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                        arrayList2.addAll((Collection<Object>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
                    } else if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                        arrayList2.add((DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
                    } else if (transferable.isDataFlavorSupported(DatabaseElementTransferable.FLAVOR)) {
                        arrayList2.add((DatabaseElement)transferable.getTransferData(DatabaseElementTransferable.FLAVOR));
                    }
                    if (arrayList2 == null || arrayList2.size() <= 0) break block17;
                    for (Object e : arrayList2) {
                        defaultMutableTreeNode = null;
                        try {
                            if (e instanceof MultiTransferable) {
                                defaultMutableTreeNode = (DefaultMutableTreeNode)((MultiTransferable)e).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                            } else if (e instanceof DefaultMutableTreeNode) {
                                defaultMutableTreeNode = (DefaultMutableTreeNode)e;
                            } else if (e instanceof DatabaseElementTransferable) {
                                arrayList.add((Displayable)((DatabaseElementTransferable)e).getTransferData(DatabaseElementTransferable.FLAVOR));
                            } else if (e instanceof DatabaseElement) {
                                arrayList.add((Displayable)e);
                            }
                        }
                        catch (Exception exception) {
                            QueryBuilderEditPanel.log(exception);
                        }
                        if (defaultMutableTreeNode == null) continue;
                        object = defaultMutableTreeNode.getUserObject();
                        arrayList.add((Displayable)object);
                    }
                }
                catch (Exception exception) {
                    QueryBuilderEditPanel.log(exception);
                }
            }
            return arrayList;
        }

        static {
            _supportedTypes.add(TABLE);
            _supportedTypes.add(VIEW);
            _supportedTypes.add(MATERIALIZED_VIEW);
            _supportedTypes.add(SYNONYM);
            _supportedTypes.add(PUBLIC_SYNONYM);
            _supportedTypes.add(SYSTEM_TABLE);
            _supportedTypes.add(ALIASES);
        }
    }
}

