/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.parser.plsql.DictionaryQuery;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.search.ItemNode;
import oracle.dbtools.raptor.controls.search.ResultsTreeNode;
import oracle.dbtools.raptor.controls.search.SchemaNode;
import oracle.dbtools.raptor.controls.search.SearchIdeNode;
import oracle.dbtools.raptor.controls.search.TypeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

public class QueryTask
extends DatabaseQueryTask<ArrayList<Item>> {
    private final DictionaryQuery query;
    private String name;
    private final String conn;
    private String userName;
    private String[] objectTypes = null;
    private String[] schemas = null;
    private String[] idTypes = null;
    private String[] idUsages = null;
    private boolean isColumns = false;
    private boolean isAllSource = false;
    private boolean isWildcard = false;
    private DefaultMutableTreeNode root;
    static final String connPref = "IdeConnections%23";
    int cardinality;
    long time;

    public QueryTask(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, boolean bl3) {
        super(MessageFormat.format(ControlsArb.getString("SearchPanel.4"), string2.startsWith(connPref) ? string2.substring(connPref.length()) : string2, string), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true);
        this.name = string;
        this.conn = string2;
        this.query = new DictionaryQuery(this.conn, null, false);
        this.objectTypes = stringArray;
        this.schemas = stringArray2;
        this.idTypes = stringArray3;
        this.idUsages = stringArray4;
        this.isColumns = bl;
        this.isAllSource = bl2;
        this.isWildcard = bl3;
        Properties properties = Connections.getInstance().getConnectionInfo(this.conn);
        if (properties != null) {
            this.userName = properties.getProperty("user");
        }
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ArrayList arrayList = null;
                        try {
                            arrayList = (ArrayList)QueryTask.this.getResult();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                            return;
                        }
                        catch (ExecutionException executionException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                            return;
                        }
                        QueryTask.this.buildOutputTree(arrayList);
                        final Context context = Context.newIdeContext((Node)new SearchIdeNode(QueryTask.this.conn, QueryTask.this.name, QueryTask.this.cardinality, QueryTask.this.time, QueryTask.this.root));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public ArrayList<Item> doWork() {
        this.query.lateCheckDbaAccess();
        if (this.objectTypes != null) {
            this.query.prepareAllObjects(this.name, this.objectTypes, this.schemas);
        }
        if (this.idTypes != null || this.idUsages != null) {
            this.query.prepareAllIdentifiers(this.name, this.idTypes, this.idUsages, this.schemas);
        }
        if (this.isColumns) {
            this.query.prepareAllColumns(this.name, this.schemas);
        }
        if (this.isAllSource) {
            this.query.prepareAllSource(this.name, this.schemas, this.isWildcard);
        }
        long l = System.currentTimeMillis();
        ArrayList<Item> arrayList = this.query.fetch(this.name);
        this.time = System.currentTimeMillis() - l;
        this.cardinality = arrayList.size();
        return arrayList;
    }

    public boolean cancel() {
        DatabaseQueryTask<Void> databaseQueryTask = new DatabaseQueryTask<Void>(ControlsArb.getString("SearchPanel.46"), IRaptorTaskRunMode.NO_GUI, false, false){

            protected Void doWork() throws TaskException {
                if (QueryTask.this.query != null) {
                    QueryTask.this.query.cancel();
                }
                return null;
            }

            @Override
            public String getConnectionName() {
                return QueryTask.this.conn;
            }

            @Override
            public String getQuery() {
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
        return super.cancel();
    }

    @Override
    public String getConnectionName() {
        return this.query.getConnectionName();
    }

    @Override
    public String getQuery() {
        return this.query != null ? this.query.QUERY_ALL_OBJECTS() : "";
    }

    private void buildOutputTree(ArrayList<Item> arrayList) {
        this.root = new TypeNode("");
        LinkedList<SchemaNode> linkedList = new LinkedList<SchemaNode>();
        LinkedList<TypeNode> linkedList2 = new LinkedList<TypeNode>();
        LinkedList<TypeNode> linkedList3 = new LinkedList<TypeNode>();
        for (Item item : arrayList) {
            ResultsTreeNode resultsTreeNode = new SchemaNode(item.owner);
            int n = linkedList.indexOf(resultsTreeNode);
            if (n == -1) {
                linkedList.add((SchemaNode)resultsTreeNode);
                this.root.add(resultsTreeNode);
                linkedList2 = new LinkedList();
                linkedList3 = new LinkedList();
            } else {
                resultsTreeNode = (ResultsTreeNode)linkedList.get(n);
            }
            ResultsTreeNode resultsTreeNode2 = new TypeNode(item.objType);
            int n2 = linkedList2.indexOf(resultsTreeNode2);
            if (n2 == -1) {
                linkedList2.add((TypeNode)resultsTreeNode2);
                resultsTreeNode.add(resultsTreeNode2);
                linkedList3 = new LinkedList();
            } else {
                resultsTreeNode2 = (ResultsTreeNode)linkedList2.get(n2);
            }
            String string = item.objName;
            ResultsTreeNode resultsTreeNode3 = null;
            if (-1 < item.line || "COLUMN".equals(item.colType)) {
                resultsTreeNode3 = new TypeNode(string);
                n = linkedList3.indexOf(resultsTreeNode3);
                if (n == -1) {
                    linkedList3.add((TypeNode)resultsTreeNode3);
                } else {
                    resultsTreeNode3 = (ResultsTreeNode)linkedList3.get(n);
                }
                resultsTreeNode3.add(new ItemNode(item, this.name));
            }
            if (resultsTreeNode3 == null) {
                resultsTreeNode3 = new ItemNode(item, this.name);
            }
            resultsTreeNode2.add(resultsTreeNode3);
        }
    }
}

