/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.sql.Datum;

public class ActionSql {
    private Map<String, Object> _dict;
    private String _origSql;
    private String _cleanedSql;
    private Map<String, Object> _binds;

    public ActionSql() {
    }

    public ActionSql(String string, Map<String, Object> map) {
        this._origSql = string;
        this._dict = map;
    }

    public void clear() {
        this._origSql = null;
        this._dict = null;
    }

    public String manualSubs(String string, Map<String, ?> map) {
        String string2 = string;
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String string3 = entry.getKey();
                if (string2.toUpperCase().indexOf(string3.toUpperCase()) <= 0) continue;
                string2 = this.subHashMark(string2, string3, entry.getValue());
            }
        }
        return string2;
    }

    public String directSubstuitions(String string) {
        return this.manualSubs(string, this._dict);
    }

    private void findNamedBinds() {
        if (this._dict != null) {
            Iterator<String> iterator = this._dict.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = iterator.next();
                if (this._cleanedSql.toLowerCase().indexOf(":" + string.toLowerCase()) <= 0) continue;
                this._binds.put(string, this._dict.get(string));
            }
        }
    }

    public String processPrompts(String string, List<JComponent> list, List<String> list2) {
        String string2 = string;
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) {
                string3 = "";
            } else if (list.get(i) instanceof JTextComponent) {
                string3 = ((JTextComponent)list.get(i)).getText();
            } else if (list.get(i) instanceof RadioGroupPanel) {
                string3 = ((RadioGroupPanel)list.get(i)).getSelectedValue();
            } else if (list.get(i) instanceof JComboBox) {
                string3 = ((JComboBox)list.get(i)).getSelectedItem() != null ? ((JComboBox)list.get(i)).getSelectedItem().toString() : "";
            } else if (list.get(i) instanceof JCheckBox) {
                string3 = ((JCheckBox)list.get(i)).isSelected() && list2.size() > i && list2.get(i) != null ? list2.get(i) : "";
            } else if (list.get(i) instanceof JScrollPane && ((JViewport)((JScrollPane)list.get(i)).getComponent(0)).getComponent(0) instanceof BasicEditorPane) {
                string3 = ((BasicEditorPane)((JViewport)((JScrollPane)list.get(i)).getComponent(0)).getComponent(0)).getText();
            }
            if (string2.indexOf(":" + i) > 0) {
                this._binds.put("" + i, string3);
            }
            string2 = this.subHashMark(string2, i + "", string3);
        }
        return string2;
    }

    private String subHashMark(String string, String string2, Object object) {
        String string3 = null;
        if (object == null) {
            string3 = "";
        } else if (object instanceof Datum) {
            try {
                string3 = ((Datum)object).stringValue();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        if (string3 == null) {
            string3 = object.toString();
        }
        String string4 = string;
        String string5 = string3.replace("\\", "\\\\");
        string5 = string5.replace("$", "\\$");
        string5 = string5.replace("(", "\\(");
        string5 = string5.replace("*", "\\*");
        string5 = string5.replace(")", "\\)");
        try {
            if (this.matches(string4, ".*#" + string2 + "#.*")) {
                string4 = string4.replaceAll("((?i)#" + string2 + "#)", string5);
            } else if (this.matches(string4, ".*#\"" + string2 + "\"#.*")) {
                string4 = string4.replaceAll("((?i)#\"" + string2 + "\"#)", "\"" + string5 + "\"");
            } else if (this.matches(string4, ".*#," + string2 + "#.*")) {
                string4 = string4.replaceAll("(?i)#," + string2 + "#", "".equals(string5) ? "" : "," + string5);
            } else if (this.matches(string4, ".*#,\"" + string2 + "\"#.*")) {
                string4 = string4.replaceAll("((?i)#,\"" + string2 + "\"#)", "".equals(string5) ? "" : ",\"" + string5 + "\"");
            }
            if (this.matches(string4, ".*#esc\\(" + string5 + "\\)#.*")) {
                string4 = string4.replaceAll("((?i)#esc\\(" + string5 + "\\)#)", "".equals(string5) ? "" : string5.replaceAll("'", "''"));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string4;
    }

    public boolean matches(String string, String string2) {
        Pattern pattern = Pattern.compile(string2, 10);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public void processSql() {
        this.processSql(null, null);
    }

    public void processSql(List<JComponent> list, List<String> list2) {
        this._binds = new HashMap<String, Object>();
        this._cleanedSql = this.directSubstuitions(this._origSql);
        this.findNamedBinds();
        if (list != null) {
            this._cleanedSql = this.processPrompts(this._cleanedSql, list, list2);
        }
    }

    public void setSql(String string) {
        this._origSql = string;
    }

    public void setDict(Map<String, Object> map) {
        this._dict = map;
    }

    public String getSql() {
        return this._cleanedSql;
    }

    public String getOrigSql() {
        return this._origSql;
    }

    public Map<String, Object> getBinds() {
        return this._binds;
    }

    public Map<String, Object> getDict() {
        return this._dict;
    }
}

