/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ide.util.MetaClass;
import javax.ide.util.MetaResource;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionConstants;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.support.MetaXMLReference;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectAction
implements ObjectActionConstants {
    public static final String ACTION_KEY = "ObjectAction.KEY";
    public static final String ACTION_TARGET_KEY = "ObjectAction.TARGET.KEY";
    public static final String ACTION_CONN_NAME = "ObjectAction.CONN_NAME";
    public static final String ACTION_EVENT = "ObjectAction.EVENT";
    public static final String ACTION_DBOBJECT = "ObjectAction.DBOBJECT";
    public static final String ACTION_CLASS = "ObjectAction.CLASS";
    public static final String ACTION_CONN_TYPE = "ObjectAction.ConnType";
    public static final String ACTION_WEIGHT = "ObjectAction.ConnType";
    public static final String ACTION_UNDECORATED_NAME = "ObjectAction.UndecoratedName";
    public static final String RENAME_ACTION_NAME = "Rename...";
    public static int SINGLE_SELECT = 1;
    public static int MULTI_SELECT = 2;
    public static int BOTH_SELECT = SINGLE_SELECT | MULTI_SELECT;
    private MetaClass<AbstractMenuAction> m_cls;
    private String _sql;
    private String _title;
    private String _help;
    private String _type;
    private MetaResource _iconRef;
    private Icon _icon;
    private IdeAction _action;
    private int _id;
    private boolean _reloadParent = false;
    private boolean _reload = false;
    private String _confirm;
    private String _confirmTitle;
    private String _confirmSql;
    private String _classArgs;
    private boolean _removeFromParent;
    private boolean _connRequired;
    private Version _maxver;
    private Version _minver;
    private String[] _reqFeatures;
    private String _commandName;
    private List<ObjectActionPrompt> _prompts;
    private String _connType;
    private JMenuItem _menuItem;
    private String _sqlType;
    private MetaClass<Controller> _controllerClass;
    private int _selection;
    private float _weight = 1.0f;
    public static final float SECTION_OBJECT_ACTIONS_CTXT_MENU = MenuConstants.decrement((float)MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
    private Float _section = Float.valueOf(SECTION_OBJECT_ACTIONS_CTXT_MENU);
    private String _script;
    private String _scriptLang;
    private boolean _toolbar = false;
    private boolean _sqldevOnly;
    private boolean _isRenameAction;

    public ObjectAction() {
    }

    public ObjectAction(MetaXMLReference metaXMLReference) {
        this(metaXMLReference, null);
    }

    public ObjectAction(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        this.processNode(metaXMLReference, xLIFFHelper);
    }

    public ObjectAction(String string, String string2, String string3, String string4, MetaClass<AbstractMenuAction> metaClass, String string5, String string6, String string7) {
        this(string, string2, string3, string4, metaClass, string5, string6, string7, null);
    }

    public ObjectAction(String string, String string2, String string3, String string4, MetaClass<AbstractMenuAction> metaClass, String string5, String string6, String string7, String string8) {
        this.m_cls = metaClass;
        this._sql = string2;
        this._title = string3;
        this._type = string;
        this._help = string4;
        this._confirm = string6;
        this._confirmTitle = string5;
        this._confirmSql = string7;
        this._controllerClass = new MetaClass(this.getClass().getClassLoader(), string8);
    }

    private void initAction() {
        if (this._action == null) {
            String string;
            Object object;
            if (this._commandName == null || this._commandName.equals("")) {
                object = UUID.randomUUID().toString();
                string = MessageFormat.format("raptor.objectaction.{0}.{1}.{2}.{3}", this._connType != null ? this._connType : "Oracle", this._type, this._title, object);
                this._id = Ide.findOrCreateCmdID((String)string);
            } else {
                this._id = Ide.findOrCreateCmdID((String)this._commandName);
            }
            object = StringUtils.getMnemonicKeyCode((String)("raptor.objectaction." + this._type + "." + this._title));
            this._action = IdeAction.findOrCreate((int)this._id, null, (String)this._title, null, (Integer)object, (Icon)this.getIcon(), null, (boolean)true);
            if (this._commandName != null && !this._commandName.equals("") && this._iconRef != null) {
                this._action.putValue("SmallIcon", (Object)this.getIcon());
            }
            this._action.putValue(ACTION_KEY, (Object)this);
            this._action.putValue("menu-section-id", (Object)this._section);
            this._action.setMenuWeight(this._weight);
            this._action.addController(ObjectActionController.getInstance());
            if (this._controllerClass != null) {
                try {
                    string = (Controller)this._controllerClass.newInstance();
                    if (string != null) {
                        this._action.addController((Controller)string);
                    }
                }
                catch (Exception exception) {
                    Logger.severe(this.getClass(), (String)"initAction", (Throwable)exception);
                }
            }
        }
    }

    public Object getProperty(String string) {
        if (this._action == null) {
            this.initAction();
        }
        return this._action.getValue(string);
    }

    public void putProperty(String string, Object object) {
        if (this._action == null) {
            this.initAction();
        }
        this._action.putValue(string, object);
    }

    public JMenuItem getMenuItem(ContextMenu contextMenu) {
        if (this._action == null) {
            this.initAction();
        }
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._action);
        jMenuItem.putClientProperty(ACTION_KEY, this);
        jMenuItem.putClientProperty("menu-weight", Float.valueOf(this._weight));
        jMenuItem.putClientProperty("menu-section-id", this._section);
        jMenuItem.setIcon(this.getIcon());
        return jMenuItem;
    }

    public JMenuItem getMenuItem() {
        if (this._action == null) {
            this.initAction();
        }
        if (this._menuItem == null) {
            this._menuItem = new JMenuItem((Action)this._action);
            this._menuItem.putClientProperty(ACTION_KEY, this);
            this._menuItem.putClientProperty("menu-section-id", this._section);
        }
        this._menuItem.setIcon(this.getIcon());
        return this._menuItem;
    }

    public boolean isValidForVersion(DBObject dBObject) {
        return this.isValidForVersion(dBObject, null);
    }

    public boolean isValidForVersion(DBObject dBObject, IdeAction ideAction) {
        if (this._minver == null && this._maxver == null && this._reqFeatures == null) {
            this.decorateActionWithValidation(ideAction, null);
            return true;
        }
        if (!Connections.getInstance().isConnectionOpen(dBObject.getConnectionName())) {
            String string = "!" + DatabaseNavigatorResources.get("CONNECTION_FILTER_CONNECTED_MSG");
            this.decorateActionWithValidation(ideAction, string);
            return false;
        }
        Connection connection = dBObject.getConnection();
        if (!QueryUtils.hasRequiredFeatures((Connection)connection, (String[])this._reqFeatures)) {
            this.decorateActionWithValidation(ideAction, Arrays.toString(this._reqFeatures));
            return false;
        }
        if (!DBUtil.checkVersion((Connection)connection, (Version)this._maxver, (Version)this._minver)) {
            String string = (this._minver != null ? this._minver.toString() : "-") + (this._maxver != null ? (this._minver != null ? " - " : "") + this._maxver.toString() : "+");
            this.decorateActionWithValidation(ideAction, string);
            return false;
        }
        this.decorateActionWithValidation(ideAction, null);
        return true;
    }

    private void decorateActionWithValidation(IdeAction ideAction, String string) {
        if (ideAction != null) {
            String string2 = (String)ideAction.getValue(ACTION_UNDECORATED_NAME);
            if (null == string2) {
                string2 = (String)ideAction.getValue("Name");
                ideAction.putValueDirectly(ACTION_UNDECORATED_NAME, (Object)string2);
            }
            if (null == string || string.isEmpty()) {
                ideAction.putValueDirectly("Name", (Object)string2);
            } else {
                if (string.startsWith("[")) {
                    string = string.substring(1, string.length() - 1);
                }
                String string3 = String.format("%s [ %s ]", string2, string);
                ideAction.putValueDirectly("Name", (Object)string3);
            }
        }
    }

    public void setMinVersion(String string) {
        if (string != null) {
            this._minver = new Version(string);
        }
    }

    public void setMaxVersion(String string) {
        if (string != null) {
            this._maxver = new Version(string);
        }
    }

    public List<ObjectActionPrompt> getPrompts() {
        return this._prompts;
    }

    public void setReload(boolean bl) {
        this._reload = bl;
    }

    public boolean getReload() {
        return this._reload;
    }

    public void setReloadParent(boolean bl) {
        this._reloadParent = bl;
    }

    public boolean getReloadParent() {
        return this._reloadParent;
    }

    public void setRemoveFromParent(boolean bl) {
        this._removeFromParent = bl;
    }

    public boolean isRemoveFromParent() {
        return this._removeFromParent;
    }

    public IdeAction getAction() {
        this.initAction();
        return this._action;
    }

    public int getId() {
        return this._id;
    }

    public String getHelp() {
        return this._help;
    }

    public String getType() {
        return this._type;
    }

    public String getSql() {
        return this._sql;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getTitle() {
        return this._title;
    }

    public MetaClass<AbstractMenuAction> getMetaClass() {
        return this.m_cls;
    }

    public AbstractMenuAction getActionInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (AbstractMenuAction)this.m_cls.newInstance();
    }

    public String getControllerClassName() {
        return this._controllerClass.getClassName();
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getConfirm() {
        return this._confirm;
    }

    public String getConfirmSql() {
        return this._confirmSql;
    }

    public String getConfirmTitle() {
        return this._confirmTitle;
    }

    public void setClassArgs(String string) {
        this._classArgs = string;
    }

    public String getClassArgs() {
        return this._classArgs;
    }

    public void setConnType(String string) {
        this._connType = string;
    }

    public String getConnType() {
        return this._connType == null ? "Oracle" : this._connType;
    }

    private boolean isTrue(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    public int getSelectionMode() {
        return this._selection;
    }

    public boolean isSelectable(int n) {
        return (n & this._selection) == n;
    }

    public void setSelectionMode(int n) {
        this._selection = n;
    }

    public void setSelectionMode(String string) {
        this._selection = string != null && string.equalsIgnoreCase("MULTI") ? MULTI_SELECT : (string != null && string.equalsIgnoreCase("BOTH") ? BOTH_SELECT : SINGLE_SELECT);
    }

    private void processNode(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        String string;
        String string2;
        String string3;
        Node node = metaXMLReference.getNode();
        this._title = XMLHelper.getNodeValue((Node)node, (String)"title");
        this.setIsRenameAction(RENAME_ACTION_NAME.equals(this._title));
        this._sql = XMLHelper.getNodeValue((Node)node, (String)"sql");
        this._script = XMLHelper.getNodeValue((Node)node, (String)"script");
        this._scriptLang = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"script"), (String)"language");
        this._sqlType = XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"sql"), (String)"type");
        String string4 = XMLHelper.getNodeValue((Node)node, (String)"iconName");
        if (ModelUtil.hasLength((String)string4)) {
            this._iconRef = new MetaResource(metaXMLReference.getReferenceClassLoader(), string4);
        }
        this._sqldevOnly = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"sqldevonly"));
        this._reloadParent = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"reloadparent"));
        this._reload = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"reload"));
        this._removeFromParent = this.isTrue(XMLHelper.getAttributeNode((Node)node, (String)"removeFromParent"));
        this._type = XMLHelper.getAttributeNode((Node)node, (String)"type");
        this._connType = XMLHelper.getAttributeNode((Node)node, (String)"connType");
        String string5 = XMLHelper.getAttributeNode((Node)node, (String)"className");
        if (ModelUtil.hasLength((String)string5)) {
            this.m_cls = new MetaClass(metaXMLReference.getReferenceClassLoader(), string5);
        }
        this._classArgs = XMLHelper.getAttributeNode((Node)node, (String)"classArgs");
        this.setSelectionMode(XMLHelper.getAttributeNode((Node)node, (String)"selectionMode"));
        String string6 = XMLHelper.getAttributeNode((Node)node, (String)"controllerClassName");
        if (ModelUtil.hasLength((String)string6)) {
            this._controllerClass = new MetaClass(metaXMLReference.getReferenceClassLoader(), string6);
        }
        this._connRequired = XMLHelper.getAttributeNode((Node)node, (String)"connectionRequired") != null ? Boolean.valueOf(XMLHelper.getAttributeNode((Node)node, (String)"connectionRequired")) : true;
        this._toolbar = Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"toolbar"));
        this._commandName = XMLHelper.getAttributeNode((Node)node, (String)"commandName");
        String string7 = XMLHelper.getAttributeNode((Node)node, (String)"weight");
        if (string7 != null) {
            try {
                this._weight = this.resolveFloatValue(string7).floatValue();
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (String)"Menu Weight", (Throwable)exception);
            }
        }
        if ((string3 = XMLHelper.getAttributeNode((Node)node, (String)"section")) != null) {
            try {
                this._section = this.resolveFloatValue(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.severe(this.getClass(), (String)"Menu Section", (Throwable)numberFormatException);
            }
        }
        this._confirm = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"prompt");
        this._confirmTitle = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"title");
        this._confirmSql = XMLHelper.getNodeValue((Node)XMLHelper.getChildNode((Node)node, (String)"confirmation"), (String)"sql");
        this._help = XMLHelper.getNodeValue((Node)node, (String)"help");
        this._prompts = ObjectActionPrompt.getPrompts(node, xLIFFHelper);
        String string8 = XMLHelper.getAttributeNode((Node)node, (String)"maxversion");
        if (string8 != null) {
            this._maxver = new Version(string8);
        }
        if ((string2 = XMLHelper.getAttributeNode((Node)node, (String)"minversion")) != null) {
            this._minver = new Version(string2);
        }
        String[] stringArray = this._reqFeatures = (string = XMLHelper.getAttributeNode((Node)node, (String)"requiredFeatures")) != null ? string.split(",") : null;
        if (xLIFFHelper != null) {
            this._title = xLIFFHelper.getTranslation(this._title);
            this._confirm = xLIFFHelper.getTranslation(this._confirm);
            this._confirmTitle = xLIFFHelper.getTranslation(this._confirmTitle);
            this._help = xLIFFHelper.getTranslation(this._help);
        }
    }

    private Float resolveFloatValue(String string) throws NumberFormatException {
        if (null == string) {
            return null;
        }
        Float f = Float.valueOf(Float.MAX_VALUE);
        try {
            f = Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = string.substring(0, string.lastIndexOf("."));
            String string3 = string.substring(string.lastIndexOf(".") + 1);
            try {
                Field field = Class.forName(string2).getDeclaredField(string3);
                Object object = field.get(null);
                if (object instanceof Float) {
                    f = (Float)object;
                }
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
                throw numberFormatException;
            }
        }
        return f;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<item ");
        stringBuffer.append(" reload=\"" + this._reload + "\" ");
        stringBuffer.append(" reloadparent=\"" + this._reloadParent + "\"");
        stringBuffer.append(" removeFromParent=\"" + this._removeFromParent + "\"");
        if (this._sqldevOnly) {
            stringBuffer.append(" sqldevonly=\"" + this._sqldevOnly + "\"");
        }
        if (this._type != null) {
            stringBuffer.append(" type=\"" + this._type + "\"");
        }
        if (this.m_cls != null) {
            stringBuffer.append(" className=\"" + this.m_cls.getClassName() + "\"");
        }
        if (this._classArgs != null) {
            stringBuffer.append(" classArgs=\"" + this._classArgs + "\"");
        }
        if (this._controllerClass != null) {
            stringBuffer.append(" controllerClassName=\"" + this._controllerClass + "\"");
        }
        if (this._maxver != null) {
            stringBuffer.append(" maxversion=\"" + this._maxver + "\"");
        }
        if (this._minver != null) {
            stringBuffer.append(" minversion=\"" + this._minver + "\"");
        }
        stringBuffer.append(" toolbar=\"" + this._toolbar + "\" ");
        stringBuffer.append(">");
        stringBuffer.append("<title>" + this._title + "</title>");
        if (this._prompts != null) {
            for (ObjectActionPrompt objectActionPrompt : this._prompts) {
                objectActionPrompt.toXML(stringBuffer);
            }
        }
        if (this._sql != null) {
            stringBuffer.append("<sql><![CDATA[" + this._sql + "]]></sql>");
        }
        if (this._script != null) {
            stringBuffer.append("<script language=\"" + this._scriptLang + "\"><![CDATA[" + this._script + "]]></script>");
        }
        if (this._help != null) {
            stringBuffer.append("<help>" + this._help + "</help>");
        }
        if (this._confirmTitle != null) {
            stringBuffer.append("<confirmation>");
            stringBuffer.append("  <title>" + this._confirmTitle + "</title>");
            stringBuffer.append("  <prompt><![CDATA[" + this._confirm + "]]></prompt>");
            stringBuffer.append("  <sql><![CDATA[" + this._sql + "]]></sql>");
            stringBuffer.append("</confirmation>");
        }
        stringBuffer.append("</item>");
    }

    public List<String> getDefaults() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ObjectActionPrompt objectActionPrompt : this._prompts) {
            arrayList.add(objectActionPrompt.getDefault());
        }
        return arrayList;
    }

    public static List<ObjectAction> getActions(MetaXMLReference metaXMLReference, XLIFFHelper xLIFFHelper) {
        ArrayList<ObjectAction> arrayList = new ArrayList<ObjectAction>();
        NodeList nodeList = ((Element)metaXMLReference.getNode()).getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (xLIFFHelper != null) {
                arrayList.add(new ObjectAction(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)nodeList.item(i)), xLIFFHelper));
                continue;
            }
            arrayList.add(new ObjectAction(MetaXMLReference.createXMLReference((MetaXMLReference)metaXMLReference, (Node)nodeList.item(i))));
        }
        return arrayList;
    }

    public void setClassName(String string, ClassLoader classLoader) {
        this.m_cls = ModelUtil.hasLength((String)string) ? new MetaClass(classLoader, string) : null;
    }

    public void setMetaClass(MetaClass<AbstractMenuAction> metaClass) {
        this.m_cls = metaClass;
    }

    private Icon getIcon() {
        if (this._iconRef != null && this._icon == null) {
            this._icon = RaptorImage.getIcon((String)this._iconRef.getResourcePath(), (ClassLoader)this._iconRef.getClassLoader());
        }
        return this._icon;
    }

    public boolean isConnectionRequired() {
        return this._connRequired;
    }

    public float getWeight() {
        return this._weight;
    }

    public boolean isScript() {
        return ModelUtil.hasLength((String)this._script);
    }

    public boolean isSqlDevOnly() {
        return this._sqldevOnly;
    }

    public String getScript() {
        return this._script;
    }

    public String getScriptLanguage() {
        if (this._scriptLang == null) {
            this._scriptLang = "js";
        }
        return this._scriptLang;
    }

    public void setToolbar(boolean bl) {
        this._toolbar = bl;
    }

    public boolean isToolbar() {
        return this._toolbar;
    }

    public boolean isRenameAction() {
        return this._isRenameAction;
    }

    public void setIsRenameAction(boolean bl) {
        this._isRenameAction = bl;
    }
}

