/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectActionPrompt {
    private String _prompt;
    private String _value;
    private String _reload;
    private String _default;
    private String _type;
    private String _datatype;
    private String _typeAttrib;
    private String _required;
    private String _validator;
    private boolean _readOnly;

    private ObjectActionPrompt(Node node, XLIFFHelper xLIFFHelper) {
        if (node.getNodeName().equalsIgnoreCase("prompt")) {
            this._prompt = XMLHelper.getNodeValue((Node)node, (String)"label");
            this._value = XMLHelper.getNodeValue((Node)node, (String)"value");
            this._default = XMLHelper.getNodeValue((Node)node, (String)"default");
            this._type = XMLHelper.getAttributeNode((Node)node, (String)"type");
            this._required = XMLHelper.getAttributeNode((Node)node, (String)"required");
            this._readOnly = Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)node, (String)"readonly"));
            this._validator = XMLHelper.getAttributeNode((Node)node, (String)"validator");
            this._reload = XMLHelper.getAttributeNode((Node)node, (String)"reload");
            this._datatype = XMLHelper.getAttributeNode((Node)node, (String)"datatype");
            this._typeAttrib = XMLHelper.getAttributeNode((Node)node, (String)"type_attrib");
            if (xLIFFHelper != null) {
                this._prompt = xLIFFHelper.getTranslation(this._prompt);
            }
        }
    }

    public String getPrompt() {
        return this._prompt == null ? "" : this._prompt;
    }

    public void setPrompt(String string) {
        this._prompt = string;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public String getReload() {
        return this._reload;
    }

    public String getDataType() {
        return this._datatype;
    }

    public String getTypeAttribute() {
        return this._typeAttrib;
    }

    public void setreload(String string) {
        this._reload = string;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String string) {
        this._default = string;
    }

    public String getType() {
        return this._type == null ? "" : this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setValidator(String string) {
        this._validator = string;
    }

    public String getValidator() {
        return this._validator;
    }

    public void setRequired(String string) {
        this._required = string;
    }

    public void setDataType(String string) {
        this._datatype = string;
    }

    public void setTypeAttribute(String string) {
        this._typeAttrib = string;
    }

    public boolean isRequired() {
        return this._required != null && this._required.equalsIgnoreCase("true");
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public static List<ObjectActionPrompt> getPrompts(Node node, XLIFFHelper xLIFFHelper) {
        ArrayList<ObjectActionPrompt> arrayList = new ArrayList<ObjectActionPrompt>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("prompt")) continue;
            arrayList.add(new ObjectActionPrompt(node2, xLIFFHelper));
        }
        return arrayList;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<prompt type=\"" + this._type + "\" ");
        if (this._reload != null) {
            stringBuffer.append("reload=\"" + this._reload + "\" ");
        }
        if (this._required != null) {
            stringBuffer.append("required=\"" + this._required + "\" ");
        }
        if (this._validator != null) {
            stringBuffer.append("validator=\"" + this._validator + "\" ");
        }
        stringBuffer.append(">");
        stringBuffer.append("\t<label>" + this._prompt + "</label>");
        if (this._default != null) {
            stringBuffer.append("\t<default><![CDATA[" + this._default + "]]></default>");
        }
        if (this._value != null) {
            stringBuffer.append("\t<value><![CDATA[" + this._value + "]]></value>   ");
        }
        stringBuffer.append("\t</prompt>");
    }

    public boolean isReloadable() {
        return this._reload != null;
    }
}

