/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnPanel;
import oracle.dbtools.raptor.data.ui.ColumnShuttlePanel;
import oracle.dbtools.raptor.data.ui.DataPreviewPanel;
import oracle.dbtools.raptor.data.ui.DataSummaryPage;
import oracle.dbtools.raptor.data.ui.ExternalOptions;
import oracle.dbtools.raptor.data.ui.ImportMethodPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class DataWizard
extends AbstractMenuAction {
    private static DataWizard m_instance = null;
    private static URL m_lastURL = null;
    public static final String DATA_WIZARD_NAME = "raptor.dataWizard";
    public static final int DATA_WIZARD_ACTION = Ide.findOrCreateCmdID((String)"raptor.dataWizard");
    public static final String HELP_DATA_PREVIEW = "f1_importdatadatapreview_html";
    public static final String HELP_LOAD_METHOD = "f1_importloadmethod_html";
    public static final String HELP_FILE = "f1_helpdatawizardfile_html";
    public static final String HELP_CHOOSE_COLUMNS = "f1_importdatachoosecolumns_html";
    public static final String HELP_DEFINE_COLUMNS = "f1_importdatadefinecolumns_html";
    public static final String HELP_SUMMARY = "f1_importdatasummary_html";
    public static final String DIRPATH = "DIRPATH";
    public static final String ORACLEDIRNAME = "ORACLEDIRNAME";
    public static final String BADDIRNAME = "ORACLEBADDIRNAME";
    public static final String LOGDIRNAME = "ORACLELOGDIRNAME";
    public static final String DISCARDDIRNAME = "ORACLEDISCARDDIRNAME";
    public static final String GENDIR = "GENDIR";
    public static final String USEGENDIR = "USEGENDIR";
    public static final String USEBADFILE = "USEBADFILE";
    public static final String USELOGFILE = "USELOGFILE";
    public static final String USEDISCARDFILE = "USEDISCARDFILE";
    public static final String FILENAME = "FILENAME";
    public static final String FILENAMECANONICAL = "FILENAMECANONICAL";
    public static final String TYPE = "IMPORT_TYPE";
    public static final String DATA_COLUMNS = "DATA_COLUMNS";
    public static final String SELECTED_COLUMNS = "SELECTED_COLUMNS";
    public static final String SELECTABLE_COLUMNS = "SELECTABLE_COLUMNS";
    public static final String SEND_TO_WORKSHEET = "SEND_TO_WORKSHEET";
    public static final String LOAD_METHOD = "LOAD_METHOD";
    public static final String OBJECT_NAME = "OBJECT_NAME";
    public static final String OBJECT_TYPE = "OBJECT_TYPE";
    public static final String CONNECTION = "CONNECTION";
    public static final String DBOBJECT = "DBOBJECT";
    public static final String REJECTED_RECORD_FILENAME = "REJECTED_RECORD_FILENAME";
    public static final String DATA_POPULATED_COLUMNS = "DATA_POPULATED_COLUMNS";
    public static final String INSERTABLE_COLUMNS = "INSERTABLE_COLUMNS";
    public static final String INSERT_INTO_EXISTING_TABLE = "INSERT_INTO_EXISTING_TABLE";
    public static final String TABLE = "TABLE";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String STAGING_TABLE_NAME = "STAGING_TABLE_NAME";
    public static final String VALIDATED = "VALIDATED";
    public static final String USE_EXISTING_COLUMN_MAP = "USE_EXISTING_COLUMN_MAP";
    public static final String MAPPING_FILE = "MAPPING_FILE";
    public static final String LOCALE = "LOCALE";
    public static final String PAGEID = "PAGEID";
    public static final String CHARNUMCHARACTERS = "CHARNUMCHARACTERS";
    public static final String FILEOUTNEWLINE = "FILEOUTNEWLINE";
    public static final String FILEINNEWLINE = "FILEINNEWLINE";
    public static final String CHARSETVAL = "CHARSETVAL";
    public static final String NLSVAL = "NLSVAL";
    public static final String FIELDSEPARATOR = "FIELDSEPARATOR";
    public static final String DATA_FORMAT = "DATA_FORMAT";
    public static final String PREVIEW_LIMIT = "PREVIEW_LIMIT";
    public static final String DROP_STAGING_TABLE = "DROP_STAGING_TABLE";
    public static final String LOAD_LIMIT = "LOAD_LIMIT";
    public static final String COMMIT_ROWS_INTERVAL = "COMMMIT_ROWS_INTERVAL";
    public static final String ERROR_ROWS_LIMIT = "ERROR_ROWS_LIMIT";
    public static final String OBJECTACTION = "OBJECTACTION";
    public static final String DEFAULT_STAGING_SUFFIX = DataImportArb.getString("METHOD_STAGING_SUFFIX");
    private Namespace initialData;
    private WizardDialog wiz;
    private DBObject dbo;
    private String filename;

    private FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DataImportArb.getString("WIZARD_PREVIEW_DATA"), DataPreviewPanel.class, HELP_DATA_PREVIEW);
        Step step2 = new Step(DataImportArb.getString("WIZARD_LOAD_METHOD"), ImportMethodPanel.class, HELP_LOAD_METHOD);
        Step step3 = new Step(DataImportArb.getString("WIZARD_CHOOSE_COLUMNS"), ColumnShuttlePanel.class, HELP_CHOOSE_COLUMNS);
        Step step4 = new Step(DataImportArb.getString("WIZARD_DEFINE_COLUMNS"), ColumnPanel.class, HELP_DEFINE_COLUMNS);
        Step step5 = new Step(Messages.getString("DataWizard.0"), ExternalOptions.class, "f1_importoptions_html");
        Step step6 = new Step(Messages.getString("DataWizard.1"), DataSummaryPage.class, HELP_SUMMARY);
        String string = step2.getTraversableClass().getSimpleName();
        String string2 = step3.getTraversableClass().getSimpleName();
        String string3 = step4.getTraversableClass().getSimpleName();
        String string4 = step5.getTraversableClass().getSimpleName();
        String string5 = step6.getTraversableClass().getSimpleName();
        fSMBuilder.newStartState(step, (Object)string2);
        fSMBuilder.setDefaultTrans((Object)string);
        fSMBuilder.addStateTrans((Object)true, (Object)string2);
        fSMBuilder.addStateTrans((Object)false, (Object)string);
        fSMBuilder.newState((Object)string, step2, (Object)string2);
        fSMBuilder.addStateTrans((Object)true, (Object)string3);
        fSMBuilder.addStateTrans((Object)false, (Object)string2);
        fSMBuilder.newState((Object)string2, step3, (Object)string3);
        fSMBuilder.newState((Object)string3, step4, (Object)string5);
        fSMBuilder.addStateTrans((Object)true, (Object)string5);
        fSMBuilder.addStateTrans((Object)false, (Object)string4);
        fSMBuilder.newState((Object)string4, step5, (Object)string5);
        fSMBuilder.addStateTrans((Object)false, (Object)string5);
        fSMBuilder.newFinalState((Object)string5, step6);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public static DataWizard getInstance() {
        if (m_instance == null) {
            m_instance = new DataWizard();
        }
        return m_instance;
    }

    public static void main(String[] stringArray) {
        DataWizard dataWizard = new DataWizard();
        dataWizard.launch();
    }

    public WizardDialog getWizard() {
        FSM fSM = this.getFSM();
        this.initialData = new Namespace();
        this.initialData.put(FILENAME, (Object)this.filename);
        this.initialData.put(DBOBJECT, (Object)this.dbo);
        this.initialData.put(CONNECTION, (Object)this.dbo.getConnectionName());
        this.initialData.put(OBJECTACTION, (Object)this.getObjectAction());
        this.setBlockOACRefresh(true);
        FSMWizard fSMWizard = new FSMWizard(fSM, this.initialData);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        bigWizardDialog.setPreferredSize(new Dimension(900, 600));
        fSMWizard.setWizardTitle(DataImportArb.getString("WIZARD_DATA_IMPORT_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DataImportArb.getImage("WIZARD_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DATA_WIZARD_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    @Override
    public void setArgs(String string) {
    }

    @Override
    public void launch() {
        ColumnMapMediator.getInstance().clearMap();
        this.dbo = this.getDBObject();
        this.filename = this.getFileName();
        if (this.filename == null) {
            return;
        }
        if ("".equals(this.filename)) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)DataImportArb.getString("WIZARD_NO_FILE_CHOSEN"), (String)DataImportArb.getString("WIZARD_DATA_IMPORT_TITLE"), null);
        } else if (DataReaderRegistry.isTypeRegistered(this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1))) {
            this.wiz = this.getWizard();
            WizardLauncher.runDialog((JDialog)this.wiz);
        } else {
            String string = DataImportArb.getString("WIZARD_NO_READER_AVAILABLE");
            string = MessageFormat.format(string, this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1));
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString("WIZARD_DATA_IMPORT_TITLE"), null);
        }
    }

    private String getFileName() {
        String string = null;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        String string2 = DBConfig.getInstance().getString("IMPORTDIR");
        if (string2 == null || string2.length() == 0) {
            string2 = DBConfig.getInstance().getString("EXPORTDIR");
        }
        File file = null;
        try {
            File file2;
            file = string2 == null || string2.equals("") ? (NonUserConfigOptions.get("DEFAULT_EXPORT") == null || NonUserConfigOptions.get("DEFAULT_EXPORT").equals("") ? new File(System.getProperty("user.home")) : new File(NonUserConfigOptions.get("DEFAULT_EXPORT"))) : new File(string2);
            m_lastURL = file.toURI().toURL();
            uRLFileChooser.setCurrentDirectory(file);
            uRLFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    boolean bl = false;
                    if (file != null) {
                        int n;
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = file.getName();
                        String string2 = null;
                        if (string != null && string.trim().length() > 0 && (n = string.lastIndexOf(46)) >= 0) {
                            string2 = string.substring(n + 1);
                        }
                        bl = "csv".equalsIgnoreCase(string2) || "xls".equalsIgnoreCase(string2) || "xlsx".equalsIgnoreCase(string2) || "tsv".equalsIgnoreCase(string2) || "dsv".equalsIgnoreCase(string2);
                    }
                    return bl;
                }

                @Override
                public String getDescription() {
                    String string = DataImportArb.getString("FILTER_DESCRIPTION");
                    return string;
                }
            });
            int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
            if (n == 0 && (file2 = uRLFileChooser.getSelectedFile()).isFile() && file2.exists()) {
                m_lastURL = file2.toURI().toURL();
                string = file2.toURI().getPath();
                NonUserConfigOptions.put("DEFAULT_EXPORT", m_lastURL.getPath());
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public static class DataController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                DataWizard.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

