/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.util.List;
import oracle.dbtools.raptor.data.core.Baseable;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.Table;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class GenericTable
implements Baseable {
    private Table table;

    public GenericTable(Relation relation) {
        this.populateTable(relation);
    }

    public GenericTable(Table table) {
        this.table = table;
    }

    public GenericTable() {
        this.table = new Table();
    }

    private void populateTable(Relation relation) {
        try {
            Table table = new Table();
            table.setTablename(relation.getName());
            oracle.javatools.db.Column[] columnArray = relation.getColumns();
            DataTypeUsage dataTypeUsage = null;
            for (int i = 0; i < columnArray.length; ++i) {
                Column column = new Column();
                column.setName(columnArray[i].getName());
                dataTypeUsage = columnArray[i].getDataTypeUsage();
                if (dataTypeUsage.getAttributeValue("time_zone") != null) {
                    column.setType(DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage).toString() + " WITH " + dataTypeUsage.getAttributeValue("time_zone"));
                } else {
                    column.setType(DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage).toString());
                }
                column.setNullable(!columnArray[i].isNotNull());
                column.setComment((String)columnArray[i].getProperty("Comment"));
                Object object = dataTypeUsage.getAttributeValue("precision");
                if (object != null) {
                    column.setPrecision(Integer.parseInt(object.toString()));
                } else {
                    object = dataTypeUsage.getAttributeValue("size");
                    if (object != null) {
                        column.setPrecision(Integer.parseInt(object.toString()));
                    }
                }
                object = dataTypeUsage.getAttributeValue("scale");
                if (object != null) {
                    column.setScale(Integer.parseInt(object.toString()));
                }
                table.addColumn(column);
                this.table = table;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void addColumn(Column column) {
        this.table.addColumn(column);
    }

    @Override
    public Column getColumn(int n) {
        return this.getColumns()[n];
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns().toArray(new Column[this.table.getColumns().size()]);
    }

    @Override
    public String getDataType(Column column) {
        return column.getType();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setColumns(Column[] columnArray) {
        List<Column> list = this.table.getColumns();
        if (list != null) {
            list.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                list.add(columnArray[i]);
            }
            this.table.setColumns(list.toArray(new Column[list.size()]));
        }
    }

    @Override
    public void setTableName(String string) {
        this.table.setTablename(string);
    }
}

