/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.readers.IImportFormatOptions;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.ide.panels.TraversableContext;

public class ImportDataFormat
extends BaseDataFormat {
    public static int HEADER_AFTER_SKIP = 0;
    public static int HEADER_BEFORE_SKIP = 1;
    public static int METHOD_INSERT_EXEC = 0;
    public static int METHOD_INSERT_SCRIPT = 1;
    public static int METHOD_EXTERNAL_TABLE = 2;
    public static int METHOD_STAGING_EXTERNAL_TABLE = 3;
    public static int METHOD_SQLLDR = 4;
    public static String METHOD_INSERT_EXEC_NAME = DataImportArb.getString("METHOD_INSERT_EXEC");
    public static String METHOD_INSERT_SCRIPT_NAME = DataImportArb.getString("METHOD_INSERT_SCRIPT");
    public static String METHOD_EXTERNAL_TABLE_NAME = DataImportArb.getString("METHOD_EXTERNAL_TABLE");
    public static String METHOD_STAGING_EXTERNAL_TABLE_NAME = DataImportArb.getString("METHOD_STAGING_EXTERNAL_TABLE");
    public static String METHOD_SQLLDR_NAME = DataImportArb.getString("METHOD_SQLLDR");
    public static String[] NEW_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_EXTERNAL_TABLE_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
    public static String[] EXISTING_METHODS = new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME, METHOD_STAGING_EXTERNAL_TABLE_NAME, METHOD_SQLLDR_NAME};
    private static String[] IMPORT_FORMATS_DELIMITED = new String[]{DELIMITED, CSV, TEXT};
    private static String[] IMPORT_FORMATS_EXCEL = new String[]{EXCEL, EXCELX};
    private boolean _usePreviewLimit;
    private int _previewLimit;
    private boolean _useLoadLimit;
    private int _loadLimit;
    private int _skipRows;
    private boolean _useMaxLength;
    private int _maxLength;
    private String _worksheet;
    private int _pageId = 0;

    public ImportDataFormat(int n, String string) {
        super(n, string);
    }

    @Override
    public void setFormat(String string) {
        super.setFormat(string);
        this.initConfigFormatOptions();
    }

    public String getWorksneet() {
        return this._worksheet;
    }

    public void setWorksheet(String string) {
        this._worksheet = string;
    }

    public int getPageId() {
        return this._pageId;
    }

    public void setPageId(int n) {
        this._pageId = n;
    }

    public boolean getUsePreviewLimit() {
        return this._usePreviewLimit;
    }

    public void setUsePreviewLimit(boolean bl) {
        this._usePreviewLimit = bl;
    }

    public int getPreviewLimit() {
        return this._previewLimit;
    }

    public void setPreviewLimit(int n) {
        this._previewLimit = n;
    }

    public boolean getUseLoadLimit() {
        return this._useLoadLimit;
    }

    public void setUseLoadLimit(boolean bl) {
        this._useLoadLimit = bl;
    }

    public int getLoadLimit() {
        return this._loadLimit;
    }

    public void setLoadLimit(int n) {
        this._loadLimit = n;
    }

    public boolean getUseMaxLength() {
        return this._useMaxLength;
    }

    public void setUseMaxLength(boolean bl) {
        this._useMaxLength = bl;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int n) {
        this._maxLength = n;
    }

    public int getPreviewCharactersLimit() {
        return this._maxLength;
    }

    public void setPreviewCharactersLimit(int n) {
        this._maxLength = n;
    }

    public boolean isHeaderLocationSupported() {
        return ((IImportFormatOptions)this._options).isHeaderLocationSupported();
    }

    public String[] getHeaderLocations() {
        String[] stringArray = new String[]{DataToolsArb.getString("AFTER"), DataToolsArb.getString("BEFORE")};
        return stringArray;
    }

    public int getHeaderLocation() {
        return ((IImportFormatOptions)this._options).getHeaderLocation();
    }

    public boolean isHeaderAfter() {
        return ((IImportFormatOptions)this._options).getHeaderLocation() == HEADER_AFTER_SKIP;
    }

    public void isHeaderAfter(boolean bl) {
        ((IImportFormatOptions)this._options).setHeaderLocation(bl ? HEADER_AFTER_SKIP : HEADER_BEFORE_SKIP);
    }

    public void setHeaderLocation(int n) {
        ((IImportFormatOptions)this._options).setHeaderLocation(n);
    }

    public int getSkipRows() {
        return this._skipRows;
    }

    public void setSkipRows(int n) {
        this._skipRows = n;
    }

    @Override
    public String[] getFormats() {
        if (this.isExcel() || this.isExcelX()) {
            return IMPORT_FORMATS_EXCEL;
        }
        return IMPORT_FORMATS_DELIMITED;
    }

    public static int getLoadMethodType(String string) {
        if (string.equals(METHOD_INSERT_EXEC_NAME)) {
            return METHOD_INSERT_EXEC;
        }
        if (string.equals(METHOD_INSERT_SCRIPT_NAME)) {
            return METHOD_INSERT_SCRIPT;
        }
        if (string.equals(METHOD_EXTERNAL_TABLE_NAME)) {
            return METHOD_EXTERNAL_TABLE;
        }
        if (string.equals(METHOD_STAGING_EXTERNAL_TABLE_NAME)) {
            return METHOD_STAGING_EXTERNAL_TABLE;
        }
        return METHOD_SQLLDR;
    }

    public static String getLoadMethodName(int n) {
        if (n == METHOD_INSERT_EXEC) {
            return METHOD_INSERT_EXEC_NAME;
        }
        if (n == METHOD_INSERT_SCRIPT) {
            return METHOD_INSERT_SCRIPT_NAME;
        }
        if (n == METHOD_EXTERNAL_TABLE) {
            return METHOD_EXTERNAL_TABLE_NAME;
        }
        if (n == METHOD_STAGING_EXTERNAL_TABLE) {
            return METHOD_STAGING_EXTERNAL_TABLE_NAME;
        }
        return METHOD_SQLLDR_NAME;
    }

    public static int getDefaultNewLoadMethod(boolean bl) {
        String[] stringArray;
        int n = DBConfig.getInstance().getInt("IMPORT_NEW_MODE");
        String string = ImportDataFormat.getLoadMethodName(n);
        for (String string2 : stringArray = ImportDataFormat.getNewLoadMethods(bl)) {
            if (!string2.equals(string)) continue;
            return n;
        }
        return METHOD_INSERT_EXEC;
    }

    public static int getDefaultExistingLoadMethod(boolean bl) {
        String[] stringArray;
        int n = DBConfig.getInstance().getInt("IMPORT_EXISTING_MODE");
        String string = ImportDataFormat.getLoadMethodName(n);
        for (String string2 : stringArray = ImportDataFormat.getNewLoadMethods(bl)) {
            if (!string2.equals(string)) continue;
            return n;
        }
        return METHOD_INSERT_EXEC;
    }

    public static String[] getNewLoadMethods(boolean bl) {
        if (bl) {
            return NEW_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    public static String[] getExistingLoadMethods(boolean bl) {
        if (bl) {
            return EXISTING_METHODS;
        }
        return new String[]{METHOD_INSERT_EXEC_NAME, METHOD_INSERT_SCRIPT_NAME};
    }

    @Override
    protected void initFormat() {
        this.initConfigOptions();
    }

    @Override
    protected void initConfigOptions() {
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            this._encoding = dBConfig.getString("IMP_ENCODING");
            Boolean bl = dBConfig.getBoolean("IMPORT_USE_PREVIEW_LIMIT");
            this._usePreviewLimit = bl;
            this._previewLimit = dBConfig.getInt("IMPORT_PREVIEW_LIMIT");
            bl = dBConfig.getBoolean("IMPORT_USE_LOAD_LIMIT");
            this._useLoadLimit = bl;
            this._loadLimit = dBConfig.getInt("IMPORT_LOAD_LIMIT");
            this._maxLength = dBConfig.getInt("IMPORT_MAX_LENGTH");
            bl = dBConfig.getBoolean("IMPORT_USE_MAX_LENGTH");
            this._useMaxLength = bl;
        }
        super.initConfigOptions();
    }

    protected void initConfigFormatOptions() {
        super.initConfigOptions();
    }

    @Override
    public void saveBasicPreferences(TraversableContext traversableContext) {
    }

    @Override
    public void saveFormatPreferences(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        if (this._usage == BaseDataFormat.IMPORT_WIZARD) {
            dBConfig.putString("IMP_ENCODING", this._encoding);
            dBConfig.putBoolean("IMPORT_USE_PREVIEW_LIMIT", this._usePreviewLimit);
            dBConfig.putInt("IMPORT_PREVIEW_LIMIT", this._previewLimit);
            dBConfig.putBoolean("IMPORT_USE_LOAD_LIMIT", this._useLoadLimit);
            dBConfig.putInt("IMPORT_LOAD_LIMIT", this._loadLimit);
            dBConfig.putInt("IMPORT_MAX_LENGTH", this._maxLength);
            dBConfig.putBoolean("IMPORT_USE_MAX_LENGTH", this._useMaxLength);
        }
        super.saveFormatPreferences(traversableContext);
    }
}

