/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.data.core.Column;

public class Table {
    private List<Column> columns = new ArrayList<Column>();
    private String tablename;

    public void addColumn(Column column) {
        if (column != null) {
            this.columns.add(column);
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    private void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setColumns(Column[] columnArray) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < columnArray.length; ++i) {
            if (columnArray[i] == null) continue;
            arrayList.add(columnArray[i]);
        }
        this.setColumns(arrayList);
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String string) {
        this.tablename = string;
    }

    public Column getColumnByName(String string) {
        for (Column column : this.columns) {
            if (!string.trim().equals(column.getName().trim())) continue;
            return column;
        }
        return null;
    }

    public Column getFirstColumn() {
        Iterator<Column> iterator = this.columns.iterator();
        if (iterator.hasNext()) {
            Column column = iterator.next();
            return column;
        }
        return null;
    }

    public Column getSrcColName(String string) {
        for (Column column : this.columns) {
            if (!string.equals(column.getSourceColumnName())) continue;
            return column;
        }
        return null;
    }

    public void updateColumn(Column column) {
        for (Column column2 : this.columns) {
            if (!column.getName().equals(column2.getName())) continue;
            column2.setType(column.getType());
            column2.setNullable(column.isNullable());
            column2.setComment(column.getComment());
            column2.setScale(column.getScale());
            column2.setPrecision(column.getPrecision());
            column2.setDefault(column.getDefault());
        }
    }
}

