/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.ui.SourceColumnRenderer;

public class ColumnListPanel
extends JPanel {
    private static final long serialVersionUID = -10394687240089213L;
    private DefaultListModel mdlColumns = new DefaultListModel();
    private JList lstColumns = new JList(this.mdlColumns);
    private JScrollPane scrColumns = new JScrollPane();

    public ColumnListPanel() {
        super(new BorderLayout());
        this.scrColumns.setVerticalScrollBarPolicy(22);
        this.lstColumns.setCellRenderer(new SourceColumnRenderer());
        this.scrColumns.getViewport().add((Component)this.lstColumns, null);
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString("DATA_MAPPING_SRC_COLUMNS")));
        this.add((Component)this.scrColumns, "Center");
    }

    public Column getCurrentSelection() {
        return (Column)this.lstColumns.getSelectedValue();
    }

    void setCurrentSelection(int n) {
        int n2 = this.lstColumns.getModel().getSize();
        if (n >= 0) {
            this.lstColumns.setSelectedIndex(n % (n2 + 1));
        }
    }

    public void addColumn(Column column) {
        this.mdlColumns.add(0, column);
    }

    public void addColumn(int n, Column column) {
        this.mdlColumns.add(n, column);
    }

    public void addColumns(Column[] columnArray) {
        for (int i = 0; i < columnArray.length; ++i) {
            this.addColumn(i, columnArray[i]);
        }
    }

    public Column[] getColumns() {
        Column[] columnArray = new Column[this.mdlColumns.size()];
        this.mdlColumns.copyInto(new Column[this.mdlColumns.size()]);
        return columnArray;
    }

    public JList getLstColumns() {
        return this.lstColumns;
    }
}

