/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.ui.ColumnListPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.dbtools.raptor.data.ui.KnownColumnPropertiesPanel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Relation;

public class ColumnPanel
extends DefaultTraversablePanel
implements ColumnChangeListener {
    private static final long serialVersionUID = 8282169188783793125L;
    private GenericTable genericTable;
    private JTextPane instructions;
    private JPanel matchPanel;
    private ColumnListPanel clp;
    private boolean insertToExistingTable;
    private ColumnPropertyPanel colPropPanel;
    private GridBagConstraints cppConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private Column column;
    private TraversableContext m_ctx;
    private boolean isHeader;
    private boolean matchByInit = false;
    private int matchByType;
    private static int matchByName = 0;
    private static int matchByPosition = 1;
    private int _loadMethod;

    public ColumnPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 7, 7, 0};
        this.setLayout(gridBagLayout);
        this.instructions = new JTextPane();
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setRequestFocusEnabled(false);
        this.instructions.setFocusable(false);
        this.add(this.instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.matchPanel = new JPanel(new GridBagLayout());
        this.add(this.matchPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.clp = new ColumnListPanel();
        this.clp.getLstColumns().setSelectionModel(new SingleSelectionModel(){

            @Override
            public void updateSingleSelection(int n, int n2) {
                if (n >= 0) {
                    Column column = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n);
                    if (ColumnPanel.this.colPropPanel != null && column != null) {
                        column.refreshData(ColumnPanel.this.colPropPanel.getColumnDetails());
                        if (ColumnPanel.this.colPropPanel != null) {
                            Column column2 = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n2);
                            ColumnPanel.this.colPropPanel.setColumn(column2);
                        }
                    }
                }
            }
        });
        this.add(this.clp, new GridBagConstraints(0, 2, 1, 1, 13.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        Object object;
        this.m_ctx = traversableContext;
        this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        int n = (Integer)this.m_ctx.get("LOAD_METHOD");
        this.insertToExistingTable = (Boolean)traversableContext.get("INSERT_INTO_EXISTING_TABLE");
        this.populateDBO(traversableContext);
        this.populateSrcDataColumns(traversableContext);
        this.setupColumnDetails(traversableContext);
        if (this.insertToExistingTable) {
            object = (ImportDataFormat)this.m_ctx.get("DATA_FORMAT");
            if (!this.matchByInit) {
                JLabel jLabel = new JLabel();
                jLabel.setText(DataImportArb.getString("MATCH_BY_LABEL"));
                this.matchPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                String[] stringArray = new String[]{DataImportArb.getString("MATCH_BY_NAME"), DataImportArb.getString("MATCH_BY_POSITION"), DataImportArb.getString("MATCH_BY_NONE")};
                JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ColumnPanel.this.matchByType = ((JComboBox)actionEvent.getSource()).getSelectedIndex();
                        ColumnPanel.this.refreshColumnData();
                    }
                });
                this.isHeader = ((BaseDataFormat)object).isHeader();
                if (this.isHeader) {
                    jComboBox.setSelectedIndex(0);
                } else {
                    jComboBox.setSelectedItem(DataImportArb.getString("MATCH_BY_POSITION"));
                }
                this.matchPanel.add(jComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            } else if (this.isHeader != ((BaseDataFormat)object).isHeader()) {
                this.isHeader = ((BaseDataFormat)object).isHeader();
                this.refreshColumnData();
            }
            this.matchByInit = true;
        }
        this.column = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
        object = new Column();
        ((Column)object).refreshData(this.column);
        this.colPropPanel.setColumn((Column)object);
        if (Boolean.valueOf(n == ImportDataFormat.METHOD_EXTERNAL_TABLE || n == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE || n == ImportDataFormat.METHOD_SQLLDR).booleanValue()) {
            traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        } else {
            traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
        }
    }

    private void refreshColumnData() {
        Column column;
        this.clp.setCurrentSelection(0);
        for (int i = 0; i < this.clp.getLstColumns().getModel().getSize(); ++i) {
            column = (Column)this.clp.getLstColumns().getModel().getElementAt(i);
            Column column2 = null;
            if (this.matchByType == matchByName) {
                column2 = this.genericTable.getTable().getFirstColumn();
                for (Column column3 : this.genericTable.getTable().getColumns()) {
                    if (!column3.getName().equalsIgnoreCase(column.getDefaultName().trim())) continue;
                    column2 = column3;
                    break;
                }
            } else if (this.matchByType == matchByPosition) {
                try {
                    column2 = this.genericTable.getTable().getColumns().get(i);
                }
                catch (Exception exception) {
                    column2 = this.genericTable.getTable().getFirstColumn();
                }
            } else {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            if (this.insertToExistingTable && column2 == null) {
                column2 = this.genericTable.getTable().getFirstColumn();
            }
            column.refreshData(column2);
        }
        if (this.colPropPanel != null) {
            Column column4 = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
            column = new Column();
            column.refreshData(column4);
            this.colPropPanel.setColumn(column);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
    }

    private void setupColumnDetails(TraversableContext traversableContext) {
        if (this.colPropPanel != null) {
            this.remove(this.colPropPanel);
        }
        if (this.insertToExistingTable) {
            KnownColumnPropertiesPanel knownColumnPropertiesPanel = new KnownColumnPropertiesPanel();
            knownColumnPropertiesPanel.setTable((Relation)((DBObject)traversableContext.get("DBOBJECT")).getSchemaObject());
            this.colPropPanel = knownColumnPropertiesPanel;
            this.add(knownColumnPropertiesPanel, this.cppConstraints);
            knownColumnPropertiesPanel.addColumnChangeListener(this);
        } else {
            ColumnPropertiesPanel columnPropertiesPanel = new ColumnPropertiesPanel();
            this.colPropPanel = columnPropertiesPanel;
            columnPropertiesPanel.setTable(this.genericTable);
            this.add(columnPropertiesPanel, this.cppConstraints);
            if (this._loadMethod == ImportDataFormat.METHOD_EXTERNAL_TABLE || this._loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
                columnPropertiesPanel.enableComment(false);
            } else {
                columnPropertiesPanel.enableComment(true);
            }
            columnPropertiesPanel.addColumnChangeListener(this);
        }
        this.validate();
    }

    private void populateSrcDataColumns(TraversableContext traversableContext) {
        ((DefaultListModel)this.clp.getLstColumns().getModel()).clear();
        Column[] columnArray = (Column[])traversableContext.get("SELECTED_COLUMNS");
        for (int i = columnArray.length - 1; i >= 0; --i) {
            this.clp.addColumn(columnArray[i]);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
    }

    public Object getExitTransition() {
        int n = (Integer)this.m_ctx.get("LOAD_METHOD");
        return n != ImportDataFormat.METHOD_EXTERNAL_TABLE && n != ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE && n != ImportDataFormat.METHOD_SQLLDR;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && !this.insertToExistingTable) {
            this.ensureSelectedColumnsHaveMapping(traversableContext);
        }
        Column column = (Column)this.clp.getLstColumns().getSelectedValue();
        column.refreshData(this.colPropPanel.getColumnDetails());
        this.genericTable.setColumns((Column[])traversableContext.get("SELECTED_COLUMNS"));
        traversableContext.put("TABLE", (Object)this.genericTable);
        if (traversableContext.getDirection() == 1 && !this.insertToExistingTable) {
            this.validateColumnNames(traversableContext);
        }
    }

    private void validateColumnNames(TraversableContext traversableContext) throws TraversalException {
        Column[] columnArray = this.genericTable.getColumns();
        int n = 0;
        String string = "";
        String string2 = " ";
        DBObject dBObject = (DBObject)this.m_ctx.get("DBOBJECT");
        Database database = dBObject.getDatabase();
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = columnArray[i].getName();
                try {
                    database.validateName("COLUMN", string3);
                    continue;
                }
                catch (InvalidNameException invalidNameException) {
                    string = string + string2 + string3;
                    if (string2.equals(" ")) {
                        this.clp.setCurrentSelection(i);
                    }
                    string2 = ",";
                }
            }
        }
        if (string.length() != 0) {
            throw new TraversalException(DataImportArb.format("COLUMN_NAMES_INVALID_ERROR", string));
        }
    }

    private void ensureSelectedColumnsHaveMapping(TraversableContext traversableContext) {
        Column[] columnArray = (Column[])traversableContext.get("SELECTED_COLUMNS");
        int n = 0;
        if (columnArray != null) {
            n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                if (columnArray[i].getName() != null && columnArray[i].getPrecision() > 0 && columnArray[i].getType() != null) continue;
                this.clp.setCurrentSelection(i);
            }
        }
    }

    private void populateDBO(TraversableContext traversableContext) {
        GenericTable genericTable = null;
        if (traversableContext.get("DBOBJECT") == null) {
            genericTable = new GenericTable();
            genericTable.setTableName((String)traversableContext.get("TABLE_NAME"));
        } else if (((DBObject)traversableContext.get("DBOBJECT")).getObjectName() != null) {
            this.insertToExistingTable = true;
            genericTable = new GenericTable((Relation)((DBObject)traversableContext.get("DBOBJECT")).getSchemaObject());
        } else {
            genericTable = new GenericTable();
            genericTable.setTableName((String)traversableContext.get("TABLE_NAME"));
            ArrayList<Column> arrayList = new ArrayList<Column>();
            ListModel listModel = this.clp.getLstColumns().getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                if (listModel.getElementAt(i) == null) continue;
                arrayList.add((Column)listModel.getElementAt(i));
            }
            genericTable.getTable().setColumns(arrayList.toArray(new Column[arrayList.size()]));
        }
        this.setTable(genericTable);
        this.setInstruction((DBObject)traversableContext.get("DBOBJECT"));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this.instructions.setText(DataImportArb.getString("DATA_MAPPING_EXISTING_INFO"));
            return;
        }
        this.instructions.setText(DataImportArb.getString("DATA_MAPPING_CREATE_INFO"));
    }

    private void setTable(GenericTable genericTable) {
        this.genericTable = genericTable;
    }

    @Override
    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        Column column = columnChangeEvent.getColumn();
        this.column.refreshData(column);
        System.out.println("Panel Properties");
        System.out.println("NAme:" + column.getName());
        System.out.println("src NameNAme:" + column.getSourceColumnName());
    }

    private class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            int n3 = this.getMinSelectionIndex();
            super.setSelectionInterval(n, n2);
            int n4 = this.getMinSelectionIndex();
            if (n3 != n4) {
                this.updateSingleSelection(n3, n4);
            }
        }

        public void updateSingleSelection(int n, int n2) {
        }
    }
}

