/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportPreRequisiteChecker;
import oracle.dbtools.raptor.data.ui.PreReqResultsPanel;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class DataSummaryPage
extends DefaultTraversablePanel {
    protected final String ENCODING = "UTF-8";
    private JLabel verfiyImportParametersLabel;
    private JButton verifyButton;
    private PreReqResultsPanel panel;
    private static final long serialVersionUID = -4806824652842858395L;
    private TraversableContext m_ctx;
    private Component myCreateCodePanel = null;
    private Component myCreateVerticalGlue = null;
    BasicEditorPane summaryPanel = null;
    private int _loadMethod;

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.m_ctx.put("FIELDSEPARATOR", (Object)DBConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getString("IMPORT_DELIMITER"));
        this._loadMethod = (Integer)this.m_ctx.get("LOAD_METHOD");
        if (this._loadMethod == ImportDataFormat.METHOD_EXTERNAL_TABLE || this._loadMethod == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
            if (this.myCreateVerticalGlue != null) {
                this.remove(this.myCreateVerticalGlue);
                this.myCreateVerticalGlue = null;
            }
            if (this.myCreateCodePanel == null) {
                this.myCreateCodePanel = this.createCodePanel();
                this.add(this.myCreateCodePanel, new GridBagConstraints(0, 3, 2, 2, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
        } else {
            if (this.myCreateCodePanel != null) {
                this.remove(this.myCreateCodePanel);
                this.myCreateCodePanel = null;
            }
            if (this.myCreateVerticalGlue == null) {
                this.myCreateCodePanel = Box.createVerticalGlue();
                this.add(this.myCreateCodePanel, new GridBagConstraints(0, 3, 2, 2, 0.5, 0.5, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            }
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            try {
                ImportWriteStream importWriteStream = this.createPrintStream();
                ImportGenerator importGenerator = new ImportGenerator(importWriteStream, traversableContext);
                importGenerator.setUrl(importWriteStream.geturl());
                importGenerator.generate();
            }
            catch (Exception exception) {
                Logger.getLogger(ConnectionDialog.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public DataSummaryPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add(this.getVerfiyImportParametersLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getVerifyButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getPanel().getPanel(), new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component createCodePanel() {
        this.summaryPanel = EditorFactory.createIdeEditorPane();
        this.summaryPanel.setDocument((Document)new BasicDocument("template.plsql"));
        this.summaryPanel.setEditable(false);
        return new JScrollPane((Component)this.summaryPanel);
    }

    private String getSummary() {
        ImportWriteStream importWriteStream = null;
        ImportGenerator importGenerator = null;
        try {
            importWriteStream = this.createPrintStream();
            importGenerator = new ImportGenerator(importWriteStream, this.m_ctx);
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        importGenerator.setUrl(importWriteStream.geturl());
        return importGenerator.getExternalTableText();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected PreReqResultsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new PreReqResultsPanel();
        }
        return this.panel;
    }

    protected JButton getVerifyButton() {
        if (this.verifyButton == null) {
            this.verifyButton = new JButton();
            this.verifyButton.setText(DataImportArb.getString("PREREQ_VERIFY_BUTTON"));
            this.verifyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSummaryPage.this.performTest();
                }
            });
        }
        return this.verifyButton;
    }

    protected JLabel getVerfiyImportParametersLabel() {
        if (this.verfiyImportParametersLabel == null) {
            this.verfiyImportParametersLabel = new JLabel();
            this.verfiyImportParametersLabel.setText(DataImportArb.getString("PREREQ_VERIFY_INFO"));
        }
        return this.verfiyImportParametersLabel;
    }

    private ImportWriteStream createPrintStream() throws IOException, UnsupportedEncodingException {
        String string = Ide.getEnvironOptions().getEncoding();
        String string2 = (String)this.m_ctx.get("FILENAME");
        int n = -1;
        n = string2.lastIndexOf("/");
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        string2 = string2.replace(".", "-");
        ImportWriteStream importWriteStream = new ImportWriteStream(string2, string);
        return importWriteStream;
    }

    private void performTest() {
        ImportPreRequisiteChecker importPreRequisiteChecker = new ImportPreRequisiteChecker(this.m_ctx);
        importPreRequisiteChecker.addListener(this.panel);
        int n = importPreRequisiteChecker.runTests();
        switch (n) {
            case 0: {
                if (this._loadMethod != ImportDataFormat.METHOD_EXTERNAL_TABLE && this._loadMethod != ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) break;
                this.summaryPanel.setEditable(true);
                try {
                    this.summaryPanel.setText(this.getSummary());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.summaryPanel.setEditable(false);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
            }
        }
    }
}

