/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportDiscardFilePanel
extends JPanel {
    private JCheckBox _importFileCheckBox;
    JLabel _importFileLabel;
    private FilePanel _importFilePanel;
    private boolean checkBoxControlled;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportDiscardFilePanel() {
        this(true);
    }

    public ImportDiscardFilePanel(boolean bl) {
        try {
            this.checkBoxControlled = bl;
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initFilePanel();
    }

    public JCheckBox getCheckBox() {
        return this._importFileCheckBox;
    }

    public FilePanel getFilePanel() {
        return this._importFilePanel;
    }

    void initFilePanel() {
        int n = 0;
        this._importFileCheckBox = new JCheckBox();
        this._importFileCheckBox.setSelected(true);
        this._importFileCheckBox.setText(PreferencesArb.getString("IMPORT_USE_DISCARD"));
        if (this.checkBoxControlled) {
            this._importFileCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    ImportDiscardFilePanel.this._importFilePanel.setComponentsEnabled(jCheckBox.isSelected());
                    ImportDiscardFilePanel.this._importFileLabel.setEnabled(jCheckBox.isSelected());
                }
            });
        }
        this._importFileLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_DISCARD_DIR")));
        this._importFileLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_DISCARD_DIR")));
        this._importFilePanel = new FilePanel(this, false);
        this._importFilePanel.setSelectionMode(1);
        this._importFileLabel.setLabelFor(this._importFilePanel);
        this.add((Component)this._importFileCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._importFileLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 18, 0, 8), 0, 0));
        this.add((Component)this._importFilePanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this._importFilePanel.setFileName(dBConfig.getString("IMPORT_LDR_DISCARDGEN_DIR"));
        this._importFileCheckBox.setSelected(dBConfig.getBoolean("IMPORT_LDR_USE_DISCARD"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("IMPORT_LDR_USE_DISCARD", this._importFileCheckBox.isSelected());
        dBConfig.putString("IMPORT_LDR_DISCARDGEN_DIR", this._importFilePanel.getFileName());
    }
}

