/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.DataWizard;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.dbtools.raptor.data.ui.LoadLimitPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Relation;

public class ImportMethodPanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 8282169188783793125L;
    private JTextField _tableNameField;
    private JTextField _stagingTableNameField;
    private JLabel _stagingTableNameLabel;
    private String _stagingTableName;
    private String _stagingSuffix;
    private JCheckBox _dropStagingTable;
    private JCheckBox _sendToWorksheet;
    private GenericTable _table;
    private JTextPane _instructions;
    private JPanel _mainPanel;
    private LoadLimitPanel _loadLimitPanel;
    private boolean _init = false;
    private boolean _isExistingTable;
    private static final String HTMLCONTENT = "text/html";
    private TraversableContext _ctx;
    private int _loadMethodType;
    private JComboBox _loadMethod;
    private DefaultComboBoxModel _loadMethodModel;
    private transient WizardCallbacks _callbacks;

    public ImportMethodPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        DBConfig dBConfig = DBConfig.getInstance();
        this._stagingSuffix = dBConfig.getString("IMPORT_ORA_STAGE_SUFFIX");
        if (this._stagingSuffix == null || this._stagingSuffix.length() == 0) {
            this._stagingSuffix = DataWizard.DEFAULT_STAGING_SUFFIX;
        }
        int n = 0;
        this.setLayout(gridBagLayout);
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        this.add(this._instructions, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        this._mainPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(DataImportArb.getString("METHOD_LABEL"));
        this._loadMethod = new JComboBox();
        jLabel.setLabelFor(this._loadMethod);
        this._mainPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._loadMethod, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ImportMethodPanel.this.changeLoadMethod(ImportDataFormat.getLoadMethodType((String)ImportMethodPanel.this._loadMethodModel.getSelectedItem()));
                }
            }
        };
        this._loadMethod.addItemListener(itemListener);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Table Name");
        jLabel2.setText(DataImportArb.getString("TABLE_NAME_LABEL"));
        this._mainPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 6, 0, 8), 0, 0));
        this._tableNameField = new JTextField();
        this._tableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    ImportMethodPanel.this._table.setTableName(string);
                    ImportMethodPanel.this._table.getTable().setTablename(string);
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    ImportMethodPanel.this._tableNameField.setText("");
                    ImportMethodPanel.this._table.setTableName("");
                    ImportMethodPanel.this._table.getTable().setTablename("");
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    ImportMethodPanel.this._stagingTableName = string.substring(0, string.length() - 2) + ImportMethodPanel.this._stagingSuffix + "\"";
                } else {
                    ImportMethodPanel.this._stagingTableName = string + ImportMethodPanel.this._stagingSuffix;
                }
                ImportMethodPanel.this._stagingTableNameField.setText(ImportMethodPanel.this._stagingTableName);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._tableNameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                String string2 = ImportMethodPanel.this._tableNameField.getText();
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    ImportMethodPanel.this._stagingTableName = string2.substring(0, string2.length() - 2) + ImportMethodPanel.this._stagingSuffix + "\"";
                } else {
                    ImportMethodPanel.this._stagingTableName = string2 + ImportMethodPanel.this._stagingSuffix;
                }
                ImportMethodPanel.this._stagingTableNameField.setText(ImportMethodPanel.this._stagingTableName);
                ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
        this._mainPanel.add((Component)this._tableNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(16, 6, 0, 0), 0, 0));
        this._stagingTableNameLabel = new JLabel();
        this._stagingTableNameLabel.setText(DataImportArb.getString("STAGING_TABLE_NAME_LABEL"));
        this._dropStagingTable = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._dropStagingTable, (String)StringUtils.stripMnemonic((String)DataImportArb.getString("METHOD_DROP_STAGING")));
        this._dropStagingTable.setMnemonic(StringUtils.getMnemonicKeyCode((String)DataImportArb.getString("METHOD_DROP_STAGING")));
        this._dropStagingTable.setToolTipText(DataImportArb.getString("METHOD_DROP_STAGING_TIP"));
        this._stagingTableNameField = new JTextField();
        this._stagingTableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    ImportMethodPanel.this._stagingTableName = ImportMethodPanel.this._stagingTableNameField.getText();
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._stagingTableNameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                ImportMethodPanel.this._stagingTableName = ImportMethodPanel.this._stagingTableNameField.getText();
                ImportMethodPanel.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
        this._mainPanel.add((Component)this._stagingTableNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(28, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._stagingTableNameField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(26, 6, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._dropStagingTable, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 18, 2, new Insets(6, 6, 0, 0), 0, 0));
        this._loadLimitPanel = new LoadLimitPanel(null, true);
        this._loadLimitPanel.onEntry();
        this._mainPanel.add((Component)this._loadLimitPanel.getUseLoadLimitComponent(), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(28, 6, 0, 8), 0, 0));
        this._mainPanel.add((Component)this._loadLimitPanel.getLoadLimitComponent(), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(26, 6, 0, 0), 0, 0));
        this.add(this._mainPanel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(16, 5, 0, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        DataReadable dataReadable = DataReaderRegistry.getReader((String)this._ctx.get("IMPORT_TYPE"));
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (!this._init) {
            this._init = true;
            this.populateDBO(traversableContext);
            this.populateTableName();
            int n = ImportDataFormat.getDefaultNewLoadMethod(dataReadable.isOracleLoaderReadable());
            this._loadMethodModel = null;
            if (this._isExistingTable) {
                this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getExistingLoadMethods(dataReadable.isOracleLoaderReadable()));
                n = ImportDataFormat.getDefaultExistingLoadMethod(dataReadable.isOracleLoaderReadable());
            } else {
                this._loadMethodModel = new DefaultComboBoxModel<String>(ImportDataFormat.getNewLoadMethods(dataReadable.isOracleLoaderReadable()));
                this._sendToWorksheet = new JCheckBox();
                this._sendToWorksheet.setText(DataImportArb.getString("METHOD_SEND_TO_WORKSHEET"));
                this._mainPanel.add((Component)this._sendToWorksheet, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(8, 6, 0, 0), 0, 0));
                this._sendToWorksheet.setSelected(true);
            }
            this._loadMethod.setModel(this._loadMethodModel);
            try {
                this._loadMethodModel.setSelectedItem(ImportDataFormat.getLoadMethodName(n));
            }
            catch (Exception exception) {
                n = ImportDataFormat.METHOD_INSERT_SCRIPT;
                this._loadMethodModel.setSelectedItem(ImportDataFormat.METHOD_INSERT_SCRIPT_NAME);
            }
            this.changeLoadMethod(n);
        }
        this._callbacks = traversableContext.getWizardCallbacks();
        traversableContext.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
    }

    private void populateTableName() {
        String string;
        this._tableNameField.setEnabled(!this._isExistingTable);
        String string2 = string = this._table.getTable().getTablename() == null ? "" : this._table.getTable().getTablename();
        if (!this._isExistingTable) {
            this._tableNameField.setText(string);
        } else {
            this._tableNameField.setText(DBUtil.addDoubleQuote((String)string));
        }
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._stagingTableName == null) {
            this._stagingTableName = string.startsWith("\"") && string.endsWith("\"") ? string.substring(0, string.length() - 2) + this._stagingSuffix + "\"" : string + this._stagingSuffix;
            this._dropStagingTable.setSelected(dBConfig.getBoolean("IMPORT_ORA_STAGE_DROP"));
        }
        this._stagingTableNameField.setText(this._stagingTableName);
        if (this._tableNameField.getText().trim().length() > 0) {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public Object getExitTransition() {
        int n = (Integer)this._ctx.get("LOAD_METHOD");
        return n == ImportDataFormat.METHOD_EXTERNAL_TABLE || n == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE || n == ImportDataFormat.METHOD_SQLLDR;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        DBObject dBObject = (DBObject)this._ctx.get("DBOBJECT");
        if (traversableContext.getDirection() == 1) {
            if (this._tableNameField.getText().trim().length() > 0) {
                if (!dBObject.getDatabase().isValidName("TABLE", this._tableNameField.getText().trim())) {
                    throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
                }
                this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            } else {
                this._tableNameField.setText("");
                throw new TraversalException(DataImportArb.getString("INVALID_TABLE_NAME"));
            }
        }
        String string2 = ((DBObject)this._ctx.get("DBOBJECT")).getConnectionName();
        DBUtil dBUtil = DBUtil.getInstance((String)string2);
        if (traversableContext.getDirection() == 1 && !this._isExistingTable && dBUtil.resolveName(string = this._tableNameField.getText()) != null) {
            throw new TraversalException(DataImportArb.format("TABLE_NAME_EXISTS_ERROR", string));
        }
        if (this._loadMethodType == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
            string = this._stagingTableNameField.getText().trim();
            this._ctx.put("STAGING_TABLE_NAME", (Object)string);
            this._ctx.put("DROP_STAGING_TABLE", (Object)this._dropStagingTable.isSelected());
            if (traversableContext.getDirection() == 1) {
                if (string.length() > 0) {
                    if (!dBObject.getDatabase().isValidName("TABLE", this._stagingTableNameField.getText().trim())) {
                        throw new TraversalException(DataImportArb.getString("INVALID_STAGING_TABLE_NAME"));
                    }
                    if (dBUtil.resolveName(string) != null) {
                        throw new TraversalException(DataImportArb.format("STAGING_TABLE_NAME_EXISTS_ERROR", string));
                    }
                    this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    throw new TraversalException(DataImportArb.getString("MISSING_STAGING_TABLE_NAME"));
                }
            }
        }
        traversableContext.put("INSERT_INTO_EXISTING_TABLE", (Object)this._isExistingTable);
        traversableContext.put("TABLE_NAME", (Object)this._tableNameField.getText());
        this._table.setTableName(this._tableNameField.getText());
        int n = this._loadLimitPanel.getLoadLimitComponent().getIntValue();
        if (this._loadLimitPanel.getUseLoadLimitComponent().isSelected() && n > 0) {
            traversableContext.put("LOAD_LIMIT", (Object)n);
        } else {
            traversableContext.put("LOAD_LIMIT", (Object)0);
        }
        if (this._isExistingTable) {
            this._ctx.put("SEND_TO_WORKSHEET", (Object)false);
        } else {
            this._ctx.put("SEND_TO_WORKSHEET", (Object)this._sendToWorksheet.isSelected());
        }
        this._ctx.put("LOAD_METHOD", (Object)this._loadMethodType);
    }

    private void populateDBO(TraversableContext traversableContext) {
        GenericTable genericTable = null;
        if (traversableContext.get("DBOBJECT") == null) {
            genericTable = new GenericTable();
        } else if (((DBObject)traversableContext.get("DBOBJECT")).getObjectName() != null) {
            this._isExistingTable = true;
            genericTable = new GenericTable((Relation)((DBObject)traversableContext.get("DBOBJECT")).getSchemaObject());
        } else {
            genericTable = new GenericTable();
        }
        if (traversableContext.get("TABLE") != null) {
            this.setTable((GenericTable)traversableContext.get("TABLE"));
        } else {
            this.setTable(genericTable);
        }
        this.setInstruction((DBObject)traversableContext.get("DBOBJECT"));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this._instructions.setText(DataImportArb.getString("METHOD_EXISTING_INFO"));
            return;
        }
        this._instructions.setText(DataImportArb.getString("METHOD_CREATE_INFO"));
    }

    private void changeLoadMethod(int n) {
        this._loadMethodType = n;
        this.enableStagingComponents(this._loadMethodType == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE);
        this.enableLoadLimitComponents(this._loadMethodType != ImportDataFormat.METHOD_EXTERNAL_TABLE);
        if (!this._isExistingTable) {
            this.setSendToWorksheetComponents();
        }
        this._stagingTableNameField.setText(this._stagingTableName);
        if (this._loadMethodType == ImportDataFormat.METHOD_EXTERNAL_TABLE || this._loadMethodType == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)true);
        } else if (this._loadMethodType == ImportDataFormat.METHOD_SQLLDR) {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        } else {
            this._ctx.getWizardCallbacks().wizardUpdateExpectedTransition((Object)false);
        }
    }

    private void enableStagingComponents(boolean bl) {
        this._stagingTableNameField.setEnabled(bl);
        this._stagingTableNameLabel.setEnabled(bl);
        this._dropStagingTable.setEnabled(bl);
        this._stagingTableNameField.setVisible(bl);
        this._stagingTableNameLabel.setVisible(bl);
        this._dropStagingTable.setVisible(bl);
    }

    private void enableLoadLimitComponents(boolean bl) {
        this._loadLimitPanel.getUseLoadLimitComponent().setEnabled(bl);
        this._loadLimitPanel.getLoadLimitComponent().setEnabled(bl);
    }

    private void setSendToWorksheetComponents() {
        if (this._loadMethodType == ImportDataFormat.METHOD_INSERT_SCRIPT || this._loadMethodType == ImportDataFormat.METHOD_EXTERNAL_TABLE || this._loadMethodType == ImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE) {
            this._sendToWorksheet.setSelected(true);
            this._sendToWorksheet.setEnabled(false);
        } else if (this._loadMethodType == ImportDataFormat.METHOD_INSERT_EXEC) {
            this._sendToWorksheet.setSelected(false);
            this._sendToWorksheet.setEnabled(false);
        } else {
            this._sendToWorksheet.setSelected(false);
            this._sendToWorksheet.setEnabled(true);
        }
    }

    private void setTable(GenericTable genericTable) {
        this._table = genericTable;
    }
}

