/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.Table;
import oracle.dbtools.raptor.data.ui.ColumnListRenderer;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class KnownColumnPropertiesPanel
extends ColumnPropertyPanel {
    private static final long serialVersionUID = -5738627397607366539L;
    private JComboBox columnCombo;
    private ColumnListRenderer renderer = new ColumnListRenderer();
    private GridBagConstraints nameFieldConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
    private ItemListener columnListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                Column column = (Column)((JComboBox)itemEvent.getSource()).getSelectedItem();
                if (column.getType().equals(DataType.DATE.toString()) || column.getType().equals(DataType.TIMESTAMP.toString()) || column.getType().equals(DataType.TIMESTAMPTZ.toString()) || column.getType().equals(DataType.TIMESTAMPLTZ.toString())) {
                    KnownColumnPropertiesPanel.this.removePrecisionScale();
                    KnownColumnPropertiesPanel.this.addDateMask();
                } else {
                    KnownColumnPropertiesPanel.this.removeDateMask();
                    KnownColumnPropertiesPanel.this.removePrecisionScale();
                    KnownColumnPropertiesPanel.this.addPrecisionScale();
                }
                KnownColumnPropertiesPanel.this.refreshColumn(column);
                KnownColumnPropertiesPanel.this.column.refreshData(column);
            }
        }
    };
    private JComboBox box;

    public Column getCurrentSelection() {
        return (Column)this.box.getSelectedItem();
    }

    public KnownColumnPropertiesPanel() {
        this.typeField = new JTextField();
        this.add(this.typeField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        ((JTextField)this.typeField).setEnabled(false);
        this.enabled(false);
    }

    protected void refreshColumn(Column column) {
        Column column2 = this.m_table.getColumnByName(column.getName());
        ((JTextField)this.typeField).setText(column2.getType() != null ? column2.getType() : "");
        this.scaleField.setText(String.valueOf(column2.getScale()));
        this.precisionField.setText(String.valueOf(column2.getPrecision()));
        this.nullCheck.setSelected(column2.isNullable());
        this.defaultField.setText(column2.getDefault() != null ? column2.getDefault() : "");
        this.commentArea.setText(column2.getComment() != null ? column2.getComment() : "");
    }

    public void setTable(Relation relation) {
        Object object;
        Table table = new Table();
        DataTypeUsage dataTypeUsage = null;
        table.setTablename(relation.getName());
        ArrayList<Column> arrayList = new ArrayList<Column>();
        try {
            object = relation.getColumns();
            for (int i = 0; i < ((oracle.javatools.db.Column[])object).length; ++i) {
                String string;
                Column column = new Column();
                column.setName(object[i].getName());
                column.setNullable(!object[i].isNotNull());
                dataTypeUsage = object[i].getDataTypeUsage();
                if (dataTypeUsage.getAttributeValue("time_zone") != null) {
                    column.setType(DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage).toString() + " WITH " + dataTypeUsage.getAttributeValue("time_zone"));
                } else {
                    column.setType(DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage).toString());
                }
                String string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"precision");
                if (string2 == null) {
                    string2 = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"size");
                }
                if ((string = DataTypeHelper.getStringAttributeValue((DataTypeUsage)object[i].getDataTypeUsage(), (String)"scale")) != null) {
                    column.setScale(Integer.parseInt(string));
                }
                if (string2 != null) {
                    column.setPrecision(Integer.parseInt(string2));
                }
                column.setComment((String)object[i].getProperty("Comment"));
                arrayList.add(column);
            }
            table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
            this.m_table = table;
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        this.box = new JComboBox<Column>(arrayList.toArray(new Column[arrayList.size()]));
        this.box.setRenderer(this.renderer);
        if (this.columnCombo != null) {
            this.remove(this.columnCombo);
        }
        this.box.addItemListener(this.columnListener);
        this.add((Component)this.box, this.nameFieldConstraints);
        object = (Column)this.box.getSelectedItem();
        if (((Column)object).getType().equals(DataType.DATE.toString()) || ((Column)object).getType().equals(DataType.TIMESTAMP.toString()) || ((Column)object).getType().equals(DataType.TIMESTAMPTZ.toString()) || ((Column)object).getType().equals(DataType.TIMESTAMPLTZ.toString())) {
            this.addDateMask();
        }
        this.refreshColumn((Column)object);
        this.validate();
    }

    private boolean dateColumnExists(ArrayList<Column> arrayList) {
        for (Column column : arrayList) {
            if (column.getType().equals(DataType.DATE.toString())) {
                return true;
            }
            if (!column.getType().equals(DataType.TIMESTAMP.toString()) && !column.getType().equals(DataType.TIMESTAMPTZ.toString()) && !column.getType().equals(DataType.TIMESTAMPLTZ.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    void switchColumn(Column column) {
        String string = column.getName();
    }

    @Override
    void setColumnName(String string) {
        this.setSelectedName(string);
    }

    @Override
    void setDataType(String string) {
        ((JTextField)this.typeField).setText(string);
    }

    @Override
    void setTable(GenericTable genericTable) {
        this.m_table = genericTable.getTable();
    }

    @Override
    public Column getColumnDetails() {
        Column column = (Column)this.box.getSelectedItem();
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(column.getType())) {
            column.setFormat(this.dateMask.getText());
        }
        return column;
    }

    @Override
    void setColumn(Column column) {
        this.column = column;
        this.setColumnName(column.getName());
        this.setDataType(column.getType());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setNullable(column.isNullable());
        this.defaultField.setText(column.getDefault());
        this.setComment(column.getComment());
        if (DataType.DATE.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMP.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMPTZ.toString().equalsIgnoreCase(this.column.getType()) || DataType.TIMESTAMPLTZ.toString().equalsIgnoreCase(this.column.getType())) {
            this.setDateMask(column.getFormat());
        }
    }

    private void setSelectedName(String string) {
        ComboBoxModel comboBoxModel = this.box.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!((Column)comboBoxModel.getElementAt(i)).getName().equals(string)) continue;
            this.box.setSelectedIndex(i);
        }
    }
}

