/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.sql.Connection;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.writers.BaseFormattor;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class DateFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column column) {
        String string = null;
        string = this.addDoubleQuote(column.getName()) + " " + column.getType();
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    @Override
    public String formatData(Object object, Column column) {
        String string = "NULL";
        String string2 = column.getFormat();
        String string3 = "";
        if (string2 != null && string2.length() > 0) {
            string3 = "', '" + string2.replaceAll("\"", "");
        }
        if (object != null) {
            string = column.getType().equalsIgnoreCase("timestamp") ? "to_timestamp('" + object.toString() + string3 + "')" : (column.getType().equalsIgnoreCase("timestamp with time zone") || column.getType().equalsIgnoreCase("timestamp with local time zone") ? "to_timestamp_tz('" + object.toString() + string3 + "')" : "to_date('" + object.toString() + string3 + "')");
        }
        return string;
    }

    @Override
    public Object formatDataForJava(Object object, Column column) throws Exception {
        String string;
        String string2 = "NULL";
        String string3 = column.getFormat();
        if (string3 != null) {
            string3 = string3.replaceAll("\"", "");
        }
        if (object != null && (string = object.toString()).length() > 0 && !string.equals("NULL")) {
            if (column.getType().equalsIgnoreCase("TIMESTAMP")) {
                OraTIMESTAMPFormat oraTIMESTAMPFormat = string3 == null || string3.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_connection)).getOraTIMESTAMPFormat() : new OraTIMESTAMPFormat(string3, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                TIMESTAMP tIMESTAMP = oraTIMESTAMPFormat.parse(string, new ParsePosition(0));
                string2 = tIMESTAMP;
            } else if (column.getType().equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
                OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = string3 == null || string3.length() == 0 ? ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_connection)).getOraTIMESTAMPTZFormat() : new OraTIMESTAMPTZFormat(string3, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                TIMESTAMPTZ tIMESTAMPTZ = oraTIMESTAMPTZFormat.parse(string, new ParsePosition(0));
                string2 = tIMESTAMPTZ;
            } else if (column.getType().equalsIgnoreCase("TIMESTAMP WITH LOCAL TIME ZONE")) {
                OracleNLSProvider oracleNLSProvider = (OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_connection);
                OraTIMESTAMPLTZFormat oraTIMESTAMPLTZFormat = string3 == null || string3.length() == 0 ? oracleNLSProvider.getOraTIMESTAMPLTZFormat() : new OraTIMESTAMPLTZFormat(string3, OraLocaleInfo.getInstance((Locale)this.getLocale()), oracleNLSProvider.getTimeZone(oracleNLSProvider.getDBTimeZone()), oracleNLSProvider.getSessionTimeZone());
                TIMESTAMPLTZ tIMESTAMPLTZ = oraTIMESTAMPLTZFormat.parse(string, new ParsePosition(0));
                string2 = tIMESTAMPLTZ;
            } else {
                OraDATEFormat oraDATEFormat;
                if (string3 == null || string3.length() == 0) {
                    try {
                        oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_connection)).getOraDATEFormat();
                    }
                    catch (ParseException parseException) {
                        oraDATEFormat = null;
                    }
                } else {
                    oraDATEFormat = new OraDATEFormat(string3, OraLocaleInfo.getInstance((Locale)this.getLocale()));
                }
                DATE dATE = oraDATEFormat.parse(string, new ParsePosition(0));
                return dATE;
            }
        }
        return string2;
    }

    @Override
    public int getSqlType(String string) {
        if (string.equals("DATE")) {
            return 91;
        }
        if (string.equals("TIMESTAMP WITH TIME ZONE")) {
            return -101;
        }
        if (string.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
            return 93;
        }
        return 93;
    }
}

