/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.text.NumberFormat;
import java.text.ParseException;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.writers.BaseFormattor;

public class NumberFormattor
extends BaseFormattor {
    @Override
    public String formatColumn(Column column) {
        String string = null;
        string = this.addDoubleQuote(column.getName()) + " " + column.getType();
        if (column.getName() != null && this.isPrecisionAllowed() && column.getPrecision() > 0) {
            string = column.getScale() > 0 ? string + "(" + column.getPrecision() + ", " + column.getScale() + ")" : string + "(" + column.getPrecision() + ")";
        }
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    @Override
    public String formatData(Object object, Column column) {
        String string = "NULL";
        NumberFormat numberFormat = null;
        numberFormat = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
        if (object != null) {
            try {
                string = column.getPrecision() > 0 && column.getScale() > 0 || column.getPrecision() == 0 && column.getScale() == 0 || this.isScaleImported() ? "" + numberFormat.parse(object.toString()).doubleValue() : "" + numberFormat.parse(object.toString()).longValue();
            }
            catch (ParseException parseException) {
                string = object.toString();
            }
        }
        if (string.length() == 0) {
            return "NULL";
        }
        return string;
    }

    @Override
    public Object formatDataForJava(Object object, Column column) throws Exception {
        if (object != null) {
            return object.toString();
        }
        return "NULL";
    }

    @Override
    public int getSqlType(String string) {
        if (string.equals("NUMBER")) {
            return 2;
        }
        if (string.equals("INTEGER")) {
            return 4;
        }
        if (string.equals("LONG")) {
            return 8;
        }
        if (string.equals("FLOAT")) {
            return 6;
        }
        return 2;
    }
}

