/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.databasecopy.IAutoRefresh;
import oracle.dbtools.raptor.databasecopy.Messages;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.dialogs.databasecopy.DatabaseCopyArb;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public abstract class CopyAPI {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CopyAPI.class.getName());
    protected ExtractListModel m_listModel;
    private Connection m_sourceConn;
    private String m_sourceConnName;
    private String m_sourceConnDisplayName;
    private Connection m_destinationConn;
    protected String m_destinationConnName;
    private String m_destinationConnDisplayName;
    private IAutoRefresh _treeRefreshCallback;
    private Context context;
    private File m_file;
    private OutputStream m_fout;
    private BufferedOutputStream m_bout;
    protected OutputStreamWriter m_out;
    private boolean _suppressLogging = false;
    private String copyLogName;
    private String encoding = IdeUtil.getIdeEncoding();
    private String m_EOL;
    private RaptorTask<Void> m_task = null;
    private HashMap<String, Boolean> m_selectedOptions = new HashMap();
    private boolean m_cancel;
    private boolean m_isCopyDDL = false;
    private boolean m_isNotReplaceDest = false;
    private boolean m_isReplaceDest = false;
    private boolean m_isCopyData = false;
    private boolean m_isTruncateData = false;
    private boolean m_isMaintainSchemas = false;
    private boolean m_isConsolidateSchemas = false;
    private boolean m_isUseLogger = false;
    protected final int OBJECTS_DATACOPY = 0;
    protected final int MAINTAIN_SCHEMAS_DATACOPY = 1;
    protected final int CONSOLIDATE_SCHEMAS_DATACOPY = 2;
    private ArrayList<DBObject> _dndObjectList = new ArrayList();
    private ArrayList<ExtractObject> m_EOList;
    private String m_destTablespace = null;
    protected boolean m_ignoreAllErrors = false;

    public CopyAPI() {
    }

    public CopyAPI(HashMap<String, Boolean> hashMap) {
        this.m_selectedOptions = hashMap;
    }

    public void setExtractListModel(ExtractListModel extractListModel) {
        this.m_listModel = extractListModel;
        this.setSourceConnection(this.m_listModel.getSourceConn());
        this.setDestinationConnection(this.m_listModel.getDestConn());
        this.getSelectedOptions();
        this.openLog();
        this.setDDLFormat();
        this.setDataFormat();
    }

    protected void setSourceConnection(Connection connection) {
        this.m_sourceConn = connection;
        this.m_sourceConnName = Connections.getInstance().getConnectionName(this.m_sourceConn);
        this.m_sourceConnDisplayName = Connections.getDisplayName(Connections.getInstance().getConnectionName(this.m_sourceConn));
    }

    protected void setDestinationConnection(Connection connection) {
        this.m_destinationConn = connection;
        this.m_destinationConnName = Connections.getInstance().getConnectionName(this.m_destinationConn);
        this.m_destinationConnDisplayName = Connections.getDisplayName(Connections.getInstance().getConnectionName(this.m_destinationConn));
    }

    public synchronized void startDatabaseCopyWithDialog(IAutoRefresh iAutoRefresh) {
        this._treeRefreshCallback = iAutoRefresh;
        this.startDatabaseCopyWithDialog();
    }

    public void startDatabaseCopyWithDialog() {
        this.m_listModel.startProcess();
        this.m_listModel.reconcileDestFromSource();
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DatabaseCopyArb.getString("COPY_START"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){
            private volatile Thread m_execThread;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() {
                this.m_execThread = Thread.currentThread();
                try {
                    this.checkCanProceed();
                    CopyAPI.this.startDatabaseCopy();
                    CopyAPI.this.closeLog();
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    this.getDescriptor().setMessage(CopyPanelArb.getString("QUERY_CANCELLED"));
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
                    CopyAPI.this.initObjectFilters(null, false);
                    CopyAPI.this._treeRefreshCallback = null;
                }
                finally {
                    this.m_execThread = null;
                }
                return null;
            }

            public boolean cancel() {
                Thread thread = this.m_execThread;
                if (thread != null) {
                    DBUtil.cancelExecution((Thread)thread);
                    CopyAPI.this.m_cancel = true;
                    thread.interrupt();
                    return true;
                }
                return false;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        RaptorTaskDescriptor raptorTaskDescriptor = raptorTask.getDescriptor();
        raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CopyAPI.this._treeRefreshCallback != null) {
                            CopyAPI.this._treeRefreshCallback.refresh();
                        }
                        try {
                            if (!CopyAPI.this._suppressLogging) {
                                TextNode textNode = new TextNode(URLFactory.newFileURL((File)CopyAPI.this.m_file));
                                CopyAPI.this.context = Context.newIdeContext((Node)textNode);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(CopyAPI.this.context);
                                openEditorOptions.setFlags(1);
                                Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        finally {
                            CopyAPI.this._treeRefreshCallback = null;
                            CopyAPI.this.initObjectFilters(null, false);
                        }
                    }
                });
            }
        });
        this.m_task = raptorTask;
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected void startDatabaseCopy() {
        if (this.isCopyDDL() && !this.isCopyData()) {
            this.databaseCopyDDLOnly();
            return;
        }
        if (this.isCopyDDL()) {
            this.databaseCopyDDL();
        }
        if (this.isCopyData() && !this.m_cancel) {
            this.databaseCopyData();
        }
    }

    protected void databaseCopyDDLOnly() {
        if (this.isReplaceDest()) {
            this.getExtractListAndExecuteDDL(4, 0, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(2, 0, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(3, 0, this.getDestinationConn());
        } else {
            this.getExtractListAndExecuteDDL(2, 105, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(3, 105, this.getDestinationConn());
        }
    }

    protected void databaseCopyDDL() {
        if (this.isReplaceDest()) {
            this.getExtractListAndExecuteDDL(4, 0, this.getDestinationConn());
            this.getExtractListAndExecuteDDL(2, 0, this.getDestinationConn());
        } else {
            this.getExtractListAndExecuteDDL(2, 105, this.getDestinationConn());
        }
    }

    abstract void databaseCopyData();

    private void getSelectedOptions() {
        this.m_isCopyDDL = this.m_selectedOptions.get("DATABASE_COPY_DDL_ENABLED");
        this.m_isNotReplaceDest = this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_NOT_REPLACE");
        this.m_isReplaceDest = this.m_selectedOptions.get("DATABASE_COPY_DDL_DO_REPLACE");
        if (this.m_selectedOptions.get("DATABASE_COPY_SCHEMAS_COPY").booleanValue()) {
            this.m_isMaintainSchemas = this.m_selectedOptions.get("MAINTAIN_SCHEMAS");
            this.m_isConsolidateSchemas = this.m_selectedOptions.get("CONSOLIDATE_SCHEMA");
        }
        this.m_isCopyData = this.m_selectedOptions.get("DATABASE_COPY_DATA_ENABLED");
        this.m_isTruncateData = this.m_selectedOptions.get("DATABASE_COPY_DATA_TRUNCATE_ENABLED");
    }

    public synchronized void initObjectFilters(ArrayList<DatabaseNode> arrayList, boolean bl) {
        DBObject dBObject = null;
        this._dndObjectList.clear();
        this._suppressLogging = bl;
        if (arrayList != null) {
            for (DatabaseNode databaseNode : arrayList) {
                dBObject = databaseNode instanceof ObjectNode ? new DBObject((Element)((ObjectNode)databaseNode).getData()) : (databaseNode instanceof PlSqlNode ? new DBObject((Element)((PlSqlNode)databaseNode).getData()) : null);
                if (dBObject == null) continue;
                this._dndObjectList.add(dBObject);
            }
        }
    }

    private boolean compareSourceAndDesintationVersions(Connection connection, Connection connection2) {
        Version version = DBUtil.getDbVersion((Connection)connection);
        Version version2 = DBUtil.getDbVersion((Connection)connection2);
        if (version2.compareTo((Object)version) < 0) {
            this.lineStart();
            this.log(MessageFormat.format(CopyPanelArb.getString("NO_SEGMENT_CLAUSE_MSG"), version2.toString(), version.toString()) + this.getTerm());
            this.lineEnd();
            return false;
        }
        return true;
    }

    protected void setDDLFormat() {
        DDLFormat dDLFormat = new DDLFormat();
        dDLFormat.setPretty(false);
        dDLFormat.setSchema(false);
        dDLFormat.setConstraint(true);
        dDLFormat.setRefConstraint(true);
        dDLFormat.setCascade(true);
        dDLFormat.setDrop(true);
        dDLFormat.setAlter(false);
        dDLFormat.setSegments(this.compareSourceAndDesintationVersions(this.m_sourceConn, this.m_destinationConn));
        this.m_listModel.setDDLFormat(dDLFormat);
    }

    protected void setDataFormat() {
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
        extractDataFormat.setFormat(BaseDataFormat.COPY);
        extractDataFormat.isExportEnabled(true);
        this.m_listModel.setDataFormat(extractDataFormat);
    }

    protected void getExtractListAndExecuteDDL(int n, int n2, Connection connection) {
        ArrayList<ExtractObject> arrayList = null;
        arrayList = n2 == 0 ? this.m_listModel.getList(n) : this.m_listModel.getList(n, new int[]{n2});
        this.lineStart();
        try {
            for (ExtractObject extractObject : arrayList) {
                this.checkCancelled();
                this.setProg(DatabaseCopyArb.getString("CREATING_OBJ") + " " + extractObject.getDBObject().getObjectName());
                if (this.executeSql(extractObject.getDDL(n, ExtractObject.COPY_DDL), connection)) continue;
                String string = CopyPanelArb.format("DDL_ERROR_OBJECT", extractObject.getDBObject().getObjectType(), extractObject.getDBObject().getObjectName()) + this.getTerm();
                if (this.m_ignoreAllErrors) continue;
                DatabaseCopyException databaseCopyException = new DatabaseCopyException();
                int n3 = 0;
                try {
                    n3 = databaseCopyException.askContinueOnError(string + CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                    if (n3 == 2) {
                        this.cancel();
                        continue;
                    }
                    if (n3 == 1) {
                        this.m_ignoreAllErrors = true;
                        continue;
                    }
                    this.m_ignoreAllErrors = false;
                }
                catch (Throwable throwable) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.lineEnd();
    }

    protected void getExtractListAndCopyData(int n, Connection connection, Connection connection2, int n2) {
        ArrayList<ExtractObject> arrayList = this.m_listModel.getList(n, new int[]{103});
        this.lineStart();
        String string = null;
        DataMover dataMover = new DataMover(connection, connection2, this.m_ignoreAllErrors);
        dataMover.setLogFile(this.m_out);
        try {
            for (ExtractObject extractObject : arrayList) {
                this.checkCancelled();
                string = extractObject.getFinalWhere();
                DBObject dBObject = extractObject.getDBObject();
                if (dBObject.getObjectType().equalsIgnoreCase("VIEW")) continue;
                this.setProg(DatabaseCopyArb.getString("MOVING_DATA") + " " + dBObject.getObjectName());
                this.lineStart();
                this.log(CopyPanelArb.getString("MOVING_DATA_MESSAGE") + dBObject.getObjectName());
                if (!dataMover.move(dBObject, extractObject.getColumns(), string, n2, true)) {
                    this.cancel();
                    this.checkCancelled();
                    break;
                }
                this.lineEnd();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.lineEnd();
    }

    protected boolean executeSql(String string, Connection connection) {
        try {
            this.log(string + this.getTerm());
            String string2 = ScriptRunnerContext.getOutputEncoding();
            StringReader stringReader = new StringReader(string);
            ScriptExecutor scriptExecutor = new ScriptExecutor((Reader)stringReader, connection);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)true);
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            scriptExecutor.setOut(bufferedOutputStream);
            scriptExecutor.run();
            bufferedOutputStream.flush();
            this.log(byteArrayOutputStream.toString(string2));
            return (Boolean)scriptRunnerContext.getProperty("sqldev.error.any.in") == false;
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            return true;
        }
    }

    protected String getTerm() {
        if (this.m_EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this.m_EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this.m_EOL;
    }

    protected void setProg(String string) {
        RaptorTaskDescriptor raptorTaskDescriptor = null;
        if (this.m_task != null) {
            raptorTaskDescriptor = this.m_task.getDescriptor();
            raptorTaskDescriptor.setMessage(string);
        }
    }

    public void cancel() {
        this.m_cancel = true;
    }

    protected void openLog() {
        if (!this._suppressLogging) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
                StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
                this.copyLogName = Ide.getUserSettingsDirectory() + "DatabaseCopy." + stringBuilder + ".log";
                this.m_file = new File(this.copyLogName);
                this.m_fout = new FileOutputStream(this.m_file.getPath());
                this.m_bout = new BufferedOutputStream(this.m_fout);
                this.m_out = new OutputStreamWriter((OutputStream)this.m_bout, this.encoding);
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)CopyPanelArb.getString("FILE_CREATION_ERROR"), (String)(this.m_file.getPath() + this.m_file.getName()), null);
            }
        }
    }

    protected void lineStart() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.169") + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.169"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void lineEnd() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.170") + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.170"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void lineError() {
        try {
            if (this.m_out != null) {
                this.m_out.write(Messages.getString("CopyAPI.171") + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("CopyAPI.171"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void log(String string) {
        try {
            if (this.m_out != null) {
                this.m_out.write(string + this.getTerm());
            } else if (this.m_isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void closeLog() {
        try {
            if (this.m_out != null) {
                this.m_out.flush();
                this.m_out.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public boolean isCopyDDL() {
        return this.m_isCopyDDL;
    }

    public void isCopyDDL(boolean bl) {
        this.m_isCopyDDL = bl;
    }

    public boolean isNotReplaceDest() {
        return this.m_isNotReplaceDest;
    }

    public void isNotReplaceDest(boolean bl) {
        this.m_isNotReplaceDest = bl;
    }

    public boolean isReplaceDest() {
        return this.m_isReplaceDest;
    }

    public void isReplaceDest(boolean bl) {
        this.m_isReplaceDest = bl;
    }

    public boolean isCopyData() {
        return this.m_isCopyData;
    }

    public void isCopyData(boolean bl) {
        this.m_isCopyData = bl;
    }

    public boolean isTruncateData() {
        return this.m_isTruncateData;
    }

    public void isTruncateData(boolean bl) {
        this.m_isTruncateData = bl;
    }

    protected Connection getSourceConn() {
        return this.m_sourceConn;
    }

    protected Connection getDestinationConn() {
        return this.m_destinationConn;
    }

    protected void setSourceConn(Connection connection) {
        this.m_sourceConn = connection;
    }

    protected void setDestinationConn(Connection connection) {
        this.m_destinationConn = connection;
    }

    protected ExtractListModel getExtractListModel() {
        return this.m_listModel;
    }

    protected boolean isMaintainSchemas() {
        return this.m_isMaintainSchemas;
    }

    protected boolean isConsolidateSchemas() {
        return this.m_isConsolidateSchemas;
    }

    public void isUseLogger(boolean bl) {
        this.m_isUseLogger = bl;
    }

    protected void checkCancelled() throws InterruptedException {
        if (Thread.interrupted() || this.m_cancel) {
            try {
                this.m_destinationConn.rollback();
            }
            catch (SQLException sQLException) {
                LOGGER.severe(CopyPanelArb.getString("NO_ROLLBACK"));
            }
        }
    }

    public void setDestinationTablespace(String string) {
        this.m_destTablespace = string;
    }

    public String getDestinationTablespaceString() {
        return " TABLESPACE \"" + this.m_destTablespace + "\"";
    }

    public BufferedOutputStream getBufferedOutputStream() {
        return this.m_bout;
    }

    public OutputStreamWriter getOutputStreamWriter() {
        return this.m_out;
    }
}

