/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.ide.util.ResourceUtils;

public class CopyOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    private JPanel m_optionPanel = new JPanel();
    private JRadioButton m_jRdoSchemasCopy = new JRadioButton();
    private JRadioButton m_jRdoObjectsCopy = new JRadioButton();
    private JRadioButton m_jRdoTablespaceCopy = new JRadioButton();
    private JRadioButton m_jRdoMaintainSchemas = new JRadioButton();
    private JRadioButton m_jRdoConsolidateSchemas = new JRadioButton();
    private ItemListener m_optionsCopyListener;
    private boolean m_optionsCopyListenerAdded = false;
    private int m_usage;

    public CopyOptionsPanel() {
        this(WIZARD);
    }

    public CopyOptionsPanel(int n) {
        this.m_usage = n;
    }

    public void allowDisable(boolean bl) {
        this.m_jRdoSchemasCopy.setSelected(!bl);
        this.m_jRdoSchemasCopy.setEnabled(bl);
        if (bl) {
            this.addOptionsCopyListener();
        } else {
            this.removeOptionsCopyListener();
        }
    }

    public JPanel getPanel() {
        this.m_optionPanel = new JPanel(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_jRdoObjectsCopy, (String)CopyWizArb.getString("OBJECTS_COPY"));
        ResourceUtils.resButton((AbstractButton)this.m_jRdoSchemasCopy, (String)CopyWizArb.getString("SCHEMAS_COPY"));
        ResourceUtils.resButton((AbstractButton)this.m_jRdoTablespaceCopy, (String)CopyWizArb.getString("TABLESPACE_COPY"));
        ResourceUtils.resButton((AbstractButton)this.m_jRdoMaintainSchemas, (String)CopyWizArb.getString("MAINTAIN_SCHEMAS"));
        ResourceUtils.resButton((AbstractButton)this.m_jRdoConsolidateSchemas, (String)CopyWizArb.getString("CONSOLIDATE_SCHEMA"));
        this.addOptionsCopyListener();
        this.m_jRdoObjectsCopy.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("OBJECTS_COPY")));
        this.m_jRdoObjectsCopy.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("OBJECTS_COPY")));
        this.m_jRdoObjectsCopy.setSelected(true);
        this.m_jRdoObjectsCopy.setActionCommand("ObjectCopyActionCommand");
        this.m_jRdoSchemasCopy.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("SCHEMAS_COPY")));
        this.m_jRdoSchemasCopy.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("SCHEMAS_COPY")));
        this.m_jRdoSchemasCopy.setSelected(false);
        this.m_jRdoSchemasCopy.setActionCommand("SchemasCopyActionCommand");
        this.m_jRdoMaintainSchemas.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("MAINTAIN_SCHEMAS")));
        this.m_jRdoMaintainSchemas.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("MAINTAIN_SCHEMAS")));
        this.m_jRdoMaintainSchemas.setSelected(true);
        this.m_jRdoConsolidateSchemas.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("CONSOLIDATE_SCHEMA")));
        this.m_jRdoConsolidateSchemas.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("CONSOLIDATE_SCHEMA")));
        this.m_jRdoConsolidateSchemas.setSelected(false);
        this.m_jRdoTablespaceCopy.setText(StringUtils.stripMnemonic((String)CopyWizArb.getString("TABLESPACE_COPY")));
        this.m_jRdoTablespaceCopy.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("TABLESPACE_COPY")));
        this.m_jRdoTablespaceCopy.setSelected(false);
        this.m_jRdoTablespaceCopy.setActionCommand("TablespaceCopyActionCommand");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jRdoObjectsCopy);
        buttonGroup.add(this.m_jRdoSchemasCopy);
        buttonGroup.add(this.m_jRdoTablespaceCopy);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_jRdoMaintainSchemas);
        buttonGroup2.add(this.m_jRdoConsolidateSchemas);
        this.m_jRdoMaintainSchemas.setEnabled(false);
        this.m_jRdoConsolidateSchemas.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.m_jRdoObjectsCopy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jRdoSchemasCopy, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jRdoMaintainSchemas, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jRdoConsolidateSchemas, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jRdoTablespaceCopy, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 8, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        TitledPane titledPane = new TitledPane((Component)new JLabel(CopyWizArb.getString("COPY_OPTIONS")), (Component)jPanel3);
        this.m_optionPanel.setLayout(new BorderLayout());
        this.m_optionPanel.add((Component)titledPane, "Center");
        return this.m_optionPanel;
    }

    public JRadioButton getObjectsCopyComponent() {
        return this.m_jRdoObjectsCopy;
    }

    public boolean getObjectsCopyOption() {
        return this.m_jRdoObjectsCopy.isSelected();
    }

    public void setObjectsCopyOption(boolean bl) {
        this.m_jRdoObjectsCopy.setSelected(bl);
    }

    public JRadioButton getSchemasCopyComponent() {
        return this.m_jRdoSchemasCopy;
    }

    public boolean getSchemasCopyOption() {
        return this.m_jRdoSchemasCopy.isSelected();
    }

    public void setSchemasCopyOption(boolean bl) {
        this.m_jRdoSchemasCopy.setSelected(bl);
    }

    public JRadioButton getTablespaceCopyComponent() {
        return this.m_jRdoTablespaceCopy;
    }

    public boolean getTablespaceCopyOption() {
        return this.m_jRdoTablespaceCopy.isSelected();
    }

    public void setTablespaceCopyOption(boolean bl) {
        this.m_jRdoTablespaceCopy.setSelected(bl);
    }

    public boolean getMaintainSchemasOption() {
        return this.m_jRdoMaintainSchemas.isSelected();
    }

    public void setMaintainSchemasOption(boolean bl) {
        this.m_jRdoMaintainSchemas.setSelected(bl);
    }

    public boolean getConsolidateSchemasOption() {
        return this.m_jRdoConsolidateSchemas.isSelected();
    }

    public void setConsolidateSchemasOption(boolean bl) {
        this.m_jRdoConsolidateSchemas.setSelected(bl);
    }

    public void setDefault() {
        this.m_jRdoObjectsCopy.setSelected(true);
        this.m_jRdoSchemasCopy.setSelected(false);
        this.m_jRdoTablespaceCopy.setSelected(false);
    }

    public void removeOptionsCopyListener() {
        if (this.m_optionsCopyListenerAdded) {
            this.m_jRdoSchemasCopy.removeItemListener(this.m_optionsCopyListener);
        }
        this.m_optionsCopyListenerAdded = false;
    }

    void addOptionsCopyListener() {
        if (!this.m_optionsCopyListenerAdded) {
            this.m_optionsCopyListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CopyOptionsPanel.this.enableOptions(CopyOptionsPanel.this.m_jRdoSchemasCopy.isSelected());
                }
            };
            this.m_jRdoSchemasCopy.addItemListener(this.m_optionsCopyListener);
            this.m_optionsCopyListenerAdded = true;
        }
    }

    void enableOptions(boolean bl) {
        this.m_jRdoMaintainSchemas.setEnabled(bl);
        this.m_jRdoConsolidateSchemas.setEnabled(bl);
    }
}

