/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.databasecopy.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDBConnPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDataOptionPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyDdlOptionPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyOptionsPanel;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class CopyWizDBSelectorPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private CopyDBConnPanel m_copyDBConnPanel = new CopyDBConnPanel();
    private CopyOptionsPanel m_optionsPanel = new CopyOptionsPanel();
    private CopyDdlOptionPanel m_copyDdlOptionPanel = new CopyDdlOptionPanel();
    private CopyDataOptionPanel m_copyDataOptionPanel = new CopyDataOptionPanel();
    private final JCheckBox m_chkbxToSummary = new JCheckBox();
    private String m_wizardType;
    private ExtractListModel m_listModel;
    private TraversableContext m_dataContext;

    public CopyWizDBSelectorPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkbxToSummary, (String)CopyWizArb.getString("GOTO_SUMMARY"));
        this.m_chkbxToSummary.setEnabled(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add((Component)this.m_chkbxToSummary, "South");
        this.add(jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this.m_copyDBConnPanel.getPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_optionsPanel.getPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_copyDdlOptionPanel.getPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.m_copyDataOptionPanel.getPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel3, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        this.m_listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this.m_copyDBConnPanel.setSourceConnection((String)traversableContext.get("DATABASE_COPY_SOURCE_CONNECTION_NAME"));
        this.m_copyDBConnPanel.setTargetConnection((String)traversableContext.get("DATABASE_COPY_DESTINATION_CONNECTION_NAME"));
        this.m_optionsPanel.getObjectsCopyComponent().addActionListener(this);
        this.m_optionsPanel.getSchemasCopyComponent().addActionListener(this);
        this.m_optionsPanel.getTablespaceCopyComponent().addActionListener(this);
        this.m_wizardType = (String)traversableContext.get("WIZARD_TYPE");
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object[] objectArray;
        boolean bl;
        String string = this.m_copyDBConnPanel.getSourceConnection();
        Connection connection = null;
        this.m_dataContext = traversableContext;
        if (string != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
            }
            catch (Exception exception) {
                Throwable throwable;
                Exception exception2;
                while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                    exception2 = (Exception)throwable;
                }
                ExceptionHandler.handleException((String)string, (Throwable)exception2);
                throw new TraversalException(null);
            }
        }
        if (connection == null) {
            throw new TraversalException(CopyWizArb.getString("NO_SOURCE_CONNECTION"));
        }
        String string2 = this.m_copyDBConnPanel.getTargetConnection();
        Connection connection2 = null;
        if (string2 != null) {
            try {
                connection2 = Connections.getInstance().getConnection(string2);
            }
            catch (Exception exception) {
                Throwable throwable;
                Exception exception3;
                while (exception3 instanceof DBException && (throwable = exception3.getCause()) instanceof Exception) {
                    exception3 = (Exception)throwable;
                }
                ExceptionHandler.handleException((String)string2, (Throwable)exception3);
                throw new TraversalException(null);
            }
        }
        if (connection2 == null) {
            throw new TraversalException(CopyWizArb.getString("NO_DEST_CONNECTION"));
        }
        if (this.checkDatabaseConnections(connection, connection2)) {
            throw new TraversalException(CopyWizArb.getString("SAME_CONNECTION"));
        }
        if (DBUtil.getDbVersion((Connection)connection).compareTo((Object)DBUtil.getDbVersion((Connection)connection2)) > 0 && !(bl = MessageDialog.confirm((Component)((Object)this), (Object)CopyWizArb.format("COMPATIBILITY_WARNING", objectArray = new Object[]{Connections.getDisplayName(string), DBUtil.getDbVersion((Connection)connection).toCanonicalString(), Connections.getDisplayName(string2), DBUtil.getDbVersion((Connection)connection2).toCanonicalString()}), (String)CopyWizArb.getString("COMPATIBILITY_TITLE"), null))) {
            throw new TraversalException(null);
        }
        if ((this.m_optionsPanel.getTablespaceCopyOption() || this.m_optionsPanel.getSchemasCopyOption() && this.m_optionsPanel.getMaintainSchemasOption()) && this.validateDatabases(connection, connection2)) {
            throw new TraversalException(CopyWizArb.getString("SAME_DATABASE_SRC_DEST"));
        }
        if (this.m_optionsPanel.getTablespaceCopyOption() || this.m_optionsPanel.getSchemasCopyOption()) {
            if (!this.validateRolesOfUsers(string)) {
                throw new TraversalException(CopyWizArb.getString("INSUFFICIENT_PRIVILEGES_SRC"));
            }
            if (!this.validateRolesOfUsers(string2)) {
                throw new TraversalException(CopyWizArb.getString("INSUFFICIENT_PRIVILEGES_DEST"));
            }
        }
        if (!this.m_copyDdlOptionPanel.getChkbxCopyDDL() && !this.m_copyDataOptionPanel.getChkbxCopyData()) {
            throw new TraversalException(CopyWizArb.getString("NOTHING_TO_DO"));
        }
        traversableContext.put("DATABASE_COPY_SOURCE_CONNECTION", (Object)connection);
        traversableContext.put("DATABASE_COPY_SOURCE_CONNECTION_NAME", (Object)string);
        traversableContext.put("DATABASE_COPY_DESTINATION_CONNECTION", (Object)connection2);
        traversableContext.put("DATABASE_COPY_DESTINATION_CONNECTION_NAME", (Object)string2);
        traversableContext.put("CONNECTION_NAME", (Object)string);
        this.m_listModel.setSourceConnName(string);
        this.m_listModel.setDestConnName(string2);
        this.m_listModel.isDDLEnabled(this.m_copyDdlOptionPanel.getChkbxCopyDDL());
        this.m_listModel.isDataEnabled(this.m_copyDataOptionPanel.getChkbxCopyData());
        traversableContext.put("DATABASE_COPY_OBJECTS_COPY", (Object)this.m_optionsPanel.getObjectsCopyOption());
        traversableContext.put("DATABASE_COPY_SCHEMAS_COPY", (Object)this.m_optionsPanel.getSchemasCopyOption());
        traversableContext.put("DATABASE_COPY_TABLESPACE", (Object)this.m_optionsPanel.getTablespaceCopyOption());
        if (this.m_optionsPanel.getSchemasCopyOption()) {
            traversableContext.put("MAINTAIN_SCHEMAS", (Object)this.m_optionsPanel.getMaintainSchemasOption());
            traversableContext.put("CONSOLIDATE_SCHEMA", (Object)this.m_optionsPanel.getConsolidateSchemasOption());
        }
        traversableContext.put("DATABASE_COPY_DDL_ENABLED", (Object)this.m_copyDdlOptionPanel.getChkbxCopyDDL());
        traversableContext.put("DATABASE_COPY_DDL_DO_NOT_REPLACE", (Object)this.m_copyDdlOptionPanel.getDoNotReplaceDest());
        traversableContext.put("DATABASE_COPY_DDL_DO_REPLACE", (Object)this.m_copyDdlOptionPanel.getDoReplaceDest());
        traversableContext.put("DATABASE_COPY_DATA_ENABLED", (Object)this.m_copyDataOptionPanel.getChkbxCopyData());
        traversableContext.put("DATABASE_COPY_DATA_TRUNCATE_ENABLED", (Object)this.m_copyDataOptionPanel.getChkbxTruncData());
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        if (this.m_chkbxToSummary.isSelected()) {
            return "Finish";
        }
        return "TransitionObjectTypes";
    }

    protected boolean validateRolesOfUsers(String string) {
        boolean bl = false;
        try {
            DBUtil dBUtil = DBUtil.getInstance((String)string);
            String string2 = Connections.getInstance().getConnection(string).getMetaData().getUserName();
            String string3 = "select granted_role ROLE from USER_ROLE_PRIVS where username = '" + string2 + "'";
            List list = dBUtil.executeReturnList(string3, null);
            for (Map map : list) {
                if (!"DBA".equals((String)map.get("ROLE"))) continue;
                bl = true;
                break;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return bl;
    }

    public boolean validateDatabases(Connection connection, Connection connection2) {
        boolean bl = false;
        try {
            String string = connection.getMetaData().getURL();
            String string2 = connection2.getMetaData().getURL();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return bl;
    }

    public boolean checkDatabaseConnections(Connection connection, Connection connection2) {
        boolean bl = false;
        try {
            String string;
            String string2;
            if (this.validateDatabases(connection, connection2) && (string2 = connection.getMetaData().getUserName()).equals(string = connection2.getMetaData().getUserName())) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("ObjectCopyActionCommand".equals(actionEvent.getActionCommand())) {
            this.m_chkbxToSummary.setEnabled(true);
        } else if ("SchemasCopyActionCommand".equals(actionEvent.getActionCommand()) || "TablespaceCopyActionCommand".equals(actionEvent.getActionCommand())) {
            this.m_chkbxToSummary.setEnabled(false);
        }
    }

    public void removeNotify() {
        this.m_copyDBConnPanel.dispose();
        super.removeNotify();
    }
}

