/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Date;
import java.util.EventObject;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeArb;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.ui.cell.CellEditVerifier;
import oracle.dbtools.raptor.datatypes.ui.cell.CellEditorPanel;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.javatools.dialogs.MessageDialog;

public class BaseCellEditor
extends DefaultCellEditor
implements ComboBoxEditor {
    private static final JTextField dummyTextField = new JTextField();
    private JComponent m_inputVerifierOwner = null;
    DataValue dataValue;
    DataType dataType;
    Properties properties;
    private Object oldValue;
    private String propertyName;
    private boolean ignoreStopCellEdit;
    private VetoableChangeSupport m_vetoableChangeSupport;

    public BaseCellEditor() {
        super(dummyTextField);
        final JTextField jTextField = new JTextField();
        Document document = jTextField.getDocument();
        if (document != null) {
            document.putProperty("filterNewlines", Boolean.FALSE);
        }
        this.editorComponent = jTextField;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                Object object2 = object;
                if (object2 instanceof DataValue) {
                    BaseCellEditor.this.dataValue = (DataValue)object;
                    object2 = BaseCellEditor.this.dataValue.getStringValue();
                }
                jTextField.setText(object2 == null ? "" : object2.toString());
            }

            @Override
            public Object getCellEditorValue() {
                return jTextField.getText();
            }

            @Override
            public boolean startCellEditing(EventObject eventObject) {
                jTextField.selectAll();
                jTextField.requestFocusInWindow();
                return true;
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public BaseCellEditor(final DateTimeEditor dateTimeEditor) {
        super(dummyTextField);
        this.editorComponent = dateTimeEditor;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                if (object instanceof DataValue) {
                    BaseCellEditor.this.dataValue = (DataValue)object;
                    dateTimeEditor.setDate((Date)BaseCellEditor.this.dataValue.getTypedValue(ValueType.JAVA));
                } else {
                    dateTimeEditor.setDate((Date)object);
                }
            }

            @Override
            public Object getCellEditorValue() {
                return dateTimeEditor.getDate();
            }
        };
    }

    public BaseCellEditor(JComboBox jComboBox) {
        super(jComboBox);
    }

    public BaseCellEditor(final CellEditorPanel cellEditorPanel) {
        super(dummyTextField);
        this.editorComponent = cellEditorPanel;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                cellEditorPanel.setEditorPanelValue(object);
            }

            @Override
            public Object getCellEditorValue() {
                return cellEditorPanel.getEditorPanelValue();
            }
        };
    }

    public BaseCellEditor(final JTextArea jTextArea) {
        super(dummyTextField);
        this.editorComponent = jTextArea;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                Object object2 = object;
                if (object2 instanceof DataValue) {
                    BaseCellEditor.this.dataValue = (DataValue)object;
                    object2 = BaseCellEditor.this.dataValue.getStringValue();
                }
                jTextArea.setText(object2 == null ? "" : object2.toString());
            }

            @Override
            public Object getCellEditorValue() {
                return jTextArea.getText();
            }

            @Override
            public boolean startCellEditing(EventObject eventObject) {
                jTextArea.selectAll();
                jTextArea.requestFocusInWindow();
                return true;
            }
        };
    }

    public BaseCellEditor(final JLabel jLabel) {
        super(dummyTextField);
        this.editorComponent = jLabel;
        this.delegate = new DefaultCellEditor.EditorDelegate(){
            Object localValue;

            @Override
            public void setValue(Object object) {
                this.localValue = object;
                Object object2 = object;
                if (null == object2 || object2 instanceof DataValue && ((DataValue)object2).isNull()) {
                    object2 = DBConfig.getInstance().getString("NULLDISPLAY");
                }
                if (object2 instanceof DataValue) {
                    object2 = ((DataValue)object2).getStringValue().toString();
                }
                StringBuilder stringBuilder = new StringBuilder();
                Scanner scanner = new Scanner(object2.toString());
                boolean bl = true;
                while (scanner.hasNextLine()) {
                    if (bl) {
                        bl = false;
                        stringBuilder.append(scanner.nextLine());
                        continue;
                    }
                    stringBuilder.append("\\n").append(scanner.nextLine());
                }
                jLabel.setText(stringBuilder.toString());
            }

            @Override
            public Object getCellEditorValue() {
                return this.localValue;
            }
        };
    }

    public BaseCellEditor(JTextField jTextField) {
        super(jTextField);
    }

    public BaseCellEditor(JCheckBox jCheckBox) {
        super(jCheckBox);
    }

    public BaseCellEditor(final JSpinner jSpinner) {
        super(dummyTextField);
        this.editorComponent = jSpinner;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                if (object instanceof DataValue) {
                    BaseCellEditor.this.dataValue = (DataValue)object;
                    Object object2 = BaseCellEditor.this.dataValue.getTypedValue(ValueType.JAVA);
                    if (null == object2) {
                        object2 = 0;
                    }
                    jSpinner.setValue(object2);
                } else {
                    jSpinner.setValue(object);
                }
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
                    numberEditor.commitEdit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return jSpinner.getValue();
            }
        };
    }

    public void configure(DataType dataType) {
        this.dataType = dataType;
    }

    public final void configure(DataType dataType, Properties properties) {
        this.properties = properties;
        this.configure(dataType);
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
        this.oldValue = object;
    }

    public Object getValue() {
        return this.delegate.getCellEditorValue();
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object object) {
        this.oldValue = object;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public String getPropertyName() {
        return null != this.propertyName ? this.propertyName : (null != this.dataValue ? this.dataValue.getDataType().getDataTypeString() : "");
    }

    @Override
    public void cancelCellEditing() {
        if (this.m_inputVerifierOwner != null) {
            this.m_inputVerifierOwner.setInputVerifier(null);
        }
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        Object object;
        InputVerifier inputVerifier;
        if (this.ignoreStopCellEdit) {
            return false;
        }
        this.ignoreStopCellEdit = true;
        boolean bl = true;
        JComponent jComponent = this.m_inputVerifierOwner != null ? this.m_inputVerifierOwner : this.editorComponent;
        InputVerifier inputVerifier2 = inputVerifier = null != this.m_inputVerifierOwner ? this.m_inputVerifierOwner.getInputVerifier() : null;
        if (null != inputVerifier) {
            this.m_inputVerifierOwner.setInputVerifier(null);
        }
        Object object2 = this.getValue();
        if (this.editorComponent instanceof JComboBox && ((JComboBox)(object = (JComboBox)this.editorComponent)).isEditable()) {
            ((JComboBox)object).actionPerformed(new ActionEvent(this, 0, ""));
            object2 = this.getValue();
        }
        Logger.getLogger(this.getClass().getName()).log(Level.FINER, ".stopCellEditing: value = " + object2);
        object = null;
        if (null == this.dataValue && this.oldValue instanceof DataValue) {
            this.dataValue = (DataValue)this.oldValue;
        }
        if (null != this.dataValue) {
            object = this.dataValue.getDataType().validateValue(object2);
            Logger.getLogger(this.getClass().getName()).log(Level.FINER, ".stopCellEditing: valid= " + (String)object);
            if (null != object) {
                bl = false;
            } else {
                object2 = this.dataValue.getDataType().getDataValue(object2);
                Logger.getLogger(this.getClass().getName()).log(Level.FINER, ".stopCellEditing: (DataValue)value = " + object2);
            }
        }
        try {
            this.fireVetoableChange(this.propertyName, this.oldValue, object2);
        }
        catch (PropertyVetoException propertyVetoException) {
            bl = false;
        }
        if (!bl) {
            Object object3 = object;
            SwingUtilities.invokeLater(new Runnable((String)object3, jComponent, inputVerifier){
                final /* synthetic */ String val$msg;
                final /* synthetic */ JComponent val$focus;
                final /* synthetic */ InputVerifier val$verifier;
                {
                    this.val$msg = string;
                    this.val$focus = jComponent;
                    this.val$verifier = inputVerifier;
                }

                @Override
                public void run() {
                    if (null != this.val$msg && 0 < this.val$msg.length()) {
                        if (!this.val$focus.isShowing()) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINER, "BaseCellEditor.stopCellEditing..run..error: skipping error dialog (focus not visible) " + this.val$focus);
                        } else {
                            MessageDialog.error((Component)this.val$focus, (Object)this.val$msg, (String)DataTypeArb.getString((String)"INVALID_VALUE"), (String)null);
                        }
                    }
                    if (null != this.val$verifier) {
                        this.val$focus.setInputVerifier(this.val$verifier);
                    }
                    BaseCellEditor.this.ignoreStopCellEdit = false;
                }
            });
        } else {
            try {
                bl = super.stopCellEditing();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                bl = false;
            }
            this.ignoreStopCellEdit = false;
        }
        return bl;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (null == this.m_vetoableChangeSupport) {
            this.m_vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.m_vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (null != this.m_vetoableChangeSupport) {
            this.m_vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (null != this.m_vetoableChangeSupport) {
            this.m_vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setBorder(BorderFactory.createEmptyBorder());
            if (jComponent instanceof JComboBox) {
                Component component2 = ((JComboBox)jComponent).getEditor().getEditorComponent();
                if (component2 instanceof CellEditorPanel) {
                    component2 = ((CellEditorPanel)component2).getEditor().getCellEditor().getEditorComponent();
                }
                if (component2 instanceof JComponent) {
                    jComponent = (JComponent)component2;
                }
            }
            if (jComponent instanceof JSpinner) {
                jComponent = ((JSpinner.DefaultEditor)((JSpinner)jComponent).getEditor()).getTextField();
            }
            jComponent.setBorder(BorderFactory.createEmptyBorder());
            jComponent.setInputVerifier(new CellEditVerifier(this));
            this.m_inputVerifierOwner = jComponent;
        }
        this.oldValue = object;
        return component;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (this.editorComponent instanceof JTextField) {
            ((JTextField)this.editorComponent).addActionListener(actionListener);
        }
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        if (this.editorComponent instanceof JTextField) {
            ((JTextField)this.editorComponent).removeActionListener(actionListener);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this.getComponent();
    }

    @Override
    public Object getItem() {
        return this.getValue();
    }

    @Override
    public void selectAll() {
        this.delegate.startCellEditing(null);
    }

    @Override
    public void setItem(Object object) {
        this.setValue(object);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getProperty(String string) {
        return this.properties == null ? null : this.properties.getProperty(string);
    }
}

