/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.ui.cell;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.ui.DatatypesUiArb;
import oracle.dbtools.raptor.datatypes.ui.cell.BaseCustomCellEditor;
import oracle.dbtools.raptor.datatypes.ui.cell.NoEditCellEditor;
import oracle.dbtools.raptor.mimeeditor.ExternalBlobEditor;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;

public class LargeBinaryCustomCellEditor
extends BaseCustomCellEditor {
    private DataType dataType;
    private DataValue customEditorValue;
    protected JPanel customEditorPanel;
    private JTabbedPane tabbedPane;
    private JTextArea stringValue;
    private JTextArea textValue;
    private JLabel imageValue;
    private JButton loadButton;
    private JButton saveButton;
    private JButton externalEditButton;
    protected static URL _lastLoadUrl;
    protected static URL _lastSaveUrl;

    public LargeBinaryCustomCellEditor() {
        super(new NoEditCellEditor());
    }

    @Override
    public void configure(DataType dataType) {
        super.configure(dataType);
        this.dataType = dataType;
    }

    @Override
    protected Object getCustomEditorValue() {
        return this.customEditorValue;
    }

    @Override
    protected void setCustomEditorValue(Object object) {
        try {
            this.customEditorValue = this.dataType.getDataValue(object);
            this.updateUI();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    protected JComponent getCustomEditorComponent() {
        if (null == this.customEditorPanel) {
            this.customEditorPanel = new JPanel();
            this.createUI(this.customEditorPanel);
        }
        return this.customEditorPanel;
    }

    @Override
    protected JComponent getCustomEditorFocusComponent() {
        return null;
    }

    private void createUI(JPanel jPanel) {
        this.stringValue = new JTextArea();
        this.stringValue.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.stringValue);
        jScrollPane.setMinimumSize(new Dimension(-1, 35));
        this.textValue = new JTextArea();
        this.textValue.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.textValue);
        jScrollPane2.setMinimumSize(new Dimension(-1, 60));
        this.imageValue = new JLabel();
        this.imageValue.setHorizontalAlignment(0);
        this.imageValue.setVerticalAlignment(0);
        JScrollPane jScrollPane3 = new JScrollPane(this.imageValue);
        jScrollPane3.getViewport().setBackground(Color.white);
        jScrollPane3.setMinimumSize(new Dimension(-1, 60));
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.add(DatatypesUiArb.get("LargeBinaryCustomCellEditor.Hex.Tab.Title"), jScrollPane);
        this.tabbedPane.add(DatatypesUiArb.get("LargeBinaryCustomCellEditor.Text.Tab.Title"), jScrollPane2);
        this.tabbedPane.add(DatatypesUiArb.get("LargeBinaryCustomCellEditor.Image.Tab.Title"), jScrollPane3);
        this.loadButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)DatatypesUiArb.get("LargeBinaryCustomCellEditor.Load.Button"));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LargeBinaryCustomCellEditor.this.load();
            }
        });
        this.saveButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)DatatypesUiArb.get("LargeBinaryCustomCellEditor.Save.Button"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LargeBinaryCustomCellEditor.this.save();
            }
        });
        this.externalEditButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.externalEditButton, (String)DatatypesUiArb.get("LargeBinaryCustomCellEditor.ExternalEdit.Button"));
        this.externalEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LargeBinaryCustomCellEditor.this.externalEdit();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        jPanel2.add(this.loadButton);
        jPanel2.add(this.saveButton);
        jPanel2.add(this.externalEditButton);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tabbedPane, "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    protected void updateUI() {
        this.customEditorPanel.setCursor(new Cursor(3));
        this.stringValue.setText(this.getStringValue(this.customEditorValue));
        this.textValue.setText(this.getTextValue(this.customEditorValue));
        Icon icon = this.getIconValue(this.customEditorValue);
        this.imageValue.setIcon(icon);
        if (null == icon) {
            this.imageValue.setText(DatatypesUiArb.get("LargeBinaryCustomCellEditor.Image.Tab.NotImage"));
        } else {
            this.imageValue.setText(null);
        }
        if (null == this.customEditorValue || this.customEditorValue.isNull()) {
            this.saveButton.setEnabled(false);
            this.externalEditButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
            this.externalEditButton.setEnabled(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LargeBinaryCustomCellEditor.this.customEditorPanel.setCursor(new Cursor(0));
            }
        });
    }

    private String getStringValue(DataValue dataValue) {
        if (null == dataValue || dataValue.isNull()) {
            return DBConfig.getInstance().getString("NULLDISPLAY");
        }
        return dataValue.getStringValue().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTextValue(DataValue dataValue) {
        if (null == dataValue || dataValue.isNull()) {
            return DBConfig.getInstance().getString("NULLDISPLAY");
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = this.getInputStream(dataValue);
            if (inputStream != null && (bufferedReader = new BufferedReader(new InputStreamReader(inputStream))) != null) {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string).append('\n');
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getIconValue(DataValue dataValue) {
        if (null == dataValue || dataValue.isNull()) {
            return null;
        }
        ImageIcon imageIcon = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(dataValue);
            if (inputStream != null) {
                inputStream.mark(Integer.MAX_VALUE);
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage != null) {
                    imageIcon = new ImageIcon(bufferedImage);
                } else {
                    inputStream.reset();
                    if (this.skipOLEHeader(inputStream) && (bufferedImage = ImageIO.read(inputStream)) != null) {
                        imageIcon = new ImageIcon(bufferedImage);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return imageIcon;
    }

    private InputStream getInputStream(DataValue dataValue) {
        if ("BLOB".equals(dataValue.getDataType().getBaseDataTypeString())) {
            return (InputStream)dataValue.getTypedValue(ValueType.JAVA);
        }
        if ("LONG RAW".equals(dataValue.getDataType().getBaseDataTypeString())) {
            return (InputStream)dataValue.getTypedValue(ValueType.JAVA);
        }
        if ("RAW".equals(dataValue.getDataType().getBaseDataTypeString())) {
            byte[] byArray = (byte[])dataValue.getTypedValue(ValueType.JAVA);
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    private boolean skipOLEHeader(InputStream inputStream) {
        String string = "Bitmap Image";
        String string2 = "Paint.Picture";
        byte[] byArray = new byte[512];
        try {
            int n;
            int n2 = inputStream.read(byArray);
            if (n2 == -1 || n2 < 46) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 20; n < 20 + string.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            for (n = 33; n < 33 + string2.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string2)) {
                return false;
            }
            boolean bl = false;
            for (n = 33 + string2.length(); n < n2; ++n) {
                if (byArray[n] != 66 || byArray[n + 1] != 77) continue;
                bl = true;
                break;
            }
            if (bl) {
                inputStream.reset();
                inputStream.skip(n);
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
        return false;
    }

    protected void load() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.clearChooseableURLFilters();
        if (_lastLoadUrl == null) {
            String string = System.getProperty("user.home");
            File file = new File(string);
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        } else {
            uRLFileChooser.setSelectedURL(_lastLoadUrl);
        }
        if (uRLFileChooser.showOpenDialog(this.customEditorPanel) == 0) {
            _lastLoadUrl = uRLFileChooser.getSelectedURL();
            try {
                this.setCustomEditorValue(new FileInputStream(_lastLoadUrl.getFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ExceptionHandler.handleException((Throwable)fileNotFoundException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        Object object;
        Object object2;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.clearChooseableURLFilters();
        if (_lastSaveUrl == null) {
            _lastSaveUrl = _lastLoadUrl;
        }
        if (_lastSaveUrl == null) {
            object2 = System.getProperty("user.home");
            object = new File((String)object2);
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)object));
        } else {
            uRLFileChooser.setSelectedURL(_lastSaveUrl);
        }
        if (uRLFileChooser.showSaveDialog(this.customEditorPanel) == 0) {
            _lastSaveUrl = uRLFileChooser.getSelectedURL();
            object2 = null;
            try {
                object2 = new FileOutputStream(_lastSaveUrl.getFile());
                object = this.getInputStream(this.customEditorValue);
                if (object != null) {
                    byte[] byArray = new byte[256];
                    int n = 0;
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        ((FileOutputStream)object2).write(byArray, 0, n);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            finally {
                if (object2 != null) {
                    try {
                        ((FileOutputStream)object2).close();
                    }
                    catch (IOException iOException) {
                        ExceptionHandler.handleException((Throwable)iOException);
                    }
                }
            }
        }
    }

    protected void externalEdit() {
        try {
            ExternalBlobEditor externalBlobEditor = new ExternalBlobEditor();
            URL uRL = externalBlobEditor.displayBlobEditor(this.getInputStream(this.customEditorValue));
            FileInputStream fileInputStream = new FileInputStream(uRL.getFile());
            if (externalBlobEditor.isFileModified()) {
                this.setCustomEditorValue(fileInputStream);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }
}

