/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.ddl.Messages;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class DDLContextMenuListener
implements ContextMenuListener,
Controller {
    private JMenu _menu;
    public static final String DDL_AS_FILE_CMD = "DatabaseNavigator.DDL_AS_FILE_CMD";
    public static final int DDL_AS_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_AS_FILE_CMD");
    public static final String DDL_TO_WRKSHEET_CMD = "DatabaseNavigator.DDL_TO_WRKSHEET_CMD";
    public static final int DDL_TO_WRKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_WRKSHEET_CMD");
    public static final String DDL_TO_CLIPBOARD_CMD = "DatabaseNavigator.DDL_TO_CLIPBOARD_CMD";
    public static final int DDL_TO_CLIPBOARD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_CLIPBOARD_CMD");
    public static final String DDL_TO_HTML_FILE_CMD = "DatabaseNavigator.EXPORT_DDL_TO_HTML_FILE";
    public static final IdeAction DDL_TO_FILE = IdeAction.find((int)DDL_AS_FILE_CMD_ID);
    public static final IdeAction DDL_TO_WRKSHEET = IdeAction.find((int)DDL_TO_WRKSHEET_CMD_ID);
    public static final IdeAction DDL_TO_CLIPBOARD = IdeAction.find((int)DDL_TO_CLIPBOARD_CMD_ID);
    private Element[] _elems;

    private void init() {
        if (this._menu == null) {
            String string = DatabaseNavigatorResources.getString("QUICK_DDL");
            this._menu = new JMenu(string);
            this._menu.getAccessibleContext().setAccessibleName(string + oracle.dbtools.raptor.dialogs.Messages.getString((String)"XMLBasedObjectAction.25"));
            this._menu.add((Action)DDL_TO_FILE);
            this._menu.add((Action)DDL_TO_WRKSHEET);
            this._menu.add((Action)DDL_TO_CLIPBOARD);
            DDL_TO_FILE.addController((Controller)this);
            DDL_TO_WRKSHEET.addController((Controller)this);
            DDL_TO_CLIPBOARD.addController((Controller)this);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (!(view instanceof NavigatorWindow) || view instanceof DBNavigatorWindow) {
            this.init();
            DBObject dBObject = null;
            boolean bl = true;
            this._elems = contextMenu.getContext().getSelection();
            if (this._elems.length == 0) {
                bl = false;
            }
            for (Element element : this._elems) {
                dBObject = new DBObject(element);
                if (DDLRegistry.isSupported(dBObject.getKey())) continue;
                bl = false;
            }
            if (bl) {
                contextMenu.add((Component)this._menu);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DDL_AS_FILE_CMD_ID) {
            this.saveToFile(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_WRKSHEET_CMD_ID) {
            this.saveToWorkSheet(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_CLIPBOARD_CMD_ID) {
            this.saveToClip(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private void getDDL(Context context, int n) {
        this.getDDL(context, n, null);
    }

    private void getDDL(Context context, int n, String string) {
        List<DBObject> list = this.getList(context);
        ExportAPI exportAPI = new ExportAPI();
        ExtractListModel extractListModel = new ExtractListModel(list);
        if (extractListModel == null) {
            return;
        }
        try {
            exportAPI.setQuickDDL(extractListModel, n, string);
            exportAPI.writeExportWithDialog();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private List<DBObject> getList(Context context) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (Element element : this._elems) {
            arrayList.add(this.getDBObject((Node)element));
        }
        return arrayList;
    }

    private DBObject getDBObject(Node node) {
        if (node instanceof ObjectNode && ((ObjectNode)node).getObjectType().equals("MATERIALIZED VIEW LOG")) {
            ObjectNode objectNode = (ObjectNode)node;
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", objectNode.getConnectionName(), null, objectNode.getSchemaName(), objectNode.getObjectType());
            URL uRL2 = DBURLFormatHelper.getURL(uRL, objectNode.getShortLabel());
            return new DBObject(uRL2);
        }
        return new DBObject((Element)node);
    }

    private void saveToWorkSheet(Context context) {
        try {
            this.getDDL(context, 4);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void saveToClip(Context context) {
        try {
            this.getDDL(context, 5);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void saveToFile(Context context) {
        File file;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        String string = DBConfig.getInstance().getString("EXPORTDIR");
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
        }
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        file = new DefaultURLFilter(Messages.getString("DDLContextMenuListener.4"), "sql");
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)file);
        TargetFormat targetFormat = new TargetFormat(1, 1);
        targetFormat.setSaveAsType(0);
        int n = -1;
        String string2 = "";
        while (n != 0) {
            int n2 = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n2 == 0) {
                File file2 = new File(uRLFileChooser.getSelectedURL().getPath());
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    string2 = file2.getPath();
                }
                URL uRL = uRLFileChooser.getSelectedURL();
                if (this.validateSaveToFile((Component)Ide.getMainWindow(), uRL) != 0) {
                    return;
                }
                if (string2.indexOf(".sql") == -1) {
                    string2 = string2 + ".sql";
                }
                targetFormat.setSaveAs(string2);
                n = targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                if (n != 1) continue;
                try {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)targetFormat.getValidationMessage(), (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                continue;
            }
            return;
        }
        this.getDDL(context, 0, string2);
    }

    private int validateSaveToFile(Component component, URL uRL) {
        File file = new File(uRL.getPath());
        if (!file.exists()) {
            return 0;
        }
        boolean bl = MessageDialog.confirm((Component)component, (Object)Messages.getString("DDLContextMenuListener.5"), (String)Messages.getString("DDLContextMenuListener.6"), null);
        if (!bl) {
            return 1;
        }
        return 0;
    }
}

