/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;

public class DDLTypes {
    public static final String DROP = "DROP";
    public static final String DATA = "DATA";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String APEX_PAGE = "APEX_PAGE";
    public static final String APEX = "APEX";
    public static final String QUEUETABLE = "QUEUE TABLE";
    public static final String REFCONSTRAINT = "REFCONSTRAINT";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String QUEUE = "QUEUE";
    public static final String DIRECTORY = "DIRECTORY";
    public static final String MATVIEWLOG = "MATERIALIZED VIEW LOG";
    public static final String SYNONYM = "SYNONYM";
    public static final String DBLINK = "DATABASE LINK";
    public static final String FUNCTION = "FUNCTION";
    public static final String INDEX = "INDEX";
    public static final String MATVIEW = "MATERIALIZED VIEW";
    public static final String PACKSPEC = "PACKAGE";
    public static final String PACKBODY = "PACKAGE BODY";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String TABLE = "TABLE";
    public static final String TRIGGER = "TRIGGER";
    public static final String TYPE = "TYPE";
    public static final String EDITION_VIEW = "EDITION_VIEW";
    public static final String VIEW = "VIEW";
    public static final String[] DATA_OBJECT_URL_TYPES = new String[]{"TABLE", "VIEW", "EDITION_VIEW", "MATERIALIZED+VIEW"};
    public static final String[] DATA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "EDITION_VIEW"};
    public static final LinkedHashMap<String, String> ret = new LinkedHashMap();
    private boolean _doView = true;
    private boolean _doTypes = true;
    private boolean _doTriggers = true;
    private boolean _doTables = true;
    private boolean _doSequence = true;
    private boolean _doProcedure = true;
    private boolean _doPackBody = true;
    private boolean _doPackSpec = true;
    private boolean _doMatView = true;
    private boolean _doIndex = true;
    private boolean _doFunction = true;
    private boolean _doDbLink = true;
    private boolean _doConstraints = true;
    private boolean _doRefConstraints = true;
    private boolean _doSynonymn = true;
    private boolean _doMatViewLog = true;
    private boolean _doTabDeps = false;
    private boolean _doDirectory = false;
    private boolean _doQueue = true;
    private boolean _doQueueTable = true;
    private boolean _doApex = false;
    private boolean _doApexPage = false;
    private boolean _showView = true;
    private boolean _showTypes = true;
    private boolean _showTriggers = true;
    private boolean _showTables = true;
    private boolean _showSequence = true;
    private boolean _showProcedure = true;
    private boolean _showPackBody = true;
    private boolean _showPackSpec = true;
    private boolean _showMatView = true;
    private boolean _showIndex = true;
    private boolean _showFunction = true;
    private boolean _showDbLink = true;
    private boolean _showConstraints = true;
    private boolean _showRefConstraints = false;
    private boolean _showSynonymn = true;
    private boolean _showMatViewLog = true;
    private boolean _showTabDeps = false;
    private boolean _showDirectory = false;
    private boolean _showQueue = true;
    private boolean _showQueueTable = true;
    private boolean _showApex = false;
    private boolean _showApexPage = false;

    public void setEnable(boolean bl) {
        this._doView = bl;
        this._doTypes = bl;
        this._doTriggers = bl;
        this._doTables = bl;
        this._doSequence = bl;
        this._doProcedure = bl;
        this._doPackBody = bl;
        this._doPackSpec = bl;
        this._doMatView = bl;
        this._doIndex = bl;
        this._doFunction = bl;
        this._doDbLink = bl;
        this._doConstraints = bl;
        this._doRefConstraints = bl;
        this._doSynonymn = bl;
        this._doMatViewLog = bl;
        this._doTabDeps = bl;
        this._doDirectory = bl;
        this._doQueue = bl;
        this._doQueueTable = bl;
        this._doApex = bl;
        this._doApexPage = bl;
    }

    public void setShow(boolean bl) {
        this._showView = bl;
        this._showTypes = bl;
        this._showTriggers = bl;
        this._showTables = bl;
        this._showSequence = bl;
        this._showProcedure = bl;
        this._showPackBody = bl;
        this._showPackSpec = bl;
        this._showMatView = bl;
        this._showIndex = bl;
        this._showFunction = bl;
        this._showDbLink = bl;
        this._showConstraints = bl;
        this._showSynonymn = bl;
        this._showMatViewLog = bl;
        this._showTabDeps = bl;
        this._showDirectory = bl;
        this._showQueue = bl;
        this._showQueueTable = bl;
        this._showApex = bl;
        this._showApexPage = bl;
    }

    public void setView(boolean bl) {
        this._doView = bl;
    }

    public void setType(boolean bl) {
        this._doTypes = bl;
    }

    public void setTrigger(boolean bl) {
        this._doTriggers = bl;
    }

    public void setTable(boolean bl) {
        this._doTables = bl;
    }

    public void setSequence(boolean bl) {
        this._doSequence = bl;
    }

    public void setProcedure(boolean bl) {
        this._doProcedure = bl;
    }

    public void setPackBody(boolean bl) {
        this._doPackBody = bl;
    }

    public void setPackSpec(boolean bl) {
        this._doPackSpec = bl;
    }

    public void setMatView(boolean bl) {
        this._doMatView = bl;
    }

    public void setIndex(boolean bl) {
        this._doIndex = bl;
    }

    public void setFunction(boolean bl) {
        this._doFunction = bl;
    }

    public void setDbLink(boolean bl) {
        this._doDbLink = bl;
    }

    public void setConstraint(boolean bl) {
        this._doConstraints = bl;
    }

    public void setRefConstraint(boolean bl) {
        this._doRefConstraints = bl;
    }

    public void setSynonymn(boolean bl) {
        this._doSynonymn = bl;
    }

    public void setMatViewLog(boolean bl) {
        this._doMatViewLog = bl;
    }

    public void setTableDeps(boolean bl) {
        this._doTabDeps = bl;
    }

    public void setDirectory(boolean bl) {
        this._doDirectory = bl;
    }

    public void setQueue(boolean bl) {
        this._doQueue = bl;
    }

    public void setQueueTable(boolean bl) {
        this._doQueueTable = bl;
    }

    public void setApex(boolean bl) {
        this._doApex = bl;
    }

    public void setApexPage(boolean bl) {
        this._doApexPage = bl;
    }

    public boolean getView() {
        return this._showView && this._doView;
    }

    public boolean getType() {
        return this._showTypes && this._doTypes;
    }

    public boolean getTrigger() {
        return this._showTriggers && this._doTriggers;
    }

    public boolean getTable() {
        return this._showTables && this._doTables;
    }

    public boolean getSequence() {
        return this._showSequence && this._doSequence;
    }

    public boolean getProcedure() {
        return this._showProcedure && this._doProcedure;
    }

    public boolean getPackBody() {
        return this._showPackBody && this._doPackBody;
    }

    public boolean getPackSpec() {
        return this._showPackSpec && this._doPackSpec;
    }

    public boolean getMatView() {
        return this._showMatView && this._doMatView;
    }

    public boolean getIndex() {
        return this._showIndex && this._doIndex;
    }

    public boolean getFunction() {
        return this._showFunction && this._doFunction;
    }

    public boolean getDbLink() {
        return this._showDbLink && this._doDbLink;
    }

    public boolean getConstraint() {
        return this._showConstraints && this._doConstraints;
    }

    public boolean getRefConstraint() {
        if (!this._showRefConstraints) {
            return this._showConstraints && this._doConstraints;
        }
        return this._showRefConstraints && this._doRefConstraints;
    }

    public boolean getSynonymn() {
        return this._showSynonymn && this._doSynonymn;
    }

    public boolean getMatViewLog() {
        return this._showMatViewLog && this._doMatViewLog;
    }

    public boolean getTableDeps() {
        return this._showTabDeps && this._doTabDeps;
    }

    public boolean getDirectory() {
        return this._showDirectory && this._doDirectory;
    }

    public boolean getQueue() {
        return this._showQueue && this._doQueue;
    }

    public boolean getQueueTable() {
        return this._showQueueTable && this._doQueueTable;
    }

    public boolean getApex() {
        return this._showApex && this._doApex;
    }

    public boolean getApexPage() {
        return this._showApexPage && this._doApexPage;
    }

    public void setShowView(boolean bl) {
        this._showView = bl;
    }

    public void setShowType(boolean bl) {
        this._showTypes = bl;
    }

    public void setShowTrigger(boolean bl) {
        this._showTriggers = bl;
    }

    public void setShowTable(boolean bl) {
        this._showTables = bl;
    }

    public void setShowSequence(boolean bl) {
        this._showSequence = bl;
    }

    public void setShowProcedure(boolean bl) {
        this._showProcedure = bl;
    }

    public void setShowPackBody(boolean bl) {
        this._showPackBody = bl;
    }

    public void setShowPackSpec(boolean bl) {
        this._showPackSpec = bl;
    }

    public void setShowMatView(boolean bl) {
        this._showMatView = bl;
    }

    public void setShowIndex(boolean bl) {
        this._showIndex = bl;
    }

    public void setShowFunction(boolean bl) {
        this._showFunction = bl;
    }

    public void setShowDbLink(boolean bl) {
        this._showDbLink = bl;
    }

    public void setShowData(boolean bl) {
    }

    public void setShowConstraint(boolean bl) {
        this._showConstraints = bl;
    }

    public void setShowRefConstraint(boolean bl) {
        this._showRefConstraints = bl;
    }

    public void setShowSynonymn(boolean bl) {
        this._showSynonymn = bl;
    }

    public void setShowMatViewLog(boolean bl) {
        this._showMatViewLog = bl;
    }

    public void setShowTableDeps(boolean bl) {
        this._showTabDeps = bl;
    }

    public void setShowDirectory(boolean bl) {
        this._showDirectory = bl;
    }

    public void setShowQueue(boolean bl) {
        this._showQueue = bl;
    }

    public void setShowQueueTable(boolean bl) {
        this._showQueueTable = bl;
    }

    public void setShowApex(boolean bl) {
        this._showApex = bl;
    }

    public void setShowApexPage(boolean bl) {
        this._showApexPage = bl;
    }

    public boolean getShowView() {
        return this._showView;
    }

    public boolean getShowType() {
        return this._showTypes;
    }

    public boolean getShowTrigger() {
        return this._showTriggers;
    }

    public boolean getShowTable() {
        return this._showTables;
    }

    public boolean getShowSequence() {
        return this._showSequence;
    }

    public boolean getShowProcedure() {
        return this._showProcedure;
    }

    public boolean getShowPackBody() {
        return this._showPackBody;
    }

    public boolean getShowPackSpec() {
        return this._showPackSpec;
    }

    public boolean getShowMatView() {
        return this._showMatView;
    }

    public boolean getShowIndex() {
        return this._showIndex;
    }

    public boolean getShowFunction() {
        return this._showFunction;
    }

    public boolean getShowDbLink() {
        return this._showDbLink;
    }

    public boolean getShowConstraint() {
        return this._showConstraints;
    }

    public boolean getShowRefConstraint() {
        return this._showRefConstraints;
    }

    public boolean getShowSynonymn() {
        return this._showSynonymn;
    }

    public boolean getShowMatViewLog() {
        return this._showMatViewLog;
    }

    public boolean getShowTableDeps() {
        return this._showTabDeps;
    }

    public boolean getShowDirectory() {
        return this._showDirectory;
    }

    public boolean getShowQueue() {
        return this._showQueue;
    }

    public boolean getShowQueueTable() {
        return this._showQueueTable;
    }

    public boolean getShowApex() {
        return this._showApex;
    }

    public boolean getShowApexPage() {
        return this._showApexPage;
    }

    public ArrayList<String> getTypes(int n) {
        switch (n) {
            case 1: {
                return this.getCreateTypes();
            }
            case 2: {
                return this.getCreatePreDataTypes();
            }
            case 3: {
                return this.getCreatePostDataTypes();
            }
            case 4: {
                return this.getDropTypes();
            }
            case 5: {
                return this.getTableType();
            }
            case 6: {
                return this.getTableType();
            }
            case 7: {
                return this.getTableType();
            }
        }
        return null;
    }

    public ArrayList<String> getCreateTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDbLink()) {
            arrayList.add(DBLINK);
        }
        if (this.getType()) {
            arrayList.add(TYPE);
        }
        if (this.getSequence()) {
            arrayList.add(SEQUENCE);
        }
        if (this.getTable()) {
            arrayList.add(TABLE);
        }
        if (this.getView()) {
            arrayList.add(VIEW);
        }
        if (this.getMatView()) {
            arrayList.add(MATVIEW);
        }
        if (this.getIndex()) {
            arrayList.add(INDEX);
        }
        if (this.getConstraint()) {
            arrayList.add(CONSTRAINT);
        }
        if (this.getRefConstraint()) {
            arrayList.add(REFCONSTRAINT);
        }
        if (this.getTrigger()) {
            arrayList.add(TRIGGER);
        }
        if (this.getMatViewLog()) {
            arrayList.add(MATVIEWLOG);
        }
        if (this.getFunction()) {
            arrayList.add(FUNCTION);
        }
        if (this.getPackSpec()) {
            arrayList.add(PACKSPEC);
        }
        if (this.getPackBody()) {
            arrayList.add(PACKBODY);
        }
        if (this.getProcedure()) {
            arrayList.add(PROCEDURE);
        }
        if (this.getSynonymn()) {
            arrayList.add(SYNONYM);
        }
        if (this.getDirectory()) {
            arrayList.add(DIRECTORY);
        }
        if (this.getQueue()) {
            arrayList.add(QUEUE);
        }
        if (this.getQueueTable()) {
            arrayList.add(QUEUETABLE);
        }
        if (this.getApex()) {
            arrayList.add(APEX);
        }
        if (this.getApexPage()) {
            arrayList.add(APEX_PAGE);
        }
        return arrayList;
    }

    public ArrayList<String> getCreatePreDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDbLink()) {
            arrayList.add(DBLINK);
        }
        if (this.getType()) {
            arrayList.add(TYPE);
        }
        if (this.getType()) {
            arrayList.add(DIRECTORY);
        }
        if (this.getSequence()) {
            arrayList.add(SEQUENCE);
        }
        if (this.getTable()) {
            arrayList.add(TABLE);
        }
        if (this.getView()) {
            arrayList.add(VIEW);
        }
        if (this.getMatView()) {
            arrayList.add(MATVIEW);
        }
        return arrayList;
    }

    public ArrayList<String> getCreatePostDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getIndex()) {
            arrayList.add(INDEX);
        }
        if (this.getConstraint()) {
            arrayList.add(CONSTRAINT);
        }
        if (this.getRefConstraint()) {
            arrayList.add(REFCONSTRAINT);
        }
        if (this.getTrigger()) {
            arrayList.add(TRIGGER);
        }
        if (this.getMatViewLog()) {
            arrayList.add(MATVIEWLOG);
        }
        if (this.getFunction()) {
            arrayList.add(FUNCTION);
        }
        if (this.getPackSpec()) {
            arrayList.add(PACKSPEC);
        }
        if (this.getPackBody()) {
            arrayList.add(PACKBODY);
        }
        if (this.getProcedure()) {
            arrayList.add(PROCEDURE);
        }
        if (this.getSynonymn()) {
            arrayList.add(SYNONYM);
        }
        if (this.getDirectory()) {
            arrayList.add(DIRECTORY);
        }
        if (this.getQueue()) {
            arrayList.add(QUEUE);
        }
        if (this.getQueueTable()) {
            arrayList.add(QUEUETABLE);
        }
        if (this.getApex()) {
            arrayList.add(APEX);
        }
        if (this.getApexPage()) {
            arrayList.add(APEX_PAGE);
        }
        return arrayList;
    }

    public ArrayList<String> getDropTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getTable()) {
            arrayList.add(TABLE);
        } else {
            if (this.getTrigger()) {
                arrayList.add(TRIGGER);
            }
            if (this.getIndex()) {
                arrayList.add(INDEX);
            }
        }
        if (this.getSynonymn()) {
            arrayList.add(SYNONYM);
        }
        if (this.getDbLink()) {
            arrayList.add(DBLINK);
        }
        if (this.getSequence()) {
            arrayList.add(SEQUENCE);
        }
        if (this.getMatView()) {
            arrayList.add(MATVIEW);
        }
        if (this.getMatViewLog()) {
            arrayList.add(MATVIEWLOG);
        }
        if (this.getView()) {
            arrayList.add(VIEW);
        }
        if (this.getFunction()) {
            arrayList.add(FUNCTION);
        }
        if (this.getPackSpec()) {
            arrayList.add(PACKSPEC);
        }
        if (this.getPackBody()) {
            arrayList.add(PACKBODY);
        }
        if (this.getProcedure()) {
            arrayList.add(PROCEDURE);
        }
        if (this.getQueue()) {
            arrayList.add(QUEUE);
        }
        if (this.getQueueTable()) {
            arrayList.add(QUEUETABLE);
        }
        if (this.getType()) {
            arrayList.add(TYPE);
        }
        if (this.getDirectory()) {
            arrayList.add(DIRECTORY);
        }
        return arrayList;
    }

    public ArrayList<String> getTableType() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getTable()) {
            arrayList.add(TABLE);
        }
        return arrayList;
    }

    public LinkedHashMap<String, String> getTypes(boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.getDbLink()) {
            linkedHashMap.put(DBLINK, "Oracle#DATABASE_LINK");
        }
        if (this.getType()) {
            linkedHashMap.put(TYPE, "Oracle#TYPE");
        }
        if (this.getSequence()) {
            linkedHashMap.put(SEQUENCE, "Oracle#SEQUENCE");
        }
        if (this.getTable()) {
            linkedHashMap.put(TABLE, "Oracle#TABLE");
        }
        if (this.getView()) {
            linkedHashMap.put(VIEW, "Oracle#VIEW");
        }
        if (this.getMatView()) {
            linkedHashMap.put(MATVIEW, "Oracle#MATERIALIZED_VIEW");
        }
        if (bl) {
            linkedHashMap.put(DATA, "Oracle#DATA");
        }
        if (this.getIndex()) {
            linkedHashMap.put(INDEX, "Oracle#INDEX");
        }
        if (this.getConstraint()) {
            linkedHashMap.put(CONSTRAINT, "Oracle#CONSTRAINT");
        }
        if (this.getRefConstraint()) {
            linkedHashMap.put(REFCONSTRAINT, "Oracle#REFCONSTRAINT");
        }
        if (this.getTrigger()) {
            linkedHashMap.put(TRIGGER, "Oracle#TRIGGER");
        }
        if (this.getMatViewLog()) {
            linkedHashMap.put(MATVIEWLOG, "Oracle#MATERIALIZED_VIEW_LOG");
        }
        if (this.getFunction()) {
            linkedHashMap.put(FUNCTION, "Oracle#FUNCTION");
        }
        if (this.getPackSpec()) {
            linkedHashMap.put(PACKSPEC, "Oracle#PACKAGE");
        }
        if (this.getPackBody()) {
            linkedHashMap.put(PACKBODY, "Oracle#PACKAGE_BODY");
        }
        if (this.getProcedure()) {
            linkedHashMap.put(PROCEDURE, "Oracle#PROCEDURE");
        }
        if (this.getSynonymn()) {
            linkedHashMap.put(SYNONYM, "Oracle#SYNONYM");
        }
        if (this.getDirectory()) {
            linkedHashMap.put(DIRECTORY, "Oracle#DIRECTORY");
        }
        if (this.getQueue()) {
            linkedHashMap.put(QUEUE, "Oracle#QUEUE");
        }
        if (this.getQueueTable()) {
            linkedHashMap.put(QUEUETABLE, "Oracle#QUEUE_TABLE");
        }
        if (this.getApex()) {
            linkedHashMap.put(APEX, "Oracle#APEX");
        }
        if (this.getApexPage()) {
            linkedHashMap.put(APEX_PAGE, "Oracle#APEX_PAGE");
        }
        return linkedHashMap;
    }

    public boolean isSupportedType(String string) {
        LinkedHashMap<String, String> linkedHashMap = this.getTypes(true);
        return linkedHashMap.get(string) != null;
    }

    public ArrayList<String> getTypeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getDbLink()) {
            arrayList.add(DBLINK);
        }
        if (this.getSequence()) {
            arrayList.add(SEQUENCE);
        }
        if (this.getTable()) {
            arrayList.add(TABLE);
        }
        if (this.getIndex()) {
            arrayList.add(INDEX);
        }
        if (this.getTrigger()) {
            arrayList.add(TRIGGER);
        }
        if (this.getView()) {
            arrayList.add(VIEW);
        }
        if (this.getMatView()) {
            arrayList.add(MATVIEW);
        }
        if (this.getMatViewLog()) {
            arrayList.add(MATVIEWLOG);
        }
        if (this.getFunction()) {
            arrayList.add(FUNCTION);
        }
        if (this.getPackSpec()) {
            arrayList.add(PACKSPEC);
        }
        if (this.getPackBody()) {
            arrayList.add(PACKBODY);
        }
        if (this.getProcedure()) {
            arrayList.add(PROCEDURE);
        }
        if (this.getType()) {
            arrayList.add(TYPE);
        }
        if (this.getSynonymn()) {
            arrayList.add(SYNONYM);
        }
        if (this.getDirectory()) {
            arrayList.add(DIRECTORY);
        }
        if (this.getQueue()) {
            arrayList.add(QUEUE);
        }
        if (this.getQueueTable()) {
            arrayList.add(QUEUETABLE);
        }
        if (this.getApex()) {
            arrayList.add(APEX);
        }
        if (this.getApexPage()) {
            arrayList.add(APEX_PAGE);
        }
        return arrayList;
    }

    public ArrayList<String> getTypeListForData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getTable()) {
            arrayList.add(TABLE);
        }
        if (this.getView()) {
            arrayList.add(VIEW);
        }
        if (this.getMatView()) {
            arrayList.add(MATVIEW);
        }
        return arrayList;
    }

    public String getAllTypes() {
        String string = "";
        for (String string2 : this.getTypeList()) {
            string = string2 + ":" + string;
        }
        return string;
    }

    public void setTypes(List<ExtractObject> list) {
        this.setTypes(list, true);
    }

    public void setTypes(List<ExtractObject> list, boolean bl) {
        this.setEnable(false);
        for (ExtractObject extractObject : list) {
            if (extractObject.getType() != 0) continue;
            URL uRL = extractObject.getDBObject().getURL();
            if (uRL != null && (DBURLFormatHelper.getBaseType(uRL).equals(VIEW) || DBURLFormatHelper.getBaseType(uRL).equals(EDITION_VIEW))) {
                this.setView(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(TYPE)) {
                this.setType(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(TRIGGER)) {
                this.setTrigger(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(TABLE)) {
                this.setTable(true);
                if (!bl) continue;
                this.setConstraint(true);
                this.setRefConstraint(true);
                this.setIndex(true);
                this.setTrigger(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(SEQUENCE)) {
                this.setSequence(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(PROCEDURE)) {
                this.setProcedure(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(PACKBODY)) {
                this.setPackBody(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(PACKSPEC)) {
                this.setPackSpec(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(MATVIEW)) {
                this.setMatView(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(INDEX)) {
                this.setIndex(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(FUNCTION)) {
                this.setFunction(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(DBLINK)) {
                this.setDbLink(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(SYNONYM)) {
                this.setSynonymn(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(MATVIEWLOG)) {
                this.setMatViewLog(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(DIRECTORY)) {
                this.setDirectory(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(QUEUE)) {
                this.setQueue(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(QUEUETABLE)) {
                this.setQueueTable(true);
                continue;
            }
            if (uRL != null && DBURLFormatHelper.getBaseType(uRL).equals(APEX)) {
                this.setApex(true);
                this.setShowApex(true);
                continue;
            }
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(APEX_PAGE)) continue;
            this.setApexPage(true);
            this.setShowApexPage(true);
        }
    }

    public static JLabel getFolderLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(DDLTypes.getFolderName(string));
        jLabel.setIcon(DDLTypes.getFolderIcon(string));
        return jLabel;
    }

    public static String getFolderName(String string) {
        String string2 = string.replaceAll(" ", "_") + "_FOLDER_LABEL";
        return DDLResources.getString(string2);
    }

    public static Icon getFolderIcon(String string) {
        String string2 = string.replaceAll(" ", "_") + "_FOLDER_ICON";
        return DDLResources.getIcon(string2);
    }
}

