/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.controls.SpringUtilities;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.ExtendedTextField;

public class PredicatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String _baseSql;
    private ExtendedTextField _objectPredicate;
    private JTextField _globalPredicate;
    private JButton apply;
    private JLabel _objectWhere = new JLabel(ExtractResources.getString("EO_PRED_OBJ_WHERE"));
    private JLabel _globalWhere = new JLabel(ExtractResources.getString("EO_PRED_GLOBAL_WHERE"));
    private JLabel _and = new JLabel(ExtractResources.getString("EO_PRED_AND"));
    private ResultSetTable _sampleTab;
    private String _conn;
    private String _globalPredicateText;
    private List _bindList = null;
    private Map _bindMap = null;
    private boolean _dirty = true;
    private boolean _verticalDiaplay = false;
    private boolean _showGlobal = true;
    private JLabel _lblSampleData = new JLabel(ExtractResources.getString("EO_PRED_SAMPLE"));
    private ExtractObject _dataObject;

    public PredicatePanel(ExtractObject extractObject, String string) {
        this(extractObject, string, true);
    }

    public PredicatePanel(ExtractObject extractObject, String string, boolean bl) {
        this._dataObject = extractObject;
        this._globalPredicateText = extractObject.getListModel().getGlobalWhere();
        this._bindMap = this._dataObject.getBindMap();
        this._bindList = extractObject.getBindList();
        this._showGlobal = bl;
        this.showPanel(this._dataObject.getSourceConnName(), this._dataObject.getSqlForVisibleCols());
        this.setPredicate(string);
        this._dirty = true;
        this.showSampleData();
    }

    public PredicatePanel(String string, String string2, List list) {
        this._bindList = list;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2, Map map) {
        this._bindMap = map;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2) {
        this.showPanel(string, string2);
    }

    public void PredicatePanelRefresh(String string) {
        if (string != null && !this._baseSql.equals(string)) {
            this.showPanelRefresh(this._conn, string);
        }
    }

    public void showPanelRefresh(String string, String string2) {
        String string3 = this.getPredicate();
        this.removeAll();
        this.showPanel(string, string2);
        this.setPredicate(string3);
        this.validate();
    }

    public void showPanel(String string, String string2) {
        JPanel jPanel;
        this._baseSql = string2;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablepredicate_html");
        this.setLayout(new SpringLayout());
        this._globalPredicate = new JTextField(this._globalPredicateText);
        this._objectPredicate = new ExtendedTextField();
        this._objectPredicate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                PredicatePanel.this._dirty = true;
                if (keyEvent.getKeyChar() == '\n') {
                    PredicatePanel.this.showSampleData();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.apply = new JButton();
        this.apply.setText(ExtractResources.getString("EO_PRED_GO"));
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PredicatePanel.this._dirty = true;
                PredicatePanel.this.showSampleData();
            }
        });
        this._sampleTab = new ResultSetTable();
        this._sampleTab.setColumnSelectorAvailable(false);
        this._sampleTab.getTableHeader().setReorderingAllowed(false);
        this._conn = string;
        int n = 2;
        if (this._showGlobal) {
            this.add(this._globalWhere);
            this._globalWhere.setEnabled(false);
            jPanel = new JPanel();
            this._globalPredicate.setColumns(40);
            this._globalPredicate.setEnabled(false);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this._globalPredicate, "Before");
            jPanel.add((Component)this._and, "After");
            this.add(jPanel);
            ++n;
        }
        this.add(this._objectWhere);
        jPanel = new JPanel();
        this._objectPredicate.setColumns(40);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._objectPredicate, "Before");
        jPanel.add((Component)this.apply, "After");
        this.add(jPanel);
        this.add(this._lblSampleData);
        this.add(new JScrollPane((Component)((Object)this._sampleTab)));
        SpringUtilities.makeCompactGrid((Container)this, (int)n, (int)2, (int)0, (int)0, (int)2, (int)2);
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDiaplay = bl;
        if (this._sampleTab != null) {
            this._sampleTab.setVerticalDisplay(this._verticalDiaplay);
        }
        this.apply.setVisible(!bl);
        this._objectPredicate.setVisible(!bl);
        this._objectWhere.setVisible(!bl);
        this._lblSampleData.setVisible(!bl);
    }

    public void showSampleData() {
        if (this._dirty && (this._sampleTab.getModel() instanceof DefaultTableModel || ((ResultSetTableModel)((Object)this._sampleTab.getModel())).getSql() != null && !((ResultSetTableModel)((Object)this._sampleTab.getModel())).getSql().equals(this.getSQL())) && this._conn != null) {
            this._sampleTab.setQuery(this._conn, this.getSQL(), this._bindList, this._bindMap);
            try {
                this._sampleTab.open(false);
                this._dirty = false;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((String)this._conn, (Throwable)exception);
            }
        }
    }

    public void setSQL(String string) {
        string.intern();
        if (!this._baseSql.equals(string)) {
            this._baseSql = string;
            this._dirty = true;
            this._baseSql.intern();
        }
    }

    public void setPredicate(String string) {
        this._objectPredicate.setText(string);
    }

    @Override
    public String toString() {
        String string = this._objectPredicate.getText();
        return string != null ? string : "";
    }

    public String getSQL() {
        return this._baseSql + " " + this.getPredicate() + this.getGlobalPredicate();
    }

    public String getPredicate() {
        String string = this._objectPredicate.getText();
        if (!string.equals("") && string.trim().toLowerCase().indexOf("where") != 0) {
            string = " where " + string;
        }
        return string;
    }

    public String getGlobalPredicate() {
        String string;
        String string2 = this._objectPredicate.getText();
        String string3 = string = this._globalPredicateText != null ? this._globalPredicateText : "";
        if (string.length() > 0) {
            string = string2.length() == 0 ? " where " + string : " and " + string;
        }
        return string;
    }

    public ResultSetTable getTable() {
        if (this._dirty) {
            this.showSampleData();
            this._dirty = false;
        }
        return this._sampleTab;
    }

    public void setDirty() {
        this._dirty = true;
    }
}

