/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.models.ExtractScript;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;

public class ScriptPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String BEFORE_CREATE_FILE_PATH = "BEFORE_CREATE_FILE_PATH";
    public static final String AFTER_CREATE_FILE_PATH = "AFTER_CREATE_FILE_PATH";
    public static final String BEFORE_LOAD_FILE_PATH = "BEFORE_LOAD_FILE_PATH";
    public static final String AFTER_LOAD_FILE_PATH = "AFTER_LOAD_FILE_PATH";
    public static final String INITIAL_FILE_PATH = "INITIAL_FILE_PATH";
    public static final String FINAL_FILE_PATH = "FINAL_FILE_PATH";
    private JCheckBox _preCreateCheckBox = new JCheckBox();
    private JCheckBox _postCreateCheckBox = new JCheckBox();
    private JCheckBox _preLoadCheckBox = new JCheckBox();
    private JCheckBox _postLoadCheckBox = new JCheckBox();
    private JLabel _initialLabel;
    private JLabel _finalLabel;
    private final URLFileChooser.URLFileChooserPanel _preCreateChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final URLFileChooser.URLFileChooserPanel _postCreateChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final URLFileChooser.URLFileChooserPanel _preLoadChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final URLFileChooser.URLFileChooserPanel _postLoadChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final URLFileChooser.URLFileChooserPanel _initialChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final URLFileChooser.URLFileChooserPanel _finalChooser = URLFileChooser.createURLFileChooserPanel(0, null, true, false);
    private final FileNameExtensionFilter filter = new FileNameExtensionFilter("SQL Files", "sql");
    private ExtractObject _extractObject;
    String _defaultFileDir;
    String _defaultEncoding;

    public ScriptPanel(ExtractObject extractObject) {
        this._extractObject = extractObject;
        this.showPanel();
    }

    public void showPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exportscripts_html");
        TargetFormat targetFormat = new TargetFormat(1, 4);
        targetFormat.setSaveAsType(1);
        this._defaultFileDir = targetFormat.getDefaultSaveAs();
        this._defaultEncoding = targetFormat.getEncoding();
        if (this._extractObject.getType() == 2) {
            this.initInitialScript();
        } else if (this._extractObject.getType() == 3) {
            this.initFinalScript();
        } else {
            this.initCreateScripts();
            if (this._extractObject.isDataObject()) {
                this.initLoadScripts();
            }
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (!this._extractObject.isTypeScript()) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this._preCreateChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
            TitledPane titledPane = new TitledPane((Component)this._preCreateCheckBox, (Component)jPanel2);
            jPanel.add((Component)titledPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.add((Component)this._postCreateChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
            TitledPane titledPane2 = new TitledPane((Component)this._postCreateCheckBox, (Component)jPanel3);
            jPanel.add((Component)titledPane2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
            if (this._extractObject.isDataObject()) {
                JPanel jPanel4 = new JPanel(new GridBagLayout());
                jPanel4.add((Component)this._preLoadChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
                TitledPane titledPane3 = new TitledPane((Component)this._preLoadCheckBox, (Component)jPanel4);
                jPanel.add((Component)titledPane3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
                JPanel jPanel5 = new JPanel(new GridBagLayout());
                jPanel5.add((Component)this._postLoadChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
                TitledPane titledPane4 = new TitledPane((Component)this._postLoadCheckBox, (Component)jPanel5);
                jPanel.add((Component)titledPane4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
            }
        } else if (this._extractObject.getType() == 2) {
            JPanel jPanel6 = new JPanel(new GridBagLayout());
            jPanel6.add((Component)this._initialChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
            TitledPane titledPane = new TitledPane((Component)this._initialLabel, (Component)jPanel6);
            jPanel.add((Component)titledPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else if (this._extractObject.getType() == 3) {
            JPanel jPanel7 = new JPanel(new GridBagLayout());
            jPanel7.add((Component)this._finalChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 8, 8, 8), 0, 0));
            TitledPane titledPane = new TitledPane((Component)this._finalLabel, (Component)jPanel7);
            jPanel.add((Component)titledPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    private void initCreateScripts() {
        ExtractScript extractScript = this._extractObject.getScript(110);
        String string = extractScript != null ? extractScript.getPath() : this._defaultFileDir;
        String string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        boolean bl = extractScript != null && extractScript.isSelectedFile();
        ResourceUtils.resButton((AbstractButton)this._preCreateCheckBox, (String)ExtractResources.getString("BEFORE_CREATE"));
        this._preCreateCheckBox.setToolTipText(ExtractResources.getString("BEFORE_CREATE_TIP"));
        this._preCreateCheckBox.setSelected(bl);
        this._preCreateChooser.showEncodings(true);
        this._preCreateChooser.setFileFilter(this.filter);
        this._preCreateChooser.setEnabled(bl);
        this._preCreateChooser.setCheckIfFileExists(true);
        this._preCreateChooser.setText(string);
        this._preCreateChooser.setEncoding(string2);
        this._preCreateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ScriptPanel.this._preCreateChooser.setEnabled(jCheckBox.isSelected());
            }
        });
        if (!this._extractObject.isExtractMetaData()) {
            this._preCreateCheckBox.setEnabled(false);
            this._preCreateChooser.setEnabled(false);
        }
        string = (extractScript = this._extractObject.getScript(111)) != null ? extractScript.getPath() : this._defaultFileDir;
        string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        bl = extractScript != null && extractScript.isSelectedFile();
        ResourceUtils.resButton((AbstractButton)this._postCreateCheckBox, (String)ExtractResources.getString("AFTER_CREATE"));
        this._postCreateCheckBox.setToolTipText(ExtractResources.getString("AFTER_CREATE_TIP"));
        this._postCreateCheckBox.setSelected(bl);
        this._postCreateChooser.showEncodings(true);
        this._postCreateChooser.setFileFilter(this.filter);
        this._postCreateChooser.setEnabled(bl);
        this._postCreateChooser.setCheckIfFileExists(true);
        this._postCreateChooser.setText(string);
        this._postCreateChooser.setEncoding(string2);
        this._postCreateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ScriptPanel.this._postCreateChooser.setEnabled(jCheckBox.isSelected());
            }
        });
        if (!this._extractObject.isExtractMetaData()) {
            this._postCreateCheckBox.setEnabled(false);
            this._postCreateChooser.setEnabled(false);
        }
    }

    private void initLoadScripts() {
        ExtractScript extractScript = this._extractObject.getScript(112);
        String string = extractScript != null ? extractScript.getPath() : this._defaultFileDir;
        String string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        boolean bl = extractScript != null && extractScript.isSelectedFile();
        ResourceUtils.resButton((AbstractButton)this._preLoadCheckBox, (String)ExtractResources.getString("BEFORE_LOAD"));
        this._preLoadCheckBox.setToolTipText(ExtractResources.getString("BEFORE_LOAD_TIP"));
        this._preLoadCheckBox.setSelected(bl);
        this._preLoadChooser.showEncodings(true);
        this._preLoadChooser.setFileFilter(this.filter);
        this._preLoadChooser.setEnabled(bl);
        this._preLoadChooser.setCheckIfFileExists(true);
        this._preLoadChooser.setText(string);
        this._preLoadChooser.setEncoding(string2);
        this._preLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ScriptPanel.this._preLoadChooser.setEnabled(jCheckBox.isSelected());
            }
        });
        if (!this._extractObject.isExtractData()) {
            this._preLoadCheckBox.setEnabled(false);
            this._preLoadChooser.setEnabled(false);
        }
        string = (extractScript = this._extractObject.getScript(113)) != null ? extractScript.getPath() : this._defaultFileDir;
        string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        bl = extractScript != null && extractScript.isSelectedFile();
        ResourceUtils.resButton((AbstractButton)this._postLoadCheckBox, (String)ExtractResources.getString("AFTER_LOAD"));
        this._postLoadCheckBox.setToolTipText(ExtractResources.getString("AFTER_LOAD_TIP"));
        this._postLoadCheckBox.setSelected(bl);
        this._postLoadChooser.showEncodings(true);
        this._postLoadChooser.setFileFilter(this.filter);
        this._postLoadChooser.setEnabled(bl);
        this._postLoadChooser.setCheckIfFileExists(true);
        this._postLoadChooser.setText(string);
        this._postLoadChooser.setEncoding(string2);
        this._postLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                ScriptPanel.this._postLoadChooser.setEnabled(jCheckBox.isSelected());
            }
        });
        if (!this._extractObject.isExtractData()) {
            this._postLoadCheckBox.setEnabled(false);
            this._postLoadChooser.setEnabled(false);
        }
    }

    private void initInitialScript() {
        ExtractScript extractScript = this._extractObject.getScript(114);
        String string = extractScript != null ? extractScript.getPath() : this._defaultFileDir;
        String string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        boolean bl = extractScript != null && extractScript.isSelectedFile();
        this._initialLabel = new JLabel(ExtractResources.getString("INITIAL"));
        this._initialChooser.showEncodings(true);
        this._initialChooser.setFileFilter(this.filter);
        this._initialChooser.setEnabled(bl);
        this._initialChooser.setCheckIfFileExists(true);
        this._initialChooser.setText(string);
        this._initialChooser.setEncoding(string2);
    }

    private void initFinalScript() {
        ExtractScript extractScript = this._extractObject.getScript(115);
        String string = extractScript != null ? extractScript.getPath() : this._defaultFileDir;
        String string2 = this._defaultEncoding;
        if (extractScript != null && extractScript.getEncoding() != null && extractScript.getEncoding().length() > 0) {
            string2 = extractScript.getEncoding();
        }
        boolean bl = extractScript != null && extractScript.isSelectedFile();
        this._finalLabel = new JLabel(ExtractResources.getString("FINAL"));
        this._finalChooser.showEncodings(true);
        this._finalChooser.setFileFilter(this.filter);
        this._finalChooser.setEnabled(bl);
        this._finalChooser.setCheckIfFileExists(true);
        this._finalChooser.setText(string);
        this._finalChooser.setEncoding(string2);
    }

    public boolean isPreCreate() {
        return this._preCreateCheckBox.isSelected();
    }

    public String getPreCreate() {
        return this._preCreateChooser.getText().trim();
    }

    public String getPreCreateEncoding() {
        return this._preCreateChooser.getEncoding().trim();
    }

    public boolean isPostCreate() {
        return this._postCreateCheckBox.isSelected();
    }

    public String getPostCreate() {
        return this._postCreateChooser.getText().trim();
    }

    public String getPostCreateEncoding() {
        return this._postCreateChooser.getEncoding().trim();
    }

    public boolean isPreLoad() {
        return this._preLoadCheckBox.isSelected();
    }

    public String getPreLoad() {
        return this._preLoadChooser.getText().trim();
    }

    public String getPreLoadEncoding() {
        return this._preLoadChooser.getEncoding().trim();
    }

    public boolean isPostLoad() {
        return this._postLoadCheckBox.isSelected();
    }

    public String getPostLoad() {
        return this._postLoadChooser.getText().trim();
    }

    public String getPostLoadEncoding() {
        return this._postLoadChooser.getEncoding().trim();
    }

    public boolean isInitial() {
        return this._extractObject.getType() == 2;
    }

    public String getInitial() {
        return this._initialChooser.getText().trim();
    }

    public String getInitialEncoding() {
        return this._initialChooser.getEncoding().trim();
    }

    public boolean isFinal() {
        return this._extractObject.getType() == 3;
    }

    public String getFinal() {
        return this._finalChooser.getText().trim();
    }

    public String getFinalEncoding() {
        return this._finalChooser.getEncoding().trim();
    }
}

