/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SqlHistory;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.insight.SynonymsCache;
import oracle.dbtools.raptor.insight.UsersCache;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.refactor.MultiFieldEdit;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.Pair;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    public static boolean trace = false;
    public static boolean timing = false;
    private ListInsightView _view = new DBListInsightView();
    DBListInsightData _lastLookup;
    private Node node;
    private String connName = null;
    int startCaretPosition;
    BackgroundParser parser = null;
    boolean raiselimit = false;
    boolean raiseHlimit = false;
    boolean raiseSlimit = false;
    boolean raiseTlimit = false;
    List<Member> members = new LinkedList<Member>();
    LexerToken prior = null;
    boolean isWorksheet = false;
    static List<CompletionInsight> instances = new LinkedList<CompletionInsight>();
    final List<String> bindVars;
    private char typedChar = '\u0000';
    boolean wasAutoInvoked;
    private String identifierPrefix = "";
    private String alias = "";
    private InsightThread worker = null;
    private static boolean firstInvocation = true;
    List<Integer> selectionOrder = new LinkedList<Integer>();
    public static final int minTSuggestions = 3;
    public static final int maxTSuggestions = 20;
    public static int tSuggestions = 3;
    public static final int minSuggestions = 3;
    public static final int maxSuggestions = 20;
    public static int suggestions = 3;

    private String getConnName() {
        if (this.connName != null) {
            return this.connName;
        }
        if (this.node instanceof PlSqlNode && ((PlSqlNode)this.node).getConnectionName() != null) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = plSqlNode.getConnectionName();
        } else if (this.node instanceof PlSqlNode) {
            PlSqlNode plSqlNode = (PlSqlNode)this.node;
            this.connName = DBURLFormatHelper.getConnectionName(this.node.getURL());
        }
        return this.connName;
    }

    public CompletionInsight(Context context, BackgroundParser backgroundParser) {
        this.parser = backgroundParser;
        this.bindVars = new LinkedList<String>();
        instances.add(this);
        this.node = context.getNode();
        if (this.node instanceof PlSqlNode) {
            this.parser = ((PlSqlNode)this.node).getParser();
            this.initMembers((PlSqlNode)this.node);
        } else if (context.getView() instanceof IDBEditor) {
            this.connName = ((IDBEditor)context.getView()).getConnectionName();
        }
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn(CompletionInsight.this.getConnName());
                    SynonymsCache.fillIn(CompletionInsight.this.getConnName());
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public CompletionInsight(String string, BackgroundParser backgroundParser, List<String> list) {
        DBConfig dBConfig;
        this.parser = backgroundParser;
        this.bindVars = list;
        instances.add(this);
        this.isWorksheet = true;
        this.connName = string;
        if (!string.startsWith("jdbc:oracle:thin:@") && (dBConfig = DBConfig.getInstance()).getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue()) {
            new Thread(){

                @Override
                public void run() {
                    UsersCache.fillIn(CompletionInsight.this.getConnName());
                    SynonymsCache.fillIn(CompletionInsight.this.getConnName());
                }
            }.start();
        }
        this.setCellRenderer();
    }

    public CompletionInsight(String string, BackgroundParser backgroundParser) {
        this(string, backgroundParser, new LinkedList<String>());
    }

    public void setCellRenderer() {
        ListDataItemCellRenderer listDataItemCellRenderer = new ListDataItemCellRenderer(){
            boolean printOnce = true;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof SuggestedItem) {
                    JLabel jLabel = (JLabel)component;
                    SuggestedItem suggestedItem = (SuggestedItem)object;
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    Font font = editorProperties.getFontHelper().getFont(0);
                    jLabel.setFont(font);
                    jLabel.setToolTipText(suggestedItem.getName());
                    if ("KEYWORD".equals(suggestedItem.getType())) {
                        jLabel.setForeground(Color.BLUE);
                    }
                    if (suggestedItem.isDocSnippet()) {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 0));
                        JButton jButton = new JButton(OracleIcons.getIcon((String)"library.png"));
                        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
                        jButton.setSize(new Dimension(suggestedItem.getIcon().getIconWidth(), suggestedItem.getIcon().getIconHeight()));
                        jButton.setEnabled(true);
                        jPanel.setToolTipText(suggestedItem.getName());
                        jPanel.add(jButton);
                        jLabel.setIcon(null);
                        jPanel.add(jLabel);
                        return jPanel;
                    }
                }
                return component;
            }

            public Dimension getPreferredSize() {
                int n;
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                if (trace && this.printOnce) {
                    System.out.println("dim.width=" + dimension2.width);
                    this.printOnce = false;
                }
                if ((n = dimension2.width / 4) < 250) {
                    n = 250;
                }
                return new Dimension(n, dimension.height);
            }
        };
        this._view.setCellRenderer((ListCellRenderer)listDataItemCellRenderer);
        int n = Toolkit.getDefaultToolkit().getScreenSize().height / 2 / (RaptorImagesArb.getIcon("FUNCTION").getIconHeight() + 4);
        n = Math.max(n, 15);
        n = Math.min(n, 45);
        this._view.setVisibleRowCount(n);
        this._view.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                Object object = mouseEvent.getSource();
                if (object instanceof ListInsightView) {
                    SuggestedItem suggestedItem;
                    ListInsightView listInsightView = (ListInsightView)object;
                    if (mouseEvent.getX() <= listInsightView.getX() + 16 && (suggestedItem = (SuggestedItem)listInsightView.getSelectedValue()).isDocSnippet()) {
                        try {
                            Desktop.getDesktop().browse(new URI(suggestedItem.doc.getPublicURL()));
                        }
                        catch (Exception exception) {
                            Log.error((String)("Failed to go to URL, " + exception.getMessage()));
                        }
                    }
                }
            }
        });
    }

    private void initMembers(PlSqlNode plSqlNode) {
        plSqlNode.addMembersTo(this.members);
        if (plSqlNode.isBody()) {
            URL uRL = plSqlNode.getURL();
            String string = DBURLFormatHelper.getBaseType(uRL);
            URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
            PlSqlNode plSqlNode2 = (PlSqlNode)DatabaseNavigatorElementFactory.getObjectNode(uRL2);
            plSqlNode2.addMembersTo(this.members);
        }
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        DBConfig dBConfig = DBConfig.getInstance();
        if (RaptorExtensionConstants.isStandAlone()) {
            if (MultiFieldEdit.inEditMode) {
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", false);
            } else if (!this.isWorksheet) {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETION"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR").booleanValue());
            } else {
                basicEditorPane.putIntegerProperty("completion-popup-delay", dBConfig.getInt("DELAYCOMPLETION"));
                basicEditorPane.putBooleanProperty("completion-enable-autopopup", dBConfig.getBoolean("ENABLECOMPLETIONWORKSHEET").booleanValue());
            }
        }
        super.characterTyped(basicEditorPane, n, c);
    }

    public boolean isInsightTriggerChar(char c) {
        this.typedChar = c;
        return c != ';';
    }

    public void showInsight(boolean bl) {
        this.wasAutoInvoked = bl;
        super.showInsight(bl);
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return false;
    }

    String getAliacedPrefix() {
        if (this.alias.length() == 0) {
            return this.identifierPrefix;
        }
        return this.alias + "." + this.identifierPrefix;
    }

    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        long l;
        if (Connections.getInstance().isTimesTen(this.getConnName())) {
            return null;
        }
        this._lastLookup = null;
        if (this.worker != null && this.worker.isAlive()) {
            return null;
        }
        this.worker = new InsightThread("InsightThread");
        this.worker.start();
        long l2 = System.currentTimeMillis();
        long l3 = l = this.typedChar == '\u0000' ? 5000L : 750L;
        if (firstInvocation && l < 2000L) {
            l = 2000L;
            firstInvocation = false;
        }
        if (this.raiselimit) {
            l = 15000L;
        }
        while (this.worker.isAlive()) {
            if (l < System.currentTimeMillis() - l2) {
                DBUtil.cancelExecution((Thread)this.worker);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.typedChar = '\u0000';
        return this._lastLookup;
    }

    /*
     * WARNING - void declaration
     */
    void complete(String string, List<LexerToken> list, LazyNode lazyNode, int n, int n2, boolean bl) {
        boolean bl2;
        Set<SuggestedItem> set;
        Object object;
        long l;
        block80: {
            String string2;
            l = System.currentTimeMillis();
            ArrayList<Object> arrayList = new ArrayList<LexerToken>();
            List list2 = LexerToken.parse((String)string, (boolean)true);
            int n3 = CompletionInsight.filterOutComments(n, list2, arrayList);
            if (n3 == -1) {
                this._lastLookup = null;
                return;
            }
            if (n3 == -2) {
                string2 = string.substring(0, n) + '\"' + string.substring(n);
                arrayList = new ArrayList();
                n3 = CompletionInsight.filterOutComments(n, LexerToken.parse((String)string2, (boolean)true), arrayList);
            }
            if (arrayList.size() == 0) {
                this._lastLookup = null;
                return;
            }
            this.identifierPrefix = "";
            this.alias = "";
            string2 = n3 < arrayList.size() ? arrayList.get(n3) : null;
            this.prior = n3 > 0 ? arrayList.get(n3 - 1) : null;
            if (n3 > 1 && this.prior != null && ".".equals(this.prior.content) && ((LexerToken)arrayList.get((int)(n3 - 2))).type == Token.IDENTIFIER) {
                this.alias = ((LexerToken)arrayList.get((int)(n3 - 2))).content;
            }
            if (string2 != null && (((LexerToken)string2).type == Token.IDENTIFIER || ((LexerToken)string2).type == Token.DQUOTED_STRING) && ((LexerToken)string2).begin < n && n < ((LexerToken)string2).end) {
                this.identifierPrefix = ((LexerToken)string2).content.substring(0, n - ((LexerToken)string2).begin);
                this.startCaretPosition -= this.identifierPrefix.length();
            } else if (string2 != null && (((LexerToken)string2).type == Token.IDENTIFIER || ((LexerToken)string2).type == Token.DQUOTED_STRING) && n == ((LexerToken)string2).end) {
                this.identifierPrefix = ((LexerToken)string2).content.substring(0, n - ((LexerToken)string2).begin);
                this.startCaretPosition -= this.identifierPrefix.length();
            }
            if (!this.identifierPrefix.startsWith("\"")) {
                this.identifierPrefix = this.identifierPrefix.toUpperCase();
            }
            SqlEarley sqlEarley = SqlEarley.partialRecognizer();
            Matrix matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.fifteenPctLAImpr = false;
            sqlEarley.parse(arrayList, matrix);
            Set<Long> set2 = CompletionInsight.predict(n3, sqlEarley, matrix);
            TreeSet<String> treeSet = new TreeSet<String>();
            Cell cell = set2.iterator();
            while (cell.hasNext()) {
                long l2 = cell.next();
                treeSet.add(SqlEarley.getInstance().allSymbols[Service.lX((long)l2)]);
            }
            cell = matrix.get(0, arrayList.size());
            ParseNode parseNode = null;
            if (this.isLegitimate(cell)) {
                parseNode = sqlEarley.forest(arrayList, matrix);
            } else {
                if (!this.isLegitimate(cell = (matrix = this.fixCode(arrayList, n3, sqlEarley, matrix, treeSet, cell)).get(0, arrayList.size()))) {
                    int n4 = string.lastIndexOf(59);
                    if (n < n4) {
                        n4 = string.substring(0, n).lastIndexOf(59);
                    }
                    if (0 < n4) {
                        string = string.substring(n4 + 1);
                        arrayList = new ArrayList();
                        list2 = LexerToken.parse((String)string, (boolean)true);
                        n3 = CompletionInsight.filterOutComments(n - (n4 + 1), list2, arrayList);
                        set2 = CompletionInsight.predict(n3, sqlEarley, matrix);
                        treeSet = new TreeSet();
                        object = set2.iterator();
                        while (object.hasNext()) {
                            long l3 = (Long)object.next();
                            treeSet.add(SqlEarley.getInstance().allSymbols[Service.lX((long)l3)]);
                        }
                        matrix = this.fixCode(arrayList, n3, sqlEarley, matrix, treeSet, cell);
                    }
                }
                parseNode = sqlEarley.forest(arrayList, matrix);
            }
            sqlEarley.fifteenPctLAImpr = true;
            set = this.suggestedBindVars(n3, parseNode, treeSet, this.identifierPrefix);
            if (0 < set.size()) {
                this.refreshSuggestedItemsList(set);
                return;
            }
            set = this.suggestedKeywords(treeSet, this.identifierPrefix);
            object = new InsightableOracleDatabase(this.getConnName(), !treeSet.contains("values_clause[12,24)"));
            ((InsightableOracleDatabase)object).limit = this.raiselimit ? 1000 : ((InsightableOracleDatabase)object).minLimit;
            suggestions = this.raiseSlimit ? 20 : 3;
            SqlHistory.suggestions = this.raiseHlimit ? 20 : 3;
            tSuggestions = this.raiseTlimit ? 20 : 3;
            if (!(this.identifierPrefix.length() <= 0 || n3 != 0 && this.prior.content.toLowerCase().startsWith("desc"))) {
                set.addAll(this.suggestedSnippets(set2, this.identifierPrefix, this.prior, matrix, n3));
            }
            bl2 = false;
            if (n3 > 0 && this.prior.content.toLowerCase().startsWith("desc")) {
                ((InsightableOracleDatabase)object).prepareAllTables(null, this.identifierPrefix);
                ((InsightableOracleDatabase)object).prepareAllProcedures(null, this.identifierPrefix);
            } else {
                Object object2;
                Object object32;
                Object object6;
                ParseNode parseNode2;
                boolean bl3;
                boolean bl4;
                boolean bl5 = bl4 = treeSet.contains("table_reference") || treeSet.contains("dml_table_expression_clause") || treeSet.contains("function_call") || treeSet.contains("function");
                if (bl4 && this.identifierPrefix.length() > 0 && this.alias.length() == 0) {
                    ((InsightableOracleDatabase)object).prepareAllSchemas(this.identifierPrefix);
                }
                this.suggestCallArguments("function_call", "name", "arg", arrayList, n3, sqlEarley, matrix, treeSet, (InsightableOracleDatabase)object);
                this.suggestCallArguments("user_defined_function", "identifier", "\"expr_list\"", arrayList, n3, sqlEarley, matrix, treeSet, (InsightableOracleDatabase)object);
                boolean bl6 = bl3 = treeSet.contains("column") || treeSet.contains("assignment_stmt") || treeSet.contains("expr");
                if (treeSet.contains("table_reference") || treeSet.contains("dml_table_expression_clause")) {
                    if (this.identifierPrefix.length() == 0) {
                        ((InsightableOracleDatabase)object).prepareUserTables();
                    } else {
                        ((InsightableOracleDatabase)object).prepareAllTables(null, this.identifierPrefix);
                    }
                } else if (bl3) {
                    if (treeSet.contains("condition")) {
                        bl2 = true;
                    }
                    parseNode2 = IdentifiersDb.getIdentifierDefs(n3, n3 + 1, parseNode);
                    if (trace) {
                        for (ParseNode hashMap2 : parseNode2) {
                            System.out.println(hashMap2);
                        }
                    }
                    object6 = new TreeMap();
                    for (ParseNode parseNode3 : parseNode2) {
                        object32 = CompletionInsight.findTableAlias(parseNode3);
                        if (object32 != null) {
                            object6.put(((Pair)object32).first, ((Pair)object32).second);
                            continue;
                        }
                        if (set == null || parseNode3.contains(IdentifiersDb.instance.table_reference) || (object2 = this.createDatabaseDataItem(arrayList, parseNode, parseNode3)) == null) continue;
                        set.add((SuggestedItem)object2);
                    }
                    if (list != null && lazyNode != null && 0 <= n2) {
                        List<ParseNode> list3 = IdentifiersDb.getIdentifierDefs(n2, n2 + 1, (ParseNode)lazyNode);
                        for (Object object32 : list3) {
                            SuggestedItem suggestedItem;
                            object2 = list.get(((ParseNode)object32).from);
                            if (!((LexerToken)object2).content.toUpperCase().startsWith(this.identifierPrefix) || set == null || (suggestedItem = this.createDatabaseDataItem(list, (ParseNode)lazyNode, (ParseNode)object32)) == null) continue;
                            set.add(suggestedItem);
                        }
                    }
                    for (Member member : this.members) {
                        set.add(new SuggestedItem(member.type, null, member.name));
                    }
                    if (!((InsightableOracleDatabase)object).prepareColumnsCalled) {
                        for (ParseNode parseNode4 : object6.keySet()) {
                            object32 = ((ParseNode)object6.get(parseNode4)).content(arrayList);
                            if (((String)object32).startsWith("(")) continue;
                            object2 = this.identifierPrefix;
                            String string3 = parseNode4.content(arrayList);
                            if (string3.equalsIgnoreCase(this.identifierPrefix)) {
                                object2 = "";
                            }
                            if (0 < this.alias.length() && !string3.equalsIgnoreCase(this.alias)) continue;
                            if (0 < this.identifierPrefix.indexOf(46)) {
                                object2 = this.identifierPrefix.substring(this.identifierPrefix.indexOf(46) + 1);
                            }
                            ((InsightableOracleDatabase)object).prepareColumns((String)object32, (String)object2);
                        }
                    }
                    ((InsightableOracleDatabase)object).prepareColumnsCalled = true;
                    ((InsightableOracleDatabase)object).setTableAliases(this.mapString2String(arrayList, (Map<ParseNode, ParseNode>)object6));
                    if (this.identifierPrefix.length() > 0 && 0 == this.alias.length()) {
                        ((InsightableOracleDatabase)object).prepareAllProcedures(null, this.identifierPrefix);
                    }
                }
                if (treeSet.contains("identifier")) {
                    Object object4;
                    Object object5;
                    parseNode2 = parseNode.parent(n3, n3 + 1);
                    if (parseNode2 != null && parseNode2.contains(IdentifiersDb.instance.table_reference)) {
                        if (parseNode2.from + 3 == parseNode2.to) {
                            object6 = ((LexerToken)arrayList.get((int)parseNode2.from)).content.toUpperCase();
                            String string4 = this.identifierPrefix.length() > 0 ? this.identifierPrefix : null;
                            ((InsightableOracleDatabase)object).prepareAllTables((String)object6, string4);
                        }
                    } else if (parseNode2 != null && (parseNode2.contains(IdentifiersDb.instance.column) || parseNode2.contains(IdentifiersDb.instance.select_term))) {
                        TabCol.Column column;
                        int n4;
                        void var27_59;
                        object6 = new StringBuffer();
                        for (ParseNode parseNode5 : parseNode2.children()) {
                            if (parseNode5.from == n3) continue;
                            for (int i = parseNode5.from; i < parseNode5.to - 1; ++i) {
                                ((StringBuffer)object6).append(((LexerToken)arrayList.get((int)i)).content);
                            }
                        }
                        List<ParseNode> list4 = IdentifiersDb.getIdentifierDefs(n3, n3 + 1, parseNode);
                        Object var27_58 = null;
                        object32 = new StringBuffer();
                        for (ParseNode parseNode6 : list4) {
                            int n5;
                            Pair<ParseNode, ParseNode> pair = CompletionInsight.findTableAlias(parseNode6);
                            if (pair == null) continue;
                            object5 = (LexerToken)arrayList.get(((ParseNode)pair.first).from);
                            if (!object5.content.toUpperCase().startsWith(((StringBuffer)object6).toString().toUpperCase())) continue;
                            object4 = new StringBuffer();
                            for (n5 = ((ParseNode)pair.first).from; n5 < ((ParseNode)pair.first).to; ++n5) {
                                ((StringBuffer)object4).append(((LexerToken)arrayList.get((int)n5)).content);
                            }
                            if (((StringBuffer)object6).length() > 0 && !((StringBuffer)object4).toString().equalsIgnoreCase(((StringBuffer)object6).toString())) {
                                Object var27_61 = null;
                                object32 = new StringBuffer();
                                continue;
                            }
                            for (n5 = ((ParseNode)pair.second).from; n5 < ((ParseNode)pair.second).to; ++n5) {
                                ((StringBuffer)object32).append(((LexerToken)arrayList.get((int)n5)).content);
                            }
                        }
                        object2 = new HashMap();
                        if (var27_59 != null) {
                            TreeMap<ParseNode, ParseNode> treeMap = new TreeMap<ParseNode, ParseNode>();
                            treeMap.put((ParseNode)var27_59.first, (ParseNode)var27_59.second);
                            object2 = this.mapString2String(arrayList, treeMap);
                        } else {
                            String string5 = this.alias.toUpperCase();
                            if (!"".equals(string5)) {
                                object2.put(string5, string5);
                            }
                            object32 = new StringBuffer(string5);
                        }
                        Map<String, ParseNode> map = TabCol.getInlineViewNodes(parseNode, arrayList);
                        if (map.size() > 0) {
                            object5 = map.get(((StringBuffer)object32).toString().toLowerCase());
                            if (object5 == null) {
                                object5 = map.get("inline subquery");
                            }
                            object4 = TabCol.getSelectList((ParseNode)object5);
                            ArrayList<TabCol.Column> arrayList2 = TabCol.extractColumns((ParseNode)object4, arrayList, false, false);
                            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                                Object object7;
                                column = arrayList2.get(n4);
                                String string6 = column.alias;
                                if (string6 == null) {
                                    object7 = column.colExpr;
                                    if (object7 == null || object7.to - object7.from != 3 && object7.to - object7.from != 1) break;
                                    string6 = ((LexerToken)arrayList.get((int)(object7.to - 1))).content;
                                }
                                object7 = new SuggestedItem("COLUMN", null, this.alias + "." + string6, n4);
                                set.add((SuggestedItem)object7);
                            }
                        }
                        ((InsightableOracleDatabase)object).setTableAliases((Map<String, String>)object2, true);
                        ((InsightableOracleDatabase)object).prepareColumns(((StringBuffer)object32).toString(), this.identifierPrefix);
                        if (parseNode2 != null && (parseNode2.contains(IdentifiersDb.instance.procedure_call) || parseNode2.contains(IdentifiersDb.instance.function) || parseNode2.contains(IdentifiersDb.instance.simple_expression))) {
                            object5 = this.identifierPrefix.length() > 0 ? this.identifierPrefix : null;
                            object4 = null;
                            Object object8 = null;
                            for (n4 = parseNode2.from; n4 < parseNode2.to; ++n4) {
                                column = (LexerToken)arrayList.get(n4);
                                if (((LexerToken)column).type == Token.OPERATION) continue;
                                if (object4 == null) {
                                    if (0 > ((LexerToken)column).begin || column == string2) continue;
                                    object4 = ((LexerToken)column).content;
                                    continue;
                                }
                                if (0 > ((LexerToken)column).begin || column == string2) break;
                                object8 = ((LexerToken)column).content;
                                break;
                            }
                            if (object4 != null && object8 == null) {
                                object8 = object4;
                                object4 = null;
                            }
                            if (object8 == null) {
                                ((InsightableOracleDatabase)object).prepareAllProcedures((String)object4, (String)object5);
                            }
                            ((InsightableOracleDatabase)object).prepareAllPkgProc((String)object4, (String)object8, (String)object5);
                        }
                    } else if (n3 > 1 && ".".equals(this.prior.content) && !"".equals(this.alias)) {
                        object6 = this.alias.toUpperCase();
                        ((InsightableOracleDatabase)object).prepareAllPkgProc(null, (String)object6, this.identifierPrefix);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put((String)object6, (String)object6);
                        ((InsightableOracleDatabase)object).setTableAliases(hashMap, true);
                        ((InsightableOracleDatabase)object).prepareColumns((String)object6, this.identifierPrefix);
                        ((InsightableOracleDatabase)object).prepareAllTables((String)object6, this.identifierPrefix);
                        ((InsightableOracleDatabase)object).prepareAllProcedures((String)object6, this.identifierPrefix);
                        if (this.members != null) {
                            String string7 = this.alias.toUpperCase();
                            object32 = null;
                            block16: for (Member member : this.members) {
                                if (object32 != null) break;
                                if (member.name.toUpperCase().equals(string7)) {
                                    object32 = member.type;
                                    break;
                                }
                                if (!"TYPE".equalsIgnoreCase(member.type)) continue;
                                object5 = member.getPayload().toUpperCase();
                                object4 = this.parseRecord((String)object5);
                                for (String string8 : object4.keySet()) {
                                    if (!string8.equals(string7)) continue;
                                    object32 = object4.get(string8);
                                    continue block16;
                                }
                            }
                            if (object32 != null) {
                                for (Member member : this.members) {
                                    if (!"TYPE".equalsIgnoreCase(member.type) || !member.name.toUpperCase().equals(object32)) continue;
                                    object5 = member.getPayload().toUpperCase();
                                    object4 = this.parseRecord((String)object5);
                                    for (String string8 : object4.keySet()) {
                                        set.add(new SuggestedItem(object4.get(string8), null, this.alias + "." + string8));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (((InsightableOracleDatabase)object).isPrepared()) {
                try {
                    Set<SuggestedItem> set3 = ((InsightableOracleDatabase)object).fetch();
                    if (!((InsightableOracleDatabase)object).colNameOrdering) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n7 = -1;
                        for (SuggestedItem suggestedItem : set3) {
                            String string9 = "[" + suggestedItem.getName() + "]";
                            stringBuilder.append(++n7 == 0 ? string9 : "," + string9);
                        }
                        set.add(new SuggestedItem("COLUMN", null, stringBuilder.toString()));
                    } else {
                        set.addAll(set3);
                    }
                }
                catch (Exception exception) {
                    if (!trace) break block80;
                    System.err.println(exception.getMessage());
                }
            }
        }
        this.raiselimit = false;
        this.raiseHlimit = false;
        this.raiseSlimit = false;
        this.raiseTlimit = false;
        if (set.size() == 1) {
            this.refreshSuggestedItemsList(set);
            for (SuggestedItem suggestedItem : set) {
                if (!this.identifierPrefix.equalsIgnoreCase(suggestedItem.getName())) continue;
                this._lastLookup = null;
                return;
            }
        }
        if (bl2) {
            set.addAll(this.joinConditions(set, (InsightableOracleDatabase)object));
        }
        this.refreshSuggestedItemsList(set);
        long l4 = System.currentTimeMillis();
        if (timing) {
            System.out.println("Code completion time = " + (l4 - l));
        }
    }

    private void suggestCallArguments(String string, String string2, String string3, ArrayList<LexerToken> arrayList, int n, SqlEarley sqlEarley, Matrix matrix, Set<String> set, InsightableOracleDatabase insightableOracleDatabase) {
        if (set.contains(string3)) {
            Cell cell;
            for (int i = n - 1; !(0 > i || n - 5 > i || (cell = matrix.get(i, n)) != null && this.foundMatchedRule(string, string2, arrayList, sqlEarley, insightableOracleDatabase, i, cell) || (cell = matrix.get(i, n - 1)) != null && this.foundMatchedRule(string, string2, arrayList, sqlEarley, insightableOracleDatabase, i, cell)); --i) {
            }
        }
    }

    private boolean foundMatchedRule(String string, String string2, ArrayList<LexerToken> arrayList, SqlEarley sqlEarley, InsightableOracleDatabase insightableOracleDatabase, int n, Cell cell) {
        for (int i = 0; i < cell.size(); ++i) {
            String string3;
            int n2 = cell.getRule(i);
            String string4 = sqlEarley.allSymbols[sqlEarley.rules[n2].head];
            if (!string.equals(string4) || !string2.equals(string3 = sqlEarley.allSymbols[sqlEarley.rules[n2].rhs[0]])) continue;
            String string5 = arrayList.get((int)n).content.toUpperCase();
            String string6 = arrayList.get((int)(n + 1)).content;
            String string7 = null;
            if (".".equals(string6)) {
                string7 = string5;
                string5 = arrayList.get((int)(n + 2)).content.toUpperCase();
            }
            insightableOracleDatabase.prepareArgumentsProc(string7, string5);
            return true;
        }
        return false;
    }

    private Matrix fixCode(ArrayList<LexerToken> arrayList, int n, SqlEarley sqlEarley, Matrix matrix, Set<String> set, Cell cell) {
        if (this.identifierPrefix.length() > 0) {
            if (arrayList.size() <= n) {
                return matrix;
            }
            if (trace) {
                System.out.println("deleted an identifier");
            }
            arrayList.remove(n);
            matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(arrayList, matrix);
            cell = matrix.get(0, arrayList.size());
        }
        if (!this.isLegitimate(cell)) {
            int n2 = arrayList.size();
            this.fixCode(arrayList, n, set);
            matrix = new Matrix((Parser)sqlEarley);
            sqlEarley.parse(arrayList, matrix);
            cell = matrix.get(0, arrayList.size());
            if (!this.isLegitimate(cell)) {
                Set<Long> set2 = CompletionInsight.predict(n + (arrayList.size() - n2), sqlEarley, matrix);
                TreeSet<String> treeSet = new TreeSet<String>();
                for (long l : set2) {
                    treeSet.add(SqlEarley.getInstance().allSymbols[Service.lX((long)l)]);
                }
                this.fixCode(arrayList, n + (arrayList.size() - n2), treeSet);
                matrix = new Matrix((Parser)sqlEarley);
                sqlEarley.parse(arrayList, matrix);
            }
        }
        return matrix;
    }

    private void fixCode(ArrayList<LexerToken> arrayList, int n, Set<String> set) {
        LexerToken lexerToken = new LexerToken((CharSequence)"du$mY", -2, -1, Token.IDENTIFIER);
        LexerToken lexerToken2 = new LexerToken((CharSequence)"=", -2, -1, Token.OPERATION);
        LexerToken lexerToken3 = new LexerToken((CharSequence)")", -2, -1, Token.OPERATION);
        LexerToken lexerToken4 = new LexerToken((CharSequence)";", -2, -1, Token.OPERATION);
        if (set.contains("';'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken4});
            return;
        }
        if (this.prior != null && "(".equals(this.prior.content) && set.contains("')'")) {
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken3});
            return;
        }
        for (String string : set) {
            if (string.equals("condition") || string.startsWith("update_set_clause")) {
                this.insertTokens(arrayList, n, new LexerToken[]{lexerToken, lexerToken2, lexerToken});
                return;
            }
            if (!string.equals("'='")) continue;
            this.insertTokens(arrayList, n, new LexerToken[]{lexerToken2, lexerToken});
            return;
        }
        this.insertTokens(arrayList, n, new LexerToken[]{lexerToken});
    }

    private void insertTokens(ArrayList<LexerToken> arrayList, int n, LexerToken[] lexerTokenArray) {
        for (LexerToken lexerToken : lexerTokenArray) {
            arrayList.add(n++, lexerToken);
            if (!trace) continue;
            System.out.println("inserted " + lexerToken.content);
        }
    }

    private Map<String, String> parseRecord(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.indexOf("RECORD") < 0) {
            return hashMap;
        }
        int n = string.indexOf(40);
        if (n < 0) {
            return hashMap;
        }
        int n2 = string.lastIndexOf(41);
        if (n2 < 0) {
            return hashMap;
        }
        string = string.substring(n + 1, n2 - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n3 = string2.indexOf(32);
            if (n3 < 0) continue;
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1).toUpperCase().trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private boolean isLegitimate(Cell cell) {
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n = cell.getRule(i);
            int n2 = cell.getPosition(i);
            if (n2 != SqlEarley.getInstance().rules[n].rhs.length) continue;
            return true;
        }
        return false;
    }

    public static Set<Long> predict(int n, SqlEarley sqlEarley, Matrix matrix) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int i = 0; i <= n; ++i) {
            Cell cell = matrix.get(i, n);
            if (cell == null) continue;
            for (int j = 0; j < cell.size(); ++j) {
                int n2 = cell.getRule(j);
                int n3 = cell.getPosition(j);
                if (n3 >= sqlEarley.rules[n2].rhs.length) continue;
                hashSet.add(Service.lPair((int)sqlEarley.rules[n2].rhs[n3], (int)sqlEarley.rules[n2].head));
            }
        }
        return hashSet;
    }

    private void refreshSuggestedItemsList(Set<SuggestedItem> set) {
        SuggestedItem[] suggestedItemArray = new SuggestedItem[set.size()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (SuggestedItem suggestedItem : set) {
            boolean bl = false;
            String string = suggestedItem.getName();
            suggestedItemArray[n] = new SuggestedItem(suggestedItem.getType(), suggestedItem.getOwner(), string);
            suggestedItemArray[n++].doc = suggestedItem.doc;
            if ("COLUMN".equalsIgnoreCase(suggestedItem.getType())) {
                ++n2;
                continue;
            }
            if (!"TABLE".equalsIgnoreCase(suggestedItem.getType()) && !"VIEW".equalsIgnoreCase(suggestedItem.getType())) continue;
            ++n3;
        }
        this._lastLookup = new DBListInsightData(this);
        this._lastLookup.setData(suggestedItemArray);
        if (n2 > 1 || n3 > 1) {
            this._view.setSelectionMode(2);
        } else {
            this._view.setSelectionMode(0);
        }
        this._view.setData((InsightData)this._lastLookup);
        this._view.revalidate();
    }

    private void addSelectFrom(Collection<SuggestedItem> collection, String string) {
        if (!"SELECT * FROM".startsWith(string.toUpperCase())) {
            return;
        }
        SuggestedItem suggestedItem = new SuggestedItem("KEYWORD", "", "SELECT * FROM");
        if (!collection.contains(suggestedItem)) {
            collection.add(suggestedItem);
        }
    }

    private Map<String, String> mapString2String(List<LexerToken> list, Map<ParseNode, ParseNode> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (ParseNode parseNode : map.keySet()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode.from; i < parseNode.to; ++i) {
                stringBuffer.append(list.get((int)i).content);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            ParseNode parseNode2 = map.get(parseNode);
            for (int i = parseNode2.from; i < parseNode2.to; ++i) {
                stringBuffer2.append(list.get((int)i).content);
            }
            treeMap.put(stringBuffer.toString(), stringBuffer2.toString());
        }
        return treeMap;
    }

    private Set<SuggestedItem> suggestedKeywords(Set<String> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        String string2 = "'" + string;
        for (String string3 : set) {
            SuggestedItem suggestedItem;
            if (!string3.startsWith(string2) || string3.startsWith("xml") || treeSet.contains(suggestedItem = new SuggestedItem("KEYWORD", null, string3.substring(1, string3.length() - 1)))) continue;
            treeSet.add(suggestedItem);
        }
        SuggestedItem suggestedItem = new SuggestedItem("KEYWORD", null, "SQL");
        treeSet.remove(suggestedItem);
        if (treeSet.size() > 3) {
            treeSet.clear();
        }
        return treeSet;
    }

    private Set<SuggestedItem> suggestedSnippets(Set<Long> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (string.length() == 0) {
            return treeSet;
        }
        treeSet.addAll(CompletionInsight.addTemplates(set, string, lexerToken, matrix, n - 1));
        treeSet.addAll(SqlHistory.addTemplates(set, string, lexerToken, matrix, n - 1));
        try {
            treeSet.addAll(this.legacyTemplates(string));
        }
        catch (Error error) {
            System.err.println("Failed to init legacy templates; OK if running InsightTest");
        }
        for (long l : set) {
            int n2 = Service.lX((long)l);
            if (n2 != IdentifiersDb.instance.table_reference && n2 != IdentifiersDb.instance.subquery) continue;
            this.addSelectFrom(treeSet, string);
            break;
        }
        return treeSet;
    }

    private List<SuggestedItem> legacyTemplates(String string) {
        Map map = CodeTemplateUtil.getModel();
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        for (String string2 : map.keySet()) {
            String string3;
            if (tSuggestions <= linkedList.size() || (string3 = (String)map.get(string2)) == null || string3.length() == 0 || !string2.toUpperCase().startsWith(string.toUpperCase()) && !string3.toUpperCase().startsWith(string.toUpperCase())) continue;
            linkedList.add(new SuggestedItem("TEMPLATE", null, string3));
        }
        if (linkedList.size() == 3 && tSuggestions == 3) {
            linkedList.add(new SuggestedItem("TEMPLATE", null, "..."));
        }
        return linkedList;
    }

    private Set<SuggestedItem> suggestedBindVars(int n, ParseNode parseNode, Set<String> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (!set.contains("identifier")) {
            return treeSet;
        }
        ParseNode parseNode2 = parseNode.descendant(n, n, IdentifiersDb.instance.bind_var);
        if (parseNode2 == null) {
            return treeSet;
        }
        for (String string2 : this.bindVars) {
            if (!string2.toUpperCase().startsWith(string.toUpperCase())) continue;
            treeSet.add(new SuggestedItem("TEMPLATE", null, string2));
        }
        return treeSet;
    }

    static int filterOutComments(int n, List<LexerToken> list, List<LexerToken> list2) {
        int n2 = 0;
        int n3 = -1;
        for (LexerToken lexerToken : list) {
            if (!(lexerToken.begin > n || n >= lexerToken.end && lexerToken.end >= 0 || lexerToken.type != Token.COMMENT && lexerToken.type != Token.LINE_COMMENT && lexerToken.type != Token.QUOTED_STRING)) {
                return -1;
            }
            if (n == lexerToken.end && lexerToken.type == Token.LINE_COMMENT) {
                return -1;
            }
            if ((lexerToken.begin <= n && n < lexerToken.end || n == lexerToken.end && lexerToken.type == Token.IDENTIFIER) && n3 == -1) {
                n3 = n2;
            }
            if (lexerToken.type == Token.DQUOTED_STRING && lexerToken.begin < n && n <= lexerToken.end) {
                if (lexerToken.content.toUpperCase().contains("FROM") || lexerToken.content.toUpperCase().contains("WHERE")) {
                    return -2;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
            }
            if (lexerToken.type == Token.WS || lexerToken.type == Token.COMMENT || lexerToken.type == Token.LINE_COMMENT) continue;
            list2.add(lexerToken);
            ++n2;
        }
        if (n3 == -1) {
            n3 = list2.size();
        }
        return n3;
    }

    public static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!(parseNode.contains(IdentifiersDb.instance.table_reference) || parseNode.contains(IdentifiersDb.instance.cartesian_product) || parseNode.contains(IdentifiersDb.instance.aliased_dml_table_expression_clause))) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(IdentifiersDb.instance.query_table_expression) || parseNode4.contains(IdentifiersDb.instance.dml_table_expression_clause)) {
                    parseNode3 = parseNode4;
                    continue;
                }
                parseNode2 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    private SuggestedItem createDatabaseDataItem(List<LexerToken> list, ParseNode parseNode, ParseNode parseNode2) {
        LexerToken lexerToken = list.get(parseNode2.from);
        if (lexerToken.begin > 0) {
            ParseNode parseNode3 = parseNode.parent(parseNode2.from, parseNode2.to);
            if (parseNode3 != null) {
                if (parseNode3.contains(IdentifiersDb.instance.prm_spec) || parseNode3.contains(IdentifiersDb.instance.object_d)) {
                    for (ParseNode parseNode4 : parseNode3.children()) {
                        if (!parseNode4.contains(IdentifiersDb.instance.object_d_rhs) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type) && !parseNode4.contains(IdentifiersDb.instance.unconstrained_type_wo_datetime)) continue;
                        String string = list.get((int)parseNode4.from).content.toUpperCase();
                        if (!(string.indexOf("CHAR") >= 0 || "INTEGER".equals(string) || "NUMBER".equals(string) || "DATE".equals(string) || "TIMESTAMP".equals(string) || "BOOLEAN".equals(string))) {
                            string = "USER DEFINED";
                        }
                        return new SuggestedItem(string, null, lexerToken.content);
                    }
                }
                if (parseNode3.contains(IdentifiersDb.instance.subprg_spec)) {
                    LexerToken lexerToken2 = list.get(parseNode2.from - 1);
                    if ("function".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("FUNCTION", null, lexerToken.content);
                    }
                    if ("procedure".equalsIgnoreCase(lexerToken2.content)) {
                        return new SuggestedItem("PROCEDURE", null, lexerToken.content);
                    }
                }
            } else {
                return new SuggestedItem("USER DEFINED", null, lexerToken.content);
            }
        }
        return null;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        return null;
    }

    public ListInsightView getInsightView() {
        return this._view;
    }

    protected boolean handleCompleteCommand(BasicEditorPane basicEditorPane) {
        boolean bl = this._view.complete((Insight)this);
        basicEditorPane.requestFocusInWindow();
        return bl;
    }

    private List<SuggestedItem> joinConditions(Set<SuggestedItem> set, InsightableOracleDatabase insightableOracleDatabase) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        int n = 0;
        block0: for (SuggestedItem suggestedItem : set) {
            String string = suggestedItem.getName();
            int n2 = string.indexOf(46);
            if (n2 <= 0 || !"COLUMN".equals(suggestedItem.getType()) || "DATE".equals(suggestedItem.columnType)) continue;
            for (SuggestedItem suggestedItem2 : set) {
                String string2 = suggestedItem2.getName();
                int n3 = string2.indexOf(46);
                if (n3 <= 0 || suggestedItem.compareTo(suggestedItem2) <= 0 || !"COLUMN".equals(suggestedItem.getType()) || !suggestedItem2.columnType.equals(suggestedItem.columnType) || !this.colNamesMatch(string, string2, insightableOracleDatabase)) continue;
                linkedList.add(new SuggestedItem("EQUIJOIN CONDITION", null, string + " = " + string2));
                if (++n <= 50) continue;
                break block0;
            }
        }
        return linkedList;
    }

    private boolean colNamesMatch(String string, String string2, InsightableOracleDatabase insightableOracleDatabase) {
        int n = string.indexOf(46);
        int n2 = string2.indexOf(46);
        String string3 = string.substring(n + 1).toUpperCase();
        String string4 = string2.substring(n2 + 1).toUpperCase();
        if (string3 == null) {
            return false;
        }
        if (string3.equals(string4)) {
            return true;
        }
        String string5 = insightableOracleDatabase.getTable(string.substring(0, n)).toUpperCase();
        String string6 = insightableOracleDatabase.getTable(string2.substring(0, n2)).toUpperCase();
        return string3.startsWith(string5) && string4.equals(string3 + "_ID") || string3.startsWith(string5) && string4.equals(string3 + "_NAME") || string4.startsWith(string6) && string3.equals(string4 + "_ID") || string4.startsWith(string6) && string3.equals(string4 + "_NAME") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_ID") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_ID") || this.tabColNamesMatch(string3, string5) && string3.endsWith("_NAME") && this.tabColNamesMatch(string4, string6) && string4.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String string, String string2) {
        if (string2.length() < 5 || string.length() < 5) {
            return false;
        }
        for (int i = 0; i < string2.length() - 5; ++i) {
            String string3 = string2.substring(i, i + 5);
            if (!string.contains(string3)) continue;
            return true;
        }
        return false;
    }

    public static List<SuggestedItem> addTemplates(Set<Long> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        Collection<Comparable> collection;
        HashSet<Substr> hashSet = new HashSet<Substr>();
        Substr.listSuggestions(set, (String)string, null, (Map)HarvestDoc.getTemplates(), hashSet, (int)suggestions);
        if (lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
            collection = CompletionInsight.predict(n, SqlEarley.getInstance(), matrix);
            Substr.listSuggestions(collection, (String)lexerToken.content, (String)string.toLowerCase(), (Map)HarvestDoc.getTemplates(), hashSet, (int)suggestions);
        }
        if ((collection = SuggestedItem.addSuggestions(hashSet, "SNIPPET")).size() == 3 && suggestions == 3) {
            collection.add(new SuggestedItem("SNIPPET", null, "..."));
        }
        return collection;
    }

    public static void main(String[] stringArray) {
    }

    class InsightThread
    extends Thread {
        public InsightThread(String string) {
            super(string);
        }

        @Override
        public void run() {
            Object object2;
            int n;
            int n2;
            TextBuffer textBuffer = CompletionInsight.this.getTextBuffer();
            CompletionInsight.this.startCaretPosition = CompletionInsight.this.getCaretPosition();
            int n3 = CompletionInsight.this.startCaretPosition - 5000;
            int n4 = CompletionInsight.this.startCaretPosition + 5000;
            if (CompletionInsight.this.startCaretPosition < 5000) {
                n3 = 0;
            }
            if ((n2 = textBuffer.getLength()) < n4) {
                n4 = n2;
            }
            LazyNode lazyNode = null;
            int n5 = CompletionInsight.this.startCaretPosition;
            List<LexerToken> list = null;
            if (CompletionInsight.this.parser != null && CompletionInsight.this.parser.src != null && CompletionInsight.this.parser.output != null) {
                lazyNode = CompletionInsight.this.parser.output;
                list = CompletionInsight.this.parser.src;
                n5 = CompletionInsight.this.parser.recalculatePosition(n5);
                for (n = 0; n < list.size() && n5 >= list.get((int)n).end; ++n) {
                }
            }
            if (list != null && lazyNode != null) {
                for (Object object2 : lazyNode.shallowChildren()) {
                    if (!"package".equalsIgnoreCase(((LazyNode)object2).startToken)) continue;
                    block4: for (ParseNode parseNode : ((LazyNode)object2).shallowChildren()) {
                        if (!((LazyNode)parseNode).isAs()) continue;
                        for (ParseNode parseNode2 : ((LazyNode)parseNode).shallowChildren()) {
                            if (!((LazyNode)parseNode2).isProcedure()) continue;
                            int n6 = list.get((int)parseNode2.to).begin;
                            if (n6 < n5) {
                                if (n3 >= n6) continue;
                                n3 = n6;
                                continue;
                            }
                            int n7 = list.get((int)parseNode2.from).begin;
                            if (n7 <= n5 && n5 < n6) {
                                if (n3 < n7) {
                                    n3 = n7;
                                }
                                if (n6 >= n4) continue block4;
                                n4 = n6;
                                continue block4;
                            }
                            if (n5 >= n7 || n7 >= n4) continue;
                            n4 = n7;
                        }
                    }
                }
                for (Object object2 : lazyNode.shallowDescendants()) {
                    LazyNode lazyNode2 = (LazyNode)object2;
                    if (list.size() == 0) continue;
                    int n8 = list.get((int)lazyNode2.from).begin;
                    int n9 = -1;
                    if (0 < lazyNode2.to) {
                        n9 = list.get((int)(lazyNode2.to - 1)).end + 1;
                    }
                    if (n8 > n5 || n5 >= n9 || !lazyNode2.isDML(null) && !lazyNode2.isStmt(lazyNode)) continue;
                    if (n3 < n8) {
                        n3 = n8;
                    }
                    if (n9 >= n4) continue;
                    n4 = n9;
                }
            }
            int n10 = CompletionInsight.this.startCaretPosition - n3;
            object2 = null;
            try {
                object2 = textBuffer.getString(n3, n4 - n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Log.error((String)("textBuffer.getString(" + n3 + ", " + (n4 - n3) + ")"));
                return;
            }
            CompletionInsight.this.complete((String)object2, list, lazyNode, n10, n, true);
        }
    }

    private final class DBListInsightView
    extends ListInsightView {
        DBListInsightView() {
            final ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    listSelectionEvent.getFirstIndex();
                    if (listSelectionModel.isSelectionEmpty()) {
                        CompletionInsight.this.selectionOrder.clear();
                        return;
                    }
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = listSelectionModel.getMaxSelectionIndex();
                    for (int i = n; i <= n2; ++i) {
                        if (listSelectionModel.isSelectedIndex(i)) {
                            if (CompletionInsight.this.selectionOrder.contains(i)) continue;
                            CompletionInsight.this.selectionOrder.add(i);
                            continue;
                        }
                        CompletionInsight.this.selectionOrder.remove(new Integer(i));
                    }
                }
            });
        }

        public void selectDefault() {
            if (!CompletionInsight.this.wasAutoInvoked) {
                super.selectDefault();
            }
        }

        public boolean complete(Insight insight) {
            int n = this.getSelectedIndex();
            ListModel listModel = this.getModel();
            if (n < 0 || n >= listModel.getSize()) {
                return false;
            }
            return super.complete(insight);
        }
    }
}

