/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionResolver;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.util.Service;

public class InsightTest {
    private static int testNo = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    private static CompletionInsight insight;
    static Set<RuleTuple> rules;
    static Earley earley;
    private static int output;
    private static int assertion;
    private static int query;
    private static int comment;
    private static int marker;
    private static int prompt;
    private static int dotted_name;
    private static int sql_prefix;
    private static int sql_postfix;

    public static void main(String[] stringArray) throws Exception {
        DBUtil.setConnectionResolver((ConnectionResolver)new DefaultConnectionResolver());
        BackgroundParser backgroundParser = new BackgroundParser();
        insight = new CompletionInsight("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521:DB12GR1N,hr,hr", backgroundParser);
        String string = Service.readFile(InsightTest.class, (String)"insight.test");
        List list = LexerToken.parse((String)string, (String)"#");
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        InsightTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> " + failedTests.toString());
        }
    }

    private static Set<RuleTuple> insightRules() {
        try {
            String string = Service.readFile(InsightTest.class, (String)"insight.grammar");
            List list = LexerToken.parse((String)string);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for insight test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            System.out.print("TEST#" + testNo + " -> ");
            if (InsightTest.assertion(parseNode, list, string, testNo++)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                System.out.println("TEST#" + testNo++ + " ->\n" + InsightTest.query(parseNode2, list, string));
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            InsightTest.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            InsightTest.atest(parseNode3, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string, int n) {
        List<String> list2 = null;
        Map<String, Boolean> map = null;
        for (Object object : parseNode.children()) {
            if (object.contains(query)) {
                list2 = InsightTest.query((ParseNode)object, list, string);
                continue;
            }
            if (!object.contains(prompt)) continue;
            map = InsightTest.prompt((ParseNode)object, list, string);
        }
        for (Object object : map.keySet()) {
            boolean bl = (Boolean)map.get(object);
            Object object2 = object;
            object2 = ((String)object2).charAt(0) != '\"' ? ((String)object2).toLowerCase() : ((String)object2).substring(1, ((String)object2).length() - 1);
            boolean bl2 = false;
            for (String string2 : list2) {
                String string3 = string2;
                string3 = string3.charAt(0) != '\"' ? string3.toLowerCase() : string3.substring(1, string3.length() - 1);
                if (!((String)object2).equals(string3)) continue;
                bl2 = true;
                break;
            }
            if ((bl2 || !bl) && (!bl2 || bl)) continue;
            System.out.println((bl ? "no" : "unexpected") + " match for " + (String)object);
            failedTests.add(n);
            return false;
        }
        return true;
    }

    private static Map<String, Boolean> prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (parseNode.contains(dotted_name)) {
            String string2 = parseNode.content(list);
            hashMap.put(string2, true);
            return hashMap;
        }
        String string3 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(prompt) && !parseNode2.contains(dotted_name)) {
                hashMap.putAll(InsightTest.prompt(parseNode2, list, string));
                continue;
            }
            String string4 = parseNode2.content(list);
            if ("-".equals(string3)) {
                hashMap.put(string4, false);
            } else if (!"-".equals(string4)) {
                hashMap.put(string4, true);
            }
            string3 = string4;
        }
        return hashMap;
    }

    private static List<String> query(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        String string3 = "";
        int n = -1;
        ParseNode parseNode2 = null;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains(marker)) {
                if (string2 == null) {
                    string2 = "";
                }
                n = string2.length() + (parseNode2 == null || list.get((int)parseNode3.from).begin == list.get((int)(parseNode2.to - 1)).end ? 0 : 1);
            }
            if (parseNode3.contains(sql_prefix) || parseNode3.contains(sql_postfix)) {
                if (n == -1) {
                    string2 = InsightTest.sql_fragment(parseNode3, list, string);
                } else {
                    string3 = InsightTest.sql_fragment(parseNode3, list, string);
                }
            }
            parseNode2 = parseNode3;
        }
        return InsightTest.output(string2 + "  " + string3, n);
    }

    private static List<String> output(String string, int n) {
        CompletionInsight.trace = false;
        CompletionInsight.timing = false;
        InsightTest.insight.parser.text = string;
        InsightTest.insight.parser.parse();
        insight.complete(string, InsightTest.insight.parser.src, InsightTest.insight.parser.output, n, -1, false);
        DBListInsightData dBListInsightData = InsightTest.insight._lastLookup;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object object : dBListInsightData.getMatchingData()) {
            linkedList.add(object.toString());
        }
        return linkedList;
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        if (parseNode.from + 1 == parseNode.to) {
            String string2 = list.get((int)parseNode.from).content;
            if (string2.charAt(0) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        String string3 = "";
        for (ParseNode parseNode2 : parseNode.children()) {
            string3 = string3 + " " + InsightTest.sql_fragment(parseNode2, list, string);
        }
        return string3.replace(". ", ".").replace(" .", ".");
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end - 1));
        return null;
    }

    static {
        rules = InsightTest.insightRules();
        earley = new Earley(rules){

            protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
                LexerToken lexerToken = list.get(n);
                return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING;
            }
        };
        output = (Integer)InsightTest.earley.symbolIndexes.get("output");
        assertion = (Integer)InsightTest.earley.symbolIndexes.get("assertion");
        query = (Integer)InsightTest.earley.symbolIndexes.get("query");
        comment = (Integer)InsightTest.earley.symbolIndexes.get("comment");
        marker = (Integer)InsightTest.earley.symbolIndexes.get("marker");
        prompt = (Integer)InsightTest.earley.symbolIndexes.get("prompt");
        dotted_name = (Integer)InsightTest.earley.symbolIndexes.get("dotted_name");
        sql_prefix = (Integer)InsightTest.earley.symbolIndexes.get("\"sql prefix\"");
        sql_postfix = (Integer)InsightTest.earley.symbolIndexes.get("\"sql postfix\"");
    }
}

