/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import oracle.dbtools.db.ChameleonConnection;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.SynonymsCache;
import oracle.dbtools.raptor.insight.UsersCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.javatools.db.DBException;
import oracle.javatools.util.Log;
import oracle.jdeveloper.db.ConnectionException;

public class InsightableOracleDatabase {
    private static final Logger logger = Logger.getLogger(InsightableOracleDatabase.class.getName());
    private static final String NOSQLTRANSL = "/*+ NO_SQL_TRANSLATION */";
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<Object> binds = new ArrayList<Object>();
    public boolean colNameOrdering = true;
    public final int minLimit = 50;
    public int limit = 50;
    UsersCache users = null;
    SynonymsCache synonyms = null;
    static Map<String, Boolean> dbaSynonymsAtConnection = new HashMap<String, Boolean>();
    private static final String USERNAME_CRITERIA = " and username like ? ";
    private static final String OBJ_TYPE_EQ_PKG = " and object_type = 'PACKAGE' ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String PROCNAME_CRITERIA = " and procedure_name like ? ";
    private static final String OWN_PKG_CRITERIA = " and (o.object_name = ? and a.package_name = ? or o.owner=?) ";
    private static final String STANDALONE_PROC_CRITERIA = " and o.object_name = ? ";
    private static final String PACKAGED_PROC_CRITERIA = " and o.object_name = ? and a.object_name = ? ";
    private boolean prepareUserTablesCalled = false;
    private boolean prepareAllTablesCalled = false;
    boolean prepareColumnsCalled = false;
    private String schema = null;
    private boolean prepareAllFunctionsCalled = false;
    private boolean prepareAllSchemasCalled = false;
    private List<String> prefixedUsers = null;
    private boolean prepareAllPkgProcCalled = false;
    private boolean prepareArgumentsProcCalled = false;
    private Map<String, String> tableAliases = null;
    boolean setTableAliasesCalled = false;
    private boolean isPrefixed = false;

    public InsightableOracleDatabase(String string, boolean bl) {
        this.connectionName = string;
        this.colNameOrdering = bl;
        this.synonyms = SynonymsCache.synonymsAtConnection.get(string);
        if (this.synonyms == null) {
            SynonymsCache.fillIn(string);
            this.synonyms = SynonymsCache.synonymsAtConnection.get(string);
        }
        this.users = UsersCache.usersAtConnection.get(string);
    }

    private int limit() {
        return this.limit;
    }

    private final String queryUserTables() {
        if (this.users == null) {
            return "/*+ NO_SQL_TRANSLATION */SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE     object_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "/*+ NO_SQL_TRANSLATION */select 'TABLE' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.owner# = " + this.users.schema + " \n" + "and o.name not like 'BIN%' \n" + "and o.type# = 2 \n" + "and rownum <=" + this.limit() + "\n";
    }

    private final String queryUserViews() {
        if (this.users == null) {
            return "/*+ NO_SQL_TRANSLATION */SELECT object_type type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, object_name, null column_name, null column_id, null data_type \nFROM user_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "/*+ NO_SQL_TRANSLATION */select 'VIEW' type, SYS_CONTEXT('USERENV','CURRENT_SCHEMA')  owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.owner# = " + this.users.schema + " \n" + "and o.name not like 'BIN%' \n" + "and o.type# = 4 \n" + "and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllTables() {
        if (this.users == null) {
            return "/*+ NO_SQL_TRANSLATION */SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "/*+ NO_SQL_TRANSLATION */select 'TABLE' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.name not like 'BIN%' \nand o.type# = 2 \nand rownum <=" + this.limit() + "\n";
    }

    private final String queryAllViews() {
        if (this.users == null) {
            return "/*+ NO_SQL_TRANSLATION */SELECT object_type type, owner, object_name, null column_name, null column_id, null data_type \nFROM all_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
        }
        return "/*+ NO_SQL_TRANSLATION */select 'VIEW' type, ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere o.name not like 'BIN%' \nand o.type# = 4 \nand rownum <=" + this.limit() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String queryAllSynonyms() {
        Boolean bl = dbaSynonymsAtConnection.get(this.connectionName);
        if (bl == null) {
            Connection connection = null;
            Statement statement = null;
            ReentrantLock reentrantLock = null;
            try {
                connection = ChameleonConnection.getConnection((String)this.connectionName);
                if (!ChameleonConnection.isTestConnection()) {
                    reentrantLock = Connections.getInstance().getLock(connection);
                }
                if (reentrantLock != null && !reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                    bl = false;
                }
                if (bl == null) {
                    statement = connection.prepareStatement("select 1 from sys.DBA_SYNONYMS where 1=0");
                    statement.executeQuery();
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (reentrantLock != null && reentrantLock.isHeldByCurrentThread()) {
                    reentrantLock.unlock();
                }
                dbaSynonymsAtConnection.put(this.connectionName, bl);
            }
        }
        return "/*+ NO_SQL_TRANSLATION */select 'TABLE' type, ''/*SYS_CONTEXT('USERENV','CURRENT_SCHEMA')*/  owner, synonym_name object_name, null column_name, null column_id, null data_type \nfrom " + (bl != false ? " dba_synonyms" : " all_synonyms") + "\n" + "where synonym_name like ?\n" + "and rownum <=" + this.limit() + "\n";
    }

    private final String objName() {
        return (this.users == null ? "object_" : "") + "name";
    }

    private final String OBJ_LIKE_CRITERIA() {
        return " and " + this.objName() + " like ? ";
    }

    private final String OWNER_CRITERIA() {
        if (this.users == null) {
            return " and owner = ? ";
        }
        return " and owner# = ? ";
    }

    private final String MIXED_CASE_CRITERIA() {
        return " and upper(" + this.objName() + ")!=" + this.objName() + " ";
    }

    private final String QUERY_COLUMNS_BY_OWNER_TABLE() {
        return "/*+ NO_SQL_TRANSLATION */SELECT 'COLUMN' type, owner, table_name object_name, column_name, column_id, data_type \nFROM sys.all_tab_cols \nWHERE hidden_column = 'NO' and rownum <=" + this.limit() + " and owner = ? and table_name = ? ";
    }

    private final String COLUMN_LIKE_CRITERIA() {
        return " and column_name like ? ";
    }

    private final String COLUMN_TYPE_NOT_CRITERIA() {
        return " and data_type != ? ";
    }

    private final String COLUMN_NAME_NOT_CRITERIA() {
        return " and column_name != ? ";
    }

    private final String queryProcedures(boolean bl) {
        if (this.users == null) {
            return "/*+ NO_SQL_TRANSLATION */SELECT object_type type, " + (bl ? "SYS_CONTEXT('USERENV','CURRENT_SCHEMA')" : "owner") + "  owner, object_name, null column_name, null column_id, null data_type \n" + "FROM " + (bl ? "user" : "all") + "_objects \n" + "WHERE rownum <=" + this.limit() + " and object_name not like 'BIN$%' " + " and object_type IN ('PROCEDURE','FUNCTION','PACKAGE') \n";
        }
        return "/*+ NO_SQL_TRANSLATION */select case type# when 7 then 'PROCEDURE' when 8 then 'FUNCTION' when 9 then 'PACKAGE' end type,\n ''||o.owner# owner, name object_name, null column_name, null column_id, null data_type FROM sys.obj$ o \nwhere " + (bl ? "o.owner# = " + this.users.schema + " and " : "") + "name not like 'BIN%' \n" + "and type# in (7,8,9) \n" + "and rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_SCHEMAS() {
        return "/*+ NO_SQL_TRANSLATION */SELECT 'SCHEMA' type, username owner, username object_name, null column_name, null column_id, null data_type \nFROM all_users WHERE rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_PACKAGED_PROCEDURES() {
        return "/*+ NO_SQL_TRANSLATION */SELECT 'FUNCTION' type, owner, object_name||'.'||procedure_name object_name, null column_name, null column_id, null data_type \nFROM all_procedures \nWHERE rownum <=" + this.limit() + " OBJ_TYPE_EQ_PKG " + " and procedure_name is not null \n";
    }

    private final String QUERY_ARGUMENTS() {
        return "/*+ NO_SQL_TRANSLATION */SELECT 'ARGUMENT' type, null owner,  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||' '||a.data_type column_name, a.position column_id, null data_type \nFROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and rownum <=" + this.limit() + " and    argument_name is not null \n";
    }

    public void prepareUserTables() {
        if (this.prepareUserTablesCalled) {
            return;
        }
        this.prepareUserTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryUserTables());
        this.query.append("\n union all \n");
        this.query.append(this.queryUserViews());
    }

    public void prepareAllTables(String string, String string2) {
        if (this.prepareAllTablesCalled) {
            return;
        }
        this.prepareAllTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryAllTables());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        this.query.append("\n union all \n");
        this.query.append(this.queryAllViews());
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        this.addOwnerCriteria(string);
        if (string2 != null && string2.length() > 0) {
            this.query.append("\n union all \n");
            this.query.append(this.queryAllSynonyms());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
            if (string != null) {
                this.query.append(" and owner = ? ");
                this.binds.add(string);
            } else {
                this.query.append(" and owner in (SYS_CONTEXT('USERENV','CURRENT_SCHEMA') ,'PUBLIC') ");
            }
        }
    }

    private void addOwnerCriteria(String string) {
        if (string != null) {
            if (this.users == null) {
                this.query.append(this.OWNER_CRITERIA());
                this.binds.add(string);
            } else {
                Integer n = this.users.getUserId(string);
                if (n != null) {
                    this.query.append(this.OWNER_CRITERIA());
                    this.binds.add(n);
                } else {
                    this.query.append(" and 0 = 1 ");
                }
            }
        }
    }

    public void prepareColumns(String string, String string2) {
        String string3 = null;
        String string4 = null;
        if (string.indexOf(46) < 0) {
            String string5;
            string4 = string.substring(string.indexOf(46) + 1);
            if (this.synonyms != null && (string5 = this.synonyms.getTable(null, string4)) != null) {
                string3 = string5.substring(0, string5.indexOf(46));
                string4 = string5.substring(string5.indexOf(46) + 1);
            }
        } else {
            String string6;
            string3 = string.substring(0, string.indexOf(46));
            string4 = string.substring(string.indexOf(46) + 1);
            if (this.synonyms != null && (string6 = this.synonyms.getTable(string3, string4)) != null) {
                string3 = string6.substring(0, string6.indexOf(46));
                string4 = string6.substring(string6.indexOf(46) + 1);
            }
        }
        if (string3 == null) {
            string3 = this.getCurrentSchema();
        }
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(1));
        this.binds.add(Service.handleMixedCase((String)string3));
        this.binds.add(Service.handleMixedCase((String)string4));
        if (string2 != null && !"".equals(string2)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
    }

    private String getCurrentSchema() {
        if (this.schema == null) {
            try {
                this.schema = DBUtil.getInstance((Connection)this.getConnection()).executeOracleReturnOneCol("/*+ NO_SQL_TRANSLATION */select SYS_CONTEXT('USERENV','CURRENT_SCHEMA') current_schema from dual", new HashMap());
            }
            catch (Exception exception) {
                Log.error((String)("IOD.gcs():" + exception.getMessage()));
                this.schema = "N/A";
            }
        }
        if (this.schema == null) {
            Log.error((String)"IOD.gcs(): schema == null");
            this.schema = "N/A";
        }
        return this.schema;
    }

    public void prepareFQColumns(Set<String> set, String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(set.size()));
        this.setFQBinds(set, this.binds);
        if (string != null && !"".equals(string)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
    }

    public void excludeColTypes(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_TYPE_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void excludeColNames(List<String> list) {
        for (String string : list) {
            this.query.append(this.COLUMN_NAME_NOT_CRITERIA());
            this.binds.add(string);
        }
    }

    public void prepareAllProcedures(String string, String string2) {
        if (this.prepareAllFunctionsCalled) {
            return;
        }
        this.prepareAllFunctionsCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryProcedures(false));
        if (string2 != null && string2.length() > 0) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(Service.handleMixedCase((String)string2) + "%");
        }
        this.addOwnerCriteria(string);
    }

    public void prepareAllSchemas(String string) {
        if (this.users != null) {
            this.prefixedUsers = this.users.prefixedUsers(string);
            return;
        }
        this.prefixedUsers = null;
        if (this.prepareAllSchemasCalled) {
            return;
        }
        this.prepareAllSchemasCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string2 = this.QUERY_SCHEMAS();
        if (string != null && !"".equals(string)) {
            string2 = string2 + USERNAME_CRITERIA;
            this.binds.add(Service.handleMixedCase((String)string) + "%");
        }
        this.query.append(string2);
    }

    public void prepareAllPkgProc(String string, String string2, String string3) {
        if (this.prepareAllPkgProcCalled) {
            return;
        }
        this.prepareAllPkgProcCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_PACKAGED_PROCEDURES());
        if (string == null) {
            string = Service.handleMixedCase((String)this.getCurrentSchema());
            this.query.append(" and owner in('SYS',?) ");
            this.binds.add(string);
        } else {
            this.query.append(" and owner = ? ");
            this.binds.add(Service.handleMixedCase((String)string));
        }
        if (string2 != null) {
            this.query.append(OBJ_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string2));
        }
        if (string3 != null && string3.length() > 0) {
            this.query.append(PROCNAME_CRITERIA);
            this.binds.add(Service.handleMixedCase((String)string3) + "%");
        }
    }

    public void prepareArgumentsProc(String string, String string2) {
        if (this.prepareArgumentsProcCalled) {
            return;
        }
        this.prepareArgumentsProcCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ARGUMENTS();
        if (string != null) {
            string3 = string3 + OWN_PKG_CRITERIA;
            this.binds.add(string);
            this.binds.add(string);
            this.binds.add(string);
        }
        if (string2 != null) {
            if (string != null) {
                string3 = string3 + PACKAGED_PROC_CRITERIA;
                this.binds.add(string);
                this.binds.add(string2);
            } else {
                string3 = string3 + STANDALONE_PROC_CRITERIA;
                this.binds.add(string2);
            }
        }
        this.query.append(string3);
    }

    public void setTableAliases(Map<String, String> map) {
        this.setTableAliases(map, false);
    }

    public void setTableAliases(Map<String, String> map, boolean bl) {
        if (this.setTableAliasesCalled) {
            return;
        }
        this.setTableAliasesCalled = true;
        this.isPrefixed = bl;
        if (this.synonyms == null) {
            this.tableAliases = map;
        } else {
            this.tableAliases = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2;
                String string3 = map.get(string);
                String string4 = null;
                String string5 = string3;
                if (string5.indexOf(46) > 0) {
                    string4 = string5.substring(0, string5.indexOf(46));
                    string5 = string5.substring(string5.indexOf(46) + 1);
                }
                if ((string2 = this.synonyms.getTable(string4, string5)) != null) {
                    string3 = string2;
                }
                this.tableAliases.put(string, string3);
            }
        }
    }

    String getTable(String string) {
        if (this.tableAliases == null) {
            return null;
        }
        return this.tableAliases.get(string);
    }

    private List<String> translate(String string, String string2, String string3) {
        String string4;
        String string5;
        boolean bl = false;
        int n = 0;
        for (String object2 : this.tableAliases.keySet()) {
            String string6;
            ++n;
            String string7 = this.tableAliases.get(object2);
            if (object2.equalsIgnoreCase(string7)) continue;
            string5 = null;
            string4 = object2;
            if (string4.indexOf(46) > 0) {
                string5 = string4.substring(0, string4.indexOf(46));
                string4 = string4.substring(string4.indexOf(46) + 1);
            }
            if (string7.equals(string6 = this.synonyms.getTable(string5, string4))) continue;
            bl = true;
            break;
        }
        if (this.colNameOrdering && this.isPrefixed) {
            bl = true;
        }
        if (1 < n) {
            bl = true;
        }
        ArrayList arrayList = new ArrayList();
        for (String string7 : this.tableAliases.keySet()) {
            string5 = this.tableAliases.get(string7);
            if (!string5.equalsIgnoreCase(string + '.' + string2) && !string5.equalsIgnoreCase(string2) && !string5.equalsIgnoreCase("\"" + string + "\".\"" + string2 + "\"") && !string5.equalsIgnoreCase("\"" + string + "\"." + string2) && !string5.equalsIgnoreCase("\"" + string2 + "\"")) continue;
            string4 = bl ? string7 + "." + string3 : string3;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean isPrepared() {
        return this.query.length() > 0;
    }

    private String queryByOwnerTable(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("\n  union all\n");
            }
            stringBuffer.append(this.QUERY_COLUMNS_BY_OWNER_TABLE());
        }
        return stringBuffer.toString();
    }

    private void setFQBinds(Set<String> set, List<Object> list) {
        for (String string : set) {
            String string2;
            String string3 = string.substring(0, string.indexOf(46));
            list.add(Service.handleMixedCase((String)string3));
            String string4 = string.substring(string.indexOf(46) + 1);
            if (this.synonyms != null && (string2 = this.synonyms.getTable(string3, string4)) != null) {
                string3 = string2.substring(0, string2.indexOf(46));
                string4 = string2.substring(string2.indexOf(46) + 1);
            }
            list.add(Service.handleMixedCase((String)string4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Set<SuggestedItem> fetch() throws Exception {
        CharSequence charSequence;
        Iterator<Object> iterator;
        if (this.query == null || this.query.length() == 0) {
            return Collections.emptySet();
        }
        long l = System.currentTimeMillis();
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        ResultSet resultSet = null;
        String string = null;
        ResultSetWrapper resultSetWrapper = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (connection == null) {
                Set<SuggestedItem> set = Collections.emptySet();
                return set;
            }
            ReentrantLock reentrantLock = null;
            if (!ChameleonConnection.isTestConnection()) {
                reentrantLock = Connections.getInstance().getLock(connection);
            }
            if (reentrantLock != null && !reentrantLock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                Set<SuggestedItem> set = Collections.emptySet();
                return set;
            }
            string = connection.getMetaData().getDatabaseMajorVersion() > 10 ? this.query.toString().replace("OBJ_TYPE_EQ_PKG", OBJ_TYPE_EQ_PKG) : this.query.toString().replace("OBJ_TYPE_EQ_PKG", "");
            String string2 = connection.getMetaData().getUserName();
            resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string, this.binds);
            resultSet = resultSetWrapper.getResultSet();
            iterator = null;
            Object object = new HashMap<Integer, String>();
            while (resultSet.next()) {
                String string3;
                charSequence = resultSet.getString("type");
                String string4 = resultSet.getString("object_name");
                if (string4.indexOf(46) <= 0) {
                    string4 = Service.addDoubleQuote((String)string4);
                }
                String string5 = resultSet.getString("column_name");
                if ("ARGUMENT".equals(charSequence)) {
                    string3 = string4;
                    if (iterator == null || string3.equals(iterator)) {
                        object.put(resultSet.getInt("column_id"), string5);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 1; i <= object.size(); ++i) {
                            if (i > 1) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append((String)object.get(i));
                        }
                        treeSet.add(new SuggestedItem((String)charSequence, null, stringBuilder.toString()));
                        object.put(resultSet.getInt("column_id"), string5);
                    }
                    iterator = string3;
                    continue;
                }
                string3 = resultSet.getString("owner");
                if ("COLUMN".equals(charSequence)) {
                    void object2;
                    if (string5 != null) {
                        String string6 = Service.addDoubleQuote((String)string5);
                    }
                    if (string3 == null || string4 == null || object2 == null) {
                        System.out.println(string3);
                    }
                    List<String> list = this.translate(string3, string4, (String)object2);
                    Integer n = resultSet.getInt("column_id");
                    for (String string7 : list) {
                        SuggestedItem suggestedItem = null;
                        suggestedItem = n != null && !this.colNameOrdering ? new SuggestedItem((String)charSequence, null, string7, n) : new SuggestedItem((String)charSequence, null, string7);
                        suggestedItem.columnType = resultSet.getString("data_type");
                        treeSet.add(suggestedItem);
                    }
                    continue;
                }
                if (this.users != null) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n >= 0) {
                        string3 = this.users.getUserName(n);
                    }
                }
                treeSet.add(new SuggestedItem((String)charSequence, string2.equals(string3) ? "" : string3, string4));
            }
            if (object.size() > 0) {
                charSequence = new StringBuilder();
                for (int i = 1; i <= object.size(); ++i) {
                    if (i > 1) {
                        ((StringBuilder)charSequence).append(",");
                    }
                    ((StringBuilder)charSequence).append((String)object.get(i));
                }
                treeSet.add(new SuggestedItem("ARGUMENT", null, ((StringBuilder)charSequence).toString()));
                object.clear();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null && !ChameleonConnection.isTestConnection()) {
                Connections.getInstance().unlock(connection);
            }
            if (resultSetWrapper != null) {
                resultSetWrapper.close();
            }
        }
        long l2 = System.currentTimeMillis();
        if (CompletionInsight.timing) {
            System.out.println("InsightableOracleDatabase.fetch() time = " + (l2 - l));
        }
        if (l + 500L < l2) {
            logger.warning("InsightableOracleDatabase.fetch() time = " + (l2 - l));
            logger.warning(string);
            if (CompletionInsight.timing) {
                System.out.println(string);
                for (Object object : this.binds) {
                    System.out.println(object);
                    if (object != null) {
                        logger.warning(object.toString());
                        continue;
                    }
                    logger.warning("bind=null");
                }
            }
        }
        iterator = new TreeSet();
        int n = 0;
        charSequence = null;
        for (SuggestedItem suggestedItem : treeSet) {
            if (!suggestedItem.getType().equals(charSequence)) {
                n = 0;
            }
            if (++n >= this.limit()) {
                iterator.add(new SuggestedItem(suggestedItem.getType(), null, "..."));
            }
            charSequence = suggestedItem.getType();
        }
        treeSet.addAll((Collection<SuggestedItem>)((Object)iterator));
        if (this.prefixedUsers != null) {
            for (String string8 : this.prefixedUsers) {
                treeSet.add(new SuggestedItem("SCHEMA", null, string8));
            }
        }
        return treeSet;
    }

    public Connection getConnection() throws DBException, ClassNotFoundException, SQLException, ConnectionException {
        return ChameleonConnection.getConnection((String)this.connectionName);
    }
}

